/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.log.stats;

import com.android.sched.util.log.stats.ArrayAlloc;
import com.android.sched.util.log.stats.SampleImpl;
import com.android.sched.util.log.stats.Statistic;
import com.android.sched.util.log.stats.StatisticId;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class ArrayAllocImpl
extends ArrayAlloc {
    @Nonnegative
    private long number;
    @Nonnull
    private final SampleImpl element;
    @Nonnegative
    private long size;

    protected ArrayAllocImpl(@Nonnull StatisticId<? extends Statistic> id) {
        super(id);
        this.element = new SampleImpl(id);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public synchronized void recordAllocation(@Nonnegative int count, @Nonnegative long size, @CheckForNull Object object) {
        ++this.number;
        this.size += size;
        this.element.add(count, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void merge(@Nonnull Statistic statistic) {
        ArrayAllocImpl stat;
        ArrayAllocImpl arrayAllocImpl = stat = (ArrayAllocImpl)statistic;
        synchronized (arrayAllocImpl) {
            this.number += stat.number;
            this.size += stat.size;
            this.element.merge(stat.element);
        }
    }

    @Override
    @Nonnegative
    public long getNumber() {
        return this.number;
    }

    @Override
    @Nonnegative
    public long getSize() {
        return this.size;
    }

    @Override
    @Nonnull
    public synchronized Iterator<Object> iterator() {
        return Iterators.concat(Iterators.forArray(this.getNumber(), this.getSize()), this.element.iterator());
    }
}

