/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.config.id;

import com.android.sched.util.codec.WriterFileCodec;
import com.android.sched.util.config.category.Category;
import com.android.sched.util.config.expression.BooleanExpression;
import com.android.sched.util.config.id.PropertyId;
import com.android.sched.util.file.StreamFileStatus;
import com.android.sched.util.file.WriterFile;
import com.android.sched.util.log.LoggerFactory;
import com.android.sched.util.stream.CustomPrintWriter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

public class WriterFilePropertyId
extends PropertyId<WriterFile> {
    @Nonnull
    private static final Logger logger = LoggerFactory.getLogger();

    @Nonnull
    public static WriterFilePropertyId create(@Nonnull String name, @Nonnull String description, @Nonnull WriterFileCodec codec) {
        return new WriterFilePropertyId(name, description, codec);
    }

    protected WriterFilePropertyId(@Nonnull String name, @Nonnull String description, @Nonnull WriterFileCodec codec) {
        super(name, description, codec);
        this.withAutoCheck();
    }

    @Nonnull
    public WriterFilePropertyId withAutoClose() {
        this.setShutdownHook(new PropertyId.ShutdownRunnable<WriterFile>(){

            @Override
            public void run(WriterFile file) {
                if (file.getStatus() != StreamFileStatus.NOT_USED) {
                    CustomPrintWriter writer = file.getPrintWriter();
                    try {
                        writer.throwPendingException();
                    }
                    catch (IOException e) {
                        logger.log(Level.SEVERE, "Pending exception writing " + file.getLocation().getDescription() + " from property '" + WriterFilePropertyId.this.getName() + "'", e);
                    }
                    if (file.getStatus() == StreamFileStatus.OPEN) {
                        try {
                            writer.close();
                            writer.throwPendingException();
                        }
                        catch (IOException e) {
                            logger.log(Level.SEVERE, "Failed to close " + file.getLocation().getDescription() + " from property '" + WriterFilePropertyId.this.getName() + "'", e);
                        }
                    }
                }
            }
        });
        return this;
    }

    @Nonnull
    public WriterFilePropertyId withAutoCheck() {
        this.setShutdownHook(new PropertyId.ShutdownRunnable<WriterFile>(){

            @Override
            public void run(WriterFile file) {
                if (file.getStatus() != StreamFileStatus.NOT_USED) {
                    CustomPrintWriter writer = file.getPrintWriter();
                    try {
                        writer.throwPendingException();
                    }
                    catch (IOException e) {
                        String message = "Pending exception writing " + file.getLocation().getDescription() + " from property '" + WriterFilePropertyId.this.getName() + "'";
                        logger.log(Level.SEVERE, message, e);
                        throw new AssertionError((Object)message);
                    }
                    if (file.getStatus() == StreamFileStatus.OPEN) {
                        throw new AssertionError((Object)(file.getLocation().getDescription() + " from property '" + WriterFilePropertyId.this.getName() + "' is not closed"));
                    }
                }
            }
        });
        return this;
    }

    @Nonnull
    public WriterFilePropertyId withoutAutoAction() {
        this.removeShutdownHook();
        return this;
    }

    @Nonnull
    public WriterFilePropertyId addDefaultValue(@Nonnull String defaultValue) {
        super.addDefaultValue(defaultValue);
        return this;
    }

    @Nonnull
    public WriterFilePropertyId addDefaultValue(@Nonnull WriterFile defaultValue) {
        super.addDefaultValue(defaultValue);
        return this;
    }

    @Override
    @Nonnull
    public WriterFilePropertyId requiredIf(@Nonnull BooleanExpression expression) {
        super.requiredIf(expression);
        return this;
    }

    @Nonnull
    public WriterFileCodec getCodec() {
        return (WriterFileCodec)super.getCodec();
    }

    @Nonnull
    public WriterFilePropertyId addCategory(@Nonnull Class<? extends Category> category) {
        super.addCategory((Class)category);
        return this;
    }

    @Override
    @Nonnull
    public WriterFilePropertyId addCategory(@Nonnull Category category) {
        super.addCategory(category);
        return this;
    }
}

