/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.codec;

import com.android.sched.util.codec.CheckingException;
import com.android.sched.util.codec.CodecContext;
import com.android.sched.util.codec.ParsingException;
import com.android.sched.util.codec.Selector;
import com.android.sched.util.codec.StringCodec;
import com.android.sched.util.config.ConfigurationError;
import com.android.sched.util.config.ReflectFactory;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import javax.annotation.Nonnull;

public class ReflectFactorySelector<T>
extends Selector<T>
implements StringCodec<ReflectFactory<T>> {
    private boolean bypassAccessibility = false;
    @Nonnull
    private final ArrayList<Class<?>> argTypes = new ArrayList(1);

    public ReflectFactorySelector(@Nonnull Class<T> cls) {
        super(cls);
    }

    @Nonnull
    public ReflectFactorySelector<T> bypassAccessibility() {
        this.bypassAccessibility = true;
        return this;
    }

    @Nonnull
    public ReflectFactorySelector<T> addArgType(@Nonnull Class<?> argType) {
        this.argTypes.add(argType);
        return this;
    }

    @Override
    @Nonnull
    public ReflectFactory<T> parseString(@Nonnull CodecContext context, @Nonnull String string) {
        try {
            return this.checkString(context, string);
        }
        catch (ParsingException e) {
            throw new ConfigurationError(e);
        }
    }

    @Override
    @Nonnull
    public ReflectFactory<T> checkString(@Nonnull CodecContext context, @Nonnull String string) throws ParsingException {
        Class[] types = this.argTypes.toArray(new Class[this.argTypes.size()]);
        return new ReflectFactory(this.getClass(string), !this.bypassAccessibility, types);
    }

    @Override
    public void checkValue(@Nonnull CodecContext context, @Nonnull ReflectFactory<T> factory) throws CheckingException {
        if (!this.checkClass(factory.getInstanciatedClass())) {
            throw new CheckingException("The value must be a ReflectFactory<{" + Joiner.on(',').join(this.getClasses()) + "}> but is a ReflectFactory<" + factory.getInstanciatedClass().getCanonicalName() + ">");
        }
    }

    @Override
    @Nonnull
    public String formatValue(@Nonnull ReflectFactory<T> factory) {
        return this.getName(factory.getInstanciatedClass());
    }
}

