/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.scheduler;

import com.android.sched.item.Component;
import com.android.sched.scheduler.FitnessPlanCandidate;
import com.android.sched.scheduler.ManagedRunnable;
import com.android.sched.scheduler.Request;
import com.android.sched.scheduler.State;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class GroupPlanCandidate<T extends Component>
extends FitnessPlanCandidate<T>
implements Iterable<ManagedRunnable> {
    @CheckForNull
    private List<Integer> unsatisfiedConstraints;
    @CheckForNull
    private List<Integer> satisfiedConstraints;
    @CheckForNull
    private List<List<Integer>> unsatisfiedGroups;
    @CheckForNull
    private List<List<Integer>> satisfiedGroups;
    @CheckForNull
    private List<Integer> currentGroup;
    @CheckForNull
    private State.ThreeState currentGroupState;

    public GroupPlanCandidate(@Nonnull FitnessPlanCandidate<T> analyzer, @Nonnull List<ManagedRunnable> plan) {
        super(analyzer, plan);
    }

    public GroupPlanCandidate(@Nonnull Request request, @Nonnull Class<T> rootRunOn, @Nonnull List<ManagedRunnable> plan) {
        super(request, rootRunOn, plan);
    }

    @Override
    protected void update(@Nonnull FitnessPlanCandidate.State currentState, int index) {
        super.update(currentState, index);
        this.ensureAllocated();
        assert (this.unsatisfiedConstraints != null);
        assert (this.satisfiedConstraints != null);
        assert (this.unsatisfiedGroups != null);
        assert (this.satisfiedGroups != null);
        assert (this.currentGroup != null);
        assert (this.currentGroupState != null);
        if (currentState.isSatisfied()) {
            this.satisfiedConstraints.add(index);
            if (this.currentGroupState != State.ThreeState.SATISFIED) {
                this.currentGroupState = State.ThreeState.SATISFIED;
                this.satisfiedGroups.add(this.currentGroup);
                this.currentGroup = new ArrayList<Integer>();
            }
        } else {
            this.unsatisfiedConstraints.add(index);
            if (this.currentGroupState != State.ThreeState.UNSATISFIED) {
                this.currentGroupState = State.ThreeState.UNSATISFIED;
                this.unsatisfiedGroups.add(this.currentGroup);
                this.currentGroup = new ArrayList<Integer>();
            }
        }
        this.currentGroup.add(index);
    }

    private void ensureAllocated() {
        this.unsatisfiedConstraints = new ArrayList<Integer>();
        this.satisfiedConstraints = new ArrayList<Integer>();
        this.unsatisfiedGroups = new ArrayList<List<Integer>>();
        this.satisfiedGroups = new ArrayList<List<Integer>>();
        this.currentGroup = new ArrayList<Integer>();
        this.currentGroupState = State.ThreeState.UNDEFINED;
    }

    @Nonnegative
    public int getTotalGroupCount() {
        assert (this.unsatisfiedGroups != null);
        assert (this.satisfiedGroups != null);
        return this.satisfiedGroups.size() + this.unsatisfiedGroups.size();
    }

    @Nonnegative
    public int getSatisfiedGroupCount() {
        assert (this.satisfiedGroups != null);
        return this.satisfiedGroups.size();
    }

    @Nonnegative
    public int getUnsatisfiedGroupCount() {
        assert (this.unsatisfiedGroups != null);
        return this.unsatisfiedGroups.size();
    }

    @Nonnegative
    public int getIndexFromUnsatisfiedIndex(@Nonnegative int index) {
        assert (this.unsatisfiedConstraints != null);
        return this.unsatisfiedConstraints.get(index);
    }

    @Nonnegative
    public int getIndexFromSatisfiedIndex(@Nonnegative int index) {
        assert (this.satisfiedConstraints != null);
        return this.satisfiedConstraints.get(index);
    }
}

