/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.item;

import com.android.sched.item.ComposedOf;
import com.android.sched.item.Description;
import com.android.sched.item.Item;
import com.android.sched.item.Name;
import com.android.sched.item.onlyfor.Default;
import com.android.sched.item.onlyfor.OnlyFor;
import com.android.sched.item.onlyfor.OnlyForType;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class Items {
    @Nonnull
    private static final Class<?>[] EMPTY_COMPOSED_OF = new Class[0];

    private Items() {
    }

    @Nonnull
    public static <T> Class<? extends T>[] getComposedOf(@Nonnull Class<? extends T> item) {
        ComposedOf annotation = item.getAnnotation(ComposedOf.class);
        if (annotation != null && annotation.value() != null) {
            return annotation.value();
        }
        return EMPTY_COMPOSED_OF;
    }

    @Nonnull
    public static String getName(@Nonnull Class<? extends Item> item) {
        Name annotation = item.getAnnotation(Name.class);
        if (annotation != null && annotation.value() != null) {
            return annotation.value();
        }
        return item.getSimpleName();
    }

    @CheckForNull
    public static String getDescription(@Nonnull Class<? extends Item> item) {
        Description annotation = item.getAnnotation(Description.class);
        if (annotation != null && annotation.value() != null) {
            return annotation.value();
        }
        return null;
    }

    @Nonnull
    public static Class<? extends OnlyForType> getOnlyForType(@Nonnull Class<? extends Item> item) {
        OnlyFor ignore = item.getAnnotation(OnlyFor.class);
        if (ignore != null) {
            return ignore.value();
        }
        return Default.class;
    }
}

