/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.coverage;

import com.android.jack.coverage.CoverageFilterSet;
import com.android.jack.coverage.CoveragePattern;
import javax.annotation.Nonnull;

public class CoverageFilter {
    static final String[] EXCLUDED_PACKAGES = new String[]{"org.jacoco.*", "com.vladium.emma.*"};
    @Nonnull
    private final CoverageFilterSet includes;
    @Nonnull
    private final CoverageFilterSet excludes;

    public CoverageFilter(@Nonnull CoverageFilterSet includes, @Nonnull CoverageFilterSet excludes) {
        this.includes = includes.makeCopy();
        this.excludes = excludes.makeCopy();
        for (String packageName : EXCLUDED_PACKAGES) {
            this.excludes.addPattern(new CoveragePattern(packageName));
        }
    }

    public CoverageFilter() {
        this(new CoverageFilterSet(), new CoverageFilterSet());
    }

    public boolean matches(@Nonnull String className) {
        if (this.excludes.matchesAny(className)) {
            return false;
        }
        if (this.includes.isEmpty()) {
            return true;
        }
        return this.includes.matchesAny(className);
    }
}

