/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.config.id;

import com.android.sched.util.config.ConfigurationError;
import com.android.sched.util.config.ReflectDefaultCtorFactory;
import com.android.sched.util.config.id.KeyId;
import java.lang.reflect.Modifier;
import javax.annotation.Nonnull;

public class ObjectId<T>
extends KeyId<T, T> {
    @Nonnull
    private final Class<? extends T> cls;

    public ObjectId(@Nonnull String name, @Nonnull Class<? extends T> cls) {
        super(name);
        this.cls = cls;
    }

    public void checkInstantiability() throws ConfigurationError {
        if (this.cls.isInterface() || Modifier.isAbstract(this.cls.getModifiers())) {
            throw new ConfigurationError("Object id '" + this.getName() + "' is declared with uninstantiable type " + this.cls.getName());
        }
    }

    @Nonnull
    public T createObject() {
        return new ReflectDefaultCtorFactory<T>(this.cls, false).create();
    }
}

