/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.codec;

import com.android.sched.util.codec.CheckingException;
import com.android.sched.util.codec.CodecContext;
import com.android.sched.util.codec.Parser;
import com.android.sched.util.codec.ParsingException;
import com.android.sched.util.codec.StringCodec;
import com.android.sched.util.config.ConfigurationError;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public abstract class ConvertCodec<SRC, DST>
implements StringCodec<DST> {
    @Nonnull
    protected final StringCodec<SRC> codec;

    public ConvertCodec(@Nonnull StringCodec<SRC> codec) {
        this.codec = codec;
    }

    @Nonnull
    protected abstract DST convert(@Nonnull SRC var1) throws ParsingException;

    @Nonnull
    protected abstract SRC revert(@Nonnull DST var1);

    @Override
    @Nonnull
    public DST parseString(@Nonnull CodecContext context, @Nonnull String string) {
        try {
            return this.convert(this.codec.parseString(context, string));
        }
        catch (ParsingException e) {
            throw new ConfigurationError(e);
        }
    }

    @Override
    @CheckForNull
    public DST checkString(@Nonnull CodecContext context, @Nonnull String string) throws ParsingException {
        Object src = this.codec.checkString(context, string);
        if (src == null) {
            return null;
        }
        return this.convert(src);
    }

    @Override
    @Nonnull
    public String formatValue(@Nonnull DST data) {
        return this.codec.formatValue(this.revert(data));
    }

    @Override
    public void checkValue(@Nonnull CodecContext context, @Nonnull DST data) throws CheckingException {
        this.codec.checkValue(context, this.revert(data));
    }

    @Override
    @Nonnull
    public String getUsage() {
        return this.codec.getUsage();
    }

    @Override
    @Nonnull
    public String getVariableName() {
        return this.codec.getVariableName();
    }

    @Override
    @Nonnull
    public List<Parser.ValueDescription> getValueDescriptions() {
        return this.codec.getValueDescriptions();
    }
}

