/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.uncommons.watchmaker.framework.operators;

import com.android.jack.uncommons.maths.number.ConstantGenerator;
import com.android.jack.uncommons.maths.number.NumberGenerator;
import com.android.jack.uncommons.maths.random.Probability;
import com.android.jack.uncommons.watchmaker.framework.EvolutionaryOperator;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class StringMutation
implements EvolutionaryOperator<String> {
    private final char[] alphabet;
    private final NumberGenerator<Probability> mutationProbability;

    public StringMutation(char[] alphabet, Probability mutationProbability) {
        this(alphabet, new ConstantGenerator<Probability>(mutationProbability));
    }

    public StringMutation(char[] alphabet, NumberGenerator<Probability> mutationProbability) {
        this.alphabet = (char[])alphabet.clone();
        this.mutationProbability = mutationProbability;
    }

    @Override
    public List<String> apply(List<String> selectedCandidates, Random rng) {
        ArrayList<String> mutatedPopulation = new ArrayList<String>(selectedCandidates.size());
        for (String s : selectedCandidates) {
            mutatedPopulation.add(this.mutateString(s, rng));
        }
        return mutatedPopulation;
    }

    private String mutateString(String s, Random rng) {
        StringBuilder buffer = new StringBuilder(s);
        for (int i = 0; i < buffer.length(); ++i) {
            if (!this.mutationProbability.nextValue().nextEvent(rng)) continue;
            buffer.setCharAt(i, this.alphabet[rng.nextInt(this.alphabet.length)]);
        }
        return buffer.toString();
    }
}

