/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.uncommons.watchmaker.framework;

import com.android.jack.uncommons.watchmaker.framework.AbstractEvolutionEngine;
import com.android.jack.uncommons.watchmaker.framework.CandidateFactory;
import com.android.jack.uncommons.watchmaker.framework.EvaluatedCandidate;
import com.android.jack.uncommons.watchmaker.framework.EvolutionUtils;
import com.android.jack.uncommons.watchmaker.framework.EvolutionaryOperator;
import com.android.jack.uncommons.watchmaker.framework.FitnessEvaluator;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class EvolutionStrategyEngine<T>
extends AbstractEvolutionEngine<T> {
    private final EvolutionaryOperator<T> evolutionScheme;
    private final FitnessEvaluator<? super T> fitnessEvaluator;
    private final boolean plusSelection;
    private final int offspringMultiplier;

    public EvolutionStrategyEngine(CandidateFactory<T> candidateFactory, EvolutionaryOperator<T> evolutionScheme, FitnessEvaluator<? super T> fitnessEvaluator, boolean plusSelection, int offspringMultiplier, Random rng) {
        super(candidateFactory, fitnessEvaluator, rng);
        this.evolutionScheme = evolutionScheme;
        this.fitnessEvaluator = fitnessEvaluator;
        this.plusSelection = plusSelection;
        this.offspringMultiplier = offspringMultiplier;
    }

    @Override
    protected List<EvaluatedCandidate<T>> nextEvolutionStep(List<EvaluatedCandidate<T>> evaluatedPopulation, int eliteCount, Random rng) {
        assert (eliteCount == 0) : "Explicit elitism is not supported for an ES, eliteCount should be 0.";
        int offspringCount = this.offspringMultiplier * evaluatedPopulation.size();
        ArrayList<T> parents = new ArrayList<T>(offspringCount);
        for (int i = 0; i < offspringCount; ++i) {
            parents.add(evaluatedPopulation.get(rng.nextInt(evaluatedPopulation.size())).getCandidate());
        }
        List<T> offspring = this.evolutionScheme.apply(parents, rng);
        List<EvaluatedCandidate<T>> evaluatedOffspring = this.evaluatePopulation(offspring);
        if (this.plusSelection) {
            evaluatedOffspring.addAll(evaluatedPopulation);
        }
        EvolutionUtils.sortEvaluatedPopulation(evaluatedOffspring, this.fitnessEvaluator.isNatural());
        return evaluatedOffspring.subList(0, evaluatedPopulation.size());
    }
}

