/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.uselessif;

import com.android.jack.Options;
import com.android.jack.ir.ast.JBooleanLiteral;
import com.android.jack.ir.ast.JIfStatement;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.scheduling.filter.SourceTypeFilter;
import com.android.jack.transformations.SanityChecks;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Support;
import com.android.sched.util.config.ThreadConfig;
import javax.annotation.Nonnull;

@Description(value="Checks that there is no if statement with a condition that is a boolean literal.")
@Name(value="UselessIfChecker")
@Constraint(need={JIfStatement.class})
@Support(value={SanityChecks.class})
@com.android.sched.schedulable.Filter(value={SourceTypeFilter.class})
public class UselessIfChecker
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        UselessIfCheckerVisitor visitor = new UselessIfCheckerVisitor();
        visitor.accept(method);
    }

    private static class UselessIfCheckerVisitor
    extends JVisitor {
        private UselessIfCheckerVisitor() {
        }

        @Override
        public boolean visit(@Nonnull JIfStatement ifStmt) {
            if (ifStmt.getIfExpr() instanceof JBooleanLiteral) {
                throw new AssertionError((Object)"All useless if should have been removed");
            }
            return super.visit(ifStmt);
        }
    }
}

