/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.ast.switches;

import com.android.jack.Options;
import com.android.jack.ir.ast.JCaseStatement;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JStatementList;
import com.android.jack.ir.ast.JSwitchStatement;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.transformations.ast.switches.UselessSwitches;
import com.android.jack.transformations.request.Remove;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.util.ControlFlowHelper;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.util.config.ThreadConfig;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Removes useless cases from switch statements.")
@Constraint(need={JSwitchStatement.class})
@Transform(add={UselessSwitches.class})
@com.android.sched.schedulable.Filter(value={TypeWithoutPrebuiltFilter.class})
public class UselessCaseRemover
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        new Remover().accept(method);
    }

    private static class Remover
    extends JVisitor {
        @CheckForNull
        private TransformationRequest tr;

        private Remover() {
        }

        @Override
        public boolean visit(@Nonnull JMethod method) {
            this.tr = new TransformationRequest(method);
            return super.visit(method);
        }

        @Override
        public void endVisit(@Nonnull JMethod method) {
            assert (this.tr != null);
            this.tr.commit();
            super.endVisit(method);
        }

        @Override
        public boolean visit(@Nonnull JCaseStatement caseStmt) {
            JStatement nextStmt = caseStmt;
            do {
                assert (nextStmt != null);
                nextStmt = ControlFlowHelper.getNextStatement(nextStmt);
                while (nextStmt instanceof JStatementList) {
                    nextStmt = ControlFlowHelper.getConcreteStatement((JStatementList)nextStmt);
                }
            } while (this.isCaseStmt(nextStmt));
            if (this.isDefaultCaseStmt(nextStmt)) {
                assert (this.tr != null);
                this.tr.append(new Remove(caseStmt));
                caseStmt.getParent(JSwitchStatement.class).removeCase(caseStmt);
            }
            return super.visit(caseStmt);
        }

        private boolean isCaseStmt(@CheckForNull JStatement stmt) {
            return stmt instanceof JCaseStatement && ((JCaseStatement)stmt).getExpr() != null;
        }

        private boolean isDefaultCaseStmt(@CheckForNull JStatement stmt) {
            return stmt instanceof JCaseStatement && ((JCaseStatement)stmt).getExpr() == null;
        }
    }
}

