/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations.ast.splitnew;

import com.android.jack.Options;
import com.android.jack.ir.ast.JAlloc;
import com.android.jack.ir.ast.JAsgOperation;
import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JLocal;
import com.android.jack.ir.ast.JLocalRef;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodCall;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.ir.ast.JMultiExpression;
import com.android.jack.ir.ast.JNewInstance;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.transformations.LocalVarCreator;
import com.android.jack.transformations.ast.NewInstanceRemoved;
import com.android.jack.transformations.request.Replace;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.transformations.threeaddresscode.ThreeAddressCodeForm;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.schedulable.Use;
import com.android.sched.util.config.ThreadConfig;
import javax.annotation.Nonnull;

@Description(value="Splits JSymbolicNewInstance into JAlloc and JSymbolicCall")
@Name(value="SplitNewInstance")
@Transform(add={JAlloc.class, JAsgOperation.NonReusedAsg.class, JLocalRef.class, JMultiExpression.class, NewInstanceRemoved.class}, remove={JNewInstance.class, ThreeAddressCodeForm.class})
@Use(value={LocalVarCreator.class})
@com.android.sched.schedulable.Filter(value={TypeWithoutPrebuiltFilter.class})
public class SplitNewInstance
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);
    @Nonnull
    private static final String LOCAL_VAR_PREFIX = "sni";

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        TransformationRequest request = new TransformationRequest(method);
        Visitor visitor = new Visitor(request, new LocalVarCreator(method, LOCAL_VAR_PREFIX));
        visitor.accept(method);
        request.commit();
    }

    @Transform(add={JAlloc.class, JAsgOperation.NonReusedAsg.class, JLocalRef.class})
    @Use(value={LocalVarCreator.class})
    public static class NewExpressionSplitter {
        @Nonnull
        public static JExpression[] splitNewInstance(@Nonnull JNewInstance newInstance, @Nonnull TransformationRequest request, @Nonnull LocalVarCreator varCreator) {
            SourceInfo srcInfos = newInstance.getSourceInfo();
            JClass type = newInstance.getType();
            JAlloc alloc = new JAlloc(srcInfos, type);
            JLocal tmp = varCreator.createTempLocal(type, srcInfos, request);
            JAsgOperation assign = new JAsgOperation(srcInfos, tmp.makeRef(srcInfos), alloc);
            JMethodIdWide methodId = newInstance.getMethodId();
            JMethodCall initCall = new JMethodCall(srcInfos, tmp.makeRef(srcInfos), type, methodId, JPrimitiveType.JPrimitiveTypeEnum.VOID.getType(), methodId.canBeVirtual());
            initCall.addArgs(newInstance.getArgs());
            JLocalRef result = tmp.makeRef(srcInfos);
            return new JExpression[]{assign, initCall, result};
        }
    }

    private static class Visitor
    extends JVisitor {
        @Nonnull
        private final TransformationRequest request;
        @Nonnull
        private final LocalVarCreator lvCreator;

        private Visitor(@Nonnull TransformationRequest request, @Nonnull LocalVarCreator lvCreator) {
            this.request = request;
            this.lvCreator = lvCreator;
        }

        @Override
        public boolean visit(@Nonnull JNewInstance newInstance) {
            SourceInfo srcInfos = newInstance.getSourceInfo();
            JExpression[] exprs = NewExpressionSplitter.splitNewInstance(newInstance, this.request, this.lvCreator);
            JMultiExpression splittedNewInstance = new JMultiExpression(srcInfos, exprs);
            this.request.append(new Replace(newInstance, splittedNewInstance));
            return super.visit(newInstance);
        }
    }
}

