/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.transformations;

import com.android.jack.ir.ast.JAbstractMethodBody;
import com.android.jack.ir.ast.JLocal;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodBody;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.transformations.request.AddJLocalInMethodBody;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.util.NamingTools;
import com.android.sched.schedulable.Transform;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

@Transform(add={JLocal.class})
public class LocalVarCreator {
    @Nonnull
    private final JMethodBody currentMethodBody;
    @Nonnull
    private final String tmpLocalVarPrefix;
    @Nonnegative
    private int tmpLocalVarSuffix = 0;

    public LocalVarCreator(@Nonnull JMethod method, @Nonnull String prefix) {
        JAbstractMethodBody body = method.getBody();
        assert (body != null);
        assert (body instanceof JMethodBody);
        this.currentMethodBody = (JMethodBody)body;
        this.tmpLocalVarPrefix = prefix;
    }

    @Nonnull
    public JLocal createTempLocal(@Nonnull JType type, @Nonnull SourceInfo sourceInfo, @Nonnull TransformationRequest transformationRequest) {
        String name = NamingTools.getNonSourceConflictingName(this.tmpLocalVarPrefix + this.tmpLocalVarSuffix++);
        JLocal local = new JLocal(sourceInfo, name, type, 4096, this.currentMethodBody);
        transformationRequest.append(new AddJLocalInMethodBody(local, this.currentMethodBody));
        return local;
    }
}

