/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.shrob.shrink;

import com.android.jack.Jack;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JField;
import com.android.jack.shrob.shrink.KeepMarker;
import com.android.jack.shrob.shrink.ShrinkStatistic;
import com.android.jack.transformations.request.Remove;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.sched.item.Description;
import com.android.sched.item.Synchronized;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.ExclusiveAccess;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.util.log.LoggerFactory;
import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.TracerFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

@Description(value="Removes all fields not marked with the KeepMarker")
@Synchronized
@Constraint(need={KeepMarker.class})
@ExclusiveAccess(value=JDefinedClassOrInterface.class)
public class FieldShrinker
implements RunnableSchedulable<JField> {
    @Nonnull
    private static final Logger logger = LoggerFactory.getLogger();
    @Nonnull
    private final Tracer tracer = TracerFactory.getTracer();

    @Override
    public synchronized void run(@Nonnull JField field) {
        boolean toRemove;
        boolean bl = toRemove = !field.containsMarker(KeepMarker.class);
        if (toRemove) {
            TransformationRequest request = new TransformationRequest(field);
            request.append(new Remove(field));
            request.commit();
            logger.log(Level.INFO, "Removed field {0} from {1}", new Object[]{field.getName(), Jack.getUserFriendlyFormatter().getName(field.getEnclosingType())});
        }
        this.tracer.getStatistic(ShrinkStatistic.FIELDS_REMOVED).add(toRemove);
    }
}

