/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.optimizations.valuepropagation.argument;

import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JInterface;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.MethodKind;
import com.android.jack.optimizations.common.LiteralValueListTracker;
import com.android.jack.optimizations.common.SimpleLiteralValueListTracker;
import com.android.jack.optimizations.valuepropagation.argument.AvpSchedulable;
import com.android.jack.optimizations.valuepropagation.argument.MethodCallArgumentsMarker;
import com.android.jack.optimizations.valuepropagation.argument.TaintedVirtualMethodsMarker;
import com.android.jack.optimizations.valuepropagation.argument.TypeMethodCallArgumentsMarker;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.marker.Marker;
import com.android.sched.marker.ValidOn;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Argument value propagation, propagation of single-valued arguments")
@Constraint(need={TaintedVirtualMethodsMarker.class, TypeMethodCallArgumentsMarker.class})
@Transform(add={MethodCallArgumentsMarker.class, AvpSchedulable.TaintedMethodMarker.class})
@Name(value="ArgumentValuePropagation: ComputeMethodArgumentsValues")
public class AvpComputeMethodArgumentsValues
extends AvpSchedulable
implements RunnableSchedulable<JSession> {
    @Nonnull
    private TypeMethodTable computeTypeMethodTable(@Nonnull JDefinedClassOrInterface type) {
        assert (!type.containsMarker(TypeMethodTable.class));
        TypeMethodTable marker = new TypeMethodTable(type);
        type.addMarker(marker);
        return marker;
    }

    @Override
    public void run(@Nonnull JSession session) {
        List<JDefinedClassOrInterface> sortedTypes = AvpComputeMethodArgumentsValues.sortTopologically(session.getTypesToEmit());
        this.computeVirtualCallArguments(sortedTypes);
        for (JDefinedClassOrInterface type : sortedTypes) {
            type.removeMarker(TypeMethodTable.class);
            type.removeMarker(CumulativeArguments.class);
        }
    }

    private void computeVirtualCallArguments(@Nonnull List<JDefinedClassOrInterface> sortedTypes) {
        for (int i = sortedTypes.size() - 1; i >= 0; --i) {
            JDefinedClassOrInterface type = sortedTypes.get(i);
            TypeMethodTable methodTable = this.computeTypeMethodTable(type);
            CumulativeArguments virtualCallArgs = CumulativeArguments.compute(type, TypeMethodCallArgumentsMarker.getCallsArgsOnType(type, true));
            methodTable.markCallArgs(virtualCallArgs.values);
            ConcurrentMap<String, LiteralValueListTracker> directCallArgs = TypeMethodCallArgumentsMarker.getCallsArgsOnType(type, false);
            if (directCallArgs == null) continue;
            methodTable.markCallArgs(directCallArgs);
        }
    }

    @Nonnull
    private static List<JDefinedClassOrInterface> sortTopologically(@Nonnull Collection<JDefinedClassOrInterface> types) {
        for (JDefinedClassOrInterface jDefinedClassOrInterface : types) {
            JClass superClass = jDefinedClassOrInterface.getSuperClass();
            if (superClass != null && superClass.isToEmit()) {
                TypeRefCounter.inc((JDefinedClassOrInterface)((Object)superClass));
            }
            for (JInterface impl : jDefinedClassOrInterface.getImplements()) {
                if (!impl.isToEmit()) continue;
                TypeRefCounter.inc((JDefinedClassOrInterface)((Object)impl));
            }
        }
        LinkedList<JDefinedClassOrInterface> queue = new LinkedList<JDefinedClassOrInterface>();
        for (JDefinedClassOrInterface type : types) {
            if (type.containsMarker(TypeRefCounter.class)) continue;
            queue.offer(type);
        }
        ArrayList<JDefinedClassOrInterface> arrayList = new ArrayList<JDefinedClassOrInterface>();
        while (!queue.isEmpty()) {
            JDefinedClassOrInterface type;
            type = (JDefinedClassOrInterface)queue.poll();
            arrayList.add(type);
            JClass superClass = type.getSuperClass();
            if (superClass != null && superClass.isToEmit() && TypeRefCounter.dec((JDefinedClassOrInterface)((Object)superClass))) {
                queue.offer((JDefinedClassOrInterface)((Object)superClass));
            }
            for (JInterface impl : type.getImplements()) {
                if (!impl.isToEmit() || !TypeRefCounter.dec((JDefinedClassOrInterface)((Object)impl))) continue;
                queue.offer((JDefinedClassOrInterface)((Object)impl));
            }
        }
        return arrayList;
    }

    @Description(value="Interim: type's 'extended' method table")
    @ValidOn(value={JDefinedClassOrInterface.class})
    private class TypeMethodTable
    implements Marker {
        @Nonnull
        private final Map<String, JMethod> methods = new HashMap<String, JMethod>();

        void markCallArgs(@Nonnull Map<String, LiteralValueListTracker> args) {
            for (Map.Entry<String, JMethod> e : this.methods.entrySet()) {
                LiteralValueListTracker tracker = args.get(e.getKey());
                if (tracker == null) continue;
                MethodCallArgumentsMarker.markArgValues(e.getValue(), tracker);
            }
        }

        private TypeMethodTable(JDefinedClassOrInterface type) {
            JClass superClass = type.getSuperClass();
            if (superClass != null) {
                this.mergeWith(superClass);
            }
            for (JMethod method : type.getMethods()) {
                this.methods.put(AvpComputeMethodArgumentsValues.this.getMethodSignature(method), method);
            }
            for (JInterface impl : type.getImplements()) {
                this.mergeWith(impl);
            }
            TaintedVirtualMethodsMarker tainted = TaintedVirtualMethodsMarker.getMarker(type);
            assert (tainted != null);
            Iterator<Map.Entry<String, JMethod>> iterator = this.methods.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, JMethod> next = iterator.next();
                String signature = next.getKey();
                JMethod method = next.getValue();
                if (method.getMethodIdWide().getKind() != MethodKind.INSTANCE_VIRTUAL || !tainted.isMethodTainted(signature)) continue;
                AvpSchedulable.TaintedMethodMarker.markAsTainted(method);
                iterator.remove();
            }
        }

        private void mergeWith(@Nonnull JType type) {
            if (type instanceof JDefinedClassOrInterface && ((JDefinedClassOrInterface)type).isToEmit()) {
                TypeMethodTable other = ((JDefinedClassOrInterface)type).getMarker(TypeMethodTable.class);
                assert (other != null);
                for (Map.Entry<String, JMethod> e : other.methods.entrySet()) {
                    JMethod method = e.getValue();
                    if (method.getMethodIdWide().isInit() || method.isPrivate() || this.methods.containsKey(e.getKey())) continue;
                    this.methods.put(e.getKey(), method);
                }
            }
        }

        @Override
        @Nonnull
        public Marker cloneIfNeeded() {
            throw new AssertionError();
        }
    }

    @Description(value="Interim: Tracks cumulative call arguments reaching this type")
    @ValidOn(value={JDefinedClassOrInterface.class})
    private static class CumulativeArguments
    implements Marker {
        @Nonnull
        final Map<String, LiteralValueListTracker> values = new HashMap<String, LiteralValueListTracker>();

        private CumulativeArguments(@Nonnull JDefinedClassOrInterface type, @CheckForNull Map<String, LiteralValueListTracker> callsOnType) {
            TaintedVirtualMethodsMarker tainted = TaintedVirtualMethodsMarker.getMarker(type);
            assert (tainted != null);
            CumulativeArguments.mergeMethodTrackers(this.values, callsOnType, tainted);
            JClass superClass = type.getSuperClass();
            if (superClass != null && superClass.isToEmit()) {
                CumulativeArguments marker = ((JDefinedClassOrInterface)((Object)superClass)).getMarker(CumulativeArguments.class);
                assert (marker != null);
                CumulativeArguments.mergeMethodTrackers(this.values, marker.values, tainted);
            }
            for (JInterface impl : type.getImplements()) {
                if (!impl.isToEmit()) continue;
                CumulativeArguments marker = ((JDefinedClassOrInterface)((Object)impl)).getMarker(CumulativeArguments.class);
                assert (marker != null);
                CumulativeArguments.mergeMethodTrackers(this.values, marker.values, tainted);
            }
        }

        private static void mergeMethodTrackers(@Nonnull Map<String, LiteralValueListTracker> mergeTarget, @CheckForNull Map<String, LiteralValueListTracker> newData, @Nonnull TaintedVirtualMethodsMarker tainted) {
            if (newData != null) {
                for (Map.Entry<String, LiteralValueListTracker> e : newData.entrySet()) {
                    String signature = e.getKey();
                    if (tainted.isMethodTainted(signature)) continue;
                    LiteralValueListTracker tracker = e.getValue();
                    LiteralValueListTracker accumulatedTracker = mergeTarget.get(signature);
                    if (accumulatedTracker == null) {
                        accumulatedTracker = new SimpleLiteralValueListTracker(tracker.size());
                        mergeTarget.put(signature, accumulatedTracker);
                    }
                    accumulatedTracker.updateWith(tracker);
                }
            }
        }

        @Nonnull
        static CumulativeArguments compute(@Nonnull JDefinedClassOrInterface type, @CheckForNull Map<String, LiteralValueListTracker> callsOnType) {
            assert (!type.containsMarker(CumulativeArguments.class));
            CumulativeArguments marker = new CumulativeArguments(type, callsOnType);
            type.addMarker(marker);
            return marker;
        }

        @Override
        @Nonnull
        public Marker cloneIfNeeded() {
            throw new AssertionError();
        }
    }

    @Description(value="Interim: counts a number of downstream references on a type")
    @ValidOn(value={JDefinedClassOrInterface.class})
    private static class TypeRefCounter
    implements Marker {
        private int count = 0;

        private TypeRefCounter() {
        }

        static void inc(@Nonnull JDefinedClassOrInterface type) {
            TypeRefCounter marker = type.getMarker(TypeRefCounter.class);
            if (marker == null) {
                marker = new TypeRefCounter();
                type.addMarker(marker);
            }
            ++marker.count;
        }

        static boolean dec(@Nonnull JDefinedClassOrInterface type) {
            TypeRefCounter marker = type.getMarker(TypeRefCounter.class);
            assert (marker != null);
            --marker.count;
            if (marker.count == 0) {
                type.removeMarker(TypeRefCounter.class);
            }
            return marker.count == 0;
        }

        @Override
        @Nonnull
        public Marker cloneIfNeeded() {
            throw new AssertionError();
        }
    }
}

