/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.optimizations.modifiers;

import com.android.jack.ir.ast.JDefinedClass;
import com.android.sched.item.Description;
import com.android.sched.marker.Marker;
import com.android.sched.marker.ValidOn;
import javax.annotation.Nonnull;

@Description(value="Marker records the 'effectively final' flag on classes.")
@ValidOn(value={JDefinedClass.class})
public enum EffectivelyFinalClassMarker implements Marker
{
    Final;


    @Override
    @Nonnull
    public Marker cloneIfNeeded() {
        return this;
    }

    public static boolean isEffectivelyFinal(@Nonnull JDefinedClass type) {
        return type.getMarker(EffectivelyFinalClassMarker.class) != null;
    }

    public static void markAsEffectivelyFinal(@Nonnull JDefinedClass type) {
        if (!EffectivelyFinalClassMarker.isEffectivelyFinal(type)) {
            type.addMarker(Final);
        }
    }
}

