/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.optimizations;

import com.android.jack.Options;
import com.android.jack.analysis.DefinitionMarker;
import com.android.jack.analysis.UseDefsMarker;
import com.android.jack.cfg.BasicBlock;
import com.android.jack.cfg.BasicBlockMarker;
import com.android.jack.cfg.ConditionalBasicBlock;
import com.android.jack.cfg.ControlFlowGraph;
import com.android.jack.ir.ast.JBlock;
import com.android.jack.ir.ast.JBooleanLiteral;
import com.android.jack.ir.ast.JGoto;
import com.android.jack.ir.ast.JIfStatement;
import com.android.jack.ir.ast.JLabel;
import com.android.jack.ir.ast.JLabeledStatement;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JSwitchStatement;
import com.android.jack.ir.ast.JVariableRef;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.optimizations.Optimizations;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.transformations.ast.NoImplicitBlock;
import com.android.jack.transformations.request.AppendBefore;
import com.android.jack.transformations.request.AppendStatement;
import com.android.jack.transformations.request.PrependAfter;
import com.android.jack.transformations.request.PrependStatement;
import com.android.jack.transformations.request.Remove;
import com.android.jack.transformations.request.Replace;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.jack.transformations.threeaddresscode.ThreeAddressCodeForm;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Support;
import com.android.sched.util.config.ThreadConfig;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

@Description(value="Simplify if that uses only boolean constants.")
@Constraint(need={UseDefsMarker.class, NoImplicitBlock.class, ThreeAddressCodeForm.class, ControlFlowGraph.class})
@Support(value={Optimizations.IfSimplifier.class})
@com.android.sched.schedulable.Filter(value={TypeWithoutPrebuiltFilter.class})
public class IfWithConstantSimplifier
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        ControlFlowGraph cfg = method.getMarker(ControlFlowGraph.class);
        assert (cfg != null);
        for (BasicBlock bb : cfg.getNodes()) {
            if (!(bb instanceof ConditionalBasicBlock)) continue;
            for (JStatement stmt : bb.getStatements()) {
                Visitor visitor = new Visitor(method);
                visitor.accept(stmt);
            }
        }
    }

    private static class Visitor
    extends JVisitor {
        @Nonnegative
        private int count;
        @Nonnull
        private final JMethod method;

        public Visitor(@Nonnull JMethod method) {
            this.method = method;
        }

        @Override
        public boolean visit(@Nonnull JIfStatement ifStmt) {
            if (ifStmt.getIfExpr() instanceof JVariableRef && ((JVariableRef)ifStmt.getIfExpr()).getTarget().isSynthetic()) {
                UseDefsMarker udm = ifStmt.getIfExpr().getMarker(UseDefsMarker.class);
                assert (udm != null);
                assert (!udm.isWithoutDefinition());
                boolean allDefsAreBooleanCstAndUseByIfStmt = true;
                JLabeledStatement thenLabel = null;
                JLabeledStatement elseLabel = null;
                TransformationRequest tr = new TransformationRequest(this.method);
                SourceInfo si = ifStmt.getThenStmt().getSourceInfo();
                JStatement elseStmt = ifStmt.getElseStmt();
                for (DefinitionMarker dm : udm.getDefs()) {
                    if (dm.hasValue() && dm.getValue() instanceof JBooleanLiteral && dm.isUsedOnlyOnce() && !this.hasCodeBetweenDefAndUsage(dm, ifStmt)) {
                        if (((JBooleanLiteral)dm.getValue()).getValue()) {
                            if (thenLabel == null) {
                                thenLabel = new JLabeledStatement(si, new JLabel(si, "ifSimplierThen_" + this.count), new JBlock(si));
                                tr.append(new PrependStatement((JBlock)ifStmt.getThenStmt(), thenLabel));
                            }
                            assert (thenLabel != null);
                            tr.append(new Replace(dm.getDefinition().getParent(), new JGoto(si, thenLabel)));
                            continue;
                        }
                        if (elseStmt != null) {
                            if (elseLabel == null) {
                                elseLabel = new JLabeledStatement(si, new JLabel(si, "ifSimplierElse_" + this.count), new JBlock(si));
                                tr.append(new PrependStatement((JBlock)elseStmt, elseLabel));
                            }
                        } else if (elseLabel == null) {
                            elseLabel = new JLabeledStatement(si, new JLabel(si, "ifSimplierEnd_" + this.count), new JBlock(si));
                            tr.append(new PrependAfter(ifStmt, elseLabel));
                        }
                        tr.append(new Replace(dm.getDefinition().getParent(), new JGoto(si, elseLabel)));
                        continue;
                    }
                    allDefsAreBooleanCstAndUseByIfStmt = false;
                }
                if (allDefsAreBooleanCstAndUseByIfStmt) {
                    tr.append(new AppendBefore(ifStmt, ifStmt.getThenStmt()));
                    if (elseStmt != null) {
                        tr.append(new AppendBefore(ifStmt, elseStmt));
                        JBlock thenBb = (JBlock)ifStmt.getThenStmt();
                        List<JStatement> thenStatements = thenBb.getStatements();
                        JLabeledStatement endLabel = new JLabeledStatement(si, new JLabel(si, "ifSimplierEnd_" + this.count), new JBlock(si));
                        if (!thenStatements.isEmpty()) {
                            JStatement lastStatement = this.getLastStatement(thenStatements);
                            if (!lastStatement.isUnconditionalBranch()) {
                                tr.append(new PrependAfter(lastStatement, new JGoto(si, endLabel)));
                                tr.append(new PrependAfter(ifStmt, endLabel));
                            }
                        } else {
                            tr.append(new AppendStatement(thenBb, new JGoto(si, endLabel)));
                            tr.append(new PrependAfter(ifStmt, endLabel));
                        }
                    }
                    tr.append(new Remove(ifStmt));
                }
                ++this.count;
                tr.commit();
            }
            return false;
        }

        @Override
        public boolean visit(@Nonnull JSwitchStatement switchStmt) {
            super.visit(switchStmt);
            this.accept(switchStmt.getExpr());
            return false;
        }

        @Nonnull
        private JStatement getLastStatement(@Nonnull List<JStatement> thenStatements) {
            JStatement lastStatement = thenStatements.get(thenStatements.size() - 1);
            while (lastStatement instanceof JBlock) {
                thenStatements = ((JBlock)lastStatement).getStatements();
                lastStatement = thenStatements.get(thenStatements.size() - 1);
            }
            return lastStatement;
        }

        private boolean hasCodeBetweenDefAndUsage(@Nonnull DefinitionMarker dm, @Nonnull JIfStatement ifStmt) {
            BasicBlockMarker ifStmtBbMarker = ifStmt.getMarker(BasicBlockMarker.class);
            assert (ifStmtBbMarker != null);
            BasicBlock ifStmtBasicBlock = ifStmtBbMarker.getBasicBlock();
            JNode defStmt = dm.getDefinition().getParent();
            BasicBlockMarker bbm = defStmt.getMarker(BasicBlockMarker.class);
            assert (bbm != null);
            BasicBlock defBasicBlock = bbm.getBasicBlock();
            List<JStatement> statementsOfDefBlock = defBasicBlock.getStatements();
            int lastStmtIndex = statementsOfDefBlock.size() - 1;
            if (defBasicBlock == ifStmtBasicBlock) {
                assert (statementsOfDefBlock.get(lastStmtIndex) == ifStmt);
                if (statementsOfDefBlock.get(lastStmtIndex - 1) == defStmt) {
                    return false;
                }
            } else if (statementsOfDefBlock.get(lastStmtIndex) == defStmt) {
                for (BasicBlock succ : defBasicBlock.getSuccessors()) {
                    if (succ.getStatements().get(0) != ifStmt) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

