/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0003.nodes;

import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JMethodCall;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.ir.ast.MethodKind;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.jayce.v0003.io.ExportSession;
import com.android.jack.jayce.v0003.io.ImportHelper;
import com.android.jack.jayce.v0003.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0003.io.JayceInternalWriterImpl;
import com.android.jack.jayce.v0003.io.Token;
import com.android.jack.jayce.v0003.nodes.NExpression;
import com.android.jack.jayce.v0003.nodes.NSourceInfo;
import com.android.jack.lookup.JMethodLookupException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NMethodCall
extends NExpression {
    @Nonnull
    public static final Token TOKEN = Token.METHOD_CALL;
    @CheckForNull
    public NExpression instance;
    @CheckForNull
    public String receiverType;
    public ReceiverKind receiverKind;
    @CheckForNull
    public String methodName;
    @Nonnull
    public List<String> methodArgsType = Collections.emptyList();
    @CheckForNull
    public MethodKind methodKind;
    @CheckForNull
    public String returnType;
    @Nonnull
    public List<NExpression> args = Collections.emptyList();
    @CheckForNull
    public JMethodCall.DispatchKind dispatchKind;
    @CheckForNull
    public NSourceInfo sourceInfo;

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JMethodCall jMethodCall = (JMethodCall)node;
        this.instance = (NExpression)loader.load(jMethodCall.getInstance());
        this.receiverType = ImportHelper.getSignatureName(jMethodCall.getReceiverType());
        this.receiverKind = this.getReceiverKind(jMethodCall);
        this.methodName = jMethodCall.getMethodId().getName();
        this.methodArgsType = ImportHelper.getMethodArgsSignature(jMethodCall.getMethodId());
        this.methodKind = jMethodCall.getMethodId().getKind();
        this.returnType = ImportHelper.getSignatureName(jMethodCall.getType());
        this.args = loader.load(NExpression.class, jMethodCall.getArgs());
        this.dispatchKind = jMethodCall.getDispatchKind();
        this.sourceInfo = loader.load(jMethodCall.getSourceInfo());
    }

    private ReceiverKind getReceiverKind(JMethodCall jMethodCall) {
        return jMethodCall.getReceiverType() instanceof JClass ? ReceiverKind.CLASS : ReceiverKind.INTERFACE;
    }

    @Override
    @Nonnull
    public JMethodCall exportAsJast(@Nonnull ExportSession exportSession) throws JTypeLookupException, JMethodLookupException {
        assert (this.sourceInfo != null);
        assert (this.receiverType != null);
        assert (this.receiverKind != null);
        assert (this.methodName != null);
        assert (this.methodArgsType != null);
        assert (this.methodKind != null);
        assert (this.returnType != null);
        assert (this.dispatchKind != null);
        JExpression jInstance = this.instance != null ? this.instance.exportAsJast(exportSession) : null;
        JClassOrInterface jReceiverType = this.receiverKind == ReceiverKind.CLASS ? exportSession.getLookup().getClass(this.receiverType) : exportSession.getLookup().getInterface(this.receiverType);
        JMethodIdWide methodId = jReceiverType.getOrCreateMethodIdWide(this.methodName, exportSession.getTypeListFromSignatureList(this.methodArgsType), this.methodKind);
        JType jReturnType = exportSession.getLookup().getType(this.returnType);
        SourceInfo jSourceInfo = this.sourceInfo.exportAsJast(exportSession);
        JMethodCall jMethodCall = new JMethodCall(jSourceInfo, jInstance, jReceiverType, methodId, jReturnType, this.dispatchKind == JMethodCall.DispatchKind.VIRTUAL);
        for (NExpression arg : this.args) {
            jMethodCall.addArg(arg.exportAsJast(exportSession));
        }
        return jMethodCall;
    }

    @Override
    public void writeContent(@Nonnull JayceInternalWriterImpl out) throws IOException {
        assert (this.receiverType != null);
        assert (this.receiverKind != null);
        assert (this.methodName != null);
        assert (this.methodKind != null);
        assert (this.returnType != null);
        assert (this.dispatchKind != null);
        assert (this.sourceInfo != null);
        out.writeNode(this.instance);
        out.writeId(this.receiverType);
        out.writeReceiverKindEnum(this.receiverKind);
        out.writeId(this.methodName);
        out.writeIds(this.methodArgsType);
        out.writeMethodKindEnum(this.methodKind);
        out.writeId(this.returnType);
        out.writeNodes(this.args);
        out.writeDispatchKindEnum(this.dispatchKind);
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.instance = in.readNode(NExpression.class);
        this.receiverType = in.readId();
        this.receiverKind = in.readReceiverKindEnum();
        this.methodName = in.readId();
        this.methodArgsType = in.readIds();
        this.methodKind = in.readMethodKindEnum();
        this.returnType = in.readId();
        this.args = in.readNodes(NExpression.class);
        this.dispatchKind = in.readDispatchKindEnum();
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }

    @Override
    @Nonnull
    public NSourceInfo getSourceInfos() {
        assert (this.sourceInfo != null);
        return this.sourceInfo;
    }

    @Override
    public void setSourceInfos(@Nonnull NSourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
    }

    public static enum ReceiverKind {
        CLASS,
        INTERFACE;

    }
}

