/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.naming;

import com.android.jack.ir.ast.JArrayType;
import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.formatter.BinaryQualifiedNameFormatter;
import com.android.jack.ir.formatter.BinarySignatureFormatter;
import com.android.jack.ir.formatter.SourceFormatter;
import com.android.jack.ir.formatter.TypeFormatter;
import com.android.jack.ir.naming.AbstractName;
import javax.annotation.Nonnull;

public class TypeName
extends AbstractName {
    @Nonnull
    private static final TypeFormatter binaryQnFormatter = BinaryQualifiedNameFormatter.getFormatter();
    @Nonnull
    private static final TypeFormatter binarySignatureFormatter = BinarySignatureFormatter.getFormatter();
    @Nonnull
    private static final TypeFormatter sourceQnFormatter = SourceFormatter.getFormatter();
    @Nonnull
    private final JType type;
    @Nonnull
    private final Kind kind;

    public TypeName(@Nonnull Kind kind, @Nonnull JType type) {
        assert (kind != Kind.SIMPLE_NAME || type instanceof JClassOrInterface);
        this.kind = kind;
        this.type = type;
    }

    @Nonnull
    private static String getValue(@Nonnull JType type, @Nonnull Kind kind) {
        if (type instanceof JArrayType) {
            switch (kind) {
                case BINARY_SIGNATURE: 
                case SRC_SIGNATURE: {
                    return "[" + TypeName.getValue(((JArrayType)type).getElementType(), kind);
                }
                case BINARY_QN: 
                case SRC_QN: {
                    return TypeName.getValue(((JArrayType)type).getElementType(), kind) + "[]";
                }
            }
            throw new AssertionError();
        }
        switch (kind) {
            case BINARY_SIGNATURE: {
                return binarySignatureFormatter.getName(type);
            }
            case SRC_SIGNATURE: {
                return binarySignatureFormatter.getName(type).replace('/', '.');
            }
            case BINARY_QN: {
                assert (type instanceof JClassOrInterface);
                return binaryQnFormatter.getName(type);
            }
            case SRC_QN: {
                assert (type instanceof JClassOrInterface);
                return sourceQnFormatter.getName(type);
            }
            case SIMPLE_NAME: {
                return TypeName.getSimpleName((JDefinedClassOrInterface)type);
            }
        }
        throw new AssertionError();
    }

    @Override
    @Nonnull
    public String toString() {
        return TypeName.getValue(this.type, this.kind);
    }

    @Nonnull
    public JType getReferencedType() {
        return this.type;
    }

    @Nonnull
    public static String getSimpleName(@Nonnull JDefinedClassOrInterface type) {
        String simpleName = type.getName();
        JClassOrInterface enclosingType = type.getEnclosingType();
        if (enclosingType != null && simpleName.startsWith(enclosingType.getName() + '$')) {
            int simpleNameBeginIndex;
            for (simpleNameBeginIndex = enclosingType.getName().length() + 1; simpleNameBeginIndex < simpleName.length() && Character.isDigit(simpleName.charAt(simpleNameBeginIndex)); ++simpleNameBeginIndex) {
            }
            simpleName = simpleName.substring(simpleNameBeginIndex);
        }
        return simpleName;
    }

    public static enum Kind {
        BINARY_SIGNATURE,
        SRC_SIGNATURE,
        BINARY_QN,
        SRC_QN,
        SIMPLE_NAME;

    }
}

