/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.impl;

import com.android.jack.ir.ast.JDefinedClass;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JDefinedInterface;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodBody;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.impl.BaseGenerationVisitor;
import com.android.jack.util.TextOutput;
import javax.annotation.Nonnull;

public class SourceGenerationVisitor
extends BaseGenerationVisitor {
    public SourceGenerationVisitor(TextOutput textOutput) {
        super(textOutput);
    }

    @Override
    public boolean visit(@Nonnull JDefinedClass x) {
        super.visit(x);
        this.openBlock();
        for (JField jField : x.getFields()) {
            this.accept(jField);
            this.newline();
            this.newline();
        }
        for (JMethod jMethod : x.getMethods()) {
            if (JMethod.isClinit(jMethod)) {
                JMethodBody body = (JMethodBody)jMethod.getBody();
                assert (body != null);
                if (body.getBlock().getStatements().isEmpty()) continue;
            }
            this.accept(jMethod);
            this.newline();
            this.newline();
        }
        this.closeBlock();
        return false;
    }

    @Override
    public boolean visit(@Nonnull JDefinedInterface x) {
        super.visit(x);
        this.openBlock();
        for (JField field : x.getFields()) {
            this.accept(field);
            this.newline();
            this.newline();
        }
        for (JMethod method : x.getMethods()) {
            this.accept(method);
            this.newline();
            this.newline();
        }
        this.closeBlock();
        return false;
    }

    @Override
    public boolean visit(@Nonnull JSession x) {
        for (JDefinedClassOrInterface type : x.getTypesToEmit()) {
            this.accept(type);
            this.newline();
            this.newline();
        }
        return false;
    }

    @Override
    protected boolean shouldPrintMethodBody() {
        return true;
    }
}

