/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.ir.ast.JAnnotationMethod;
import com.android.jack.ir.ast.JCaseStatement;
import com.android.jack.ir.ast.JEnum;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JFieldId;
import com.android.jack.ir.ast.JFieldInitializer;
import com.android.jack.ir.ast.JNameValuePair;
import com.android.jack.ir.ast.JReturnStatement;
import com.android.jack.ir.ast.JSwitchStatement;
import com.android.jack.ir.ast.JSynchronizedBlock;
import com.android.jack.ir.ast.JValueLiteral;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.sched.item.Component;
import com.android.sched.item.Description;
import com.android.sched.scheduler.ScheduleInstance;
import com.android.sched.transform.TransformRequest;
import javax.annotation.Nonnull;

@Description(value="JLiteral representing a reference to an Enum field.")
public class JEnumLiteral
extends JValueLiteral {
    @Nonnull
    private final JFieldId value;

    public JEnumLiteral(@Nonnull SourceInfo sourceInfo, @Nonnull JFieldId value) {
        super(sourceInfo);
        this.value = value;
        assert (value.getType() instanceof JEnum);
    }

    @Override
    @Nonnull
    public JEnum getType() {
        return (JEnum)this.value.getType();
    }

    @Override
    public void traverse(@Nonnull JVisitor visitor) {
        if (visitor.visit(this)) {
            // empty if block
        }
        visitor.endVisit(this);
    }

    @Override
    public void traverse(@Nonnull ScheduleInstance<? super Component> schedule) throws Exception {
        schedule.process(this);
    }

    @Nonnull
    public JFieldId getFieldId() {
        return this.value;
    }

    @Override
    public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
        visitor.visit(this, transformRequest);
    }

    @Override
    public void checkValidity() {
        if (!(this.parent instanceof JExpression || this.parent instanceof JNameValuePair || this.parent instanceof JAnnotationMethod || this.parent instanceof JCaseStatement || this.parent instanceof JSwitchStatement || this.parent instanceof JReturnStatement || this.parent instanceof JFieldInitializer || this.parent instanceof JSynchronizedBlock)) {
            super.checkValidity();
        }
    }

    @Override
    public boolean isTypeValue() {
        return false;
    }
}

