/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JDefinedInterface;
import com.android.jack.ir.ast.JInterface;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JReferenceTypeCommon;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.sched.item.Description;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Base class for any defined reference type.")
public abstract class JDefinedReferenceType
extends JReferenceTypeCommon {
    @CheckForNull
    private JClass superClass = null;
    @Nonnull
    private List<JInterface> superInterfaces = new ArrayList<JInterface>();

    public JDefinedReferenceType(@Nonnull SourceInfo info, @Nonnull String name) {
        super(info, name);
    }

    boolean implementsInterface(@Nonnull JInterface jinterface) {
        for (JInterface interf : this.getImplements()) {
            if (interf.isSameType(jinterface)) {
                return true;
            }
            if (!(interf instanceof JDefinedInterface) || !((JDefinedInterface)interf).implementsInterface(jinterface)) continue;
            return true;
        }
        return false;
    }

    public void addImplements(JInterface superInterface) {
        this.superInterfaces.add(superInterface);
    }

    public void setImplements(@Nonnull List<JInterface> superInterfaces) {
        this.superInterfaces = superInterfaces;
    }

    @Nonnull
    public List<JInterface> getImplements() {
        return this.superInterfaces;
    }

    public final void setSuperClass(@CheckForNull JClass superClass) {
        this.superClass = superClass;
    }

    @CheckForNull
    public JClass getSuperClass() {
        return this.superClass;
    }

    @Override
    protected void transform(@Nonnull JNode existingNode, @CheckForNull JNode newNode, @Nonnull JNode.Transformation transformation) throws UnsupportedOperationException {
        if (!JDefinedReferenceType.transform(this.superInterfaces, existingNode, (JInterface)((Object)newNode), transformation)) {
            super.transform(existingNode, newNode, transformation);
        }
    }
}

