/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.incremental;

import com.android.jack.google.common.base.Function;
import com.android.jack.google.common.base.Joiner;
import com.android.jack.google.common.collect.Collections2;
import com.android.jack.library.FileType;
import com.android.jack.library.FileTypeDoesNotExistException;
import com.android.jack.library.InputLibrary;
import com.android.jack.library.LibraryIOException;
import com.android.jack.library.OutputJackLibrary;
import com.android.sched.util.file.CannotCreateFileException;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.vfs.OutputVFile;
import com.android.sched.vfs.VPath;
import java.io.PrintStream;
import java.util.Collection;
import javax.annotation.Nonnull;

class IncrementalLogWriter {
    @Nonnull
    static final VPath vpath = new VPath("logs", '/');
    @Nonnull
    private final PrintStream ps;
    @Nonnull
    private static Joiner commaJoiner = Joiner.on(",").useForNull("");

    IncrementalLogWriter(@Nonnull OutputJackLibrary library) throws LibraryIOException {
        OutputVFile vFile;
        try {
            vFile = library.getFile(FileType.LOG, vpath);
        }
        catch (FileTypeDoesNotExistException e) {
            try {
                vFile = library.createFile(FileType.LOG, vpath);
            }
            catch (CannotCreateFileException e1) {
                throw new LibraryIOException(library.getLocation(), e1);
            }
        }
        try {
            this.ps = new PrintStream(vFile.getPrintStream(true));
            this.writeString("***");
        }
        catch (WrongPermissionException e) {
            throw new LibraryIOException(library.getLocation(), e);
        }
    }

    void writeStrings(@Nonnull String prefixStr, @Nonnull Collection<String> strings) {
        this.ps.print(prefixStr);
        this.ps.print(": ");
        this.ps.print(commaJoiner.join(strings));
        this.ps.println();
    }

    void close() {
        this.ps.close();
    }

    void writeString(@Nonnull String str) {
        this.ps.print(str);
        this.ps.println();
    }

    void writeLibraryDescriptions(@Nonnull String prefixStr, @Nonnull Collection<? extends InputLibrary> libraries) {
        this.writeStrings(prefixStr, Collections2.transform(libraries, new Function<InputLibrary, String>(){

            @Override
            public String apply(InputLibrary library) {
                return "\"" + library.getLocation().getDescription() + "\"";
            }
        }));
    }
}

