/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.freemarker.cache;

import com.android.jack.freemarker.cache.TemplateConfigurationFactory;
import com.android.jack.freemarker.cache.TemplateConfigurationFactoryException;
import com.android.jack.freemarker.core.TemplateConfiguration;
import com.android.jack.freemarker.template.Configuration;
import java.io.IOException;

public class MergingTemplateConfigurationFactory
extends TemplateConfigurationFactory {
    private final TemplateConfigurationFactory[] templateConfigurationFactories;

    public MergingTemplateConfigurationFactory(TemplateConfigurationFactory ... templateConfigurationFactories) {
        this.templateConfigurationFactories = templateConfigurationFactories;
    }

    public TemplateConfiguration get(String sourceName, Object templateSource) throws IOException, TemplateConfigurationFactoryException {
        TemplateConfiguration mergedTC = null;
        TemplateConfiguration resultTC = null;
        for (TemplateConfigurationFactory tcf : this.templateConfigurationFactories) {
            TemplateConfiguration tc = tcf.get(sourceName, templateSource);
            if (tc == null) continue;
            if (resultTC == null) {
                resultTC = tc;
                continue;
            }
            if (mergedTC == null) {
                Configuration cfg = this.getConfiguration();
                if (cfg == null) {
                    throw new IllegalStateException("The TemplateConfigurationFactory wasn't associated to a Configuration yet.");
                }
                mergedTC = new TemplateConfiguration();
                mergedTC.setParentConfiguration(cfg);
                mergedTC.merge(resultTC);
                resultTC = mergedTC;
            }
            mergedTC.merge(tc);
        }
        return resultTC;
    }

    protected void setConfigurationOfChildren(Configuration cfg) {
        for (TemplateConfigurationFactory templateConfigurationFactory : this.templateConfigurationFactories) {
            templateConfigurationFactory.setConfiguration(cfg);
        }
    }
}

