/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.dx.rop.code;

import com.android.jack.dx.rop.code.DualCstInsn;
import com.android.jack.dx.rop.code.Insn;
import com.android.jack.dx.rop.code.RegisterSpec;
import com.android.jack.dx.rop.code.RegisterSpecList;
import com.android.jack.dx.rop.code.Rop;
import com.android.jack.dx.rop.code.SourcePosition;
import com.android.jack.dx.rop.code.ThrowingInsn;
import com.android.jack.dx.rop.cst.Constant;
import com.android.jack.dx.rop.type.Type;
import com.android.jack.dx.rop.type.TypeList;
import javax.annotation.Nonnull;

public final class ThrowingDualCstInsn
extends DualCstInsn {
    @Nonnull
    private final TypeList catches;

    public ThrowingDualCstInsn(@Nonnull Rop opcode, @Nonnull SourcePosition position, @Nonnull RegisterSpecList sources, @Nonnull TypeList catches, @Nonnull Constant firstConstant, @Nonnull Constant secondConstant) {
        super(opcode, position, null, sources, firstConstant, secondConstant);
        assert (opcode.getBranchingness() == 6);
        assert (catches != null);
        this.catches = catches;
    }

    @Override
    @Nonnull
    public TypeList getCatches() {
        return this.catches;
    }

    @Override
    @Nonnull
    public String getInlineString() {
        return super.getInlineString() + " " + ThrowingInsn.toCatchString(this.getCatches());
    }

    @Override
    public void accept(@Nonnull Insn.Visitor visitor) {
        visitor.visitThrowingDualCstInsn(this);
    }

    @Override
    @Nonnull
    public Insn withAddedCatch(Type type) {
        return new ThrowingDualCstInsn(this.getOpcode(), this.getPosition(), this.getSources(), this.getCatches().withAddedType(type), this.getFirstConstant(), this.getSecondConstant());
    }

    @Override
    @Nonnull
    public Insn withRegisterOffset(int delta) {
        return new ThrowingDualCstInsn(this.getOpcode(), this.getPosition(), this.getSources().withOffset(delta), this.getCatches(), this.getFirstConstant(), this.getSecondConstant());
    }

    @Override
    @Nonnull
    public Insn withNewRegisters(RegisterSpec result, RegisterSpecList sources) {
        return new ThrowingDualCstInsn(this.getOpcode(), this.getPosition(), sources, this.getCatches(), this.getFirstConstant(), this.getSecondConstant());
    }
}

