/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.dx.io;

import com.android.jack.dx.io.DexBuffer;
import com.android.jack.dx.util.Unsigned;

public final class FieldId
implements Comparable<FieldId> {
    private final DexBuffer buffer;
    private final int declaringClassIndex;
    private final int typeIndex;
    private final int nameIndex;

    public FieldId(DexBuffer buffer, int declaringClassIndex, int typeIndex, int nameIndex) {
        this.buffer = buffer;
        this.declaringClassIndex = declaringClassIndex;
        this.typeIndex = typeIndex;
        this.nameIndex = nameIndex;
    }

    public int getDeclaringClassIndex() {
        return this.declaringClassIndex;
    }

    public int getTypeIndex() {
        return this.typeIndex;
    }

    public int getNameIndex() {
        return this.nameIndex;
    }

    @Override
    public int compareTo(FieldId other) {
        if (this.declaringClassIndex != other.declaringClassIndex) {
            return Unsigned.compare(this.declaringClassIndex, other.declaringClassIndex);
        }
        if (this.nameIndex != other.nameIndex) {
            return Unsigned.compare(this.nameIndex, other.nameIndex);
        }
        return Unsigned.compare(this.typeIndex, other.typeIndex);
    }

    public void writeTo(DexBuffer.Section out) {
        out.writeUnsignedShort(this.declaringClassIndex);
        out.writeUnsignedShort(this.typeIndex);
        out.writeInt(this.nameIndex);
    }

    public String toString() {
        if (this.buffer == null) {
            return this.declaringClassIndex + " " + this.typeIndex + " " + this.nameIndex;
        }
        return this.buffer.typeNames().get(this.typeIndex) + "." + this.buffer.strings().get(this.nameIndex);
    }
}

