/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.dx.io;

import com.android.jack.dx.dex.TableOfContents;
import com.android.jack.dx.io.Annotation;
import com.android.jack.dx.io.ClassData;
import com.android.jack.dx.io.ClassDef;
import com.android.jack.dx.io.Code;
import com.android.jack.dx.io.EncodedValue;
import com.android.jack.dx.io.EncodedValueReader;
import com.android.jack.dx.io.FieldId;
import com.android.jack.dx.io.MethodId;
import com.android.jack.dx.io.ProtoId;
import com.android.jack.dx.io.TypeList;
import com.android.jack.dx.util.ByteInput;
import com.android.jack.dx.util.ByteOutput;
import com.android.jack.dx.util.DexException;
import com.android.jack.dx.util.FileUtils;
import com.android.jack.dx.util.Leb128Utils;
import com.android.jack.dx.util.Mutf8;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public final class DexBuffer {
    private byte[] data;
    private final TableOfContents tableOfContents = new TableOfContents();
    private int length = 0;
    private final List<String> strings;
    private final List<Integer> typeIds;
    private final List<String> typeNames;
    private final List<ProtoId> protoIds = new AbstractList<ProtoId>(){

        @Override
        public ProtoId get(int index) {
            DexBuffer.checkBounds(index, ((DexBuffer)DexBuffer.this).tableOfContents.protoIds.size);
            return DexBuffer.this.openInternal(((DexBuffer)DexBuffer.this).tableOfContents.protoIds.off + 12 * index).readProtoId();
        }

        @Override
        public int size() {
            return ((DexBuffer)DexBuffer.this).tableOfContents.protoIds.size;
        }
    };
    private final List<FieldId> fieldIds;
    private final List<MethodId> methodIds;
    @Nonnull
    private final Section internalSection;

    public DexBuffer() {
        this.data = new byte[0];
        this.internalSection = new Section(0);
        this.strings = Collections.emptyList();
        this.typeIds = Collections.emptyList();
        this.typeNames = Collections.emptyList();
        this.fieldIds = Collections.emptyList();
        this.methodIds = Collections.emptyList();
    }

    public DexBuffer(byte[] data) {
        this.data = data;
        this.internalSection = new Section(0);
        this.length = data.length;
        this.tableOfContents.readFrom(this);
        this.strings = this.readStrings();
        this.typeIds = this.readTypeIds();
        this.typeNames = this.readTypeNames(this.strings, this.typeIds);
        this.fieldIds = this.readFieldIds();
        this.methodIds = this.readMethodIds();
    }

    public DexBuffer(InputStream in) throws IOException {
        this.loadFrom(in);
        this.internalSection = new Section(0);
        this.strings = this.readStrings();
        this.typeIds = this.readTypeIds();
        this.typeNames = this.readTypeNames(this.strings, this.typeIds);
        this.fieldIds = this.readFieldIds();
        this.methodIds = this.readMethodIds();
    }

    /*
     * Enabled aggressive block sorting
     */
    public DexBuffer(File file) throws IOException {
        if (FileUtils.hasArchiveSuffix(file.getName())) {
            ZipFile zipFile = new ZipFile(file);
            ZipEntry entry = zipFile.getEntry("classes.dex");
            if (entry == null) {
                zipFile.close();
                throw new DexException("Expected classes.dex in " + file);
            }
            this.loadFrom(zipFile.getInputStream(entry));
            zipFile.close();
        } else {
            if (!file.getName().endsWith(".dex")) {
                throw new DexException("unknown output extension: " + file);
            }
            this.loadFrom(new FileInputStream(file));
        }
        this.internalSection = new Section(0);
        this.strings = this.readStrings();
        this.typeIds = this.readTypeIds();
        this.typeNames = this.readTypeNames(this.strings, this.typeIds);
        this.fieldIds = this.readFieldIds();
        this.methodIds = this.readMethodIds();
    }

    private List<String> readStrings() {
        Section strings = this.openInternal(this.tableOfContents.stringIds.off);
        String[] result = new String[this.tableOfContents.stringIds.size];
        for (int i = 0; i < this.tableOfContents.stringIds.size; ++i) {
            result[i] = strings.readString();
        }
        return Arrays.asList(result);
    }

    private List<Integer> readTypeIds() {
        Section typeIds = this.openInternal(this.tableOfContents.typeIds.off);
        Integer[] result = new Integer[this.tableOfContents.typeIds.size];
        for (int i = 0; i < this.tableOfContents.typeIds.size; ++i) {
            result[i] = typeIds.readInt();
        }
        return Arrays.asList(result);
    }

    private List<String> readTypeNames(List<String> strings, List<Integer> typeIds) {
        String[] result = new String[this.tableOfContents.typeIds.size];
        for (int i = 0; i < this.tableOfContents.typeIds.size; ++i) {
            result[i] = strings.get(typeIds.get(i));
        }
        return Arrays.asList(result);
    }

    private List<FieldId> readFieldIds() {
        Section fieldIds = this.openInternal(this.tableOfContents.fieldIds.off);
        FieldId[] result = new FieldId[this.tableOfContents.fieldIds.size];
        for (int i = 0; i < this.tableOfContents.fieldIds.size; ++i) {
            result[i] = fieldIds.readFieldId();
        }
        return Arrays.asList(result);
    }

    private List<MethodId> readMethodIds() {
        Section methodIds = this.openInternal(this.tableOfContents.methodIds.off);
        MethodId[] result = new MethodId[this.tableOfContents.methodIds.size];
        for (int i = 0; i < this.tableOfContents.methodIds.size; ++i) {
            result[i] = methodIds.readMethodId();
        }
        return Arrays.asList(result);
    }

    private void loadFrom(InputStream in) throws IOException {
        int count;
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        while ((count = in.read(buffer)) != -1) {
            bytesOut.write(buffer, 0, count);
        }
        in.close();
        this.data = bytesOut.toByteArray();
        this.length = this.data.length;
        this.tableOfContents.readFrom(this);
    }

    private static void checkBounds(int index, int length) {
        if (index < 0 || index >= length) {
            throw new IndexOutOfBoundsException("index:" + index + ", length=" + length);
        }
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.data);
    }

    public void writeTo(File dexOut) throws IOException {
        FileOutputStream out = new FileOutputStream(dexOut);
        this.writeTo(out);
        ((OutputStream)out).close();
    }

    public TableOfContents getTableOfContents() {
        return this.tableOfContents;
    }

    @Nonnull
    private Section openInternal(@Nonnegative int position) {
        this.internalSection.initialPosition = (this.internalSection.position = position);
        return this.internalSection;
    }

    public Section open(int position) {
        if (position < 0 || position > this.length) {
            throw new IllegalArgumentException("position=" + position + " length=" + this.length);
        }
        return new Section(position);
    }

    public Section appendSection(int maxByteCount, String name) {
        int limit = DexBuffer.fourByteAlign(this.length + maxByteCount);
        Section result = new Section(name, this.length, limit);
        this.length = limit;
        return result;
    }

    public void noMoreSections() {
        this.data = new byte[this.length];
    }

    public int getLength() {
        return this.length;
    }

    public static int fourByteAlign(int position) {
        return position + 3 & 0xFFFFFFFC;
    }

    public byte[] getBytes() {
        return this.data;
    }

    public List<String> strings() {
        return this.strings;
    }

    public List<Integer> typeIds() {
        return this.typeIds;
    }

    public List<String> typeNames() {
        return this.typeNames;
    }

    public List<ProtoId> protoIds() {
        return this.protoIds;
    }

    public List<FieldId> fieldIds() {
        return this.fieldIds;
    }

    public List<MethodId> methodIds() {
        return this.methodIds;
    }

    public Iterable<ClassDef> classDefs() {
        return new Iterable<ClassDef>(){

            @Override
            public Iterator<ClassDef> iterator() {
                if (!((DexBuffer)DexBuffer.this).tableOfContents.classDefs.exists()) {
                    return Collections.emptySet().iterator();
                }
                return new Iterator<ClassDef>(){
                    private Section in;
                    private int count;
                    {
                        this.in = DexBuffer.this.open(((DexBuffer)DexBuffer.this).tableOfContents.classDefs.off);
                        this.count = 0;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.count < ((DexBuffer)DexBuffer.this).tableOfContents.classDefs.size;
                    }

                    @Override
                    public ClassDef next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        ++this.count;
                        return this.in.readClassDef();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public TypeList readTypeList(int offset) {
        if (offset == 0) {
            return TypeList.EMPTY;
        }
        return this.openInternal(offset).readTypeList();
    }

    public ClassData readClassData(ClassDef classDef) {
        int offset = classDef.getClassDataOffset();
        if (offset == 0) {
            throw new IllegalArgumentException("offset == 0");
        }
        return this.openInternal(offset).readClassData();
    }

    public Code readCode(ClassData.Method method) {
        int offset = method.getCodeOffset();
        if (offset == 0) {
            throw new IllegalArgumentException("offset == 0");
        }
        return this.openInternal(offset).readCode();
    }

    public final class Section
    implements ByteInput,
    ByteOutput {
        private final String name;
        private int position;
        private final int limit;
        private int initialPosition;

        private Section(String name, int position, int limit) {
            this.name = name;
            this.position = this.initialPosition = position;
            this.limit = limit;
        }

        private Section(int position) {
            this("section", position, this$0.data.length);
        }

        public int getPosition() {
            return this.position;
        }

        public int readInt() {
            int result = DexBuffer.this.data[this.position] & 0xFF | (DexBuffer.this.data[this.position + 1] & 0xFF) << 8 | (DexBuffer.this.data[this.position + 2] & 0xFF) << 16 | (DexBuffer.this.data[this.position + 3] & 0xFF) << 24;
            this.position += 4;
            return result;
        }

        public short readShort() {
            int result = DexBuffer.this.data[this.position] & 0xFF | (DexBuffer.this.data[this.position + 1] & 0xFF) << 8;
            this.position += 2;
            return (short)result;
        }

        public int readUnsignedShort() {
            return this.readShort() & 0xFFFF;
        }

        @Override
        public byte readByte() {
            return (byte)(DexBuffer.this.data[this.position++] & 0xFF);
        }

        public byte[] readByteArray(int length) {
            byte[] result = Arrays.copyOfRange(DexBuffer.this.data, this.position, this.position + length);
            this.position += length;
            return result;
        }

        public short[] readShortArray(int length) {
            short[] result = new short[length];
            for (int i = 0; i < length; ++i) {
                result[i] = this.readShort();
            }
            return result;
        }

        public int readUleb128() {
            return Leb128Utils.readUnsignedLeb128(this);
        }

        public int readUleb128p1() {
            return Leb128Utils.readUnsignedLeb128(this) - 1;
        }

        public int readSleb128() {
            return Leb128Utils.readSignedLeb128(this);
        }

        public TypeList readTypeList() {
            this.assertFourByteAligned();
            int size = this.readInt();
            short[] types = new short[size];
            for (int i = 0; i < size; ++i) {
                types[i] = this.readShort();
            }
            this.position = DexBuffer.fourByteAlign(this.position);
            return new TypeList(DexBuffer.this, types);
        }

        public String readString() {
            int offset = this.readInt();
            int savedPosition = this.position;
            this.position = offset;
            try {
                int expectedLength = this.readUleb128();
                String result = Mutf8.decode(this, new char[expectedLength]);
                if (result.length() != expectedLength) {
                    throw new DexException("Declared length " + expectedLength + " doesn't match decoded length of " + result.length());
                }
                String string = result;
                return string;
            }
            catch (UTFDataFormatException e) {
                throw new DexException(e);
            }
            finally {
                this.position = savedPosition;
            }
        }

        public FieldId readFieldId() {
            int declaringClassIndex = this.readUnsignedShort();
            int typeIndex = this.readUnsignedShort();
            int nameIndex = this.readInt();
            return new FieldId(DexBuffer.this, declaringClassIndex, typeIndex, nameIndex);
        }

        public MethodId readMethodId() {
            int declaringClassIndex = this.readUnsignedShort();
            int protoIndex = this.readUnsignedShort();
            int nameIndex = this.readInt();
            return new MethodId(DexBuffer.this, declaringClassIndex, protoIndex, nameIndex);
        }

        public ProtoId readProtoId() {
            int shortyIndex = this.readInt();
            int returnTypeIndex = this.readInt();
            int parametersOffset = this.readInt();
            return new ProtoId(DexBuffer.this, shortyIndex, returnTypeIndex, parametersOffset);
        }

        public ClassDef readClassDef() {
            int offset = this.getPosition();
            int type = this.readInt();
            int accessFlags = this.readInt();
            int supertype = this.readInt();
            int interfacesOffset = this.readInt();
            int sourceFileIndex = this.readInt();
            int annotationsOffset = this.readInt();
            int classDataOffset = this.readInt();
            int staticValuesOffset = this.readInt();
            return new ClassDef(DexBuffer.this, offset, type, accessFlags, supertype, interfacesOffset, sourceFileIndex, annotationsOffset, classDataOffset, staticValuesOffset);
        }

        private Code readCode() {
            Code.Try[] tries;
            Code.CatchHandler[] catchHandlers;
            int registersSize = this.readUnsignedShort();
            int insSize = this.readUnsignedShort();
            int outsSize = this.readUnsignedShort();
            int triesSize = this.readUnsignedShort();
            int debugInfoOffset = this.readInt();
            int instructionsSize = this.readInt();
            short[] instructions = this.readShortArray(instructionsSize);
            if (triesSize > 0) {
                if (instructions.length % 2 == 1) {
                    this.readShort();
                }
                int savedPosition = this.position;
                this.skip(triesSize * 8);
                catchHandlers = this.readCatchHandlers();
                this.position = savedPosition;
                tries = this.readTries(triesSize, catchHandlers);
            } else {
                tries = new Code.Try[]{};
                catchHandlers = new Code.CatchHandler[]{};
            }
            return new Code(registersSize, insSize, outsSize, debugInfoOffset, instructions, tries, catchHandlers);
        }

        private Code.CatchHandler[] readCatchHandlers() {
            int baseOffset = this.position;
            int catchHandlersSize = this.readUleb128();
            Code.CatchHandler[] result = new Code.CatchHandler[catchHandlersSize];
            for (int i = 0; i < catchHandlersSize; ++i) {
                int offset = this.position - baseOffset;
                result[i] = this.readCatchHandler(offset);
            }
            return result;
        }

        private Code.Try[] readTries(int triesSize, Code.CatchHandler[] catchHandlers) {
            Code.Try[] result = new Code.Try[triesSize];
            for (int i = 0; i < triesSize; ++i) {
                int startAddress = this.readInt();
                int instructionCount = this.readUnsignedShort();
                int handlerOffset = this.readUnsignedShort();
                int catchHandlerIndex = this.findCatchHandlerIndex(catchHandlers, handlerOffset);
                result[i] = new Code.Try(startAddress, instructionCount, catchHandlerIndex);
            }
            return result;
        }

        private int findCatchHandlerIndex(Code.CatchHandler[] catchHandlers, int offset) {
            for (int i = 0; i < catchHandlers.length; ++i) {
                Code.CatchHandler catchHandler = catchHandlers[i];
                if (catchHandler.getOffset() != offset) continue;
                return i;
            }
            throw new IllegalArgumentException();
        }

        private Code.CatchHandler readCatchHandler(int offset) {
            int size = this.readSleb128();
            int handlersCount = Math.abs(size);
            int[] typeIndexes = new int[handlersCount];
            int[] addresses = new int[handlersCount];
            for (int i = 0; i < handlersCount; ++i) {
                typeIndexes[i] = this.readUleb128();
                addresses[i] = this.readUleb128();
            }
            int catchAllAddress = size <= 0 ? this.readUleb128() : -1;
            return new Code.CatchHandler(typeIndexes, addresses, catchAllAddress, offset);
        }

        private ClassData readClassData() {
            int staticFieldsSize = this.readUleb128();
            int instanceFieldsSize = this.readUleb128();
            int directMethodsSize = this.readUleb128();
            int virtualMethodsSize = this.readUleb128();
            ClassData.Field[] staticFields = this.readFields(staticFieldsSize);
            ClassData.Field[] instanceFields = this.readFields(instanceFieldsSize);
            ClassData.Method[] directMethods = this.readMethods(directMethodsSize);
            ClassData.Method[] virtualMethods = this.readMethods(virtualMethodsSize);
            return new ClassData(staticFields, instanceFields, directMethods, virtualMethods);
        }

        private ClassData.Field[] readFields(int count) {
            ClassData.Field[] result = new ClassData.Field[count];
            int fieldIndex = 0;
            for (int i = 0; i < count; ++i) {
                int accessFlags = this.readUleb128();
                result[i] = new ClassData.Field(fieldIndex += this.readUleb128(), accessFlags);
            }
            return result;
        }

        private ClassData.Method[] readMethods(int count) {
            ClassData.Method[] result = new ClassData.Method[count];
            int methodIndex = 0;
            for (int i = 0; i < count; ++i) {
                int accessFlags = this.readUleb128();
                int codeOff = this.readUleb128();
                result[i] = new ClassData.Method(methodIndex += this.readUleb128(), accessFlags, codeOff);
            }
            return result;
        }

        public Annotation readAnnotation() {
            byte visibility = this.readByte();
            int typeIndex = this.readUleb128();
            int size = this.readUleb128();
            int[] names = new int[size];
            EncodedValue[] values = new EncodedValue[size];
            for (int i = 0; i < size; ++i) {
                names[i] = this.readUleb128();
                values[i] = this.readEncodedValue();
            }
            return new Annotation(DexBuffer.this, visibility, typeIndex, names, values);
        }

        public EncodedValue readEncodedValue() {
            int start = this.position;
            new EncodedValueReader(this).readValue();
            int end = this.position;
            return new EncodedValue(Arrays.copyOfRange(DexBuffer.this.data, start, end));
        }

        public EncodedValue readEncodedArray() {
            int start = this.position;
            new EncodedValueReader(this).readArray();
            int end = this.position;
            return new EncodedValue(Arrays.copyOfRange(DexBuffer.this.data, start, end));
        }

        private void ensureCapacity(int size) {
            if (this.position + size > this.limit) {
                throw new DexException("Section limit " + this.limit + " exceeded by " + this.name);
            }
        }

        public void skip(int count) {
            if (count < 0) {
                throw new IllegalArgumentException();
            }
            this.ensureCapacity(count);
            this.position += count;
        }

        public void alignToFourBytes() {
            int unalignedCount = this.position;
            this.position = DexBuffer.fourByteAlign(this.position);
            for (int i = unalignedCount; i < this.position; ++i) {
                ((DexBuffer)DexBuffer.this).data[i] = 0;
            }
        }

        public void assertFourByteAligned() {
            if ((this.position & 3) != 0) {
                throw new IllegalStateException("Not four byte aligned!");
            }
        }

        public void write(byte[] bytes) {
            this.ensureCapacity(bytes.length);
            System.arraycopy(bytes, 0, DexBuffer.this.data, this.position, bytes.length);
            this.position += bytes.length;
        }

        @Override
        public void writeByte(int b) {
            this.ensureCapacity(1);
            ((DexBuffer)DexBuffer.this).data[this.position++] = (byte)b;
        }

        public void writeShort(short i) {
            this.ensureCapacity(2);
            ((DexBuffer)DexBuffer.this).data[this.position] = (byte)i;
            ((DexBuffer)DexBuffer.this).data[this.position + 1] = (byte)(i >>> 8);
            this.position += 2;
        }

        public void writeUnsignedShort(int i) {
            short s = (short)i;
            if (i != (s & 0xFFFF)) {
                throw new IllegalArgumentException("Expected an unsigned short: " + i);
            }
            this.writeShort(s);
        }

        public void write(short[] shorts) {
            for (short s : shorts) {
                this.writeShort(s);
            }
        }

        public void writeInt(int i) {
            this.ensureCapacity(4);
            ((DexBuffer)DexBuffer.this).data[this.position] = (byte)i;
            ((DexBuffer)DexBuffer.this).data[this.position + 1] = (byte)(i >>> 8);
            ((DexBuffer)DexBuffer.this).data[this.position + 2] = (byte)(i >>> 16);
            ((DexBuffer)DexBuffer.this).data[this.position + 3] = (byte)(i >>> 24);
            this.position += 4;
        }

        public void writeUleb128(int i) {
            try {
                Leb128Utils.writeUnsignedLeb128(this, i);
                this.ensureCapacity(0);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new DexException("Section limit " + this.limit + " exceeded by " + this.name);
            }
        }

        public void writeUleb128p1(int i) {
            this.writeUleb128(i + 1);
        }

        public void writeSleb128(int i) {
            try {
                Leb128Utils.writeSignedLeb128(this, i);
                this.ensureCapacity(0);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new DexException("Section limit " + this.limit + " exceeded by " + this.name);
            }
        }

        public void writeStringData(String value) {
            try {
                int length = value.length();
                this.writeUleb128(length);
                this.write(Mutf8.encode(value));
                this.writeByte(0);
            }
            catch (UTFDataFormatException e) {
                throw new AssertionError();
            }
        }

        public void writeTypeList(TypeList typeList) {
            short[] types = typeList.getTypes();
            this.writeInt(types.length);
            for (short type : types) {
                this.writeShort(type);
            }
            this.alignToFourBytes();
        }

        public int remaining() {
            return this.limit - this.position;
        }

        public int used() {
            return this.position - this.initialPosition;
        }
    }
}

