/$ TCP.h

// Handles all TCP communications

#ifndef	__TCP_H__
#define	__TCP_H__

// this value should never be found in a TCP stream
#define TCP_NONCE		"ADB&B#&+#4WSG598RWE*^R%@@"

int _tcp_open = FALSE;

initTCP() {
	int retcode;
	
	retcode = tcp_netopen();
	if (retcode != 0) {
		alert("tcp_netopen failed " + retcode);
		exit();
	}
	_tcp_open = TRUE;
}

clearTCP() {
	tcp_netclose();
}

int tcpConnect(string ip, int port) {
	return tcp_connect(ip, port, 200);
}

tcpClose(int sock) {
	tcp_disconnect(sock);
}

int tcpWrite(int sock, string str) {
	return tcp_write(sock, str);
}

int tcpRead(int sock, int len, string token) {
	return tcp_read(sock, len, token, 2000);
}

int tcpReadTO(int sock, int len, int timeout) {
	return tcp_read(sock, len, TCP_NONCE, timeout);
}

#endif
