/*
 *  © Darren McDonald 2010
 *
 *  This file is part of athena-ssl-cipher-check.
 *
 *  athena-ssl-cipher-check is free software: you can redistribute it
 *  and/or modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation, either version 3 of the License,
 *  or (at your option) any later version.
 *
 *  athena-ssl-cipher-check is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
 *  Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with athena-ssl-cipher-check. If not, see
 *  <http://www.gnu.org/licenses/>.
 *
 */

package athenasslciphercheck;

public class sslv2MessageFactory {
    public static void makeMessage( byte[] helloMessage, byte[] cipherSuite, int offset )
    {
        byte[] messageLength = new byte[2]; //length of the message -2
        messageLength[0] = (byte) 0x80;
        messageLength[1] = (byte) 28;

        byte messageType = 0x01; // 0x01 == client hello

        byte[] version = new byte[2]; //version
        version[0] = 0x00;
        version[1] = 0x02; //ssl v2

        byte[] cipherSpecLength = new byte[2];
        cipherSpecLength[0] = 0x00;
        cipherSpecLength[1] = 0x03;

        byte sessionIdLength = 0x00;

        byte[] challengeLength = new byte[2];
        challengeLength[0] = 0x00;
        challengeLength[1] = 0x10;

        //Ciphers
        

        // My 'random' challenge is not random. Do not copy this example.
        byte[] challenge = { 0x00, 0x01, 0x02, 0x03, 0x04,
                             0x05, 0x06, 0x07, 0x08, 0x09,
                             0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F };

         System.arraycopy(messageLength, 0, helloMessage, 0, 2);
         helloMessage[2] = messageType;
         System.arraycopy(version, 0, helloMessage, 3, 2);
         System.arraycopy(cipherSpecLength, 0, helloMessage, 5, 2);
         helloMessage[7] = 0x00;
         helloMessage[8] = sessionIdLength;
         System.arraycopy(challengeLength, 0, helloMessage, 9, 2);

         helloMessage[11] = cipherSuite[offset];
         helloMessage[12] = cipherSuite[offset+1];
         helloMessage[13] = cipherSuite[offset+2];

         System.arraycopy(challenge, 0, helloMessage, 14, 0x010);

    }
}
