/*
 *  © Darren McDonald 2010
 *
 *  This file is part of athena-ssl-cipher-check.
 *
 *  athena-ssl-cipher-check is free software: you can redistribute it
 *  and/or modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation, either version 3 of the License,
 *  or (at your option) any later version.
 *
 *  athena-ssl-cipher-check is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
 *  Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with athena-ssl-cipher-check. If not, see
 *  <http://www.gnu.org/licenses/>.
 *
 */

package athenasslciphercheck;

import java.io.*;
import java.net.*;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClientCheck {
    int port;
    public ClientCheck( int p )
    {
        port = p;
        check();
        //check();
        //check();

    }

    private void check()
    {
                System.out.println("");
        try
        {
            CipherListWrapper cipherListWrapper = new CipherListWrapper();
            cipherListWrapper.loadCiphers();

            int type = 0;
            // 0 = unknown
            // 1 SSLv2
            // 2 SSLv3
            // 3 TLSv1

            InputStream in;
            OutputStream out;
            ServerSocket sconn = null;
            Socket conn = null;

            sconn = new ServerSocket(port);
            conn = sconn.accept();

            //Assign Streams
            in = conn.getInputStream();
            out = conn.getOutputStream();

            //Is this SSlv3 / TLS ?

            byte[] tmp = new byte[2];
            byte[] tmp2 = new byte[1];
            in.read(tmp);

            if( tmp[0] == 0x16 ) //handshake
            {
                //find out what version this is
                in.read(tmp);

                if( true )
                {
                    if( tmp[0] == 0x00 )
                    {
                        type = 2;
                        System.out.println("SSLv3 Connection Received");
                    }
                    else if( tmp[0] == 0x01 )
                    {
                        type = 3;
                        System.out.println("TLSv1 Connection Received");
                    }
                    else //wtf?
                    {
                        System.out.println("Unexpected SSL version detected, but I'll give it a shot anyway...");
                    }


                    //Size (dont care)
                    in.read(tmp);

                    //handshack type (dont care)
                    in.read(tmp);

                    //Size
                    //in.read(tmp);
                    in.read(tmp2);

                    //version
                    in.read(tmp);

                    //random (dont care)
                    for( int i = 0; i < 16; i++ )
                    {
                        in.read(tmp);
                    }

                    //Session Length (dont care, just need to read passed it)
                    in.read(tmp2);

                    int sessionLength = tmp2[0];
                    for( int i = 0; i < sessionLength; i++ )
                    {
                        in.read(tmp2);
                    }

                    //Cipher Length
                    in.read(tmp);
                    int cipherLength = tmp[0] *256 + tmp[1];

                    byte[] cipherCode = new byte[2];

                    for( int i = 0; i < cipherLength/2; i++)
                    {
                        in.read(cipherCode);
                        Cipher c = cipherListWrapper.lookUpCipher( cipherCode );
                        System.out.println( c.getDesc() );
                    }

                }
            }
            else if( tmp[0] == -128 )
            {
                System.out.println("SSLv2 Connection Received");
            }
            else
                System.out.println("Unidentified header, are you sure this is a SSL/TLS client?");

            conn.close();
            sconn.close();


        }
        catch (IOException ex)
        {
            System.out.println("");
            System.out.println("Unable to open listener on port " +port );
            System.out.println(ex.getMessage());
        }
    }

}
