/*
 *  © Darren McDonald 2010
 *
 *  This file is part of athena-ssl-cipher-check.
 *
 *  athena-ssl-cipher-check is free software: you can redistribute it
 *  and/or modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation, either version 3 of the License,
 *  or (at your option) any later version.
 *
 *  athena-ssl-cipher-check is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
 *  Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with athena-ssl-cipher-check. If not, see
 *  <http://www.gnu.org/licenses/>.
 *
 */

package athenasslciphercheck;

public class Cipher {
    
    private String description;
    private int keySize;
    private int anonymous;
    private byte[] id;

    public Cipher( String description, byte[] id, int keySize, int anonymous )
    {
        this.description = description;
        this.keySize = keySize;
        this.anonymous = anonymous;

        this.id = new byte[2];

        if( id != null )
        {
            this.id[0] = id[0];
            this.id[1] = id[1];
        }
    }

    public int getKeySize()
    {
        return keySize;
    }

    public String getDesc()
    {
        return description;
    }

    public int getanonymous()
    {
        return anonymous;
    }

    public byte[] getId()
    {
        return id;
    }
}
