# Generated by Django 5.1.1 on 2024-10-02 04:34

import archivebox.base_models.models
import charidfield.fields
import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="Machine",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=None,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                        unique=True,
                        verbose_name="ID",
                    ),
                ),
                (
                    "abid",
                    charidfield.fields.CharIDField(
                        blank=True,
                        db_index=True,
                        default=None,
                        help_text="ABID-format identifier for this entity (e.g. snp_01BJQMF54D093DXEAWZ6JYRPAQ)",
                        max_length=30,
                        null=True,
                        prefix="mxn_",
                        unique=True,
                    ),
                ),
                (
                    "created_at",
                    archivebox.base_models.models.AutoDateTimeField(
                        db_index=True, default=None
                    ),
                ),
                ("modified_at", models.DateTimeField(auto_now=True)),
                (
                    "guid",
                    models.CharField(
                        default=None, editable=False, max_length=64, unique=True
                    ),
                ),
                ("hostname", models.CharField(default=None, max_length=63)),
                ("hw_in_docker", models.BooleanField(default=False)),
                ("hw_in_vm", models.BooleanField(default=False)),
                ("hw_manufacturer", models.CharField(default=None, max_length=63)),
                ("hw_product", models.CharField(default=None, max_length=63)),
                ("hw_uuid", models.CharField(default=None, max_length=255)),
                ("os_arch", models.CharField(default=None, max_length=15)),
                ("os_family", models.CharField(default=None, max_length=15)),
                ("os_platform", models.CharField(default=None, max_length=63)),
                ("os_release", models.CharField(default=None, max_length=63)),
                ("os_kernel", models.CharField(default=None, max_length=255)),
                ("stats", models.JSONField(default=None)),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="NetworkInterface",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=None,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                        unique=True,
                        verbose_name="ID",
                    ),
                ),
                (
                    "abid",
                    charidfield.fields.CharIDField(
                        blank=True,
                        db_index=True,
                        default=None,
                        help_text="ABID-format identifier for this entity (e.g. snp_01BJQMF54D093DXEAWZ6JYRPAQ)",
                        max_length=30,
                        null=True,
                        prefix="ixf_",
                        unique=True,
                    ),
                ),
                (
                    "created_at",
                    archivebox.base_models.models.AutoDateTimeField(
                        db_index=True, default=None
                    ),
                ),
                ("modified_at", models.DateTimeField(auto_now=True)),
                (
                    "mac_address",
                    models.CharField(default=None, editable=False, max_length=17),
                ),
                (
                    "ip_public",
                    models.GenericIPAddressField(default=None, editable=False),
                ),
                (
                    "ip_local",
                    models.GenericIPAddressField(default=None, editable=False),
                ),
                (
                    "dns_server",
                    models.GenericIPAddressField(default=None, editable=False),
                ),
                ("iface", models.CharField(default=None, max_length=15)),
                ("hostname", models.CharField(default=None, max_length=63)),
                ("isp", models.CharField(default=None, max_length=63)),
                ("city", models.CharField(default=None, max_length=63)),
                ("region", models.CharField(default=None, max_length=63)),
                ("country", models.CharField(default=None, max_length=63)),
                (
                    "machine",
                    models.ForeignKey(
                        default=None,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="machine.machine",
                    ),
                ),
            ],
            options={
                "unique_together": {
                    ("machine", "ip_public", "ip_local", "mac_address", "dns_server")
                },
            },
        ),
    ]
