import re

from core.msfActionModule import msfActionModule
from core.keystore import KeyStore as kb
from core.utils import Utils


class exploit_msf_tomcat_mgr_login(msfActionModule):
    def __init__(self, config, display, lock):
        super(exploit_msf_tomcat_mgr_login, self).__init__(config, display, lock)
        self.triggers = ["newService_http", "newPort_80", "newPort_8080"]
        self.requirements = ["msfconsole"]
        self.types = ["http"]
        self.title = "Attempt to determine if a tomcat instance has default creds"
        self.shortName = "MSFTomcatMgrLogin"
        self.description = "execute [auxiliary/scanner/http/tomcat_mgr_login] on each target"
        self.safeLevel = 4

    def getTargets(self):
        # we are interested only in the hosts that have UDP 161 open
        self.targets = kb.get('service/http', 'port/tcp/80', 'port/tcp/8080')

    def process(self):
        # load any targets we are interested in
        self.getTargets()

        if len(self.targets) > 0:
            # loop over each target
            for t in self.targets:
                ports = kb.get('service/http/' + t + '/tcp')
                for p in ports:
                    # verify we have not tested this host before
                    if not self.seentarget(t+p):
                        # add the new IP to the already seen list
                        self.addseentarget(t+p)

                        cmd = {
                                'config':[
                                        "use auxiliary/scanner/http/tomcat_mgr_login",
                                        "set RHOSTS %s" % t,
                                        "set RPORT %s" % p
                                    ],
                                'payload':'win'}
                        result, outfile = self.msfExec(t, cmds)

                        for line in result.splitlines():
                            m = re.match(r'.*Successful: (.*):(.*)', line)
                            if (m):
                                self.display.error("Tomcat on [" + t + ":" + p + "] has default creds of [" +
                                        m.group(1).strip() +"]/[" + m.group(2).strip() + "]")
                                kb.add("creds/service/tomcat/" + t + "/tcp/" + p + "/username/"
                                        + m.group(1).strip() + "/password/" + m.group(2).strip())
                                self.fire("newTomcatPassword")

            # clean up after ourselves
            result = msf.cleanup()

        return
