/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class FileContentUtilCore {
    @NonNls
    public static final String FORCE_RELOAD_REQUESTOR = "FileContentUtilCore.saveOrReload";

    public static void reparseFiles(VirtualFile ... files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/util/FileContentUtilCore", "reparseFiles"));
        }
        FileContentUtilCore.reparseFiles(Arrays.asList(files));
    }

    public static void reparseFiles(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/util/FileContentUtilCore", "reparseFiles"));
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (files == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/util/FileContentUtilCore", "lambda$reparseFiles$0"));
            }
            THashSet events = new THashSet();
            for (VirtualFile file : files) {
                FileContentUtilCore.saveOrReload(file, (Collection<VFilePropertyChangeEvent>)events);
            }
            BulkFileListener publisher = ApplicationManager.getApplication().getMessageBus().syncPublisher(VirtualFileManager.VFS_CHANGES);
            ArrayList eventList = new ArrayList(events);
            publisher.before(eventList);
            publisher.after(eventList);
        });
    }

    private static void saveOrReload(VirtualFile file, @NotNull Collection<VFilePropertyChangeEvent> events) {
        Document document;
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/util/FileContentUtilCore", "saveOrReload"));
        }
        if (file == null || file.isDirectory() || !file.isValid()) {
            return;
        }
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        if (documentManager.isFileModified(file) && (document = documentManager.getDocument(file)) != null) {
            documentManager.saveDocumentAsIs(document);
        }
        events.add(new VFilePropertyChangeEvent(FORCE_RELOAD_REQUESTOR, file, "name", file.getName(), file.getName(), false));
    }
}

