/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.patterns.CharPattern;
import com.intellij.patterns.CollectionPattern;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ElementPatternCondition;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.InitialPatternConditionPlus;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.StringPattern;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StandardPatterns {
    private static final FalsePattern FALSE_PATTERN = new FalsePattern();

    @NotNull
    public static StringPattern string() {
        StringPattern stringPattern = StringPattern.STRING_PATTERN;
        if (stringPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/StandardPatterns", "string"));
        }
        return stringPattern;
    }

    @NotNull
    public static CharPattern character() {
        CharPattern charPattern = new CharPattern();
        if (charPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/StandardPatterns", "character"));
        }
        return charPattern;
    }

    @NotNull
    public static <T> ObjectPattern.Capture<T> instanceOf(Class<T> aClass) {
        ObjectPattern.Capture<T> capture = new ObjectPattern.Capture<T>(aClass);
        if (capture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/StandardPatterns", "instanceOf"));
        }
        return capture;
    }

    @SafeVarargs
    @NotNull
    public static <T> ElementPattern<T> instanceOf(Class<T> ... classes) {
        if (classes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "com/intellij/patterns/StandardPatterns", "instanceOf"));
        }
        ElementPattern[] patterns = ContainerUtil.map(classes, StandardPatterns::instanceOf, new ElementPattern[0]);
        ElementPattern elementPattern = StandardPatterns.or(patterns);
        if (elementPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/StandardPatterns", "instanceOf"));
        }
        return elementPattern;
    }

    @NotNull
    public static <T> ElementPattern save(final Key<T> key) {
        ObjectPattern.Capture capture = new ObjectPattern.Capture(new InitialPatternCondition(Object.class){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                context.put(key, o);
                return true;
            }

            @Override
            public void append(@NotNull @NonNls StringBuilder builder, String indent) {
                if (builder == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/patterns/StandardPatterns$1", "append"));
                }
                builder.append("save(").append(key).append(")");
            }
        });
        if (capture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/StandardPatterns", "save"));
        }
        return capture;
    }

    @NotNull
    public static ObjectPattern.Capture<Object> object() {
        ObjectPattern.Capture<Object> capture = StandardPatterns.instanceOf(Object.class);
        if (capture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/StandardPatterns", "object"));
        }
        return capture;
    }

    @NotNull
    public static <T> ObjectPattern.Capture<T> object(@NotNull T value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/patterns/StandardPatterns", "object"));
        }
        ObjectPattern.Capture capture = (ObjectPattern.Capture)StandardPatterns.instanceOf(value.getClass()).equalTo(value);
        if (capture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/StandardPatterns", "object"));
        }
        return capture;
    }

    @NotNull
    public static <T> CollectionPattern<T> collection(Class<T> aClass) {
        CollectionPattern collectionPattern = new CollectionPattern();
        if (collectionPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/StandardPatterns", "collection"));
        }
        return collectionPattern;
    }

    @NotNull
    public static ElementPattern get(final @NotNull @NonNls String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/patterns/StandardPatterns", "get"));
        }
        ObjectPattern.Capture capture = new ObjectPattern.Capture(new InitialPatternCondition(Object.class){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                return Comparing.equal(o, context.get(key));
            }

            @Override
            public void append(@NotNull @NonNls StringBuilder builder, String indent) {
                if (builder == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/patterns/StandardPatterns$2", "append"));
                }
                builder.append("get(").append(key).append(")");
            }
        });
        if (capture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/StandardPatterns", "get"));
        }
        return capture;
    }

    @NotNull
    public static <T> CollectionPattern<T> collection() {
        CollectionPattern collectionPattern = new CollectionPattern();
        if (collectionPattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/StandardPatterns", "collection"));
        }
        return collectionPattern;
    }

    @SafeVarargs
    @NotNull
    public static <E> ElementPattern<E> or(final ElementPattern<? extends E> ... patterns) {
        if (patterns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patterns", "com/intellij/patterns/StandardPatterns", "or"));
        }
        ObjectPattern.Capture capture = new ObjectPattern.Capture(new InitialPatternConditionPlus(Object.class){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                for (ElementPattern pattern : patterns) {
                    if (!pattern.accepts(o, context)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void append(@NotNull @NonNls StringBuilder builder, String indent) {
                if (builder == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/patterns/StandardPatterns$3", "append"));
                }
                boolean first = true;
                for (ElementPattern pattern : patterns) {
                    if (!first) {
                        builder.append("\n").append(indent);
                    }
                    first = false;
                    pattern.getCondition().append(builder, indent + "  ");
                }
            }

            @Override
            public List<ElementPattern<?>> getPatterns() {
                return Arrays.asList(patterns);
            }
        });
        if (capture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/StandardPatterns", "or"));
        }
        return capture;
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    @NotNull
    public static <E> ElementPattern<E> and(ElementPattern<? extends E> ... patterns) {
        void var5_8;
        List<InitialPatternCondition> initial = ContainerUtil.newSmartList();
        for (ElementPattern<E> elementPattern : patterns) {
            initial.add(elementPattern.getCondition().getInitialCondition());
        }
        ObjectPattern.Capture result = StandardPatterns.composeInitialConditions(initial);
        ElementPattern<? extends E>[] elementPatternArray = patterns;
        int n = elementPatternArray.length;
        boolean bl = false;
        while (var5_8 < n) {
            ElementPattern<E> elementPattern = elementPatternArray[var5_8];
            for (PatternCondition<? extends E> patternCondition : elementPattern.getCondition().getConditions()) {
                result = (ObjectPattern.Capture)result.with(patternCondition);
            }
            ++var5_8;
        }
        ObjectPattern.Capture capture = result;
        if (capture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/StandardPatterns", "and"));
        }
        return capture;
    }

    @NotNull
    private static <E> ObjectPattern.Capture<E> composeInitialConditions(final List<InitialPatternCondition> initial) {
        ObjectPattern.Capture capture = new ObjectPattern.Capture(new InitialPatternCondition(Object.class){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                for (InitialPatternCondition pattern : initial) {
                    if (pattern.accepts(o, context)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public void append(@NotNull @NonNls StringBuilder builder, String indent) {
                if (builder == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/patterns/StandardPatterns$4", "append"));
                }
                boolean first = true;
                for (InitialPatternCondition pattern : initial) {
                    if (!first) {
                        builder.append("\n").append(indent);
                    }
                    first = false;
                    pattern.append(builder, indent + "  ");
                }
            }
        });
        if (capture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/StandardPatterns", "composeInitialConditions"));
        }
        return capture;
    }

    @NotNull
    public static <E> ObjectPattern.Capture<E> not(final ElementPattern<E> pattern) {
        ObjectPattern.Capture capture = new ObjectPattern.Capture(new InitialPatternConditionPlus(Object.class){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                return !pattern.accepts(o, context);
            }

            @Override
            public void append(@NotNull @NonNls StringBuilder builder, String indent) {
                if (builder == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/patterns/StandardPatterns$5", "append"));
                }
                pattern.getCondition().append(builder.append("not("), indent + "  ");
                builder.append(")");
            }

            @Override
            public List<ElementPattern<?>> getPatterns() {
                return Collections.singletonList(pattern);
            }
        });
        if (capture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/StandardPatterns", "not"));
        }
        return capture;
    }

    @NotNull
    public static <T> ObjectPattern.Capture<T> optional(final ElementPattern<T> pattern) {
        ObjectPattern.Capture capture = new ObjectPattern.Capture(new InitialPatternCondition(Object.class){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                pattern.accepts(o, context);
                return true;
            }
        });
        if (capture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/StandardPatterns", "optional"));
        }
        return capture;
    }

    @NotNull
    public static <E> ElementPattern<E> alwaysFalse() {
        FalsePattern falsePattern = FALSE_PATTERN;
        if (falsePattern == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/patterns/StandardPatterns", "alwaysFalse"));
        }
        return falsePattern;
    }

    private static final class FalsePattern
    implements ElementPattern {
        private FalsePattern() {
        }

        @Override
        public boolean accepts(@Nullable Object o) {
            return false;
        }

        @Override
        public boolean accepts(@Nullable Object o, ProcessingContext context) {
            return false;
        }

        public ElementPatternCondition getCondition() {
            return new ElementPatternCondition(new InitialPatternCondition(Object.class){

                @Override
                public boolean accepts(@Nullable Object o, ProcessingContext context) {
                    return false;
                }
            });
        }
    }
}

