/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ImageList;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class ToolBar
extends Composite {
    ToolItem lastFocus;
    ToolItem[] tabItemList;
    ImageList imageList;

    public ToolBar(Composite composite, int n) {
        super(composite, ToolBar.checkStyle(n));
        this.style = (n & 0x200) != 0 ? (this.style |= 0x200) : (this.style |= 0x100);
        int n2 = (n & 0x200) != 0 ? 1 : 0;
        OS.gtk_toolbar_set_orientation(this.handle, n2);
    }

    static int checkStyle(int n) {
        if ((n & 0x40) != 0) {
            n &= 0xFFFFFFBF;
        }
        return n & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void createHandle(int n) {
        this.state |= 0x10008;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        OS.gtk_fixed_set_has_window(this.fixedHandle, true);
        this.handle = OS.gtk_toolbar_new();
        if (this.handle == 0L) {
            this.error(2);
        }
        OS.gtk_container_add(this.fixedHandle, this.handle);
        if ((this.style & 0x800000) != 0) {
            byte[] byArray = Converter.wcsToMbcs(null, "swt-toolbar-flat", true);
            OS.gtk_widget_set_name(this.handle, byArray);
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        return this.computeNativeSize(this.handle, n, n2, bl);
    }

    Widget computeTabGroup() {
        int n;
        ToolItem[] toolItemArray = this._getItems();
        if (this.tabItemList == null) {
            n = 0;
            while (n < toolItemArray.length && toolItemArray[n].control == null) {
                ++n;
            }
            if (n == toolItemArray.length) {
                return super.computeTabGroup();
            }
        }
        n = 0;
        while (n < toolItemArray.length) {
            if (toolItemArray[n].hasFocus()) break;
            ++n;
        }
        while (n >= 0) {
            ToolItem toolItem = toolItemArray[n];
            if (toolItem.isTabGroup()) {
                return toolItem;
            }
            --n;
        }
        return super.computeTabGroup();
    }

    Widget[] computeTabList() {
        ToolItem[] toolItemArray = this._getItems();
        if (this.tabItemList == null) {
            int n = 0;
            while (n < toolItemArray.length && toolItemArray[n].control == null) {
                ++n;
            }
            if (n == toolItemArray.length) {
                return super.computeTabList();
            }
        }
        Widget[] widgetArray = new Widget[]{};
        if (!(this.isTabGroup() && this.isEnabled() && this.isVisible())) {
            return widgetArray;
        }
        ToolItem[] toolItemArray2 = this.tabList != null ? this._getTabItemList() : toolItemArray;
        int n = 0;
        while (n < toolItemArray2.length) {
            ToolItem toolItem = toolItemArray2[n];
            Widget[] widgetArray2 = toolItem.computeTabList();
            if (widgetArray2.length != 0) {
                Widget[] widgetArray3 = new Widget[widgetArray.length + widgetArray2.length];
                System.arraycopy(widgetArray, 0, widgetArray3, 0, widgetArray.length);
                System.arraycopy(widgetArray2, 0, widgetArray3, widgetArray.length, widgetArray2.length);
                widgetArray = widgetArray3;
            }
            ++n;
        }
        if (widgetArray.length == 0) {
            widgetArray = new Widget[]{this};
        }
        return widgetArray;
    }

    long eventHandle() {
        return this.fixedHandle;
    }

    long enterExitHandle() {
        return this.handle;
    }

    void fixChildren(Shell shell, Shell shell2, Decorations decorations, Decorations decorations2, Menu[] menuArray) {
        super.fixChildren(shell, shell2, decorations, decorations2, menuArray);
        ToolItem[] toolItemArray = this.getItems();
        if (this.toolTipText == null) {
            int n = 0;
            while (n < toolItemArray.length) {
                ToolItem toolItem = toolItemArray[n];
                if (toolItem.toolTipText != null) {
                    toolItem.setToolTipText(shell2, null);
                    toolItem.setToolTipText(shell, toolItem.toolTipText);
                }
                ++n;
            }
        }
    }

    boolean forceFocus(long l) {
        if (this.lastFocus != null && this.lastFocus.setFocus()) {
            return true;
        }
        ToolItem[] toolItemArray = this.getItems();
        int n = 0;
        while (n < toolItemArray.length) {
            ToolItem toolItem = toolItemArray[n];
            if (toolItem.setFocus()) {
                return true;
            }
            ++n;
        }
        return super.forceFocus(l);
    }

    public ToolItem getItem(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.getItemCount()) {
            this.error(6);
        }
        return this.getItems()[n];
    }

    public ToolItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        ToolItem[] toolItemArray = this.getItems();
        int n = 0;
        while (n < toolItemArray.length) {
            if (toolItemArray[n].getBounds().contains(point)) {
                return toolItemArray[n];
            }
            ++n;
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        long l = OS.gtk_container_get_children(this.handle);
        if (l == 0L) {
            return 0;
        }
        int n = OS.g_list_length(l);
        OS.g_list_free(l);
        return n;
    }

    public ToolItem[] getItems() {
        this.checkWidget();
        return this._getItems();
    }

    ToolItem[] _getItems() {
        long l = OS.gtk_container_get_children(this.handle);
        if (l == 0L) {
            return new ToolItem[0];
        }
        int n = OS.g_list_length(l);
        ToolItem[] toolItemArray = new ToolItem[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            long l2 = OS.g_list_nth_data(l, n3);
            Widget widget = this.display.getWidget(l2);
            if (widget != null) {
                toolItemArray[n2++] = (ToolItem)widget;
            }
            ++n3;
        }
        OS.g_list_free(l);
        if (n2 != toolItemArray.length) {
            ToolItem[] toolItemArray2 = new ToolItem[n2];
            System.arraycopy(toolItemArray, 0, toolItemArray2, 0, n2);
            toolItemArray = toolItemArray2;
        }
        return toolItemArray;
    }

    public int getRowCount() {
        this.checkWidget();
        return 1;
    }

    ToolItem[] _getTabItemList() {
        if (this.tabItemList == null) {
            return this.tabItemList;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.tabItemList.length) {
            if (!this.tabItemList[n2].isDisposed()) {
                ++n;
            }
            ++n2;
        }
        if (n == this.tabItemList.length) {
            return this.tabItemList;
        }
        ToolItem[] toolItemArray = new ToolItem[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.tabItemList.length) {
            if (!this.tabItemList[n4].isDisposed()) {
                toolItemArray[n3++] = this.tabItemList[n4];
            }
            ++n4;
        }
        this.tabItemList = toolItemArray;
        return this.tabItemList;
    }

    long gtk_key_press_event(long l, long l2) {
        if (!this.hasFocus()) {
            return 0L;
        }
        long l3 = super.gtk_key_press_event(l, l2);
        if (l3 != 0L) {
            return l3;
        }
        ToolItem[] toolItemArray = this.getItems();
        int n = toolItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (toolItemArray[n2].hasFocus()) break;
            ++n2;
        }
        GdkEventKey gdkEventKey = new GdkEventKey();
        OS.memmove(gdkEventKey, l2, (long)GdkEventKey.sizeof);
        boolean bl = false;
        switch (gdkEventKey.keyval) {
            case 65361: 
            case 65362: {
                bl = false;
                break;
            }
            case 65364: {
                if (n2 >= 0 && n2 < n) {
                    ToolItem toolItem = toolItemArray[n2];
                    if ((toolItem.style & 4) != 0) {
                        Event event = new Event();
                        event.detail = 4;
                        long l4 = toolItem.topHandle();
                        event.x = OS.GTK_WIDGET_X(l4);
                        event.y = OS.GTK_WIDGET_Y(l4) + OS.GTK_WIDGET_HEIGHT(l4);
                        if ((this.style & 0x8000000) != 0) {
                            event.x = this.getClientWidth() - OS.GTK_WIDGET_WIDTH(l4) - event.x;
                        }
                        toolItem.postEvent(13, event);
                        return l3;
                    }
                }
            }
            case 65363: {
                bl = true;
                break;
            }
            default: {
                return l3;
            }
        }
        if ((this.style & 0x8000000) != 0) {
            bl = !bl;
        }
        int n3 = n2;
        int n4 = bl ? 1 : -1;
        while ((n2 = (n2 + n4 + n) % n) != n3) {
            ToolItem toolItem = toolItemArray[n2];
            if (!toolItem.setFocus()) continue;
            return l3;
        }
        return l3;
    }

    boolean hasFocus() {
        ToolItem[] toolItemArray = this.getItems();
        int n = 0;
        while (n < toolItemArray.length) {
            ToolItem toolItem = toolItemArray[n];
            if (toolItem.hasFocus()) {
                return true;
            }
            ++n;
        }
        return super.hasFocus();
    }

    public int indexOf(ToolItem toolItem) {
        this.checkWidget();
        if (toolItem == null) {
            this.error(4);
        }
        ToolItem[] toolItemArray = this.getItems();
        int n = 0;
        while (n < toolItemArray.length) {
            if (toolItem == toolItemArray[n]) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    boolean mnemonicHit(char c) {
        ToolItem[] toolItemArray = this.getItems();
        int n = 0;
        while (n < toolItemArray.length) {
            long l = toolItemArray[n].labelHandle;
            if (l != 0L && this.mnemonicHit(l, c)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    boolean mnemonicMatch(char c) {
        ToolItem[] toolItemArray = this.getItems();
        int n = 0;
        while (n < toolItemArray.length) {
            long l = toolItemArray[n].labelHandle;
            if (l != 0L && this.mnemonicMatch(l, c)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    void relayout() {
        ToolItem[] toolItemArray = this.getItems();
        int n = 0;
        while (n < toolItemArray.length) {
            ToolItem toolItem = toolItemArray[n];
            if (toolItem != null) {
                toolItem.resizeControl();
            }
            ++n;
        }
    }

    void releaseChildren(boolean bl) {
        ToolItem[] toolItemArray = this.getItems();
        int n = 0;
        while (n < toolItemArray.length) {
            ToolItem toolItem = toolItemArray[n];
            if (toolItem != null && !toolItem.isDisposed()) {
                toolItem.release(false);
            }
            ++n;
        }
        super.releaseChildren(bl);
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
    }

    void removeControl(Control control) {
        super.removeControl(control);
        ToolItem[] toolItemArray = this.getItems();
        int n = 0;
        while (n < toolItemArray.length) {
            ToolItem toolItem = toolItemArray[n];
            if (toolItem.control == control) {
                toolItem.setControl(null);
            }
            ++n;
        }
    }

    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5 = super.setBounds(n, n2, n3, n4, bl, bl2);
        if ((n5 & 0x100) != 0) {
            this.relayout();
        }
        return n5;
    }

    void setFontDescription(long l) {
        super.setFontDescription(l);
        ToolItem[] toolItemArray = this.getItems();
        int n = 0;
        while (n < toolItemArray.length) {
            toolItemArray[n].setFontDescription(l);
            ++n;
        }
        this.relayout();
    }

    void setForegroundColor(GdkColor gdkColor) {
        super.setForegroundColor(gdkColor);
        ToolItem[] toolItemArray = this.getItems();
        int n = 0;
        while (n < toolItemArray.length) {
            toolItemArray[n].setForegroundColor(gdkColor);
            ++n;
        }
    }

    void setTabItemList(ToolItem[] toolItemArray) {
        this.checkWidget();
        if (toolItemArray != null) {
            int n = 0;
            while (n < toolItemArray.length) {
                ToolItem toolItem = toolItemArray[n];
                if (toolItem == null) {
                    this.error(5);
                }
                if (toolItem.isDisposed()) {
                    this.error(5);
                }
                if (toolItem.parent != this) {
                    this.error(32);
                }
                ++n;
            }
            ToolItem[] toolItemArray2 = new ToolItem[toolItemArray.length];
            System.arraycopy(toolItemArray, 0, toolItemArray2, 0, toolItemArray.length);
            toolItemArray = toolItemArray2;
        }
        this.tabItemList = toolItemArray;
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        super.setToolTipText(string);
        Shell shell = this._getShell();
        ToolItem[] toolItemArray = this.getItems();
        int n = 0;
        while (n < toolItemArray.length) {
            String string2 = string != null ? null : toolItemArray[n].toolTipText;
            shell.setToolTipText(toolItemArray[n].handle, string2);
            ++n;
        }
    }
}

