/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.android.utils.StringHelper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class StringHelperWindows
extends StringHelper {
    public static List<String> splitCommandLine(String commandLine) {
        ArrayList<String> commands = Lists.newArrayList();
        boolean quoting = false;
        boolean escapingQuotes = false;
        boolean escapingOthers = false;
        int commandStart = 0;
        int length = commandLine.length();
        for (int i = 0; i < length; ++i) {
            char c = commandLine.charAt(i);
            if (c == '\"' && !escapingQuotes) {
                quoting = !quoting;
                continue;
            }
            if (escapingQuotes) {
                escapingQuotes = false;
            } else if (c == '\\') {
                escapingQuotes = true;
                continue;
            }
            if (escapingOthers) {
                escapingOthers = false;
                continue;
            }
            if (c == '^') {
                escapingOthers = true;
                continue;
            }
            if (quoting || commandLine.charAt(i) != '&') continue;
            commands.add(commandLine.substring(commandStart, i));
            if (commandLine.length() <= ++i || commandLine.charAt(i) == '&') {
                // empty if block
            }
            commandStart = ++i;
        }
        if (commandStart < length) {
            commands.add(commandLine.substring(commandStart));
        }
        return commands;
    }

    public static String quoteAndJoinTokens(List<String> tokens) {
        StringBuilder sb = new StringBuilder();
        for (String token : tokens) {
            token = token.replaceAll("(\\\\+)(?=\"|$)", "$1$1");
            token = token.replace("\"", "\\\"");
            sb.append("\"").append(token).append("\" ");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static List<String> tokenizeString(String string) {
        ArrayList<String> tokens = Lists.newArrayList();
        StringBuilder currentToken = new StringBuilder();
        boolean quoting = false;
        boolean escapingQuotes = false;
        boolean escapingOthers = false;
        boolean skipping = true;
        for (char c : string.toCharArray()) {
            if (skipping) {
                if (Character.isWhitespace(c)) continue;
                skipping = false;
            }
            if (c == '\"') {
                for (int i = currentToken.length() - 2; i >= 0 && currentToken.charAt(i) == '\\' && currentToken.charAt(i + 1) == '\\'; i -= 2) {
                    currentToken.deleteCharAt(i);
                }
                if (escapingQuotes) {
                    currentToken.deleteCharAt(currentToken.length() - 1);
                } else {
                    quoting = !quoting;
                    continue;
                }
            }
            if (escapingQuotes) {
                escapingQuotes = false;
            } else if (c == '\\') {
                escapingQuotes = true;
            }
            if (escapingOthers) {
                escapingOthers = false;
                if (c == '\n') {
                    continue;
                }
            } else if (!quoting && c == '^') {
                escapingOthers = true;
                continue;
            }
            if (!quoting && Character.isWhitespace(c)) {
                skipping = true;
                if (currentToken.length() > 0) {
                    tokens.add(currentToken.toString());
                }
                currentToken.setLength(0);
                continue;
            }
            currentToken.append(c);
        }
        if (currentToken.length() > 0) {
            tokens.add(currentToken.toString());
        }
        return tokens;
    }
}

