/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer.internal;

import com.android.tools.apk.analyzer.Archive;
import com.google.common.primitives.Shorts;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Path;

public class AndroidArtifact
implements Archive {
    private final Path artifact;
    private final FileSystem contents;

    public AndroidArtifact(Path artifact, FileSystem contents) {
        this.artifact = artifact;
        this.contents = contents;
    }

    @Override
    public Path getPath() {
        return this.artifact;
    }

    @Override
    public Path getContentRoot() {
        return this.contents.getPath("/", new String[0]);
    }

    @Override
    public void close() throws IOException {
        this.contents.close();
    }

    @Override
    public boolean isBinaryXml(Path p, byte[] content) {
        boolean xmlResource;
        if (!p.toString().endsWith(".xml")) {
            return false;
        }
        Path name = p.getFileName();
        if (name == null) {
            return false;
        }
        boolean manifest = p.equals(this.contents.getPath("/", "AndroidManifest.xml"));
        boolean insideResFolder = p.startsWith(this.contents.getPath("/", "res"));
        boolean insideResRaw = p.startsWith(this.contents.getPath("/", "res", "raw"));
        boolean bl = xmlResource = insideResFolder && !insideResRaw;
        if (!manifest && !xmlResource) {
            return false;
        }
        short code = Shorts.fromBytes((byte)content[1], (byte)content[0]);
        return code == 3;
    }
}

