/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib;

import brut.androlib.Androlib;
import brut.androlib.AndrolibException;
import brut.androlib.err.InFileNotFoundException;
import brut.androlib.err.OutDirExistsException;
import brut.androlib.err.UndefinedResObjectException;
import brut.androlib.meta.MetaInfo;
import brut.androlib.meta.PackageInfo;
import brut.androlib.meta.UsesFramework;
import brut.androlib.meta.VersionInfo;
import brut.androlib.res.AndrolibResources;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.ResTable;
import brut.androlib.res.xml.ResXmlPatcher;
import brut.common.BrutException;
import brut.directory.DirectoryException;
import brut.directory.ExtFile;
import brut.util.OS;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class ApkDecoder {
    public static final short DECODE_SOURCES_NONE = 0;
    public static final short DECODE_SOURCES_SMALI = 1;
    public static final short DECODE_SOURCES_SMALI_ONLY_MAIN_CLASSES = 16;
    public static final short DECODE_RESOURCES_NONE = 256;
    public static final short DECODE_RESOURCES_FULL = 257;
    public static final short FORCE_DECODE_MANIFEST_NONE = 0;
    public static final short FORCE_DECODE_MANIFEST_FULL = 1;
    public static final short DECODE_ASSETS_NONE = 0;
    public static final short DECODE_ASSETS_FULL = 1;
    private final Androlib mAndrolib;
    private static final Logger LOGGER = Logger.getLogger(Androlib.class.getName());
    private ExtFile mApkFile;
    private File mOutDir;
    private ResTable mResTable;
    private short mDecodeSources = 1;
    private short mDecodeResources = (short)257;
    private short mForceDecodeManifest = 0;
    private short mDecodeAssets = 1;
    private boolean mForceDelete = false;
    private boolean mKeepBrokenResources = false;
    private boolean mBakDeb = true;
    private Collection<String> mUncompressedFiles;
    private boolean mAnalysisMode = false;
    private int mApiLevel = 0;

    public ApkDecoder() {
        this(new Androlib());
    }

    public ApkDecoder(Androlib androlib) {
        this.mAndrolib = androlib;
    }

    public ApkDecoder(File apkFile) {
        this(apkFile, new Androlib());
    }

    public ApkDecoder(File apkFile, Androlib androlib) {
        this.mAndrolib = androlib;
        this.setApkFile(apkFile);
    }

    public void setApkFile(File apkFile) {
        if (this.mApkFile != null) {
            try {
                this.mApkFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.mApkFile = new ExtFile(apkFile);
        this.mResTable = null;
    }

    public void setOutDir(File outDir) {
        this.mOutDir = outDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decode() throws AndrolibException, IOException, DirectoryException {
        try {
            File outDir = this.getOutDir();
            AndrolibResources.sKeepBroken = this.mKeepBrokenResources;
            if (!this.mForceDelete && outDir.exists()) {
                throw new OutDirExistsException();
            }
            if (!this.mApkFile.isFile() || !this.mApkFile.canRead()) {
                throw new InFileNotFoundException();
            }
            try {
                OS.rmdir(outDir);
            }
            catch (BrutException ex) {
                throw new AndrolibException(ex);
            }
            outDir.mkdirs();
            LOGGER.info("Using Apktool " + Androlib.getVersion() + " on " + this.mApkFile.getName());
            if (this.hasResources()) {
                switch (this.mDecodeResources) {
                    case 256: {
                        this.mAndrolib.decodeResourcesRaw(this.mApkFile, outDir);
                        if (this.mForceDecodeManifest != 1 || !this.hasManifest()) break;
                        this.mAndrolib.decodeManifestWithResources(this.mApkFile, outDir, this.getResTable());
                        break;
                    }
                    case 257: {
                        if (this.hasManifest()) {
                            this.mAndrolib.decodeManifestWithResources(this.mApkFile, outDir, this.getResTable());
                        }
                        this.mAndrolib.decodeResourcesFull(this.mApkFile, outDir, this.getResTable());
                    }
                }
            } else if (this.hasManifest()) {
                if (this.mDecodeResources == 257 || this.mForceDecodeManifest == 1) {
                    this.mAndrolib.decodeManifestFull(this.mApkFile, outDir, this.getResTable());
                } else {
                    this.mAndrolib.decodeManifestRaw(this.mApkFile, outDir);
                }
            }
            if (this.hasSources()) {
                switch (this.mDecodeSources) {
                    case 0: {
                        this.mAndrolib.decodeSourcesRaw(this.mApkFile, outDir, "classes.dex");
                        break;
                    }
                    case 1: 
                    case 16: {
                        this.mAndrolib.decodeSourcesSmali(this.mApkFile, outDir, "classes.dex", this.mBakDeb, this.mApiLevel);
                    }
                }
            }
            if (this.hasMultipleSources()) {
                Set<String> files = this.mApkFile.getDirectory().getFiles(true);
                for (String file : files) {
                    if (!file.endsWith(".dex") || file.equalsIgnoreCase("classes.dex")) continue;
                    switch (this.mDecodeSources) {
                        case 0: {
                            this.mAndrolib.decodeSourcesRaw(this.mApkFile, outDir, file);
                            break;
                        }
                        case 1: {
                            this.mAndrolib.decodeSourcesSmali(this.mApkFile, outDir, file, this.mBakDeb, this.mApiLevel);
                            break;
                        }
                        case 16: {
                            if (file.startsWith("classes") && file.endsWith(".dex")) {
                                this.mAndrolib.decodeSourcesSmali(this.mApkFile, outDir, file, this.mBakDeb, this.mApiLevel);
                                break;
                            }
                            this.mAndrolib.decodeSourcesRaw(this.mApkFile, outDir, file);
                        }
                    }
                }
            }
            this.mAndrolib.decodeRawFiles(this.mApkFile, outDir, this.mDecodeAssets);
            this.mAndrolib.decodeUnknownFiles(this.mApkFile, outDir);
            this.mUncompressedFiles = new ArrayList<String>();
            this.mAndrolib.recordUncompressedFiles(this.mApkFile, this.mUncompressedFiles);
            this.mAndrolib.writeOriginalFiles(this.mApkFile, outDir);
            this.writeMetaFile();
        }
        finally {
            try {
                this.mApkFile.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void setDecodeSources(short mode) throws AndrolibException {
        if (mode != 0 && mode != 1 && mode != 16) {
            throw new AndrolibException("Invalid decode sources mode: " + mode);
        }
        if (this.mDecodeSources == 0 && mode == 16) {
            LOGGER.info("--only-main-classes cannot be paired with -s/--no-src. Ignoring.");
            return;
        }
        this.mDecodeSources = mode;
    }

    public void setDecodeResources(short mode) throws AndrolibException {
        if (mode != 256 && mode != 257) {
            throw new AndrolibException("Invalid decode resources mode");
        }
        this.mDecodeResources = mode;
    }

    public void setForceDecodeManifest(short mode) throws AndrolibException {
        if (mode != 0 && mode != 1) {
            throw new AndrolibException("Invalid force decode manifest mode");
        }
        this.mForceDecodeManifest = mode;
    }

    public void setDecodeAssets(short mode) throws AndrolibException {
        if (mode != 0 && mode != 1) {
            throw new AndrolibException("Invalid decode asset mode");
        }
        this.mDecodeAssets = mode;
    }

    public void setAnalysisMode(boolean mode) {
        this.mAnalysisMode = mode;
        if (this.mResTable != null) {
            this.mResTable.setAnalysisMode(mode);
        }
    }

    public void setApiLevel(int apiLevel) {
        this.mApiLevel = apiLevel;
    }

    public void setBaksmaliDebugMode(boolean bakDeb) {
        this.mBakDeb = bakDeb;
    }

    public void setForceDelete(boolean forceDelete) {
        this.mForceDelete = forceDelete;
    }

    public void setFrameworkTag(String tag) {
        this.mAndrolib.buildOptions.frameworkTag = tag;
    }

    public void setKeepBrokenResources(boolean keepBrokenResources) {
        this.mKeepBrokenResources = keepBrokenResources;
    }

    public void setFrameworkDir(String dir) {
        this.mAndrolib.buildOptions.frameworkFolderLocation = dir;
    }

    public ResTable getResTable() throws AndrolibException {
        if (this.mResTable == null) {
            boolean hasResources = this.hasResources();
            boolean hasManifest = this.hasManifest();
            if (!hasManifest && !hasResources) {
                throw new AndrolibException("Apk doesn't contain either AndroidManifest.xml file or resources.arsc file");
            }
            this.mResTable = this.mAndrolib.getResTable(this.mApkFile, hasResources);
            this.mResTable.setAnalysisMode(this.mAnalysisMode);
        }
        return this.mResTable;
    }

    public boolean hasSources() throws AndrolibException {
        try {
            return this.mApkFile.getDirectory().containsFile("classes.dex");
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    public boolean hasMultipleSources() throws AndrolibException {
        try {
            Set<String> files = this.mApkFile.getDirectory().getFiles(false);
            for (String file : files) {
                if (!file.endsWith(".dex") || file.equalsIgnoreCase("classes.dex")) continue;
                return true;
            }
            return false;
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    public boolean hasManifest() throws AndrolibException {
        try {
            return this.mApkFile.getDirectory().containsFile("AndroidManifest.xml");
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    public boolean hasResources() throws AndrolibException {
        try {
            return this.mApkFile.getDirectory().containsFile("resources.arsc");
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    public void close() throws IOException {
        if (this.mAndrolib != null) {
            this.mAndrolib.close();
        }
    }

    private File getOutDir() throws AndrolibException {
        if (this.mOutDir == null) {
            throw new AndrolibException("Out dir not set");
        }
        return this.mOutDir;
    }

    private void writeMetaFile() throws AndrolibException {
        MetaInfo meta = new MetaInfo();
        meta.version = Androlib.getVersion();
        meta.apkFileName = this.mApkFile.getName();
        if (this.mResTable != null) {
            meta.isFrameworkApk = this.mAndrolib.isFrameworkApk(this.mResTable);
            this.putUsesFramework(meta);
            this.putSdkInfo(meta);
            this.putPackageInfo(meta);
            this.putVersionInfo(meta);
            this.putSharedLibraryInfo(meta);
            this.putSparseResourcesInfo(meta);
        } else {
            this.putMinSdkInfo(meta);
        }
        this.putUnknownInfo(meta);
        this.putFileCompressionInfo(meta);
        this.mAndrolib.writeMetaFile(this.mOutDir, meta);
    }

    private void putUsesFramework(MetaInfo meta) {
        Set<ResPackage> pkgs = this.mResTable.listFramePackages();
        if (pkgs.isEmpty()) {
            return;
        }
        Object[] ids = new Integer[pkgs.size()];
        int i = 0;
        for (ResPackage pkg : pkgs) {
            ids[i++] = pkg.getId();
        }
        Arrays.sort(ids);
        meta.usesFramework = new UsesFramework();
        meta.usesFramework.ids = Arrays.asList(ids);
        if (this.mAndrolib.buildOptions.frameworkTag != null) {
            meta.usesFramework.tag = this.mAndrolib.buildOptions.frameworkTag;
        }
    }

    private void putSdkInfo(MetaInfo meta) {
        Map<String, String> info = this.mResTable.getSdkInfo();
        if (info.size() > 0) {
            String refValue;
            if (info.get("minSdkVersion") != null && (refValue = ResXmlPatcher.pullValueFromIntegers(this.mOutDir, info.get("minSdkVersion"))) != null) {
                info.put("minSdkVersion", refValue);
            }
            if (info.get("targetSdkVersion") != null && (refValue = ResXmlPatcher.pullValueFromIntegers(this.mOutDir, info.get("targetSdkVersion"))) != null) {
                info.put("targetSdkVersion", refValue);
            }
            if (info.get("maxSdkVersion") != null && (refValue = ResXmlPatcher.pullValueFromIntegers(this.mOutDir, info.get("maxSdkVersion"))) != null) {
                info.put("maxSdkVersion", refValue);
            }
            meta.sdkInfo = info;
        }
    }

    private void putMinSdkInfo(MetaInfo meta) {
        int minSdkVersion = this.mAndrolib.getMinSdkVersion();
        if (minSdkVersion > 0) {
            LinkedHashMap<String, String> sdkInfo = new LinkedHashMap<String, String>();
            sdkInfo.put("minSdkVersion", Integer.toString(minSdkVersion));
            meta.sdkInfo = sdkInfo;
        }
    }

    private void putPackageInfo(MetaInfo meta) throws AndrolibException {
        String renamed = this.mResTable.getPackageRenamed();
        String original = this.mResTable.getPackageOriginal();
        int id = this.mResTable.getPackageId();
        try {
            id = this.mResTable.getPackage(renamed).getId();
        }
        catch (UndefinedResObjectException undefinedResObjectException) {
            // empty catch block
        }
        if (Strings.isNullOrEmpty(original)) {
            return;
        }
        meta.packageInfo = new PackageInfo();
        if (!renamed.equalsIgnoreCase(original)) {
            meta.packageInfo.renameManifestPackage = renamed;
        }
        meta.packageInfo.forcedPackageId = String.valueOf(id);
    }

    private void putVersionInfo(MetaInfo meta) {
        VersionInfo info = this.mResTable.getVersionInfo();
        String refValue = ResXmlPatcher.pullValueFromStrings(this.mOutDir, info.versionName);
        if (refValue != null) {
            info.versionName = refValue;
        }
        meta.versionInfo = info;
    }

    private void putSharedLibraryInfo(MetaInfo meta) {
        meta.sharedLibrary = this.mResTable.getSharedLibrary();
    }

    private void putSparseResourcesInfo(MetaInfo meta) {
        meta.sparseResources = this.mResTable.getSparseResources();
    }

    private void putUnknownInfo(MetaInfo meta) {
        meta.unknownFiles = this.mAndrolib.mResUnknownFiles.getUnknownFiles();
    }

    private void putFileCompressionInfo(MetaInfo meta) {
        if (this.mUncompressedFiles != null && !this.mUncompressedFiles.isEmpty()) {
            meta.doNotCompress = this.mUncompressedFiles;
        }
    }
}

