/*
 * Decompiled with CFR 0.152.
 */
package com.doyensec.ajp13;

import com.doyensec.ajp13.AbstractAjpMessage;
import com.doyensec.ajp13.AjpReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class SendBodyChunkMessage
extends AbstractAjpMessage {
    final int length;
    final byte[] bytes;

    public SendBodyChunkMessage(byte[] bytes) throws IOException {
        super(3);
        this.length = bytes.length;
        this.writeInt(this.length);
        this.bytes = bytes;
        this.writeBytes(bytes);
    }

    public int getLength() {
        return this.length;
    }

    public byte[] getBodyChunk() {
        return this.bytes;
    }

    public String toString() {
        try {
            return new String(this.bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            System.out.println("[!] SendBodyChunkMessage UnsupportedEncodingException: " + ex.getLocalizedMessage());
            return "InvalidEncoding";
        }
    }

    static SendBodyChunkMessage readFrom(InputStream in) throws IOException {
        int length = AjpReader.readInt(in);
        byte[] bytes = new byte[length];
        AjpReader.fullyRead(bytes, in);
        return new SendBodyChunkMessage(bytes);
    }

    @Override
    public String getName() {
        return "Send Body Chunk";
    }

    @Override
    public String getDescription() {
        return "Send a chunk of the body from the servlet container to the web server.\nContent (HEX):\n0x" + AjpReader.getHex(this.bytes) + "\nContent (Ascii):\n" + this.toString();
    }
}

