/*
 * Decompiled with CFR 0.152.
 */
package com.doyensec.ajp13;

import com.doyensec.ajp13.AjpMessage;
import com.doyensec.ajp13.BodyMessage;
import com.doyensec.ajp13.CPingMessage;
import com.doyensec.ajp13.CPongMessage;
import com.doyensec.ajp13.Constants;
import com.doyensec.ajp13.EndResponseMessage;
import com.doyensec.ajp13.ForwardRequestMessage;
import com.doyensec.ajp13.GetBodyChunkMessage;
import com.doyensec.ajp13.PingMessage;
import com.doyensec.ajp13.SendBodyChunkMessage;
import com.doyensec.ajp13.SendHeadersMessage;
import com.doyensec.ajp13.ShutdownMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public final class AjpReader {
    public static AjpMessage parseMessage(byte[] reply) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(reply);
        byte[] header = AjpReader.readBytes(2, false, in);
        if (Arrays.equals(header, Constants.AJP_TAG_REQ) || Arrays.equals(header, Constants.AJP_TAG_RESP)) {
            int length = AjpReader.readInt(in);
            if (length <= 0) {
                return null;
            }
            int type = AjpReader.readByte(in);
            byte[] bytes = new byte[length - 1];
            AjpReader.fullyRead(bytes, in);
            switch (type) {
                case 10: {
                    return new CPingMessage();
                }
                case 2: {
                    return ForwardRequestMessage.readFrom(new ByteArrayInputStream(bytes));
                }
                case 7: {
                    return new ShutdownMessage();
                }
                case 8: {
                    return new PingMessage();
                }
                case 9: {
                    return new CPongMessage();
                }
                case 4: {
                    return SendHeadersMessage.readFrom(new ByteArrayInputStream(bytes));
                }
                case 3: {
                    return SendBodyChunkMessage.readFrom(new ByteArrayInputStream(bytes));
                }
                case 6: {
                    return GetBodyChunkMessage.readFrom(new ByteArrayInputStream(bytes));
                }
                case 5: {
                    return EndResponseMessage.readFrom(new ByteArrayInputStream(bytes));
                }
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            outputStream.write(type);
            outputStream.write(bytes);
            return BodyMessage.readFrom(new ByteArrayInputStream(outputStream.toByteArray()));
        }
        System.out.println("[!] AjpReader Unexpected Header Bytes: " + AjpReader.getHex(header));
        return null;
    }

    static int readInt(InputStream in) throws IOException {
        byte[] buf = new byte[2];
        AjpReader.fullyRead(buf, in);
        return AjpReader.makeInt(buf[0], buf[1]);
    }

    static int makeInt(int b1, int b2) {
        return b1 << 8 | b2 & 0xFF;
    }

    static String readString(InputStream in) throws IOException {
        int len = AjpReader.readInt(in);
        return AjpReader.readString(len, in);
    }

    static String readString(int len, InputStream in) throws IOException {
        byte[] strContent = AjpReader.readBytes(len, true, in);
        if (strContent != null && strContent.length > 0) {
            return new String(strContent, "UTF-8");
        }
        return "";
    }

    static byte[] readBytes(int len, InputStream in) throws IOException {
        return AjpReader.readBytes(len, false, in);
    }

    private static byte[] readBytes(int len, boolean nullByte, InputStream in) throws IOException {
        if (len < 1) {
            return null;
        }
        byte[] buf = new byte[len];
        AjpReader.fullyRead(buf, in);
        if (nullByte) {
            in.read();
        }
        return buf;
    }

    static void fullyRead(byte[] buffer, InputStream in) throws IOException {
        int totalRead = 0;
        int read = 0;
        while ((read = in.read(buffer, totalRead, buffer.length - totalRead)) > 0) {
            totalRead += read;
        }
        if (totalRead != buffer.length) {
            System.out.println("[!] AjpReader Short Read. Buffer: " + buffer.length + ", Read: " + totalRead);
        }
    }

    static int readByte(InputStream in) throws IOException {
        return in.read();
    }

    static boolean readBoolean(InputStream in) throws IOException {
        return AjpReader.readByte(in) > 0;
    }

    public static String getHex(byte[] raw) {
        String HEXES = "0123456789ABCDEF";
        if (raw == null) {
            return null;
        }
        StringBuilder hex = new StringBuilder(2 * raw.length);
        for (byte b : raw) {
            hex.append("0123456789ABCDEF".charAt((b & 0xF0) >> 4)).append("0123456789ABCDEF".charAt(b & 0xF));
        }
        return hex.toString();
    }

    public static byte[] toHex(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }
}

