"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Requester = void 0;
var Axios = __importStar(require("axios"));
var Https = __importStar(require("https"));
var PayloadGenerator_1 = require("./PayloadGenerator");
var HTTPParser_1 = require("./HTTPParser");
var Requester = /** @class */ (function () {
    function Requester() {
    }
    Requester.fromFile = function (templatePath, payload, line) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, new Promise(function (resolve, reject) {
                        HTTPParser_1.HTTPParser.fromFile(templatePath).then(function (parsedRequest) {
                            Requester.doRequest(parsedRequest, payload).then(function (response) { resolve([response, line]); }).catch(function (err) { return reject([err, line]); });
                        });
                    })];
            });
        });
    };
    Requester.fromString = function (requestContent, payload, line) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, new Promise(function (resolve, reject) {
                        var parsedRequest = HTTPParser_1.HTTPParser.fromString(requestContent);
                        Requester.doRequest(parsedRequest, payload).then(function (response) { resolve([response, line]); }).catch(function (err) { return reject([err, line]); });
                    })];
            });
        });
    };
    Requester.doRequest = function (parsedRequest, payload) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, new Promise(function (resolve, reject) {
                        if (parsedRequest === null)
                            reject("Error parsing request");
                        else {
                            var tmp = Requester.preparePayload(parsedRequest.headers, parsedRequest.body, payload);
                            var headers = tmp[0];
                            var body = tmp[1];
                            var r = Axios.default({
                                method: parsedRequest.method,
                                url: parsedRequest.url,
                                headers: headers,
                                httpsAgent: new Https.Agent({
                                    rejectUnauthorized: false
                                }),
                                data: body
                            });
                            r.then(function (resp) { resolve(resp); }).catch(function (err) { reject(err); });
                        }
                    })];
            });
        });
    };
    // public static saveResponse(r: Axios.AxiosResponse): string {
    //   const rawResponse = HTTPParser.axiosResponseToString(r);
    //   const date = new Date().toISOString();
    //   const filename = `xxexploiter_response_${date}.txt`;
    //   fs.writeFileSync(filename, rawResponse);
    //   return filename;
    // }
    Requester.preparePayload = function (headers, body, payload) {
        var newHeaders = {};
        headers = Object.keys(headers).map(function (k) {
            var v = headers[k];
            if (v.includes(PayloadGenerator_1.PayloadGenerator.PLACEHOLDER))
                v = v.replace(PayloadGenerator_1.PayloadGenerator.PLACEHOLDER, payload.replace("\n", ""));
            if (v.includes(PayloadGenerator_1.PayloadGenerator.PLACEHOLDER_REQUEST_B64))
                v = v.replace(PayloadGenerator_1.PayloadGenerator.PLACEHOLDER_REQUEST_B64, Buffer.from(payload.replace("\n", "")).toString("base64"));
            newHeaders[k] = v;
        });
        if (body.includes(PayloadGenerator_1.PayloadGenerator.PLACEHOLDER))
            body = body.replace(PayloadGenerator_1.PayloadGenerator.PLACEHOLDER, payload);
        if (body.includes(PayloadGenerator_1.PayloadGenerator.PLACEHOLDER_REQUEST_B64))
            body = body.replace(PayloadGenerator_1.PayloadGenerator.PLACEHOLDER_REQUEST_B64, Buffer.from(payload).toString("base64"));
        return [newHeaders, body];
    };
    return Requester;
}());
exports.Requester = Requester;
