"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Handler = void 0;
var PayloadGenerator_1 = require("./PayloadGenerator");
var readline = __importStar(require("readline"));
var Requester_1 = require("./Requester");
var yargs = __importStar(require("yargs"));
var HTTPParser_1 = require("./HTTPParser");
var fs = __importStar(require("fs"));
var CliUtils_1 = require("./CliUtils");
var Handler = /** @class */ (function () {
    function Handler(opts) {
        this.fuzzStats = { done: 0, found: 0 };
        this.opts = opts;
        this.generator = new PayloadGenerator_1.PayloadGenerator(opts.address, opts.port);
    }
    Handler.prototype.generatePayload = function (opts) {
        if (opts === void 0) { opts = this.opts; }
        var xmlPayload;
        //generate payload
        if (opts.xxeIterations)
            xmlPayload = PayloadGenerator_1.PayloadGenerator.xee(opts.xxeIterations, opts.template, opts.doctype);
        else
            xmlPayload = this.generator.generate(opts.type, opts.mode, opts.encoding, opts.commandarg, opts.template, opts.doctype);
        return xmlPayload;
    };
    Handler.prototype.sendPayload = function (xmlPayload, opts) {
        return new Promise(function (resolve, reject) {
            Requester_1.Requester.fromString(opts.requestFile, xmlPayload, opts.fuzzLine).then(function (_a) {
                var r = _a[0], line = _a[1];
                var resp = HTTPParser_1.HTTPParser.axiosResponseToString(r);
                resolve([opts, resp, line]);
            }).catch(function (_a) {
                var err = _a[0], line = _a[1];
                return reject([err, line]);
            });
        });
    };
    Handler.prototype.shouldOutputContent = function (response, successString, errorString) {
        var output = true; //if no rule defined output all responses
        if (errorString) {
            if (response.includes(errorString))
                output = false;
            else
                output = true;
        }
        if (successString) {
            if (response.includes(successString))
                output = true;
            else
                output = false;
        }
        return output;
    };
    Handler.prototype.doSingle = function () {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                return [2 /*return*/, new Promise(function (resolve, reject) {
                        if (Handler.VERBOSE)
                            CliUtils_1.CliUtils.printInfo("Generating payload");
                        var payload = _this.generatePayload(_this.opts);
                        if (_this.opts.output) {
                            if (Handler.VERBOSE)
                                CliUtils_1.CliUtils.printInfo("Writing payload to " + _this.opts.output);
                            fs.writeFileSync(_this.opts.output, payload);
                        }
                        else {
                            //print the payload if not doing a request
                            //always print in verbose mode
                            if (Handler.VERBOSE || !_this.opts.requestFile)
                                console.log("\n" + payload + "\n");
                        }
                        if (_this.opts.requestFile) {
                            if (Handler.VERBOSE)
                                CliUtils_1.CliUtils.printInfo("Sending payload to target host");
                            _this.sendPayload(payload, _this.opts).then(function (data) {
                                var resp = data[1];
                                var outputContent = "Response:\n\n".concat(resp, "\n\n");
                                if (_this.opts.requestOutput) {
                                    fs.writeFileSync(_this.opts.requestOutput, outputContent);
                                }
                                else
                                    CliUtils_1.CliUtils.printInfo(outputContent);
                                resolve(undefined);
                            }).catch(function (err) {
                                CliUtils_1.CliUtils.printError("Error on request ".concat(err[1], " - ") + (err.errno || err));
                            });
                        }
                        else {
                            //if not doing requests, inform that the server has started and we are waiting for some action
                            if (_this.opts.mode === PayloadGenerator_1.Mode.CDATA || _this.opts.mode === PayloadGenerator_1.Mode.OOB)
                                CliUtils_1.CliUtils.printInfo("Server started, waiting for requests");
                            else
                                resolve(undefined);
                        }
                    })];
            });
        });
    };
    Handler.prototype.handleFuzzLine = function (opts) {
        var _this = this;
        if (Handler.VERBOSE)
            CliUtils_1.CliUtils.printInfo("Generating payload for line " + opts.fuzzLine);
        var payload = this.generatePayload(opts);
        var prom = this.sendPayload(payload, opts);
        prom.then(function (data) {
            var opts = data[0];
            var resp = data[1];
            var line = data[2];
            var outputContent = "Response for ".concat(line, "\n\n").concat(resp, "\n\n");
            var shouldOutput = _this.shouldOutputContent(resp, opts.successString, opts.erroString);
            _this.fuzzStats.done++;
            if (shouldOutput) { //means that the filter rules passed. found a success response
                _this.fuzzStats.found++;
                if (opts.requestOutput) //output to file
                    fs.appendFileSync(opts.requestOutput, outputContent); //TODO: this may be a bottleneck. Need to keep opening the files
                else //output to console
                 {
                    CliUtils_1.CliUtils.printSuccess("Got Successfull Request for " + line);
                    console.log(outputContent);
                }
            }
            _this.printFuzzedStats();
        }).catch(function (err) {
            _this.fuzzStats.done++;
            _this.printFuzzedStats();
            CliUtils_1.CliUtils.printError("Error on request for ".concat(err[1], " - ") + (err[0].errno || err[0]));
        });
        return prom;
    };
    Handler.prototype.fuzzer = function () {
        var _this = this;
        return new Promise(function (resolve, reject) {
            if (Handler.VERBOSE)
                CliUtils_1.CliUtils.printInfo("Start fuzzing");
            var opts = _this.opts;
            var proms = [];
            _this.fuzzStats = { done: 0, found: 0 };
            if (Handler.VERBOSE)
                CliUtils_1.CliUtils.printInfo("Check wordlist");
            _this.checkWordList(opts.wordlist); //if not valid exists
            //create a file to be appended with results
            if (opts.requestOutput) {
                if (fs.existsSync(opts.requestOutput))
                    fs.unlinkSync(opts.requestOutput); //delete file if exists
                fs.writeFileSync(opts.requestOutput, "");
            }
            //read wordlist a line at a time
            if (Handler.VERBOSE)
                CliUtils_1.CliUtils.printInfo("Starting to read wordlist");
            var rd = readline.createInterface({ input: fs.createReadStream(opts.wordlist) });
            rd.on('line', function (line) {
                opts.fuzzLine = line;
                opts.commandarg = opts.originalCommandarg.replace("{{FUZZ}}", line);
                proms.push(_this.handleFuzzLine(opts));
            });
            //check for all promises only when finished reading file
            rd.on('close', function () {
                Promise.all(proms).then(function () {
                    console.log("");
                    CliUtils_1.CliUtils.printInfo("All Done");
                    resolve(undefined);
                }).catch(function (e) { });
            });
        });
    };
    Handler.prototype.checkWordList = function (wordlist) {
        //wordlist is needed for fuzz. may need to change this when adding portscan
        if (!this.opts.wordlist) {
            yargs.showHelp();
            process.exit();
        }
        //check if checklist exists
        if (!fs.existsSync(wordlist)) {
            CliUtils_1.CliUtils.printError("Wordlist file not found");
            process.exit();
        }
        return true;
    };
    Handler.prototype.printFuzzedStats = function () {
        var t = "".concat(Handler.fuzzResultsString, " ").concat(this.fuzzStats.done, "/").concat(this.fuzzStats.found);
        CliUtils_1.CliUtils.printInfo(t);
    };
    Handler.VERBOSE = false;
    Handler.fuzzResultsString = "Fuzz - Requests Done/Success Results: ";
    return Handler;
}());
exports.Handler = Handler;
