#
# (C) Tenable Network Security
#

if(description)
{
 script_id(15817);
 script_cve_id("CAN-2004-1119");
 script_bugtraq_id(11730);
 script_version("$Revision: 1.5 $");

 name["english"] = "Nullsoft Winamp IN_CDDA.dll Remote Buffer Overflow Vulnerability";

 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is using WinAMP5, a popular media player
which handles many files format (mp3, wavs and more...)

This version has a buffer overflow which may allow an attacker
to execute arbitrary code on this host, with the rights of the user
running WinAMP.

To perform an attack, the attack would have to send a malformed
playlist (.m3u) to the user of this host who would then have to
load it by double clicking on it.

Solution : Uninstall this software or upgrade to version 5.07.
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Determines the version of WinAMP";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 
 script_dependencies("netbios_name_get.nasl",
 		     "smb_login.nasl","smb_registry_access.nasl");
 script_require_keys("SMB/name", "SMB/login", "SMB/password",
		     "SMB/domain","SMB/transport");

 script_require_ports(139, 445);
 exit(0);
}


include("smb_func.inc");
include("smb_hotfixes.inc");




rootfile = hotfix_get_programfilesdir();
if ( ! rootfile ) exit(1);
share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:rootfile);
winamp5 =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1\Winamp\whatsnew.txt", string:rootfile);


name 	=  kb_smb_name();
login	=  kb_smb_login();
pass  	=  kb_smb_password();
domain 	=  kb_smb_domain();
port    =  kb_smb_transport();

if(!get_port_state(port))exit(1);

soc = open_sock_tcp(port);
if(!soc)exit(1);



session_init(socket:soc, hostname:name);
r = NetUseAdd(login:login, password:pass, domain:domain, share:share);
if ( r != 1 ) exit(1);

handle = CreateFile (file:winamp5, desired_access:GENERIC_READ, file_attributes:FILE_ATTRIBUTE_NORMAL, share_mode:FILE_SHARE_READ, create_disposition:OPEN_EXISTING);

if ( ! isnull(handle) )
{
 data = ReadFile(handle:handle, offset:0, length:12); 
 version = egrep(pattern:"^Winamp ([0-9]\.[0-9]*):", string:data);
 CloseFile(handle:handle);
 if ( version )
 {
  version = chomp(ereg_replace(pattern:"^Winamp ([0-9]\.[0-9]*):.*", string:version, replace:"\1"));
  set_kb_item(name:"SMB/Winamp/Version", value:version);
 }

 if(egrep(pattern:"^Winamp 5\.0[0-6]?:.*", string:data))
  security_hole(port);
}

NetUseDel();
