# 2003-03-20 Michel Arboi <arboi@alussinan.org>
#
# This NASL script is a quick and dirty conversion of smtpscan by
# Julien Bordet <zejames@greyhats.org>
# Note that smtpcan has more features than this simple script
#
# The following plugin is Copyright (c) 2002,2003 Julien Bordet 
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. All advertising materials mentioning features or use of this software
#    must display the following acknowledgement:
#      This product includes software developed and data gathered by
#      Julien Bordet, Renaud Deraison and Michel Arboi, for smtpscan and 
#      Nessus projects
#
# 
#

if(description)
{
 script_name(english: "smtpscan");
 script_id(11421);
 script_version ("$Revision: 1.90 $");
 
 desc["english"] = "
smtpscan is a SMTP fingerprinting tool written by Julien Bordet
It identifies the remote mail server even if the banners were changed.

Risk factor : None";

 script_description(english:desc["english"]);
 
 summary["english"] = "SMTP server fingerprinting";
 summary["francais"] = "Identifie le serveur SMTP par son empreinte";
 script_summary(english:summary["english"], francais:summary["francais"]);
 script_category(ACT_GATHER_INFO);
 script_copyright(english:"smtpscan was written by Julien Bordet. Michel Arboi converted it to NASL",
		francais:"smtpscan a t crit par Julien Bordet. Michel Arboi l'a converti en NASL");
 family["english"] = "SMTP problems";
 family["francais"] = "Problmes SMTP";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service_3digits.nasl", "doublecheck_std_services.nasl");
 script_require_ports("Services/smtp", 25);
 exit(0);
}


include("smtp_func.inc");
include("global_settings.inc");

display_report = COMMAND_LINE || experimental_scripts || report_paranoia > 1 || report_verbosity > 1;

fingerprints = '
4D WebSTAR -0-:501:250:501:250:501:250:250:214:550:550:500:500:500:250:250
4D WebSTAR -1-:501:220:501:250:501:250:250:214:500:500:500:500:500:250:250
4D WebSTAR -2-:501:250:501:250:501:250:250:214:250:250:500:500:500:250:250
4D WebSTAR -3-:501:250:501:250:501:250:250:214:550:500:500:500:500:250:250
4D WebSTAR -4-:501:250:501:250:501:250:250:214:500:500:500:500:500:250:250
4D WebSTAR -5-:501:250:501:250:501:250:250:214:550:550:500:500:500:250:250
4D WebSTAR -6-:501:220:501:250:501:250:250:214:500:500:500:500:500:250:250
4D WebSTAR -7-:501:250:501:250:501:250:250:214:250:250:500:500:500:250:250
4D WebSTAR -8-:501:250:501:250:501:250:250:214:550:500:500:500:500:250:250
4D WebSTAR V Mail (5.2.4) -0-:503:250:500:250:500:250:500:500:250:250:500:500:500:250:250
4D WebSTAR V Mail (5.2.4) -1-:503:250:500:250:500:250:500:500:500:500:500:500:500:250:250
602Pro LAN SUITE v. 2000:501:250:501:250:501:250:501:214:502:502:502:250:250:250:250
AMOS Mail version 5.1:503:250:501:250:250:250:550:214:252:502:502:502:502:250:250
Abbing Mailserver v9.5:250:501:501:250:501:501:550:214:502:502:500:250:250:250:250
ArGoSoft Pro Version 1.8 -0-:550:250:502:250:550:550:550:214:502:550:502:502:502:250:250
ArGoSoft Pro Version 1.8 -1-:250:250:550:250:250:550:550:214:550:550:550:550:550:250:250
ArGoSoft Pro Version 1.8 -2-:250:250:502:250:250:250:550:214:502:502:502:502:502:250:250
ArGoSoft Pro Win2000/XP Version 1.7 -0-:250:250:550:550:250:550:550:214:550:550:550:550:550:250:250
ArGoSoft Pro Win2000/XP Version 1.7 -1-:250:250:550:250:250:250:250:214:550:550:550:550:550:250:250
ArGoSoft Pro Win2000/XP Version 1.8 -0-:250:250:502:250:250:550:250:214:502:550:502:502:502:250:250
ArGoSoft Pro Win2000/XP Version 1.8 -1-:250:250:502:550:250:550:550:214:502:550:502:502:502:250:250
ArGoSoft Pro Win2000/XP Version 1.8 -2-:250:250:502:250:250:250:550:214:502:550:250:502:502:250:250
ArGoSoft Pro Win2000/XP Version 1.8 -3-:250:250:502:250:250:550:550:214:502:550:502:502:502:250:250
ArGoSoft Pro for WinNT/2000/XP Version 1.8 -0-:250:250:502:250:250:250:550:214:502:550:502:502:502:250:250
ArGoSoft Pro for WinNT/2000/XP Version 1.8 -1-:250:250:502:250:250:550:250:214:502:550:502:502:502:250:250
ArGoSoft Pro for WinNT/2000/XP Version 1.8 -2-:250:250:502:550:250:550:550:214:502:550:502:502:502:250:250
ArGoSoft Pro for WinNT/2000/XP Version 1.8 -3-:250:250:502:250:250:250:550:214:502:550:250:502:502:250:250
ArGoSoft Pro for WinNT/2000/XP Version 1.8 -4-:220:250:502:250:250:250:550:214:502:550:502:502:502:250:250
ArGoSoft Pro for WinNT/2000/XP Version 1.8 -5-:250:250:502:250:250:250:250:214:502:550:502:502:502:250:250
ArGoSoft Pro for WinNT/2000/XP Version 1.8 -6-:250:250:502:250:250:550:550:214:502:550:502:502:502:250:250
ArGoSoft Pro for WinNT/2000/XP Version 1.8 -7-:220:250:502:250:250:250:550:214:502:550:502:502:502:250:250
ArGoSoft Pro for WinNT/2000/XP Version 1.8 -8-:250:250:502:250:250:250:250:214:502:550:502:502:502:250:250
AvMailGate-2.0.0:503:220:500:250:250:250:552:250:250:250:502:502:250:250:250
AvMailGate-2.0.1 -0-:503:250:500:250:250:250:250:502:252:502:502:502:502:250:250
AvMailGate-2.0.1 -1-:503:250:500:552:250:250:552:502:252:502:502:502:502:250:250
Avirt 4.2:250:250:500:250:250:250:250:214:250:250:500:500:500:220:500
BMR ErlangTM/OTP (3.1/3.3) [0s1530422zack]:503:501:501:250:501:451:550:214:252:500:500:500:500:250:250
BMR ErlangTM/OTP (3.1/3.3) [1s244775sheridan]:503:501:501:250:501:451:250:214:252:500:500:500:500:250:250
CSC-Sendmail:503:250:501:250:553:250:550:214:252:502:502:502:502:250:250
CSMap Proxy for Gauntlet Firewall 6.0:250:250:501:250:501:250:550:214:250:250:500:500:500:220:500
Canon IR2200i Printer:550:501:501:250:250:250:250:500:500:500:500:500:500:250:250
CheckPoint FireWall-1 secure SMTP server -0-:501:250:501:501:501:250:501:214:502:502:500:500:500:220:250
CheckPoint FireWall-1 secure SMTP server -1-:250:250:501:250:501:250:550:214:502:502:500:500:500:220:250
CheckPoint FireWall-1 secure SMTP server -2-:501:250:501:250:501:250:501:214:250:500:500:500:500:220:500
CheckPoint FireWall-1 secure SMTP server -3-:501:250:501:250:501:250:501:214:502:502:500:500:500:220:250
CheckPoint FireWall-1 secure SMTP server -4-:501:250:501:250:501:250:501:214:502:502:500:500:500:220:500
CheckPoint FireWall-1 secure SMTP server -5-:250:250:501:250:501:250:250:214:250:500:500:500:500:220:500
CheckPoint NG FP4:501:250:501:250:501:250:501:214:502:502:500:500:500:250:250
CheckPoint NG R55:250:250:501:250:501:250:501:214:502:502:500:500:500:250:250
CommuniGate Pro 3.4.3:250:250:501:250:501:572:250:214:252:501:501:501:501:250:250
CommuniGate Pro 3.4.7:250:250:501:250:501:572:550:214:252:501:501:501:501:250:250
CommuniGate Pro 3.5.3,3.5.9:250:250:501:250:501:572:550:214:252:501:530:501:501:250:250
CommuniGate Pro 4.0:250:250:501:250:501:572:250:214:252:501:530:501:501:250:250
CommuniGate Pro 4.0.5:250:250:501:250:501:572:550:214:250:501:530:501:501:250:250
ConcentricHost SMTP Relay 1.15:550:501:501:500:550:550:550:550:550:550:550:550:550:250:250
Cyberguard Firewall SMTP Proxy:550:250:550:250:550:250:550:502:502:502:502:502:502:200:502
DanDomain Mailserver:503:501:501:250:501:501:550:214:551:551:500:250:250:250:250
ESMTP spoken here:503:501:501:250:553:451:250:214:252:502:502:502:502:250:250
Eserv/3:250:250:550:550:250:250:550:500:500:500:500:500:500:500:250
Eudora Internet Mail Server 1.3.1 -0-:500:250:500:250:501:250:501:500:550:550:500:500:500:250:250
Eudora Internet Mail Server 1.3.1 -1-:500:250:500:250:501:250:501:500:550:550:500:500:500:250:250
Eudora Internet Mail Server 2.2.2 -0-:500:250:500:250:250:250:550:500:550:550:500:500:500:250:250
Eudora Internet Mail Server 2.2.2 -1-:500:250:500:250:250:250:550:500:550:550:500:500:500:250:250
Eudora Internet Mail Server 3.1.3 -0-:500:250:500:250:250:250:250:500:550:550:500:500:500:250:250
Eudora Internet Mail Server 3.1.3 -1-:500:250:500:250:250:250:250:500:550:550:500:500:500:250:250
Eudora Internet Mail Server 3.1.4 -0-:500:250:500:250:250:250:250:500:252:500:500:500:500:250:250
Eudora Internet Mail Server 3.1.4 -1-:500:250:500:250:250:250:250:500:252:500:500:500:500:250:250
Eudora Internet Mail Server X 3.2b6 -0-:500:250:500:250:250:250:550:500:252:500:500:500:500:250:250
Eudora Internet Mail Server X 3.2b6 -1-:500:250:500:250:250:250:550:500:252:500:500:500:500:250:250
Eudora Worldmail 1.3.167 -0-:501:250:501:250:501:250:501:214:501:501:502:502:502:250:250
Eudora Worldmail 1.3.167 -1-:501:250:502:250:501:250:501:214:501:501:502:502:502:250:250
Eudora Worldmail 1.3.167 -2-:501:250:501:250:501:250:501:214:550:550:502:502:502:250:250
Eudora Worldmail 1.3.167 -3-:501:250:501:250:501:250:501:214:250:250:502:502:502:250:250
Exim 2.12,3.12,3.22,3.33,3.35,4.01,4.12:250:501:500:250:501:250:501:214:252:550:500:500:500:250:250
Exim 3.12 -0-:250:501:500:250:501:250:501:214:250:550:500:500:500:250:250
Exim 3.12 -1-:250:220:250:250:501:250:501:250:252:550:250:250:250:250:250
Exim 3.12 -2-:250:501:500:250:501:250:501:214:252:550:250:500:500:250:250
Exim 3.12 -3-:250:501:500:250:501:250:501:214:252:550:500:500:500:250:220
Exim 3.12 -4-:250:501:500:250:250:250:250:214:250:550:500:500:500:250:220
Exim 3.12 -5-:250:220:250:250:501:250:250:220:250:250:250:250:500:250:250
Exim 3.12 -6-:250:220:500:250:501:250:250:250:250:550:250:500:500:250:220
Exim 3.12 -7-:250:501:500:250:250:250:250:214:252:550:500:500:500:250:250
Exim 3.12 -8-:250:501:500:250:250:250:250:214:252:550:250:500:250:250:250
Exim 3.12 -9-:220:501:500:250:250:250:501:250:250:550:500:500:500:250:250
Exim 3.22:250:501:500:250:501:250:250:214:252:550:500:500:500:250:250
Exim 3.35 -0-:250:501:500:250:501:250:501:214:451:550:500:500:500:250:250
Exim 3.35 -1-:550:501:500:250:501:250:503:214:250:550:500:500:500:250:250
Exim 3.35 -2-:250:250:500:250:501:250:501:214:421:550:500:500:500:250:250
Exim 3.35 -3-:250:501:500:250:501:250:550:214:252:550:500:500:500:250:250
Exim 3.36:250:501:500:250:501:250:501:214:550:550:500:500:500:250:250
Exim 4.10:250:250:500:250:501:250:501:214:252:550:500:500:500:250:250
F-secure Anti-Virus for Internet Mail -0-:250:250:500:250:250:250:553:502:553:502:502:502:502:250:250
F-secure Anti-Virus for Internet Mail -1-:250:250:500:250:553:250:553:502:553:502:502:502:502:250:250
FTGate -0-:550:250:500:250:250:250:500:550:550:550:550:550:550:250:250
FTGate -1-:550:250:500:250:500:250:500:550:550:550:550:550:550:250:250
FTGate -2-:550:250:500:250:500:250:500:550:250:550:550:550:550:250:250
FTGate -3-:550:250:500:250:250:250:500:550:250:550:550:550:550:250:250
FWMAIL :250:501:501:250:553:250:550:250:252:252:500:500:500:250:250
FirstClass Mail Server v5.50:250:250:250:250:250:250:250:500:502:502:502:502:502:250:250
FirstClass Mail Server v6.0:554:250:250:250:554:250:503:500:502:502:502:502:502:250:250
FirstClass Mail server v7.0:250:250:250:250:250:250:501:500:502:502:502:502:502:250:250
FirstClass Mail Server 7.0.5:250:250:250:250:250:250:551:502:502:502:502:502:502:250:250
FirstClass Mail Server v7.1:250:220:250:250:250:250:250:500:502:502:502:502:502:250:250
Gordano Messaging Suite v8.00.3068:503:501:250:250:250:250:250:214:558:505:501:501:501:250:250
GroupWise Internet Agent 5.2:250:250:501:250:250:250:250:500:252:500:500:500:500:250:500
GroupWise Internet Agent 5.5.1 -0-:220:220:501:250:250:250:250:500:252:500:500:500:500:250:500
GroupWise Internet Agent 5.5.1 -1-:503:250:501:250:250:250:250:500:250:500:500:500:500:250:500
GroupWise Internet Agent 5.5.1 -2-:503:250:501:250:250:250:250:250:252:250:500:500:500:250:220
GroupWise Internet Agent 5.5.1 -3-:503:250:501:250:250:250:250:500:250:500:500:250:500:250:500
GroupWise Internet Agent 5.5.1 -4-:503:250:501:250:250:250:250:250:252:500:500:500:500:250:220
GroupWise Internet Agent 5.5.2:220:250:501:250:250:250:250:500:252:500:500:500:500:250:500
GroupWise Internet Agent 5.5.4 -0-:503:250:501:250:250:250:250:500:252:250:250:500:500:250:500
GroupWise Internet Agent 5.5.4 -1-:503:250:501:250:250:250:250:500:252:500:500:500:500:250:500
GroupWise Internet Agent 5.5.4 -2-:503:250:250:250:250:250:250:500:252:500:500:500:500:250:500
GroupWise Internet Agent 5.5.4 -3-:503:220:501:250:250:250:250:500:252:500:500:500:500:250:500
GroupWise Internet Agent 5.5.5 -0-:503:250:502:250:501:250:250:500:252:500:502:502:502:250:500
GroupWise Internet Agent 5.5.5 -1-:503:250:501:250:250:250:250:500:252:500:500:500:500:250:500
GroupWise Internet Agent 5.5.5 -2-:503:250:501:250:250:250:250:500:252:500:500:500:500:250:220
GroupWise Internet Agent 5.5.5 -3-:503:250:501:250:250:250:250:500:252:500:500:500:250:250:500
GroupWise Internet Agent 5.5.5 -4-:503:250:501:250:250:250:250:250:252:500:500:500:500:250:500
GroupWise Internet Agent 5.5.5 -5-:503:250:501:250:250:250:220:500:252:500:500:500:500:250:500
GroupWise Internet Agent 6.0 -0-:503:250:501:250:250:250:550:500:550:500:502:500:500:250:250
GroupWise Internet Agent 6.0 -1-:503:250:501:250:250:250:250:500:550:500:502:500:500:250:250
GroupWise Internet Agent 6.0.1 -0-:503:250:501:250:501:250:550:500:550:500:502:500:500:250:250
GroupWise Internet Agent 6.0.1 -1-:503:250:500:250:501:250:250:500:550:500:502:500:500:250:250
GroupWise Internet Agent 6.0.2 -0-:503:250:501:250:501:250:250:500:250:500:502:500:500:250:220
GroupWise Internet Agent 6.0.2 -1-:503:250:501:250:501:250:250:500:550:500:502:500:500:250:250
GroupWise Internet Agent 6.0.2 -2-:503:250:501:250:501:250:550:500:550:500:502:250:500:250:250
GroupWise Internet Agent 6.0.2 Beta:503:250:501:250:501:250:551:500:550:500:502:500:500:250:250
GroupWise Internet Agent 6.0.2 behind PIX 5.0:503:500:501:250:501:250:550:500:500:500:500:500:500:250:500
GroupWise Internet Agent 6.0.3:220:250:501:250:501:250:250:500:550:500:502:500:500:250:250
GroupWise Internet Agent 6.0.4:503:220:501:250:501:250:550:500:550:250:502:500:500:250:250
IA eMail Server version 2.3.1:503:250:501:250:250:250:250:502:550:502:502:500:500:250:500
IBM MVS SMTP CSV2R10:503:501:501:250:501:250:501:214:550:550:502:502:502:250:500
IMA ESMTP 6.0 Server:503:501:500:250:501:250:250:211:252:550:500:500:500:250:250
IMS SMTP Receiver Version 0.81:503:250:250:250:250:250:250:500:250:500:500:500:500:250:500
IMail 5.05 -1-:451:250:451:451:451:451:503:211:250:550:502:451:451:250:250
IMail 5.05 -2-:250:250:502:501:501:250:550:211:252:550:502:502:502:250:250
IMail 5.08 -0-:501:250:501:501:501:250:503:211:250:550:502:501:501:250:250
IMail 5.08 -1-:250:250:250:250:250:250:550:211:550:550:502:250:250:250:250
IMail 6.00 -0-:250:250:250:250:250:250:501:211:250:550:502:250:250:250:250
IMail 6.00 -1-:250:250:250:250:250:250:501:211:550:550:502:250:250:250:250
IMail 6.04:250:250:250:501:250:250:550:211:250:550:502:250:250:250:250
IMail 6.06 -0-:250:250:501:250:250:250:501:211:252:550:502:250:250:250:250
IMail 6.06 -1-:250:250:250:501:250:250:250:211:252:550:502:250:250:250:250
IMail 6.06 -2-:250:250:501:250:250:250:501:211:250:550:502:250:250:250:250
IMail 6.06 -3-:250:250:501:501:250:250:250:211:252:550:502:250:250:250:250
IMail 6.06 -4-:250:250:250:501:250:250:550:211:252:550:502:250:250:250:250
IMail 6.06 -5-:250:250:501:250:250:250:550:211:252:550:250:250:250:250:250
IMail 6.06 -6-:250:250:501:250:250:250:250:211:250:550:502:250:250:250:250
IMail 6.06 -7-:250:250:501:501:250:250:550:250:252:550:502:250:250:250:250
IMail 6.06 -8-:250:250:250:250:250:250:550:211:252:550:502:250:250:250:250
IMail 6.06 -9-:250:250:501:501:250:250:550:211:550:550:502:250:250:250:250
IMail 6.06 -10-:250:250:250:250:250:250:250:211:252:550:502:250:250:250:250
IMail 6.06 -11-:220:250:501:250:250:250:250:211:252:550:502:250:250:250:250
IMail 7.06 -0-:250:250:501:250:250:250:550:211:250:550:250:250:250:250:250
IMail 7.06 -1-:220:250:501:250:250:250:550:211:250:550:502:250:250:250:250
IMail 7.06 -2-:250:250:501:250:250:250:550:211:250:250:502:250:250:250:250
IMail 7.06 -3-:250:250:501:250:250:250:550:250:250:550:502:250:250:250:250
IMail 7.06 -4-:220:250:501:250:250:250:550:211:250:250:502:250:250:250:220
IMail 7.07 -0-:250:250:501:501:250:250:250:211:250:550:250:250:250:250:220
IMail 7.07 -1-:250:250:501:501:250:250:250:211:250:550:502:250:250:250:220
IMail 7.07 -2-:250:220:501:501:250:250:550:211:250:550:502:250:250:250:250
IMail 7.07 -3-:250:250:501:501:250:250:250:211:250:550:502:250:250:250:250
IMail 7.07 -4-:250:250:501:250:250:250:550:211:550:550:502:250:250:250:250
IMail 7.07 -5-:250:250:501:250:250:250:250:211:252:550:250:250:250:250:250
IMail 7.07 -6-:250:250:501:250:250:250:550:211:252:550:502:250:250:250:250
IMail 7.07 -7-:250:250:250:250:250:250:550:211:250:550:502:250:250:250:250
IMail 7.07 -8-:250:220:501:250:250:250:550:211:250:250:502:250:250:250:250
IMail 7.07 -9-:250:250:250:250:250:250:250:211:250:550:502:250:250:250:250
IMail 7.07 -10-:250:250:250:501:250:250:250:211:250:550:502:250:250:250:250
IMail 7.10:250:250:501:501:250:250:550:211:252:550:502:250:250:250:250
IMail 7.12 -0-:250:250:501:250:250:250:250:211:252:550:502:250:250:250:250
IMail 7.12 -1-:250:220:501:250:250:250:550:211:250:550:502:250:250:250:250
IMail 7.13 -0-:250:250:501:250:250:250:550:211:250:550:502:250:250:250:250
IMail 7.13 -1-:250:250:501:250:250:250:550:211:250:550:502:250:250:250:220
IMail 7.13 -2-:250:250:501:250:250:250:250:250:250:550:502:250:250:250:250
IMail 7.13 -3-:501:250:501:250:501:250:503:211:252:550:502:501:501:250:250
IMail 7.14:250:250:501:250:250:250:550:211:252:550:502:250:250:250:250
IMail 7.15 -0-:250:250:501:501:250:250:250:250:250:250:250:250:250:250:250
IMail 7.15 -1-:250:220:501:501:250:250:550:250:250:250:502:250:250:250:250
IMail 7.15 -2-:250:250:501:501:250:250:550:211:250:250:250:250:250:250:250
IMail 7.15 -3-:220:250:501:250:250:250:250:211:250:550:502:250:250:250:250
IMail 7.15 -4-:220:220:250:250:250:250:550:211:252:550:502:250:250:250:250
IMail 7.15 -5-:250:220:501:501:250:250:550:211:250:250:502:250:250:250:250
IMail 7.15 -6-:250:220:501:250:250:250:250:211:250:550:502:250:250:250:250
IMail 7.15 -7-:220:250:250:250:250:250:550:211:252:250:502:250:250:250:250
IMail 7.15 -8-:220:250:501:501:250:250:550:211:252:250:250:250:250:250:250
IMail 7.15 -9-:250:250:501:250:250:250:250:250:250:250:502:250:250:250:250
IMail 7.15 -10-:220:250:501:501:250:250:550:211:252:550:502:250:250:250:250
IMail 7.15 -11-:250:250:501:501:250:250:550:211:250:550:502:250:250:250:220
IMail 7.15 -12-:250:250:501:501:250:250:550:250:250:550:502:250:250:250:250
IMail 7.15 -13-:250:250:501:501:250:250:550:211:250:550:250:250:250:250:250
IMail 7.15 -14-:250:250:501:501:250:250:550:211:250:550:502:250:250:250:250
IMail 7.15 -15-:220:220:501:501:250:250:550:211:252:550:502:250:250:250:250
IMail 7.15 -16-:250:220:250:501:250:250:550:211:250:550:502:250:250:250:250
IMail 7.15 -17-:250:250:501:501:250:250:550:211:250:550:250:250:250:250:220
IMail 7.15 -18-:250:250:501:250:250:250:550:250:250:250:502:250:250:250:250
IMail 7.15 -19-:250:220:250:250:250:250:250:211:250:550:502:250:250:250:250
IMail 7.15 -20-:250:250:501:250:250:250:250:211:250:250:502:250:250:250:250
IMail 7.15 -21-:220:250:250:250:250:250:550:211:252:550:502:250:250:250:250
IMail 7.15 -22-:220:250:250:501:250:250:550:211:252:550:502:250:250:250:250
IMail 7.15 -23-:220:250:501:501:250:250:550:211:250:550:502:250:250:250:250
IMail 7.15 -24-:250:250:501:501:250:250:550:250:250:250:502:250:250:250:250
IMail 7.15 -25-:250:250:501:501:250:250:550:211:252:550:250:250:250:250:250
IMail 7.15 -26-:220:250:501:250:250:250:550:211:252:550:502:250:250:250:250
IMail 7.15 -27-:250:250:501:250:250:250:250:211:250:550:250:250:250:250:250
IMail 7.15 -28-:250:250:501:501:250:250:550:211:252:250:502:250:250:250:250
IMail 7.15 -29-:220:250:250:501:250:250:250:250:250:550:502:250:250:250:220
IMail 7.15 -30-:250:220:501:501:250:250:550:211:250:550:502:250:250:250:220
IMail 7.15 -31-:250:250:501:501:250:250:550:211:250:250:502:250:250:250:250
IMail 7.15 -32-:250:250:501:250:250:250:250:211:250:550:502:250:250:250:220
IMail 7.15 -33-:220:220:250:250:250:250:250:211:252:550:502:250:250:250:250
IMail 8.01:503:250:501:501:250:250:550:211:250:550:502:250:250:250:250
IMail 8.04:503:250:501:250:250:250:550:211:252:550:502:250:250:250:250
InterMail vK.4.04.00.00:250:250:501:250:250:250:250:214:250:502:502:502:502:250:250
InterMail vM.4.01.03.27:250:250:501:250:250:250:250:214:502:502:502:502:502:250:250
InterMail vM.5.01.03.15:250:250:501:250:250:553:550:214:502:502:502:502:502:250:250
InterMail vM.5.01.05.08:250:250:501:250:250:553:250:214:502:502:502:502:502:250:250
InterScan Messaging Security Suite 5.1.5:503:500:501:501:501:250:553:214:502:502:500:250:250:250:250
InterScan Messaging Security Suite 5.0,5.1:503:250:501:250:501:250:553:214:502:502:500:250:250:250:250
InterScan VirusWall NT 3.2:250:250:501:250:553:250:250:214:502:502:500:250:250:200:250
InterScan VirusWall NT 3.32:250:250:501:250:553:250:250:214:502:502:500:250:250:250:250
InterScan VirusWall NT 3.4:250:250:501:250:553:250:550:214:502:502:500:250:250:200:250
InterScan VirusWall NT 3.51:220:250:501:250:501:250:553:214:502:502:500:250:250:200:250
InterScan VirusWall NT 3.52:250:250:500:250:501:250:553:214:502:502:500:250:250:200:250
InterScan VirusWall NT 3.53:250:250:500:250:501:250:553:214:502:502:500:250:250:250:250
InterScan VirusWall 3.52 -0-:250:250:501:250:501:250:553:214:502:502:500:250:250:200:250 
InterScan VirusWall 3.52 -1-:250:250:501:250:501:250:553:214:502:502:500:250:250:250:250
IntraStore TurboSendmail -0-:250:250:501:250:250:250:501:500:252:550:500:500:500:250:250
IntraStore TurboSendmail -1-:250:250:501:250:250:250:551:500:252:252:500:500:500:250:250
LanSuite Pro 2003 602:250:250:501:250:501:250:550:214:502:502:502:250:250:200:250
M>Wall 5.0:503:500:501:250:553:250:501:500:501:501:500:500:500:250:250
MAILsweeper 4.3 -0-:503:250:250:250:250:250:553:500:252:500:500:500:500:250:250
MAILsweeper 4.3 -1-:503:250:250:250:250:250:250:500:252:500:500:500:500:250:250
MAILsweeper 4.3.1.0:503:250:250:250:550:250:503:500:252:500:500:500:500:250:250
MAILsweeper 4.3.6.0:503:250:501:501:250:250:250:500:252:500:500:500:500:250:250
MDaemon 3.5.0 -0-:503:220:550:250:250:250:250:214:502:502:502:250:250:250:250
MDaemon 3.5.0 -1-:503:250:250:550:250:250:550:214:502:502:502:250:250:250:502
MDaemon 3.5.2:503:250:250:550:250:250:250:214:250:502:502:250:250:250:250
MDaemon 3.5.3 -0-:503:250:250:250:250:250:250:214:550:502:502:250:250:250:250
MDaemon 3.5.3 -1-:503:250:550:250:250:250:250:214:250:502:502:250:250:250:250
MDaemon 3.5.6:503:250:250:250:250:250:550:214:502:502:502:250:250:250:250
MDaemon 3.5.7:503:250:250:550:250:250:452:214:502:502:502:250:250:250:250
MDaemon 4.0.5:503:250:250:250:250:250:550:214:550:550:502:250:250:250:502
MDaemon 5.0.3:503:250:250:250:250:501:250:250:250:250:250:250:250:250:250
MDaemon 5.0.4 -0-:503:250:550:550:250:250:550:214:550:550:502:250:250:250:502
MDaemon 5.0.4 -1-:503:220:250:250:250:250:250:214:502:502:502:250:250:250:250
MDaemon 5.0.5 -0-:503:250:550:250:250:250:550:214:502:502:502:250:250:250:250
MDaemon 5.0.5 -1-:503:250:250:550:250:250:550:214:502:502:502:250:250:250:250
MDaemon 5.0.7 -0-:503:250:250:550:250:451:550:214:502:502:502:250:250:250:250
MDaemon 5.0.7 -1-:503:250:550:250:250:250:250:214:550:502:502:250:250:250:250
MDaemon 5.0.7 -2-:503:250:550:250:250:250:250:214:550:550:502:250:250:250:250
MDaemon 5.5.0e:503:250:550:250:250:250:550:214:550:502:502:250:250:250:250
MDaemon 6.0.2:503:250:550:250:250:250:501:550:550:550:550:550:550:550:250
MDaemon 6.0.4:503:250:250:250:250:250:250:214:502:502:250:250:250:250:250
MDaemon 6.0.6:503:250:550:250:250:250:250:214:502:502:502:250:250:250:250
MDaemon 6.0.7 -0-:503:250:502:250:501:250:250:214:502:502:502:502:502:250:250
MDaemon 6.0.7 -1-:503:250:550:250:250:501:550:214:502:502:502:250:250:250:250
MDaemon 6.0.7 -2-:503:250:250:250:250:250:550:214:250:502:250:250:250:250:250
MDaemon 6.0.7 -3-:503:250:250:250:250:501:550:214:502:502:502:250:250:250:250
MDaemon 6.0.7 -4-:503:250:550:250:250:501:250:214:502:502:502:250:250:250:250
MDaemon 6.0.7 -5-:503:250:550:550:250:250:550:214:502:502:502:250:250:250:220
MDaemon 6.0.7 -6-:503:250:250:250:250:501:250:214:502:502:502:250:250:250:250
MDaemon 6.0.7 -7-:503:250:550:550:250:250:550:214:502:250:502:250:250:250:250
MDaemon 6.0.7 -8-:503:250:501:250:250:501:550:214:502:502:502:250:250:250:250
MDaemon 6.0.8:503:250:550:550:250:451:250:214:502:502:502:250:250:250:250
MDaemon 6.5.0 -0-:503:250:550:250:250:250:550:214:550:550:502:250:250:250:250
MDaemon 6.5.0 -1-:503:250:550:250:250:250:550:250:502:502:502:250:250:250:250
MDaemon 6.5.0 -2-:503:250:550:250:250:451:550:214:502:502:502:250:250:250:250
MDaemon 6.5.0 -3-:503:250:550:550:250:250:250:214:502:502:502:250:250:250:250
MDaemon 6.5.1 -0-:503:250:250:550:250:250:550:214:550:550:502:250:250:250:250
MDaemon 6.5.1 -1-:503:250:250:250:250:250:250:214:502:502:502:250:250:250:250
MDaemon 6.5.1 -2-:503:250:250:250:250:250:250:214:250:550:502:250:250:250:250
MDaemon 6.5.2 -0-:503:250:550:250:250:451:550:250:502:502:502:250:250:250:250
MDaemon 6.5.2 -1-:220:220:250:250:250:250:550:214:502:502:502:250:250:250:250
MDaemon 6.5.2 -2-:503:250:550:250:250:250:550:214:502:220:502:250:250:250:250
MDaemon 6.5.2 -3-:503:250:500:250:250:501:250:214:502:502:502:250:250:250:250
MDaemon 6.5.2 -4-:503:220:250:250:250:250:550:250:250:502:250:250:250:250:250
MDaemon 6.5.2 -5-:503:250:250:550:250:250:250:214:502:502:502:250:250:250:502
MDaemon 6.5.2 -6-:503:250:550:250:250:451:550:214:250:250:502:250:250:250:250
MDaemon 6.5.2 -7-:503:250:550:250:250:451:550:214:502:502:502:250:250:250:220
MDaemon 6.5.2 -8-:503:250:250:250:250:250:250:250:502:502:250:250:250:250:250
MDaemon 6.5.2 -9-:503:250:550:250:250:451:550:250:250:502:502:250:250:250:250
MDaemon 6.5.2 -10-:220:250:550:250:250:250:250:214:502:502:250:250:250:250:250
MDaemon 6.5.2 -11-:503:220:250:250:250:250:250:250:502:502:502:250:250:250:250
MDaemon 6.5.2 -12-:503:250:550:250:250:451:250:250:250:250:250:250:250:250:250
MDaemon 6.5.2 -13-:220:220:250:250:250:451:550:214:502:502:502:250:250:250:250
MDaemon 6.5.2 -14-:220:220:250:250:250:250:250:250:502:502:502:250:250:250:250
MDaemon 6.5.2 -15-:220:220:250:250:250:250:250:214:502:502:502:250:250:250:250
MDaemon 6.5.2 -16-:503:250:550:250:250:250:250:250:250:250:250:250:250:250:250
MDaemon 6.5.2 -17-:503:250:550:250:250:250:550:214:250:502:502:250:250:250:250
MDaemon 6.5.2 -18-:503:220:250:250:250:451:550:250:502:502:502:250:250:250:250
MDaemon 6.5.2 -19-:503:250:550:250:250:250:550:214:250:250:502:250:250:250:250
MDaemon 6.5.2 -20-:503:220:250:250:250:250:550:250:250:502:502:250:250:250:250
MDaemon 6.5.2 -21-:503:250:550:250:250:451:550:214:250:250:250:250:250:250:250
MDaemon 6.5.2 -22-:503:250:550:250:250:451:550:214:550:550:502:250:250:250:250
MDaemon 6.5.2 -23-:503:250:550:250:250:451:550:214:502:502:250:250:250:250:250
MDaemon 6.5.2 -24-:503:220:250:250:250:250:550:214:502:502:502:250:250:250:250
MDaemon 6.5.2 -25-:503:250:250:250:250:250:550:214:502:502:250:250:250:250:250
MDaemon 6.5.2 -26-:220:250:250:250:250:451:550:250:250:250:250:250:250:250:250
MDaemon 6.5.2 -27-:503:220:550:250:250:451:550:250:250:250:250:250:250:250:250
MDaemon 6.5.2 -28-:220:250:550:250:250:250:550:214:502:502:502:250:250:250:250
MDaemon 6.5.2 -29-:220:220:550:250:250:451:550:214:502:502:502:250:250:250:250
MDaemon 6.5.2 -30-:503:250:250:250:250:451:550:214:502:502:502:250:250:250:250
MDaemon 6.5.2 -31-:503:250:550:250:250:250:250:250:250:250:250:250:250:250:220
MDaemon 6.5.2 -32-:503:250:550:250:250:250:550:214:250:250:250:250:250:250:250
MDaemon 6.5.2 -33-:503:250:550:250:250:250:250:250:250:502:502:250:250:250:250
MDaemon 6.5.2 -34-:503:250:550:250:250:451:250:214:502:502:502:250:250:250:250
MDaemon 6.5.2 -35-:503:250:550:250:250:451:550:250:250:250:250:250:250:250:220
MDaemon 6.5.2 -36-:220:220:250:250:250:250:550:214:502:250:502:250:250:250:250
MDaemon 6.5.2 -37-:503:250:550:250:250:250:550:214:502:502:250:250:250:250:250
MDaemon 6.5.2 -38-:503:220:550:250:250:451:550:214:502:502:502:250:250:250:250
MDaemon 6.7.0:503:250:250:250:250:501:250:214:550:502:502:250:250:250:250
MDaemon 6.7.1:503:250:550:250:250:250:250:214:502:502:250:250:250:250:250
MDaemon 6.7.2 -0-:503:250:250:250:250:250:250:250:502:502:502:250:250:250:250
MDaemon 6.7.2 -1-:503:250:250:550:250:501:550:214:502:502:502:250:250:250:250
MDaemon 6.7.2 -2-:503:250:250:550:250:250:250:214:502:502:502:250:250:250:250
MDaemon 6.7.2 -3-:503:250:500:250:250:250:250:214:502:502:502:250:250:250:250
MDaemon 6.7.2 -4-:220:220:550:250:250:250:550:214:502:502:502:250:250:250:250
MDaemon 6.7.2 -5-:503:250:550:550:250:250:550:214:502:502:502:250:250:250:250
MDaemon 6.7.2 -6-:503:250:250:250:250:250:250:214:502:250:502:250:250:250:250
MDaemon 6.7.5:503:250:550:250:250:250:250:250:502:502:502:250:250:250:250
MDaemon 6.7.6 -0-:503:250:250:250:250:451:250:214:502:502:502:250:250:250:250
MDaemon 6.7.6 -1-:503:250:500:250:250:250:553:214:502:502:502:250:250:250:250
MDaemon 6.7.6 -2-:220:250:250:550:250:250:250:214:502:502:502:250:250:250:220
MDaemon 6.7.6 -3-:503:250:550:550:250:250:250:214:550:502:502:250:250:250:250
MDaemon 6.7.6 -4-:220:250:550:250:250:250:250:214:502:502:502:250:250:250:250
MDaemon 6.7.7 -0-:503:250:550:250:250:451:250:214:550:550:502:250:250:250:250
MDaemon 6.7.7 -1-:503:250:250:550:250:501:250:214:502:502:502:250:250:250:250
MDaemon 6.7.7 -2-:503:250:250:550:250:250:250:214:550:550:502:250:250:250:250
MDaemon 6.7.7 -3-:503:250:250:250:250:250:250:214:502:502:502:250:250:250:502
MDaemon 6.7.7 -4-:503:250:250:250:250:451:250:214:550:502:502:250:250:250:250
MDaemon 6.7.7 -5-:503:250:550:550:250:250:550:214:550:550:502:250:250:250:250
MDaemon 6.7.7 -6-:503:250:550:250:250:250:550:214:502:502:502:250:250:250:502
MDaemon 6.7.7 -7-:503:250:550:250:250:501:553:214:502:502:502:250:250:250:250
MDaemon 6.8.5:503:250:501:250:501:250:450:500:500:500:500:500:500:250:250
MTA-CT ors-116p2:503:501:501:250:553:501:554:214:252:502:502:502:502:250:250
Mail:250:501:501:250:553:553:553:214:252:502:502:502:502:250:250
Mail Server:250:501:501:250:501:250:550:214:551:502:500:250:250:250:250
Mail daemon -0-:503:501:501:451:451:451:503:214:550:550:250:502:502:250:250
Mail daemon -1-:503:501:501:451:451:451:503:214:550:550:502:502:502:250:250
Mail daemon -2-:503:501:501:451:451:451:451:214:550:550:502:502:502:250:250
Mail server "post2.ka.cz" - ka.net services - Powered by MERAK :503:501:501:250:501:501:250:214:502:502:500:250:250:250:250
MailBot Server:503:501:501:250:501:250:550:214:502:502:502:250:250:250:502
MailShield -0-:250:250:500:250:553:250:550:502:252:500:502:500:500:250:250
MailShield -1-:250:250:500:550:553:250:250:502:252:500:502:500:500:250:250
MailSite ESMTP Receiver Version 4.5.4.0 -0-:503:250:250:250:250:550:550:500:252:250:500:500:500:250:250
MailSite ESMTP Receiver Version 4.5.4.0 -1-:503:250:501:250:250:550:250:500:252:500:500:500:500:250:250
MailSite ESMTP Receiver Version 4.5.6.0 -0-:503:250:250:250:550:250:503:500:551:500:500:500:500:250:250
MailSite ESMTP Receiver Version 4.5.6.0 -1-:503:250:501:250:250:550:550:500:252:500:500:500:500:250:250
MailSite ESMTP Receiver Version 4.5.6.7 -0-:503:250:250:250:250:503:501:500:252:500:500:500:500:250:250
MailSite ESMTP Receiver Version 4.5.6.7 -1-:220:250:250:250:250:250:501:500:252:500:500:500:500:250:250
MailSite ESMTP Receiver Version 4.5.6.7 -2-:503:250:250:250:250:250:501:500:252:500:500:500:500:250:250
MailSite ESMTP Receiver Version 4.5.6.7 -3-:503:250:250:503:503:250:501:500:252:500:500:500:500:250:250
MailSite ESMTP Receiver Version 4.5.6.7 -4-:503:250:250:503:250:250:501:500:252:500:500:500:500:250:250
MailSite ESMTP Receiver Version 4.5.6.7 -5-:503:250:250:250:250:250:550:500:252:500:500:500:500:250:250
MailSite ESMTP Receiver Version 4.5.6.7 -6-:503:250:250:250:250:250:550:500:252:500:250:250:500:250:250
MailSite ESMTP Receiver Version 4.5.6.7 -7-:220:220:250:250:250:250:501:500:252:500:500:500:500:250:250
MailSite ESMTP Receiver Version 4.5.6.7 -8-:503:250:250:250:503:250:501:500:252:500:500:500:500:250:250
MailSite ESMTP Receiver Version 4.5.6.7 -9-:503:250:250:250:250:250:550:500:250:500:500:500:250:250:250
MailSite ESMTP Receiver Version 4.5.6.7 -10-:503:250:250:250:503:503:501:500:252:500:500:500:500:250:250
MailSite ESMTP Receiver Version 5.2.4.2:503:250:250:250:250:550:550:500:252:500:500:500:500:250:250
MailSite ESMTP Receiver Version 5.2.5.0 -0-:503:250:250:250:250:250:250:500:252:250:500:500:500:250:250
MailSite ESMTP Receiver Version 5.2.5.0 -1-:503:250:250:250:250:550:501:500:252:500:500:500:500:250:250
Mailkeep 1.2:503:250:550:250:250:250:550:550:550:550:550:550:550:550:250
Mailmax version 4. 7. 1. 4:503:250:503:250:250:250:503:503:550:503:503:503:503:503:250
Mailmax version 4. 8. 2. 0:503:250:503:501:250:250:503:503:250:503:503:503:503:503:250
Mailmax version 4. 8. 2. 1:503:250:503:250:250:250:503:503:250:503:503:503:503:503:250
Mailmax version 4. 8. 3. 0 -0-:503:250:503:501:250:250:503:503:550:503:503:503:503:503:250
Mailmax version 4. 8. 3. 0 -1-:503:250:503:501:250:250:503:503:250:250:503:250:250:250:250
McAfee VirusScreen ASaP v1.1:501:501:502:250:501:250:501:214:502:502:502:502:502:250:502
Merak 2.10.321:250:501:501:250:501:501:550:214:551:551:502:250:250:250:250
Merak 3.00.110:250:501:501:250:501:250:250:214:551:502:502:250:250:250:250
Merak 3.00.120 -0-:250:501:501:250:501:501:550:214:502:502:502:250:250:250:250
Merak 3.00.120 -1-:503:501:501:250:501:501:550:214:502:502:502:250:250:250:502
Merak 3.00.140 -0-:250:501:501:250:501:250:250:214:551:551:421:250:250:250:250
Merak 3.00.140 -1-:250:501:501:250:501:250:550:214:502:502:502:250:250:250:502
Merak 3.00.140 -2-:503:501:501:250:501:501:550:214:551:551:502:250:250:250:250
Merak 3.00.140 -3-:503:501:501:250:501:501:250:214:502:502:502:250:250:250:250
Merak 3.10.011:250:501:501:250:501:250:550:214:551:502:502:250:250:250:502
Merak 3.10.110:503:501:501:250:501:501:550:214:502:502:421:250:250:250:250
Merak 4.00.30:250:501:501:250:501:501:250:214:551:551:502:250:250:250:250
Merak 4.00.70:250:501:501:250:501:250:550:214:551:502:502:250:250:250:250
Merak 4.00.90:250:501:501:250:501:501:250:214:502:502:502:250:250:250:250
Merak 4.10.040:503:501:501:250:501:501:250:214:502:502:421:250:250:250:250
Merak 4.10.050 -0-:250:501:501:250:501:250:250:214:551:551:502:250:250:250:250
Merak 4.10.050 -1-:503:501:501:250:501:501:550:214:250:502:502:250:250:250:250
Merak 4.2.1:250:501:501:250:501:501:550:214:551:551:502:250:250:250:502
Merak 4.2.1,4.4.2:250:501:501:250:501:250:550:214:551:551:502:250:250:250:250
Merak 4.2.2 -0-:250:501:501:250:501:501:550:214:551:502:502:250:250:250:250
Merak 4.2.2 -1-:503:501:501:250:501:501:550:214:502:502:502:250:250:250:250
Merak 4.2.3:250:501:501:250:501:250:550:214:502:502:502:250:250:250:250
Merak 4.4.2 -0-:250:501:501:250:501:501:250:214:551:220:502:250:250:250:502
Merak 4.4.2 -1-:250:501:501:250:501:250:250:214:502:551:502:250:250:250:250
Merak 4.4.2 -2-:250:501:501:250:501:501:250:214:502:502:502:250:250:250:502
Merak 4.4.2 -3-:250:501:501:250:501:501:250:214:551:551:502:250:250:250:502
Merak 4.4.2 -4-:250:501:501:250:501:501:250:214:551:250:502:250:250:250:502
Merak 4.4.2 -5-:503:501:501:250:501:250:250:214:551:551:502:250:250:250:250
Merak 4.4.2 -6-:250:501:250:250:501:501:250:214:551:551:502:250:250:250:502
Merak 4.4.2 -7-:250:501:501:250:501:501:250:214:551:551:250:250:250:250:502
Merak 4.4.2 -8-:250:501:501:250:501:250:250:214:502:502:502:250:250:250:250
Merak 4.4.2 -9-:503:501:501:250:501:501:550:214:502:551:502:250:250:250:250
Merak 4.4.2 -10-:503:501:501:250:501:250:550:214:502:502:502:250:250:250:250
Merak 4.4.2 -11-:503:501:501:250:501:250:250:214:502:502:502:250:250:250:250
Merak 4.4.3,5.0.2:250:501:501:250:501:250:550:214:551:551:500:250:250:250:250
Merak 5.1.5:503:501:501:250:501:501:550:214:502:502:500:250:250:250:502
Merak 5.3.2:250:501:501:250:501:501:550:214:502:551:500:250:250:250:250
Merak 5.4.2 -0-:503:501:501:250:501:501:550:214:250:502:500:250:250:250:250
Merak 5.4.2 -1-:250:501:501:250:501:250:250:214:502:551:500:250:250:250:502
Merak 5.4.2 -2-:250:501:501:250:501:250:250:214:502:502:500:250:250:250:502
Merak 5.4.2 -3-:503:501:501:250:501:250:550:214:502:502:500:250:250:250:502
Merak 5.5.5 -0-:503:501:501:250:501:250:550:214:551:551:500:250:250:250:250
Merak 5.5.5 -1-:250:501:501:250:501:501:250:214:502:502:500:250:250:250:502
Merak 5.5.6 -0-:250:501:500:250:501:501:550:214:551:551:500:250:250:250:250
Merak 5.5.6 -1-:250:501:501:250:501:501:550:214:551:551:500:250:250:250:502
Merak 5.5.6 -2-:250:501:501:250:501:501:550:214:551:502:500:250:250:250:250
Merak 5.5.7 -0-:503:501:501:250:501:250:250:214:502:502:500:250:250:250:250
Merak 5.5.7 -1-:503:501:501:250:501:250:550:214:502:551:500:250:250:250:250
Merak 5.5.7 -2-:250:220:501:250:501:250:550:214:551:551:500:250:250:250:250
Merak 5.5.7 -3-:250:501:501:250:501:250:250:214:502:551:500:250:250:250:250
Merak 5.5.7 -4-:250:501:501:250:501:250:250:214:551:551:500:250:250:250:250
Merak 5.5.7 -5-:503:501:501:250:501:250:550:214:551:502:500:250:250:250:250
Merak 5.5.7 -6-:250:501:501:250:501:250:250:214:502:502:500:250:250:250:250
Merak 5.5.7 -7-:250:501:501:250:501:501:250:214:250:551:500:250:250:250:250
Merak 5.5.7 -8-:250:501:501:250:501:501:250:214:551:551:500:250:250:250:250
Merak 5.5.7 -9-:250:501:501:250:501:501:550:214:551:551:500:250:250:250:250
Merak 5.5.7 -10-:503:501:501:250:501:501:550:214:502:502:500:250:250:250:250
Merak 5.7.3:503:501:501:250:501:250:250:214:502:551:500:250:250:250:250
Merak 5.7.4 -0-:250:501:501:250:501:250:550:214:502:551:500:250:250:250:250
Merak 5.7.4 -1-:250:501:501:250:501:501:250:214:502:502:500:250:250:250:250
Merak 5.8.2:503:501:501:250:501:501:250:214:551:502:500:250:250:250:250
MessageWall 1.0.8:552:500:500:250:552:250:500:500:252:500:500:500:500:250:250
MetaInfo Sendmail 2.5 Build 2640 (Berkeley 8.8.6)/8.8.4:250:501:501:250:553:250:553:214:250:250:500:500:500:250:250
MetaInfo Sendmail 2.6 Build 1 (Berkeley 8.8.6)/8.8.4:250:501:501:250:553:250:553:214:550:550:500:500:500:250:250
Mi\'Server Version 98.35b:250:250:250:250:250:250:550:500:550:500:500:500:500:500:500
WindowsNT SMTP Server v3.03.0017 -0-:503:250:550:250:250:550:550:214:250:550:507:507:507:250:250
WindowsNT SMTP Server v3.03.0017 -1-:503:250:250:250:250:250:250:214:557:550:507:507:507:250:250
WindowsNT SMTP Server v3.03.0017 -2-:503:250:250:250:250:250:250:214:250:560:507:507:507:250:250
WindowsNT SMTP Server v3.03.0018:503:250:250:250:250:250:550:214:250:550:507:507:507:250:250
Microsoft ESMTP MAIL Service, Version 5.0.2195 -0-:503:250:501:250:501:250:250:214:252:500:505:500:500:250:250
Microsoft ESMTP MAIL Service, Version 5.0.2195 -1-:503:250:501:250:501:250:501:214:252:500:505:500:500:250:250
Microsoft ESMTP MAIL Service, Version 5.0.2195.2966 -0-:503:250:500:250:501:250:250:214:252:500:505:250:500:250:250
Microsoft ESMTP MAIL Service, Version 5.0.2195.2966 -1-:503:250:501:250:250:250:250:214:252:500:505:500:500:250:250
Microsoft ESMTP MAIL Service, Version 5.0.2195.2966 -2-:503:250:250:250:501:250:250:214:252:500:505:500:500:250:250
Microsoft ESMTP MAIL Service, Version 5.0.2195.4905:503:250:501:250:501:250:452:214:252:500:505:500:500:250:250
Microsoft ESMTP MAIL Service, Version 5.0.2195.5329 -0-:503:250:501:250:501:501:250:214:252:500:505:500:500:250:250
Microsoft ESMTP MAIL Service, Version 5.0.2195.5329 -1-:503:220:501:250:501:250:250:214:252:500:505:500:500:250:250
Microsoft ESMTP MAIL Service, Version 5.0.2195.5329 -2-:503:250:501:250:501:250:250:214:252:500:250:500:500:250:250
Microsoft ESMTP MAIL Service, Version 5.0.2195.5329 -3-:503:250:500:250:501:250:452:214:252:500:505:500:500:250:250
Microsoft ESMTP MAIL Service, Version 5.0.2195.5329 -4-:503:250:505:505:505:505:505:505:505:500:505:500:500:250:250
Microsoft ESMTP MAIL Service, Version 5.0.2195.5329 -5-:503:250:500:250:501:250:250:214:252:500:505:500:500:250:250
Microsoft ESMTP MAIL Service, Version 5.0.2195.5329 -6-:503:250:500:250:501:250:250:500:252:500:505:500:500:250:250
Microsoft ESMTP MAIL Service, Version 5.0.2195.5329 -7-:503:250:501:250:501:250:250:214:252:500:505:500:250:250:250
Microsoft ESMTP MAIL Service, Version 5.0.2195.5329 -8-:503:250:501:250:501:250:250:214:250:500:505:500:500:250:250
Microsoft ESMTP MAIL Service, Version 5.0.2195.5329 -9-:503:250:501:250:250:250:250:250:252:500:505:500:500:250:250
Microsoft ESMTP MAIL Service, Version 5.0.2195.5329 -10-:503:250:502:250:501:250:250:214:252:500:502:502:502:250:250
Microsoft ESMTP MAIL Service, Version 5.0.2195.5329 -11-:503:250:501:250:501:250:550:214:550:500:505:500:500:250:250
Microsoft ESMTP MAIL Service, Version 5.0.2195.5329 -12-:503:250:501:250:501:250:250:214:252:500:505:500:500:250:220
Microsoft ESMTP MAIL Service, Version 5.0.2195.5329 -13-:503:250:501:250:501:250:250:214:252:220:505:500:500:250:250
Microsoft ESMTP MAIL Service, Version 5.0.2195.5329 -14-:503:250:501:250:501:250:501:214:501:500:505:500:500:250:250
Microsoft ESMTP MAIL Service, Version 5.0.2195.5329 -15-:503:250:501:250:501:250:501:550:550:550:550:550:550:550:250
Microsoft ESMTP MAIL Service, Version 5.0.2195.5329 -16-:503:250:501:250:501:250:250:250:252:500:505:500:500:250:250
Microsoft ESMTP MAIL Service, Version 5.0.2195.5329 -17-:503:250:501:250:501:250:250:214:502:500:502:500:500:250:250
Microsoft ESMTP MAIL Service, Version 5.0.2195.5329 -18-:503:250:501:250:501:250:550:214:252:500:505:500:500:250:250
Microsoft ESMTP MAIL Service, Version 5.0.2195.5329 -19-:503:250:500:250:501:250:250:214:500:500:505:500:500:250:250
Microsoft ESMTP MAIL Service, Version 6.0.3718.0 -0-:503:250:501:250:501:501:250:214:252:500:530:500:500:250:250
Microsoft ESMTP MAIL Service, Version 6.0.3718.0 -1-:503:250:500:250:501:250:250:214:252:500:530:500:500:250:250
Microsoft ESMTP MAIL Service, Version 6.0.3718.0 (Exchange 2003):503:250:501:250:501:250:250:214:252:500:530:500:500:250:250
Microsoft ESMTP MAIL Service, Version 6.0.3790.0:503:250:501:250:501:250:550:214:252:500:530:500:500:250:250
Microsoft ESMTP Mail Service, Version 6.0.4417.0, behind CISCO PIX 6.3:250:500:501:250:501:250:553:500:500:500:500:500:500:250:500
Microsoft Exchange 2000:503:250:501:250:501:250:250:500:500:500:500:500:500:250:500
Microsoft Exchange 2000 behind PIX 6.3.3:503:500:501:250:501:250:250:500:500:500:500:500:500:250:500
Microsoft Exchange 2000 behind PIX 6.3.3:503:500:250:250:250:250:250:500:500:500:500:500:500:250:500
Microsoft Exchange 4.0:250:250:501:250:553:250:250:214:252:502:500:502:502:250:500
Microsoft Exchange 5.5 SP 4:250:500:501:250:553:250:250:500:500:500:500:500:500:250:500
Microsoft Exchange 5.5.1775.675.6:503:501:501:250:501:250:250:214:250:500:505:500:500:250:250
Microsoft Exchange 5.5.1875.185.18:503:501:501:250:501:250:250:214:550:500:503:500:500:250:250
Microsoft Exchange 5.5.1877.197.19 -0-:503:501:501:250:501:250:250:214:250:500:503:500:500:250:250
Microsoft Exchange 5.5.1877.197.19 -1-:503:501:505:505:505:505:505:505:505:500:503:500:500:250:250
Microsoft Exchange 5.5.1877.757.75:503:501:501:250:501:250:250:214:252:500:503:500:500:250:250
Microsoft Exchange 5.5.2650.21 -0-:250:501:501:250:553:501:250:214:250:250:500:500:500:250:250
Microsoft Exchange 5.5.2650.21 -1-:250:250:501:250:553:250:250:214:550:502:500:502:502:250:250
Microsoft Exchange 5.5.2650.21 -2-:250:220:501:250:553:250:250:214:252:502:500:502:502:250:250
Microsoft Exchange 5.5.2650.21 -3-:250:250:250:250:553:250:250:214:250:502:500:502:502:250:250
Microsoft Exchange 5.5.2650.21 -4-:503:220:501:250:553:250:501:550:550:550:550:550:550:550:250
Microsoft Exchange 5.5.2650.21 -5-:250:250:502:250:501:250:250:214:252:502:502:502:502:250:250
Microsoft Exchange 5.5.2650.21 -6-:250:250:500:250:553:250:250:214:500:502:500:502:502:250:250
Microsoft Exchange 5.5.2653.13 -0-:505:250:505:505:505:505:505:214:252:502:500:505:505:250:250
Microsoft Exchange 5.5.2653.13 -1-:250:250:250:250:553:250:250:214:252:250:500:502:502:250:250
Microsoft Exchange 5.5.2653.13 -2-:250:250:501:250:553:250:250:214:252:502:250:502:502:250:250
Microsoft Exchange 5.5.2653.13 -3-:220:250:501:250:553:250:250:214:252:502:500:502:502:250:250
Microsoft Exchange 5.5.2653.13 -4-:250:250:501:250:553:250:250:214:252:502:500:250:502:250:250
Microsoft Exchange 5.5.2653.13 -5-:250:250:501:250:553:250:250:250:250:502:500:502:502:250:250
Microsoft Exchange 5.5.2653.13 -6-:250:220:250:250:250:250:250:250:250:502:250:502:502:250:220
Microsoft Exchange 5.5.2656.59,5.5.2653.13,5.5.2655.55:250:250:501:250:553:250:250:214:252:502:500:502:502:250:250
Microsoft Exchange 5.0.2195.6713 behind PIX 6.1(4):503:500:501:250:501:250:501:500:500:500:500:500:500:250:500
Mirapoint 1.1.0:250:501:501:250:553:501:250:502:252:502:500:500:500:250:250
Mirapoint 3.2.1-GA:250:501:501:250:553:501:250:502:252:502:500:500:500:250:250
Mirapoint 3.2.1.6:250:501:501:250:553:250:250:502:252:502:500:500:500:250:250
MsgCore:501:250:501:250:501:250:501:250:502:500:500:500:500:250:250
NAVGW 2.5.1.13:250:250:501:250:250:250:550:500:250:502:502:500:500:250:250
NAVGW 2.5.1.2:250:250:501:250:250:250:550:500:250:250:250:250:500:250:250
NAVGW 2.5.2.12 -0-:250:250:500:250:250:250:550:500:250:502:502:500:500:250:250
NAVGW 2.5.2.12 -1-:250:250:500:250:250:250:250:500:250:502:502:500:500:250:250
NPlex 2.1.124:501:250:500:250:501:250:501:214:503:503:502:502:502:250:250
TMail v4.01.0008:503:501:250:250:250:250:250:214:250:505:507:507:507:250:250
NTMail v4.01.0014:220:501:250:250:250:250:550:214:250:250:507:507:507:250:250
NTMail v4.30.0010:503:501:502:250:501:250:550:214:557:505:502:502:502:250:250
NTMail v4.30.0012:503:501:250:250:250:250:250:214:557:505:507:507:507:250:250
NTMail v4.30.0013:503:501:250:250:250:250:550:214:250:505:507:507:507:250:250
NTMail v5.02.0001:503:501:250:250:250:250:550:214:557:505:507:507:507:250:250
NTMail v5.06.0014:503:501:250:250:250:250:250:214:557:505:501:501:501:250:250
NTMail v5.06.0016 -0-:503:501:250:250:250:250:550:214:250:505:501:501:501:250:250
NTMail v5.06.0016 -1-:503:501:542:250:250:542:250:214:557:505:501:501:501:250:250
NTMail v6.04.0010:503:501:250:250:250:250:550:214:557:505:501:501:501:250:250
NTMail v7.00.0018:503:501:250:250:250:250:550:214:250:560:501:501:501:250:250
NTMail v7.00.0022:503:501:550:250:250:550:550:214:250:505:501:501:501:250:250
NTMail v7.02.3037 -0-:503:501:250:250:250:250:250:214:250:505:501:501:501:250:250
NTMail v7.02.3037 -1-:503:501:250:250:250:250:550:214:558:505:501:501:501:250:250
NTMail v7.02.3037 -2-:503:501:250:250:250:250:500:214:250:505:501:501:501:250:250
Netscape Messaging Server 3.6:250:250:501:250:250:250:250:451:502:502:502:502:502:250:250
Netscape Messaging Server 4.15:250:250:501:250:250:250:551:214:251:550:500:500:500:250:250
Netscape Messaging Server 4.15 Patch 7:250:250:501:250:250:250:250:214:502:550:500:500:500:250:250
WebShield SMTP V4.5 -0-:250:250:500:250:501:250:501:250:502:502:500:502:502:250:502
WebShield SMTP V4.5 -1-:250:220:500:250:501:250:501:250:502:502:500:502:502:250:502
WebShield SMTP V4.5 -2-:250:250:500:250:501:250:550:250:502:502:500:502:502:250:502
WebShield SMTP V4.5 -3-:250:250:500:250:501:250:501:250:250:502:500:502:502:250:502
WebShield SMTP V4.5 MR1a:250:250:500:250:501:250:501:214:502:502:500:502:502:250:502
WebShielde500/SMTP:250:250:501:250:501:250:501:500:252:502:500:500:500:250:250
Norton Antivirus for Gateways Version 2.5.2.11:250:250:501:250:250:250:250:500:250:502:502:500:500:250:250
Obtuse smtpd:554:250:501:250:250:250:551:500:252:500:500:500:500:250:500
PP 6.0:250:501:501:250:501:250:250:214:250:550:500:500:500:250:250
Post.Office v3.1.2:250:250:501:250:250:250:550:214:250:250:502:502:502:250:250
Post.Office v3.5:250:250:501:250:250:250:550:214:252:550:502:502:502:250:250
Post.Office v3.5.3:250:250:501:250:250:250:550:214:550:550:502:502:502:250:250
Postfix -0-:250:501:501:250:501:250:250:502:252:502:502:502:502:250:250
Postfix -1-:503:501:501:250:501:250:501:502:502:502:502:502:502:250:250
Postfix -2-:250:501:501:250:501:250:550:502:550:502:502:502:502:250:250
Postfix -3-:250:501:501:250:501:250:250:502:252:502:502:502:502:250:220
Postfix -4-:250:501:501:250:501:250:554:502:502:502:502:502:502:250:250
Postfix -5-:503:501:501:250:501:250:450:502:252:502:502:502:502:250:250
Postfix -6-:250:401:401:250:401:250:450:402:252:402:402:402:402:250:250
Postfix -7-:553:501:553:553:553:553:553:553:553:553:553:553:553:250:250
Postfix-20010228-pl08:250:250:501:250:553:250:250:214:252:252:500:500:500:250:250
Postfix-20010228-pl08 -1-:503:501:501:250:501:250:250:502:252:502:502:502:502:250:250
Postfix (local database user checking):250:501:501:250:501:250:450:502:450:502:502:502:502:250:250
Postfix (RedHat/GNU):250:501:501:250:501:450:250:502:502:502:502:502:502:250:250
Postfix on SuSE Linux 7.2 (i386):250:501:501:250:501:250:250:502:250:502:502:502:250:250:250
Postfix 1.1.7:503:501:501:250:501:450:501:502:502:502:502:502:502:250:250
Postfix 1.1.11 -0-:503:501:501:250:501:250:250:502:502:502:502:502:502:250:250
Postfix 1.1.11 -1-:250:501:501:250:501:250:250:502:502:502:502:502:502:250:250
Postfix 1.1.11 -2-:503:501:501:250:501:250:504:502:252:502:502:502:502:502:250:250
Postfix 1.1.11 -3-:250:501:501:250:501:250:550:502:502:502:502:502:502:250:250
Postfix 1.1.12:250:501:501:250:501:250:550:502:252:502:502:502:502:250:220
Postfix 1.1.13:503:501:501:250:501:250:504:502:504:502:502:502:502:250:250
Postfix 2.0pl16 (disable_vrfy_command=yes):250:501:501:250:501:250:450:502:502:502:502:502:502:250:250
Postfix 2.0.3:250:501:501:250:501:250:550:502:252:502:502:502:502:250:250
Postfix 2.0.4:250:501:501:250:501:250:450:502:252:502:502:502:502:250:250
Postfix 2.0.6 (Mandrake Linux):250:401:401:250:401:250:454:402:252:402:402:402:402:250:250
Postfix 2.0.6:503:501:501:250:501:250:550:502:502:502:502:502:502:250:250
Postfix 2.0.7:503:501:501:250:501:250:550:502:252:502:502:502:502:250:250
Postfix 2.0.12:250:501:501:250:501:250:504:502:504:502:502:502:502:250:250
Postfix 2.0.13-3 (Mandrake Linux):503:501:501:250:501:250:504:502:502:502:502:502:502:250:250
Postfix 2.0.14:503:501:501:250:501:250:501:502:504:502:502:502:502:250:250
Postfix 2.0.16-2.1.5:503:501:501:250:501:250:501:502:252:502:502:502:502:250:250
Postfix 2.1.1:503:501:501:250:501:250:450:502:450:502:502:502:502:250:250
Postfix 2.2.2:403:401:401:250:401:250:250:402:402:402:402:402:402:250:250

Postfix (Debian/GNU) -0-:250:501:501:250:250:250:550:502:252:502:502:502:502:250:250
Postfix (Debian/GNU) -1-:250:501:501:250:501:250:554:502:252:502:502:502:502:250:250
Postfix (Debian/GNU) -2-:220:220:501:250:501:250:250:502:250:250:502:502:502:250:220
Postfix (Debian/GNU) -3-:503:501:250:250:501:250:501:502:252:502:502:502:502:250:250
Prioserve Mailserver -0-:503:501:250:250:553:250:250:250:250:502:250:250:250:250:220
Prioserve Mailserver -1-:220:220:250:250:250:501:250:214:250:250:502:250:250:250:250
Prioserve Mailserver -2-:220:220:250:250:250:501:250:214:252:250:250:502:250:250:220
Process Software PMDF e-Mail Interconnect V6.0-025:250:251:501:250:250:250:550:214:252:550:502:250:250:250:250
Protofax server 4.0:250:250:250:250:250:250:550:500:250:500:500:500:500:250:500
Qmail 1.0.3 -0-:250:250:250:250:250:250:250:214:252:502:502:502:502:250:250
Qmail 1.0.3 -1-:250:250:250:250:250:553:250:214:252:502:502:502:502:250:250
Qmail 1.0.3 -2-:250:250:250:250:250:250:553:214:252:502:502:502:502:250:250
Qmail 1.0.3 + spamcontrol 1.9.2:250:250:250:250:250:552:250:214:252:502:502:502:502:250:250
Qmail 1.0.3 + ldap-1.03-20030101.patch:250:502:250:250:250:250:250:502:502:502:502:502:502:250:502
Qmail 1.0.3 + spamcontrol + qmailqueue patches:250:250:250:250:250:250:554:214:252:502:502:502:502:250:250
Routing Proxy, v1.0 (build 22):503:250:501:250:250:250:501:214:504:504:504:504:504:250:504
SLMail 5.1.0:250:250:500:250:501:250:550:214:250:250:500:250:250:250:250
SMTP server ready:250:501:501:554:553:250:550:214:250:250:500:500:500:250:250
SNS Securities N.V. ready:501:501:501:250:250:501:250:500:500:500:500:500:500:250:500
SPA-Pro ESMTP Receiver 3.04:250:250:500:550:250:250:550:500:501:501:500:500:500:250:250
Sendmail (NEN) 8.11.6+Sun/8.11.6/NEN:503:501:501:250:553:250:250:214:250:502:502:502:502:250:250
Sendmail -0-:250:220:501:250:553:553:550:214:250:250:502:502:250:250:250
Sendmail -1-:220:501:501:250:553:553:550:250:250:250:502:502:502:250:250
Sendmail -2-:250:220:250:250:553:553:250:250:250:250:502:502:250:250:250
Sendmail -3-:220:501:501:250:250:553:250:214:250:250:250:502:502:250:220
Sendmail -4-:220:220:501:250:553:250:550:214:250:250:250:250:502:250:250
Sendmail -5-:250:220:501:250:553:553:550:214:250:250:502:502:502:250:220
Sendmail -6-:250:220:250:250:553:553:550:214:250:250:250:502:502:250:250
Sendmail -7-:250:501:501:250:553:553:550:250:250:250:502:250:502:250:250
Sendmail -8-:250:501:501:250:250:553:550:214:250:250:502:502:502:250:250
Sendmail -9-:250:220:501:250:553:553:550:214:250:250:250:502:502:250:220
Sendmail -10-:250:501:250:250:250:553:550:250:250:250:250:502:502:250:250
Sendmail -11-:250:501:501:250:553:553:550:250:250:250:502:502:250:250:250
Sendmail -12-:220:501:501:250:553:553:550:214:250:250:502:502:250:250:220
Sendmail -13-:250:501:250:250:553:553:550:214:250:250:502:502:502:250:220
Sendmail -14-:250:501:501:250:553:553:550:214:250:250:502:250:250:250:220
Sendmail -15-:220:220:501:250:553:553:550:214:250:250:250:502:502:250:250
Sendmail -16-:250:501:250:250:250:553:550:214:250:250:250:502:502:250:220
Sendmail -17-:250:501:501:250:553:553:550:214:250:250:250:250:502:250:250
Sendmail -18-:250:501:501:250:553:250:550:214:250:502:502:502:502:250:220
Sendmail -19-:250:501:501:250:553:250:550:214:252:250:250:502:502:250:250
Sendmail -20-:250:501:501:250:250:250:550:214:252:502:250:250:502:250:250
Sendmail -21-:250:250:501:250:553:250:550:214:252:502:502:502:502:250:250
Sendmail -22-:501:501:501:250:553:553:501:502:252:502:502:502:502:250:250
Sendmail -23-:250:220:250:250:250:553:250:250:250:250:502:250:502:250:250
Sendmail -24-:220:501:250:250:250:501:250:250:250:250:250:250:250:250:220
Sendmail -25-:250:220:250:250:250:501:250:214:250:250:502:250:250:250:220
Sendmail -26-:250:220:250:250:250:553:550:214:250:250:502:250:502:250:250
Sendmail -27-:220:220:250:250:250:501:250:214:250:250:250:250:250:250:220
Sendmail -28-:250:501:501:250:553:553:550:250:250:250:502:502:502:250:220
Sendmail -29-:250:501:501:250:250:250:250:250:250:250:502:502:250:250:250
Sendmail -30-:220:501:250:250:250:250:550:214:250:250:502:250:250:250:220
Sendmail -31-:220:220:501:250:250:553:250:250:250:250:502:502:502:250:250
Sendmail -32-:250:220:250:250:250:501:550:214:250:250:250:250:250:250:220
Sendmail -33-:220:220:250:250:250:501:250:250:250:250:502:502:250:250:220
Sendmail -34-:250:501:501:250:250:553:550:250:250:250:502:502:502:250:250
Sendmail -35-:220:220:250:250:250:553:550:250:250:250:250:502:250:250:250
Sendmail -36-:220:220:250:250:250:501:550:214:250:250:502:250:250:250:220
Sendmail -37-:250:220:501:250:250:250:550:250:250:250:250:502:502:250:250
Sendmail -38-:220:220:250:250:250:501:250:250:250:250:502:250:250:250:220
Sendmail -39-:250:501:501:250:250:553:250:250:250:250:502:502:502:250:250
Sendmail -40-:220:220:250:250:250:501:550:214:250:250:502:250:250:250:250
Sendmail -41-:250:220:501:250:250:553:550:250:250:250:502:502:502:250:220
Sendmail 4.1/SMI-4.1:554:250:501:250:250:250:0:500:252:500:500:500:500:250:500
Sendmail 8.10.1:250:501:501:250:553:250:550:214:250:250:502:502:502:250:250
Sendmail 8.10.1/UW7.1.1-NSC:250:501:501:250:553:250:554:214:250:250:502:502:502:250:250
Sendmail 8.10.2/8.10.2 -0-:220:220:501:250:553:250:250:250:252:250:502:502:250:250:250
Sendmail 8.10.2/8.10.2 -1-:503:501:250:250:250:250:250:250:252:250:250:250:502:250:250
Sendmail 8.10.2/8.10.2 -2-:503:220:250:250:250:501:250:250:250:250:502:250:250:250:250
Sendmail 8.10.2/8.10.2 -3-:503:220:501:250:553:250:250:250:252:250:250:250:250:250:250
Sendmail 8.10.2/8.10.2 -4-:220:220:250:250:250:250:250:250:252:250:250:502:250:250:250
Sendmail 8.10.2/8.10.2 -5-:503:220:501:250:553:250:250:214:250:250:250:250:250:250:220
Sendmail 8.10.2/8.10.2 -6-:503:220:501:250:250:501:550:250:252:502:502:502:502:250:250
Sendmail 8.10.2/8.10.2 -7-:220:501:250:250:250:250:250:250:250:502:250:250:502:250:220
Sendmail 8.10.2/8.10.2 -8-:503:220:501:250:250:501:250:250:252:502:502:250:502:250:220
Sendmail 8.10.2/8.10.2 -9-:503:501:250:250:553:250:250:214:252:502:502:250:250:250:220
Sendmail 8.10.2/8.10.2 -10-:503:501:501:250:553:250:550:250:250:250:502:250:502:250:220
Sendmail 8.10.2/8.10.2 -11-:220:220:250:250:250:501:250:250:250:502:250:502:250:250:250
Sendmail 8.10.2/8.10.2 -12-:503:501:501:250:553:250:250:250:250:250:250:250:250:250:250
Sendmail 8.10.2/8.10.2 -13-:220:220:250:250:250:250:250:214:250:502:502:250:502:250:220
Sendmail 8.10.2/8.10.2 -14-:220:501:501:250:250:501:250:214:252:502:250:250:250:250:220
Sendmail 8.10.2/8.10.2 -15-:503:220:250:250:553:501:250:250:252:250:250:250:250:250:250
Sendmail 8.10.2/8.10.2 -16-:220:220:250:250:250:250:550:214:250:502:250:502:502:250:220
Sendmail 8.10.2/8.10.2 -17-:503:501:250:250:553:501:250:214:250:250:250:502:250:250:220
Sendmail 8.10.2/8.10.2 -18-:220:220:250:250:250:501:550:214:252:502:250:250:250:250:250
Sendmail 8.10.2/8.10.2 -19-:503:501:501:250:250:501:250:250:250:502:502:250:502:250:220
Sendmail 8.10.2/8.10.2 -20-:220:501:250:250:250:501:250:250:250:502:502:502:502:250:250
Sendmail 8.10.2/8.10.2 -21-:220:501:501:250:553:501:550:250:252:502:502:250:502:250:250
Sendmail 8.10.2/8.10.2 -22-:503:501:501:250:250:501:250:250:252:502:250:250:250:250:250
Sendmail 8.10.2/8.10.2 -23-:503:220:250:250:250:250:550:250:250:250:502:250:502:250:220
Sendmail 8.10.2/8.10.2 -24-:220:501:250:250:553:250:250:214:252:502:502:250:502:250:250
Sendmail 8.10.2/8.10.2 -25-:220:501:501:250:250:501:250:214:250:250:502:250:250:250:220
Sendmail 8.10.2/8.10.2 -26-:220:501:250:250:250:501:550:250:250:250:250:250:250:250:220
Sendmail 8.10.2/8.10.2 -27-:220:501:501:250:553:250:250:250:252:502:502:250:502:250:250
Sendmail 8.10.2/8.10.2 -28-:220:501:501:250:250:250:250:214:250:502:250:502:250:250:250
Sendmail 8.10.2/8.10.2 -29-:220:501:501:250:250:250:250:214:250:502:502:250:250:250:250
Sendmail 8.10.2/8.10.2 -30-:503:220:250:250:250:250:550:250:252:250:250:250:250:250:250
Sendmail 8.10.2/8.10.2 -31-:220:501:250:250:250:250:250:214:250:502:502:250:502:250:220
Sendmail 8.10.2/8.10.2 -32-:220:501:501:250:553:250:250:250:252:502:250:502:502:250:220
Sendmail 8.10.2/8.10.2 -33-:220:220:250:250:553:250:250:250:250:502:502:502:502:250:220
Sendmail 8.10.2/8.10.2 -34-:503:501:501:250:250:501:250:250:252:502:250:502:502:250:220
Sendmail 8.10.2/8.10.2 -35-:220:501:250:250:250:501:250:250:252:250:502:502:502:250:220
Sendmail 8.10.2/8.10.2 -36-:503:501:501:250:553:501:250:250:252:250:250:250:502:250:220
Sendmail 8.10.2/8.10.2 -37-:220:220:501:250:553:501:250:250:250:502:502:502:502:250:220
Sendmail 8.10.2/8.10.2 -38-:220:220:250:250:250:250:550:214:250:502:502:250:250:250:250
Sendmail 8.10.2/8.10.2 -39-:503:220:501:250:250:250:550:214:250:250:502:502:502:250:250
Sendmail 8.10.2/8.10.2 -40-:503:501:501:250:553:501:250:214:250:250:250:250:250:250:220
Sendmail 8.10.2/8.10.2 -41-:220:220:250:250:553:501:250:214:250:502:502:502:250:250:250
Sendmail 8.10.2/8.10.2 -42-:503:501:501:250:553:250:550:250:250:250:250:502:250:250:250
Sendmail 8.10.2/8.10.2 -43-:503:220:501:250:553:250:250:250:252:502:502:250:502:250:250
Sendmail 8.10.2/8.10.2 -44-:220:501:250:250:250:501:250:250:250:502:250:502:250:250:220
Sendmail 8.10.2/8.10.2 -45-:503:501:250:250:553:501:250:214:250:250:250:250:250:250:220
Sendmail 8.10.2/8.10.2 -46-:220:220:250:250:250:501:250:214:250:502:502:502:250:250:220
Sendmail 8.10.2/8.10.2 -47-:220:220:250:250:553:250:550:214:252:502:502:250:502:250:250
Sendmail 8.10.2/8.10.2 -48-:503:501:250:250:553:250:250:214:250:250:502:250:250:250:220
Sendmail 8.10.2/8.10.2 -49-:220:501:250:250:553:250:550:250:250:502:250:250:250:250:250
Sendmail 8.10.2/8.10.2 -50-:503:501:250:250:553:501:250:214:250:250:250:250:250:250:250
Sendmail 8.10.2/8.10.2 -51-:220:501:250:250:553:250:250:214:250:250:250:502:502:250:250
Sendmail 8.10.2/8.10.2 -52-:503:220:501:250:250:250:250:250:250:502:250:250:502:250:250
Sendmail 8.10.2/8.10.2 -53-:220:220:250:250:250:250:550:250:252:502:250:250:250:250:250
Sendmail 8.10.2/8.10.2 -54-:503:501:501:250:553:250:250:214:250:250:502:250:250:250:250
Sendmail 8.10.2/8.10.2 -55-:220:220:250:250:250:250:250:214:250:250:502:502:250:250:220
Sendmail 8.10.2/8.10.2 -56-:220:220:501:250:250:250:250:214:250:250:250:250:502:250:220
Sendmail 8.10.2/8.10.2 -57-:503:220:250:250:250:501:550:250:252:502:502:502:502:250:250
Sendmail 8.10.2/8.10.2 -58-:503:501:250:250:250:501:250:250:250:250:502:502:502:250:220
Sendmail 8.10.2/8.10.2 -59-:503:220:250:250:250:501:250:250:250:250:250:250:502:250:250
Sendmail 8.10.2/8.10.2 -60-:503:220:501:250:553:250:550:250:252:250:502:250:250:250:220
Sendmail 8.10.2/8.10.2 -61-:503:501:501:250:553:250:550:214:250:250:250:502:250:250:250
Sendmail 8.10.2/8.10.2 -62-:503:501:250:250:553:501:550:214:250:502:502:502:502:250:250
Sendmail 8.10.2/8.10.2 -63-:503:501:501:250:250:501:250:214:252:250:250:250:250:250:220
Sendmail 8.10.2/8.10.2 -64-:220:501:250:250:250:501:250:214:250:502:502:250:502:250:250
Sendmail 8.10.2/8.10.2 -65-:220:501:250:250:250:501:250:214:252:502:502:250:250:250:220
Sendmail 8.10.2/8.10.2 -66-:503:220:250:250:553:250:550:214:250:250:250:250:250:250:220
Sendmail 8.10.2/8.10.2 -67-:220:501:501:250:250:501:250:250:250:250:502:502:502:250:250
Sendmail 8.10.2/8.10.2 -68-:220:220:501:250:250:501:250:250:252:502:250:250:250:250:250
Sendmail 8.10.2/8.10.2 -69-:503:501:250:250:250:501:250:214:252:250:250:502:250:250:220
Sendmail 8.10.2/8.10.2 -70-:220:501:250:250:250:501:250:250:250:250:502:502:502:250:220
Sendmail 8.10.2/8.10.2 -71-:220:220:501:250:250:501:250:214:250:502:502:250:250:250:220
Sendmail 8.10.2/8.10.2 -72-:503:220:250:250:553:501:250:250:250:502:502:502:250:250:220
Sendmail 8.10.2/8.10.2 -73-:220:501:250:250:250:501:550:250:252:502:502:250:250:250:250
Sendmail 8.10.2/8.10.2 -74-:220:501:501:250:553:501:550:214:250:250:250:502:250:250:250
Sendmail 8.10.2/8.10.2 -75-:503:220:250:250:553:250:550:214:250:250:250:250:502:250:220
Sendmail 8.10.2/8.10.2 -76-:220:220:250:250:250:250:550:250:252:502:502:502:502:250:250
Sendmail 8.10.2/8.10.2 -77-:220:220:250:250:553:250:550:214:252:250:502:502:250:250:250
Sendmail 8.10.2/8.10.2 -78-:503:501:250:250:553:250:550:214:250:502:502:250:250:250:220
Sendmail 8.10.2/8.10.2 -79-:220:220:501:250:250:250:250:250:250:250:250:250:250:250:220
Sendmail 8.10.2/8.10.2 -80-:220:220:250:250:553:501:250:250:250:502:250:502:502:250:250
Sendmail 8.10.2/8.10.2 -81-:503:220:250:250:250:501:250:250:250:502:502:502:502:250:250
Sendmail 8.10.2/8.10.2 -82-:503:501:501:250:553:501:250:214:252:250:502:250:250:250:250
Sendmail 8.10.2/8.10.2 -83-:503:220:250:250:553:250:550:250:250:502:250:250:502:250:250
Sendmail 8.10.2/8.10.2 -84-:503:501:250:250:250:250:250:214:250:250:250:250:502:250:220
Sendmail 8.10.2/8.10.2 -85-:503:220:250:250:250:501:250:214:250:502:250:502:502:250:220
Sendmail 8.10.2/8.10.2 -86-:220:501:250:250:250:250:550:214:252:250:250:250:250:250:220
Sendmail 8.10.2/8.10.2 -87-:503:220:250:250:250:250:250:214:252:502:502:502:250:250:220
Sendmail 8.10.2/8.10.2 -88-:220:220:250:250:250:501:250:214:250:502:250:502:502:250:250
Sendmail 8.10.2/8.10.2 -89-:503:501:501:250:250:250:550:214:250:250:502:250:250:250:250
Sendmail 8.10.2/8.10.2 -90-:220:501:250:250:250:250:250:250:250:502:502:502:502:250:250
Sendmail 8.10.2/8.10.2 -91-:503:501:250:250:553:250:250:214:252:250:502:250:502:250:250
Sendmail 8.10.2/8.10.2 -92-:220:220:250:250:553:250:250:214:252:250:502:250:502:250:250
Sendmail 8.10.2/8.10.2 -93-:220:220:501:250:250:501:550:214:252:502:502:250:250:250:250
Sendmail 8.10.2/8.10.2 -94-:503:220:250:250:553:501:250:214:250:502:250:250:250:250:250
Sendmail 8.10.2/8.10.2 -95-:220:501:501:250:250:501:250:250:250:250:250:502:250:250:250
Sendmail 8.10.2/8.10.2 -96-:220:501:250:250:250:250:250:214:250:502:502:250:250:250:220
Sendmail 8.10.2/8.10.2 -97-:220:501:501:250:250:501:550:250:252:502:502:502:502:250:250
Sendmail 8.10.2/8.10.2 -98-:503:501:501:250:250:250:250:250:250:502:250:250:502:250:220
Sendmail 8.10.2/8.10.2 -99-:220:220:501:250:553:501:250:214:252:502:502:250:250:250:250
Sendmail 8.10.2/8.10.2 -100-:503:501:501:250:553:250:550:214:250:502:250:502:250:250:220
Sendmail 8.10.2/8.10.2 -101-:220:220:250:250:250:250:550:250:250:250:502:502:250:250:250
Sendmail 8.10.2/8.10.2 -102-:220:501:250:250:250:250:250:214:252:250:502:250:502:250:250
Sendmail 8.10.2/8.10.2 -103-:220:220:501:250:553:501:250:214:252:502:502:250:250:250:220
Sendmail 8.10.2/8.10.2 -104-:220:220:250:250:250:250:250:250:252:502:502:250:250:250:220
Sendmail 8.10.2/8.10.2 -105-:220:501:501:250:553:501:250:250:250:502:502:502:250:250:220
Sendmail 8.10.2/8.10.2 -106-:220:501:501:250:553:501:250:214:250:250:502:502:502:250:250
Sendmail 8.10.2/8.10.2 -107-:220:220:250:250:250:250:250:214:252:502:502:502:502:250:250
Sendmail 8.10.2/8.10.2 -108-:220:220:501:250:553:501:250:250:252:250:502:250:502:250:250
Sendmail 8.10.2/8.10.2 -109-:503:220:501:250:250:250:550:214:250:250:502:250:250:250:220
Sendmail 8.10.2/8.10.2 -110-:220:501:501:250:250:250:550:214:250:250:502:502:502:250:220
Sendmail 8.10.2/8.10.2 -111-:220:220:501:250:553:501:250:214:252:250:250:250:502:250:250
Sendmail 8.10.2/8.10.2 -112-:503:501:250:250:250:501:250:250:250:250:250:502:502:250:220
Sendmail 8.10.2/8.10.2 -113-:220:501:250:250:250:501:550:214:250:250:250:502:250:250:250
Sendmail 8.10.2/8.10.2 -114-:503:220:250:250:250:250:550:214:252:502:502:250:250:250:250
Sendmail 8.10.2/8.10.2 -115-:220:501:501:250:250:501:250:250:252:250:502:250:502:250:250
Sendmail 8.10.2/8.10.2 -116-:220:220:250:250:250:501:250:214:252:250:502:502:502:250:220
Sendmail 8.10.2/8.10.2 -117-:503:220:501:250:250:501:250:250:252:250:250:502:502:250:250
Sendmail 8.10.2/8.10.2 -118-:220:501:501:250:250:501:250:214:252:250:502:502:502:250:220
Sendmail 8.10.2/8.10.2 -119-:503:220:250:250:250:250:250:250:250:250:502:250:502:250:250
Sendmail 8.10.2/8.10.2 -120-:503:220:250:250:553:250:250:250:252:250:250:250:502:250:220
Sendmail 8.10.2/8.10.2 -121-:220:220:250:250:250:501:250:214:250:502:502:502:502:250:220
Sendmail 8.10.2/8.10.2 -122-:503:220:501:250:553:250:250:250:252:502:250:250:250:250:250
Sendmail 8.10.2/8.10.2 -123-:503:501:501:250:553:501:550:214:250:250:250:250:250:250:250
Sendmail 8.10.2/8.10.2 -124-:503:220:501:250:250:501:250:250:250:250:250:250:502:250:220
Sendmail 8.10.2/8.10.2 -125-:220:220:501:250:553:501:250:250:252:502:502:250:502:250:220
Sendmail 8.10.2/8.10.2 -126-:220:220:501:250:553:250:550:250:252:250:250:250:502:250:250
Sendmail 8.10.2/8.10.2 -127-:503:220:250:250:250:250:250:250:250:502:502:250:502:250:250
Sendmail 8.10.2/8.10.2 -128-:503:220:250:250:250:501:250:214:250:502:502:250:250:250:250
Sendmail 8.10.2/8.10.2 -129-:503:220:250:250:250:250:250:214:250:502:502:502:502:250:220
Sendmail 8.10.2/8.10.2 -130-:503:501:501:250:553:250:250:214:252:250:250:250:250:250:250
Sendmail 8.10.2/8.10.2 -131-:220:220:501:250:553:250:250:214:250:502:502:502:250:250:250
Sendmail 8.10.2/8.10.2 -132-:503:220:250:250:250:250:250:250:250:502:502:502:502:250:250
Sendmail 8.10.2/8.10.2 -133-:503:220:250:250:250:501:250:250:250:250:502:250:502:250:250
Sendmail 8.10.2/8.10.2 -134-:220:220:250:250:250:250:550:250:252:250:502:250:250:250:220
Sendmail 8.10.2/8.10.2 -135-:503:220:501:250:250:501:250:214:250:502:502:502:250:250:250
Sendmail 8.10.2/8.10.2 -136-:503:501:501:250:250:501:250:214:250:250:250:250:250:250:250
Sendmail 8.10.2/8.10.2 -137-:503:220:250:250:553:250:550:214:250:502:250:502:250:250:250
Sendmail 8.10.2/8.10.2 -138-:503:501:250:250:553:501:550:214:252:502:250:250:502:250:250
Sendmail 8.10.2/8.10.2 -139-:220:501:250:250:250:501:250:250:252:250:250:502:250:250:250
Sendmail 8.10.2/8.10.2 -140-:220:501:501:250:553:250:250:250:252:250:502:502:250:250:220
Sendmail 8.10.2/8.10.2 -141-:503:501:250:250:250:250:550:250:252:502:250:502:502:250:250
Sendmail 8.10.2/8.10.2 -142-:503:220:501:250:250:250:550:214:252:502:502:502:502:250:250
Sendmail 8.10.2/8.10.2 -143-:503:501:501:250:553:250:250:250:252:502:502:502:250:250:220
Sendmail 8.10.2/8.10.2 -144-:220:220:250:250:553:250:250:214:250:502:250:250:250:250:250
Sendmail 8.10.2/8.10.2 -145-:220:220:501:250:250:250:250:250:252:502:250:250:250:250:250
Sendmail 8.10.2/8.10.2 -146-:220:220:501:250:250:250:250:214:252:250:250:502:502:250:250
Sendmail 8.10.2/8.10.2 -147-:503:220:250:250:250:250:250:214:250:250:250:250:250:250:250
Sendmail 8.10.2/8.10.2 -148-:503:220:501:250:250:501:250:214:252:502:250:502:502:250:250
Sendmail 8.10.2/8.10.2 -149-:220:501:250:250:553:250:250:250:252:250:250:250:250:250:220
Sendmail 8.10.2/8.10.2 -150-:220:501:250:250:250:250:250:250:250:250:502:502:502:250:220
Sendmail 8.10.2/8.10.2 -151-:220:220:250:250:250:501:250:250:250:250:250:502:502:250:250
Sendmail 8.10.2/8.10.2 -152-:220:220:250:250:250:501:250:214:250:502:250:502:250:250:220
Sendmail 8.10.2/8.10.2 -153-:503:220:250:250:250:250:250:214:250:502:250:250:250:250:220
Sendmail 8.10.2/8.10.2 -154-:220:220:501:250:250:501:550:214:250:250:502:250:250:250:220
Sendmail 8.10.2/8.10.2 -155-:220:220:501:250:250:501:550:250:250:250:250:502:250:250:220
Sendmail 8.10.2/8.10.2 -156-:503:220:501:250:553:250:550:250:252:250:250:502:250:250:250
Sendmail 8.10.2/8.10.2 -157-:503:220:250:250:553:250:250:250:250:250:250:502:502:250:220
Sendmail 8.10.2/8.10.2 -158-:503:501:501:250:553:501:250:214:250:502:250:250:250:250:250
Sendmail 8.10.2/8.10.2 -159-:503:220:501:250:250:501:550:250:252:502:250:250:250:250:250
Sendmail 8.10.2/8.10.2 -160-:220:220:501:250:553:250:250:250:252:250:502:250:250:250:220
Sendmail 8.10.2/8.10.2 -161-:220:501:250:250:553:250:250:214:250:502:502:250:250:250:220
Sendmail 8.10.2/8.10.2 -162-:220:220:250:250:553:501:250:214:250:502:502:250:502:250:220
Sendmail 8.10.2/8.10.2 -163-:220:501:250:250:250:501:250:250:250:502:250:250:250:250:250
Sendmail 8.10.2/8.10.2 -164-:503:501:501:250:250:250:250:250:252:250:502:502:250:250:250
Sendmail 8.10.2/8.10.2 -165-:503:220:501:250:553:501:250:214:252:502:502:502:502:250:250
Sendmail 8.10.2/8.10.2 -166-:503:501:501:250:553:501:550:250:252:502:250:250:502:250:220
Sendmail 8.10.2/8.10.2 -167-:503:501:501:250:250:501:250:250:250:250:250:502:502:250:220
Sendmail 8.10.2/8.10.2 -168-:503:220:250:250:553:501:250:214:252:250:250:250:250:250:220
Sendmail 8.10.2/8.10.2 -169-:220:220:501:250:553:250:250:250:250:250:250:250:502:250:250
Sendmail 8.10.2/8.10.2 -170-:220:220:501:250:553:501:550:250:250:502:250:502:250:250:250
Sendmail 8.10.2/8.10.2 -171-:220:220:250:250:250:501:550:214:252:250:250:502:502:250:250
Sendmail 8.10.2/8.10.2 -172-:503:501:501:250:553:250:250:214:250:250:250:502:250:250:220
Sendmail 8.10.2/8.10.2 -173-:220:501:501:250:250:501:250:250:250:250:250:250:502:250:250
Sendmail 8.10.2/8.10.2 -174-:503:220:250:250:553:250:250:250:250:250:250:250:502:250:250
Sendmail 8.10.2/8.10.2 -175-:220:501:501:250:250:250:250:250:252:250:250:502:250:250:220
Sendmail 8.10.2/8.10.2 -176-:220:220:250:250:553:501:550:250:250:502:502:250:502:250:250
Sendmail 8.10.2/8.10.2 -177-:220:220:250:250:250:250:550:214:250:502:250:250:502:250:220
Sendmail 8.10.2/8.10.2 -178-:503:220:250:250:250:250:250:250:250:250:250:250:502:250:250
Sendmail 8.10.2/8.10.2 -179-:220:220:250:250:250:250:250:250:250:250:502:502:250:250:250
Sendmail 8.10.2/8.10.2 -180-:220:220:250:250:553:501:550:214:250:502:250:502:502:250:220
Sendmail 8.10.2/8.10.2 -181-:220:220:250:250:250:501:250:214:252:502:502:250:502:250:220
Sendmail 8.10.2/8.10.2 -182-:220:501:501:250:553:250:250:214:252:502:502:502:250:250:250
Sendmail 8.10.2/8.10.2 -183-:220:220:250:250:250:250:250:250:250:250:502:250:250:250:250
Sendmail 8.10.2/8.10.2 -184-:503:501:501:250:553:250:250:250:252:502:250:502:250:250:220
Sendmail 8.10.2/8.10.2 -185-:503:220:501:250:553:501:250:250:250:250:502:502:502:250:220
Sendmail 8.10.2/8.10.2 -186-:220:501:501:250:553:250:550:250:250:502:502:250:250:250:250
Sendmail 8.10.2/8.10.2 -187-:503:501:501:250:250:250:250:250:252:250:502:502:250:250:220
Sendmail 8.10.2/8.10.2 -188-:220:220:250:250:250:501:550:250:252:250:502:502:250:250:220
Sendmail 8.10.2/8.10.2 -189-:503:501:250:250:250:250:250:214:250:250:250:502:250:250:220
Sendmail 8.10.2/8.10.2 -190-:220:220:250:250:553:501:250:214:252:502:250:250:250:250:250
Sendmail 8.10.2/8.10.2 -191-:220:220:250:250:250:250:250:250:250:250:250:502:502:250:220
Sendmail 8.10.2/8.10.2 -192-:503:501:501:250:553:501:550:250:252:502:502:250:250:250:220
Sendmail 8.10.2/8.10.2 -193-:220:501:501:250:553:501:250:250:250:502:250:250:250:250:250
Sendmail 8.10.2/8.10.2 -194-:503:220:250:250:553:501:550:214:252:502:250:502:250:250:250
Sendmail 8.10.2/8.10.2 -195-:503:501:250:250:250:501:250:250:252:502:502:502:502:250:250
Sendmail 8.10.2/8.10.2 -196-:503:501:250:250:553:501:550:250:252:250:250:250:502:250:250
Sendmail 8.10.2/8.10.2 -197-:220:220:250:250:250:250:250:250:250:502:502:250:250:250:250
Sendmail 8.10.2/8.10.2 -198-:220:220:250:250:250:250:550:250:250:250:250:502:502:250:250
Sendmail 8.10.2/8.10.2 -199-:503:220:250:250:250:501:250:214:250:502:502:250:502:250:220
Sendmail 8.10.2/8.10.2 -200-:220:501:250:250:250:501:250:214:250:250:250:502:250:250:220
Sendmail 8.10.2/8.10.2 -201-:220:220:250:250:250:501:250:214:250:502:250:250:502:250:250
Sendmail 8.10.2/8.10.2 -202-:220:220:250:250:553:501:550:214:252:502:502:502:250:250:220
Sendmail 8.10.2/8.10.2 -203-:220:220:250:250:250:250:250:214:252:250:502:502:502:250:220
Sendmail 8.10.2/8.10.2 -204-:220:220:501:250:553:501:250:214:250:250:250:250:250:250:250
Sendmail 8.10.2/8.10.2 -205-:220:220:250:250:250:250:550:250:252:250:250:502:250:250:220
Sendmail 8.10.2/8.10.2 -206-:220:220:250:250:250:250:550:250:252:502:250:250:502:250:220
Sendmail 8.10.2/8.10.2 -207-:220:220:250:250:553:250:250:250:250:250:502:250:502:250:250
Sendmail 8.10.2/8.10.2 -208-:220:220:501:250:250:250:250:214:252:250:250:502:250:250:250
Sendmail 8.10.2/8.10.2 -209-:220:220:250:250:250:250:550:250:250:502:502:502:502:250:250
Sendmail 8.10.2/8.10.2 -210-:220:501:501:250:553:501:250:214:252:250:250:502:250:250:220
Sendmail 8.10.2/8.10.2 -211-:503:220:250:250:553:250:550:214:252:250:250:250:250:250:250
Sendmail 8.10.2/8.10.2 -212-:220:501:250:250:250:501:250:250:250:502:502:502:250:250:220
Sendmail 8.10.2/8.10.2 -213-:220:501:501:250:250:501:550:214:250:250:250:502:502:250:250
Sendmail 8.10.2/8.10.2 -214-:220:501:501:250:553:501:550:214:250:250:250:250:502:250:250
Sendmail 8.10.2/8.10.2 -215-:220:501:250:250:553:501:250:250:252:250:250:250:502:250:250
Sendmail 8.10.2/8.10.2 -216-:503:501:250:250:553:501:550:214:252:502:502:502:502:250:220
Sendmail 8.10.2/8.10.2 -217-:503:501:501:250:553:250:550:214:250:502:502:250:502:250:250
Sendmail 8.10.2/8.10.2 -218-:503:220:250:250:250:250:250:214:250:250:502:250:250:250:250
Sendmail 8.10.2/8.10.2 -219-:220:220:250:250:553:501:250:250:250:250:502:250:250:250:220
Sendmail 8.10.2/8.10.2 -220-:220:220:250:250:553:501:250:214:252:250:502:250:250:250:250
Sendmail 8.10.2/8.10.2 -221-:220:220:501:250:250:250:250:250:252:502:502:502:250:250:250
Sendmail 8.10.2/8.10.2 -222-:220:501:501:250:250:250:250:214:252:502:502:250:502:250:250
Sendmail 8.10.2/8.10.2 -223-:220:220:250:250:553:250:250:250:252:502:250:502:250:250:250
Sendmail 8.10.2/8.10.2 -224-:503:501:501:250:250:250:250:250:252:502:250:250:502:250:220
Sendmail 8.10.2/8.10.2 -225-:503:220:250:250:250:501:250:250:250:250:250:502:502:250:220
Sendmail 8.10.2/8.10.2 -226-:220:220:250:250:250:250:250:250:250:250:250:502:502:250:250
Sendmail 8.10.2/8.10.2 -227-:503:501:501:250:250:250:250:214:252:250:502:502:250:250:250
Sendmail 8.10.2/8.10.2 -228-:220:501:501:250:553:501:550:214:250:250:502:502:250:250:250
Sendmail 8.10.2/8.10.2 -229-:220:501:501:250:553:250:250:250:250:250:250:502:250:250:250
Sendmail 8.10.2/8.10.2 -230-:503:220:250:250:250:250:250:214:250:502:502:250:502:250:250
Sendmail 8.10.2/8.10.2 -231-:503:501:250:250:553:250:250:250:252:502:250:250:502:250:220
Sendmail 8.10.2/8.10.2 -232-:220:501:501:250:553:250:550:214:252:502:502:502:502:250:220
Sendmail 8.10.2/8.10.2 -233-:503:220:250:250:250:501:250:250:250:502:502:250:250:250:250
Sendmail 8.10.2/8.10.2 -234-:503:220:250:250:250:250:550:250:252:502:502:250:502:250:250
Sendmail 8.10.2/8.10.2 -235-:503:220:250:250:553:250:250:250:250:502:250:502:502:250:220
Sendmail 8.10.2/8.10.2 -236-:220:501:501:250:250:250:550:214:252:250:250:502:250:250:220
Sendmail 8.10.2/8.10.2 -237-:220:220:501:250:250:501:550:214:252:502:502:250:250:250:220
Sendmail 8.10.2/8.10.2 -238-:220:220:501:250:250:501:250:250:252:250:250:250:502:250:220
Sendmail 8.10.2/8.10.2 -239-:220:220:501:250:553:250:250:214:250:502:250:502:250:250:220
Sendmail 8.10.2/8.10.2 -240-:220:220:501:250:250:501:250:250:250:250:502:502:250:250:250
Sendmail 8.10.2/8.10.2 -241-:220:501:501:250:553:501:250:214:252:250:250:250:250:250:250
Sendmail 8.10.2/8.10.2 -242-:503:220:501:250:553:501:250:250:250:250:250:502:502:250:220
Sendmail 8.10.2/8.10.2 -243-:503:501:250:250:250:501:250:214:250:250:250:502:502:250:250
Sendmail 8.10.2/8.10.2 -244-:503:501:501:250:250:501:550:214:250:250:250:250:502:250:220
Sendmail 8.10.2/8.10.2 -245-:220:220:501:250:250:250:550:250:250:502:250:250:250:250:250
Sendmail 8.10.2/8.10.2 -246-:220:220:501:250:553:501:250:250:250:502:250:250:250:250:250
Sendmail 8.10.2/8.10.2 -247-:503:220:501:250:250:250:250:250:250:502:250:250:250:250:220
Sendmail 8.10.2/8.10.2 -248-:503:501:501:250:250:250:550:250:250:502:250:250:250:250:220
Sendmail 8.10.2/8.10.2 -249-:220:220:250:250:553:250:250:250:250:502:250:250:250:250:250
Sendmail 8.10.2/8.10.2 -250-:220:220:501:250:250:501:250:214:250:250:502:250:502:250:220
Sendmail 8.10.2/8.10.2 -251-:503:220:250:250:250:250:250:250:250:502:502:502:250:250:220
Sendmail 8.10.2/8.10.2 -252-:503:220:250:250:553:501:250:214:252:502:502:502:502:250:220
Sendmail 8.10.2/8.10.2 -253-:503:220:250:250:250:250:250:250:250:250:250:502:250:250:250
Sendmail 8.10.2/8.10.2 -254-:220:501:250:250:553:250:250:250:250:502:502:250:250:250:220
Sendmail 8.10.2/8.10.2 -255-:220:501:250:250:553:250:550:250:252:250:250:502:502:250:220
Sendmail 8.10.2/8.10.2 -256-:220:220:250:250:553:250:550:250:252:502:250:250:502:250:250
Sendmail 8.10.2/8.10.2 -257-:220:501:501:250:553:501:250:250:250:502:502:250:502:250:220
Sendmail 8.10.2/8.10.2 -258-:503:501:250:250:553:501:550:214:252:250:250:250:250:250:220
Sendmail 8.10.2/8.10.2 -259-:220:501:250:250:553:250:250:214:250:502:250:250:250:250:220
Sendmail 8.10.2/8.10.2 -260-:220:220:501:250:553:250:550:250:250:502:502:250:250:250:220
Sendmail 8.10.2/8.10.2 -261-:220:220:501:250:250:250:550:214:252:250:250:502:502:250:220
Sendmail 8.10.2/8.10.2 -262-:220:220:250:250:553:501:550:214:252:502:502:250:250:250:220
Sendmail 8.10.2/8.10.2 -263-:220:220:501:250:250:250:550:250:250:502:250:250:502:250:250
Sendmail 8.10.2/8.10.2 -264-:220:501:501:250:250:501:250:214:250:502:502:502:250:250:250
Sendmail 8.10.2/8.10.2 -265-:503:220:250:250:250:501:550:214:250:250:502:502:502:250:220
Sendmail 8.10.2/8.10.2 -266-:503:501:501:250:553:250:250:214:250:250:502:250:250:250:220
Sendmail 8.10.2/8.10.2 -267-:220:501:250:250:250:250:250:214:250:250:502:250:502:250:250
Sendmail 8.10.2/8.10.2 -268-:220:220:501:250:553:250:250:250:250:250:250:250:250:250:250
Sendmail 8.10.2/8.10.2 -269-:220:220:501:250:250:501:550:214:250:250:250:250:250:250:220
Sendmail 8.10.2/8.10.2 -270-:220:220:501:250:553:250:550:214:252:250:250:502:502:250:220
Sendmail 8.10.2/8.10.2 -271-:503:220:501:250:553:501:550:214:252:502:502:502:502:250:250
Sendmail 8.10.2/8.10.2 -272-:220:501:501:250:250:501:250:250:252:250:250:502:250:250:250
Sendmail 8.10.2/8.10.2 -273-:503:220:250:250:553:250:550:214:250:250:250:250:250:250:250
Sendmail 8.10.2/8.10.2 -274-:220:220:501:250:553:501:250:214:250:250:502:250:502:250:250
Sendmail 8.10.2/8.10.2 -275-:503:220:250:250:250:250:250:250:252:502:502:250:502:250:250
Sendmail 8.10.2/8.10.2 -276-:503:501:250:250:250:501:250:250:252:250:250:502:250:250:250
Sendmail 8.10.2/8.10.2 -277-:503:501:250:250:553:501:550:250:252:250:250:250:250:250:250
Sendmail 8.10.2/8.10.2 -278-:503:501:250:250:250:501:550:250:252:502:502:502:502:250:250
Sendmail 8.10.2/8.10.2 -279-:503:220:250:250:553:501:250:250:252:502:250:250:250:250:250
Sendmail 8.10.2/8.10.2 -280-:220:220:250:250:553:501:250:250:250:502:502:502:250:250:220
Sendmail 8.10.2/8.10.2 -281-:503:501:501:250:553:501:250:214:252:250:250:502:502:250:250
Sendmail 8.10.2/8.10.2 -282-:220:220:250:250:250:501:250:250:252:250:250:502:502:250:220
Sendmail 8.10.2/8.10.2 -283-:503:220:250:250:553:501:550:214:252:250:502:502:502:250:250
Sendmail 8.10.2/8.10.2 -284-:220:501:250:250:553:250:550:250:250:250:502:502:250:250:250
Sendmail 8.10.2/8.10.2 -285-:220:220:501:250:250:250:250:250:252:502:250:250:502:250:250
Sendmail 8.10.2/8.10.2 -286-:220:220:250:250:250:250:250:214:250:502:502:502:502:250:220
Sendmail 8.10.2/8.10.2 -287-:220:220:501:250:553:501:250:214:252:502:250:250:502:250:250
Sendmail 8.10.2/8.10.2 -288-:503:220:250:250:553:250:250:214:250:250:250:250:250:250:220
Sendmail 8.10.2/8.10.2 -289-:220:220:501:250:250:250:250:250:250:502:250:250:502:250:250
Sendmail 8.10.2/8.10.2 -290-:220:220:250:250:553:250:550:214:252:250:502:502:502:250:250
Sendmail 8.10.2/8.10.2 -291-:220:220:501:250:250:501:550:250:250:250:502:250:502:250:250
Sendmail 8.10.2/8.10.2 -292-:503:220:250:250:250:250:250:250:252:502:250:250:250:250:220
Sendmail 8.10.2/8.10.2 -293-:503:220:501:250:553:250:550:214:250:250:502:502:502:250:220
Sendmail 8.10.2/8.10.2 -294-:503:220:501:250:250:501:250:250:252:502:502:502:250:250:250
Sendmail 8.10.2/8.10.2 -295-:503:220:250:250:250:250:250:250:252:502:502:502:250:250:250
Sendmail 8.10.2/8.10.2 -296-:220:220:250:250:553:250:250:214:250:502:250:502:502:250:220
Sendmail 8.10.2/8.10.2 -297-:503:220:250:250:250:501:250:214:250:502:502:502:502:250:250
Sendmail 8.10.2/8.10.2 -298-:220:220:250:250:250:250:250:214:250:502:502:502:250:250:220
Sendmail 8.10.2/8.10.2 -299-:503:220:250:250:553:250:250:214:250:250:250:250:502:250:220
Sendmail 8.10.2/8.10.2 -300-:220:220:250:250:553:250:550:214:252:250:502:250:250:250:220
Sendmail 8.10.2/8.10.2 -301-:220:220:250:250:553:501:250:250:252:250:250:502:502:250:220
Sendmail 8.10.2/8.10.2 -302-:220:501:250:250:250:501:250:250:252:502:502:250:502:250:250
Sendmail 8.10.2/8.10.2 -303-:503:220:501:250:250:501:250:250:252:250:250:250:250:250:220
Sendmail 8.10.2/8.10.2 -304-:220:501:501:250:553:250:550:214:252:250:250:502:250:250:220
Sendmail 8.10.2/8.10.2 -305-:503:501:501:250:250:501:250:250:252:502:250:502:250:250:220
Sendmail 8.10.2/8.10.2 -306-:220:220:250:250:553:501:250:214:252:502:502:250:502:250:250
Sendmail 8.10.2/8.10.2 -307-:503:501:501:250:553:501:250:214:252:502:250:250:502:250:250
Sendmail 8.10.2/8.10.2 -308-:220:501:250:250:553:250:250:214:250:250:502:502:250:250:220
Sendmail 8.10.2/8.10.2 -309-:220:220:250:250:250:250:250:214:250:502:250:502:502:250:250
Sendmail 8.10.2/8.10.2 -310-:220:220:501:250:553:501:250:250:252:250:502:250:502:250:220
Sendmail 8.10.2/8.10.2 -311-:503:501:250:250:553:250:250:250:252:502:502:502:250:250:220
Sendmail 8.10.2/8.10.2 -312-:220:220:250:250:250:501:250:214:250:250:502:250:250:250:220
Sendmail 8.10.2/8.10.2 -313-:503:220:501:250:250:501:250:250:250:502:502:502:502:250:250
Sendmail 8.10.2/8.10.2 -314-:503:501:250:250:553:250:550:214:250:250:502:502:502:250:220
Sendmail 8.10.2/8.10.2 -315-:220:220:250:250:250:501:550:250:252:250:250:250:250:250:220
Sendmail 8.10.2/8.10.2 -316-:503:220:501:250:250:250:250:214:252:502:250:250:502:250:250
Sendmail 8.10.2/8.10.2 -317-:503:220:501:250:250:501:550:250:250:250:250:250:250:250:220
Sendmail 8.10.2/8.10.2 -318-:503:501:250:250:250:250:250:250:250:250:502:502:502:250:250
Sendmail 8.10.2/8.10.2 -319-:220:220:250:250:250:501:550:214:250:502:502:502:250:250:250
Sendmail 8.10.2/8.10.2 -320-:220:220:250:250:250:250:550:214:250:502:250:250:250:250:220
Sendmail 8.10.2/8.10.2 -321-:220:220:501:250:250:501:550:214:252:502:250:250:502:250:220
Sendmail 8.10.2/8.10.2 -322-:220:501:250:250:250:250:250:250:250:250:502:250:250:250:250
Sendmail 8.10.2/8.10.2 -323-:220:220:501:250:553:250:250:250:250:502:502:502:502:250:220
Sendmail 8.10.2/8.10.2 -324-:220:220:501:250:250:501:250:250:252:250:502:250:502:250:220
Sendmail 8.10.2/8.10.2 -325-:220:501:250:250:553:501:550:250:252:502:502:502:250:250:250
Sendmail 8.10.2/8.10.2 -326-:220:220:250:250:250:250:250:214:252:250:250:250:502:250:220
Sendmail 8.10.2/8.10.2 -327-:220:220:250:250:250:501:250:250:252:250:502:250:250:250:250
Sendmail 8.10.2/8.10.2 -328-:220:501:501:250:250:501:250:214:250:502:250:250:250:250:220
Sendmail 8.10.2/8.10.2 -329-:503:220:250:250:250:250:550:214:250:502:502:502:502:250:250
Sendmail 8.10.2/8.10.2 -330-:220:501:501:250:553:250:250:250:250:250:250:502:250:250:220
Sendmail 8.10.2/8.10.2 -331-:503:501:501:250:553:250:550:250:250:250:250:250:502:250:250
Sendmail 8.10.2/8.10.2 -332-:503:501:250:250:553:250:550:250:252:502:502:250:250:250:250
Sendmail 8.10.2/8.10.2 -333-:220:220:250:250:250:501:250:250:250:250:502:250:250:250:250
Sendmail 8.10.2/8.10.2 -334-:220:220:501:250:250:250:250:214:252:250:250:250:502:250:220
Sendmail 8.10.2/8.10.2 -335-:503:220:250:250:250:501:250:250:250:250:250:502:502:250:250
Sendmail 8.10.2/8.10.2 -336-:503:220:501:250:553:501:550:214:252:502:250:502:502:250:250
Sendmail 8.10.2/8.10.2 -337-:220:501:501:250:250:250:250:214:252:502:250:250:502:250:220
Sendmail 8.10.2/8.10.2 -338-:220:220:501:250:250:250:550:214:252:250:250:250:502:250:220
Sendmail 8.10.2/8.10.2 -339-:503:501:501:250:250:250:250:214:252:502:502:250:502:250:250
Sendmail 8.10.2/8.10.2 -340-:220:501:250:250:553:501:550:250:250:502:250:250:250:250:250
Sendmail 8.10.2/8.10.2 -341-:503:220:250:250:250:501:250:214:252:250:502:250:502:250:220
Sendmail 8.10.2/8.10.2 -342-:220:220:501:250:250:501:550:250:252:250:502:250:502:250:250
Sendmail 8.10.2/8.10.2 -343-:220:220:250:250:553:501:250:250:252:250:250:250:250:250:220
Sendmail 8.10.2/8.10.2 -344-:220:220:501:250:553:501:250:214:250:250:250:502:250:250:220
Sendmail 8.10.2/8.10.2 -345-:220:220:250:250:553:250:250:214:250:502:250:502:250:250:250
Sendmail 8.10.2/8.10.2 -346-:220:220:250:250:250:501:250:250:250:250:250:502:250:250:220
Sendmail 8.10.2/8.10.2 -347-:503:501:501:250:553:250:550:250:252:250:250:250:502:250:250
Sendmail 8.10.2/8.10.2 -348-:503:501:501:250:553:250:250:250:250:502:502:250:502:250:250
Sendmail 8.10.2/8.10.2 -349-:220:220:250:250:250:250:550:214:252:250:502:502:250:250:220
Sendmail 8.10.2/8.10.2 -350-:220:220:250:250:553:250:250:250:252:250:502:250:250:250:250
Sendmail 8.10.2/8.10.2 -351-:503:220:250:250:250:250:250:250:250:502:250:250:250:250:220
Sendmail 8.10.2/8.10.2 -352-:503:220:501:250:553:250:250:214:252:502:250:502:250:250:250
Sendmail 8.10.2/8.10.2 -353-:220:501:250:250:250:501:550:214:252:250:502:250:250:250:220
Sendmail 8.10.2/8.10.2 -354-:220:501:501:250:553:250:250:250:252:250:250:502:250:250:220
Sendmail 8.10.2/8.10.2 -355-:503:501:501:250:250:501:250:250:250:502:250:502:250:250:250
Sendmail 8.10.2/8.10.2 -356-:503:220:501:250:250:250:250:214:252:502:502:502:250:250:220
Sendmail 8.10.2/8.10.2 -357-:503:501:250:250:553:501:250:214:252:502:250:502:502:250:220
Sendmail 8.10.2/8.10.2 -358-:220:220:501:250:553:501:550:250:252:250:250:502:502:250:250
Sendmail 8.10.2/8.10.2 -359-:220:220:501:250:553:250:250:250:252:502:502:502:502:250:220
Sendmail 8.10.2/8.10.2 -360-:220:220:501:250:553:250:250:250:250:250:502:502:502:250:250
Sendmail 8.10.2/8.10.2 -361-:503:220:250:250:553:501:550:214:252:502:502:502:502:250:250
Sendmail 8.10.2/8.10.2 -362-:220:220:250:250:250:250:250:250:250:502:502:250:250:250:220
Sendmail 8.10.2/8.10.2 -363-:220:501:501:250:250:501:250:214:252:502:250:502:502:250:250
Sendmail 8.10.2/8.10.2 -364-:220:501:250:250:553:501:250:214:250:502:250:250:250:250:220
Sendmail 8.10.2/8.10.2 -365-:220:501:501:250:553:250:550:214:252:502:502:502:502:250:250
Sendmail 8.10.2/8.10.2 -366-:220:220:501:250:553:250:250:250:250:250:250:502:250:250:220
Sendmail 8.10.2/8.10.2 -367-:503:501:501:250:250:501:550:250:250:250:502:502:502:250:220
Sendmail 8.10.2/8.10.2 -368-:220:220:250:250:250:501:250:214:250:250:502:502:250:250:220
Sendmail 8.10.2/8.10.2 -369-:503:220:250:250:553:250:250:250:250:502:250:502:502:250:250
Sendmail 8.10.2/8.10.2 -370-:220:220:501:250:553:501:250:250:252:250:502:250:250:250:250
Sendmail 8.10.2/8.10.2 -371-:220:220:501:250:250:250:250:214:250:502:502:250:250:250:250
Sendmail 8.10.2/8.10.2 -372-:220:501:501:250:250:501:250:250:252:502:250:250:250:250:220
Sendmail 8.10.2/8.10.2 -373-:503:220:250:250:553:250:250:250:250:502:502:502:250:250:220
Sendmail 8.10.2/8.10.2 -374-:220:501:250:250:250:250:250:214:252:250:250:250:502:250:250
Sendmail 8.10.2/8.10.2 -375-:503:220:501:250:553:250:550:250:250:250:250:502:250:250:220
Sendmail 8.10.2/8.10.2 -376-:220:220:250:250:250:250:250:214:250:250:250:250:250:250:250
Sendmail 8.10.2/8.10.2 -377-:503:220:250:250:553:501:250:250:250:502:250:250:250:250:220
Sendmail 8.10.2/8.10.2 -378-:220:220:250:250:553:250:250:214:250:250:502:250:502:250:250
Sendmail 8.10.2/8.10.2 -379-:220:220:250:250:553:250:250:214:252:502:250:250:250:250:220
Sendmail 8.10.2/8.10.2 -380-:503:501:501:250:250:501:550:214:252:250:250:250:502:250:220
Sendmail 8.10.2/8.10.2 -381-:503:220:250:250:553:501:250:250:250:250:250:250:502:250:220
Sendmail 8.10.2/8.10.2 -382-:220:501:501:250:250:501:250:250:252:502:250:502:250:250:250
Sendmail 8.10.2/8.10.2 -383-:503:220:501:250:250:501:250:214:252:250:250:250:502:250:250
Sendmail 8.10.2/8.10.2 -384-:503:501:501:250:553:250:550:214:252:250:250:250:250:250:220
Sendmail 8.10.2/8.10.2 -385-:220:220:250:250:553:250:250:250:250:250:250:502:502:250:250
Sendmail 8.10.2/8.10.2 -386-:220:501:501:250:250:501:550:214:252:250:502:502:250:250:220
Sendmail 8.10.2/8.10.2 -387-:503:220:501:250:553:250:250:250:252:502:502:250:502:250:220
Sendmail 8.10.2/8.10.2 -388-:503:501:250:250:250:250:250:214:250:250:250:250:250:250:220
Sendmail 8.10.2/8.10.2 -389-:220:220:250:250:250:250:550:214:250:502:250:502:250:250:220
Sendmail 8.10.2/8.10.2 -390-:220:220:250:250:250:501:550:250:250:502:502:250:250:250:220
Sendmail 8.10.2/8.10.2 -391-:503:220:250:250:250:250:250:250:250:502:502:502:250:250:250
Sendmail 8.10.2/8.10.2 -392-:220:501:250:250:250:501:550:214:252:502:250:250:250:250:220
Sendmail 8.10.2/8.10.2 -393-:220:220:250:250:250:501:550:214:250:250:502:250:502:250:220
Sendmail 8.10.2/8.10.2 -394-:220:501:501:250:250:250:550:214:252:502:250:250:250:250:220
Sendmail 8.10.2/8.10.2 -395-:503:220:501:250:553:501:250:250:250:250:502:502:502:250:250
Sendmail 8.10.2/8.10.2 -396-:220:220:250:250:250:250:550:214:250:502:250:250:502:250:250
Sendmail 8.10.2/8.10.2 -397-:220:220:501:250:250:250:550:214:252:502:502:250:502:250:250
Sendmail 8.10.2/8.10.2 -398-:220:220:250:250:250:501:250:250:252:250:502:250:502:250:250
Sendmail 8.10.2/8.10.2 -399-:503:220:250:250:553:501:550:250:252:502:502:502:250:250:250
Sendmail 8.10.2/8.10.2 -400-:220:220:250:250:250:501:550:214:252:250:250:250:502:250:220
Sendmail 8.10.2/8.10.2 -401-:503:501:501:250:553:250:250:214:250:502:502:502:250:250:250
Sendmail 8.10.2/8.10.2 -402-:503:220:501:250:250:250:250:250:250:250:502:502:502:250:220
Sendmail 8.10.2/8.10.2 -403-:220:220:250:250:250:501:550:214:252:502:502:250:250:250:220
Sendmail 8.10.2/8.10.2 -404-:220:220:501:250:250:501:250:250:250:250:250:502:502:250:250
Sendmail 8.10.2/8.10.2 -405-:503:220:250:250:250:250:250:214:250:250:250:250:250:250:220
Sendmail 8.10.2/8.10.2 -406-:503:220:250:250:250:250:550:250:252:250:250:250:250:250:220
Sendmail 8.10.2/8.10.2 -407-:220:220:250:250:250:250:550:214:252:502:250:250:502:250:220
Sendmail 8.10.2/8.10.2 -408-:220:501:250:250:553:501:250:250:250:250:502:502:502:250:220
Sendmail 8.10.2/8.10.2 -409-:503:501:501:250:553:501:250:214:252:502:502:502:250:250:250
Sendmail 8.10.2/8.10.2 -410-:503:220:250:250:553:501:550:214:250:250:502:502:250:250:250
Sendmail 8.10.2/8.10.2 -411-:220:220:250:250:250:250:550:214:250:250:250:502:250:250:220
Sendmail 8.10.2/8.10.2 -412-:503:220:501:250:250:250:550:214:252:502:502:250:502:250:250
Sendmail 8.10.2/8.10.2 -413-:220:220:501:250:250:250:550:214:250:250:502:250:250:250:250
Sendmail 8.10.2/8.10.2 -414-:503:501:501:250:553:501:550:214:252:250:250:502:250:250:250
Sendmail 8.10.2/8.10.2 -415-:503:220:250:250:553:501:250:214:252:502:502:502:250:250:250
Sendmail 8.10.2/8.10.2 -416-:503:501:501:250:553:501:250:250:252:250:502:250:502:250:250
Sendmail 8.10.2/8.10.2 -417-:503:220:250:250:250:501:250:250:250:502:502:502:502:250:220
Sendmail 8.10.2/8.10.2 -418-:503:501:250:250:250:250:250:214:252:250:502:502:502:250:220
Sendmail 8.10.2/8.10.2 -419-:503:220:501:250:250:501:250:250:250:502:250:502:250:250:220
Sendmail 8.10.2/8.10.2 -420-:220:220:250:250:250:501:550:250:250:250:250:502:502:250:250
Sendmail 8.10.2/8.10.2 -421-:503:220:501:250:250:501:250:250:250:250:250:502:502:250:220
Sendmail 8.10.2/8.10.2 -422-:220:501:501:250:250:250:250:250:252:250:502:250:250:250:250
Sendmail 8.10.2/8.10.2 -423-:503:501:250:250:553:501:250:214:250:250:250:502:502:250:220
Sendmail 8.10.2/8.10.2 -424-:503:501:501:250:250:250:250:214:250:502:502:502:250:250:250
Sendmail 8.10.2/8.10.2 -425-:220:220:250:250:250:250:250:214:250:250:250:250:250:250:220
Sendmail 8.10.2/8.10.2 -426-:503:220:250:250:250:501:550:214:250:250:250:250:502:250:220
Sendmail 8.10.2/8.10.2 -427-:503:501:501:250:250:501:250:250:252:502:502:502:502:250:220
Sendmail 8.10.2/8.10.2 -428-:503:220:250:250:250:501:250:250:252:502:250:250:250:250:220
Sendmail 8.10.2/8.10.2 -429-:503:220:250:250:250:250:250:214:250:502:250:250:250:250:250
Sendmail 8.10.2/8.10.2 -430-:220:220:250:250:553:501:550:214:252:502:250:502:250:250:220
Sendmail 8.10.2/8.10.2 -431-:220:220:501:250:553:501:250:214:252:502:502:502:250:250:220
Sendmail 8.10.2/8.10.2 -432-:220:220:250:250:250:501:250:214:252:502:502:250:250:250:250
Sendmail 8.10.2/8.10.2 -433-:220:220:501:250:250:250:550:250:250:250:502:250:250:250:250
Sendmail 8.10.2/8.10.2 -434-:220:220:250:250:553:501:550:214:252:502:250:502:502:250:250
Sendmail 8.10.2/8.10.2 -435-:220:501:501:250:250:501:250:250:252:502:502:250:502:250:220
Sendmail 8.10.2/8.10.2 -436-:220:501:250:250:250:501:250:214:250:250:502:250:250:250:220
Sendmail 8.10.2/8.10.2 -437-:220:501:250:250:553:250:250:250:252:250:250:502:502:250:250
Sendmail 8.10.2/8.10.2 -438-:503:501:250:250:250:250:250:250:250:250:250:502:502:250:250
Sendmail 8.10.2/8.10.2 -439-:503:220:501:250:250:250:250:214:252:502:250:250:250:250:250
Sendmail 8.10.2/8.10.2 -440-:220:220:250:250:553:501:250:214:252:250:250:502:502:250:250
Sendmail 8.10.2/8.10.2 -441-:220:220:250:250:250:250:250:214:252:250:502:502:250:250:250
Sendmail 8.10.2/8.10.2 -442-:503:220:250:250:250:250:250:214:252:502:502:502:502:250:250
Sendmail 8.10.2/8.10.2 -443-:503:501:250:250:553:501:250:250:250:250:502:250:502:250:250
Sendmail 8.10.2/8.10.2 -444-:220:501:250:250:250:501:250:250:252:250:502:502:250:250:220
Sendmail 8.10.2/8.10.2 -445-:503:501:501:250:553:501:250:214:252:250:502:502:502:250:220
Sendmail 8.10.2/8.10.2 -446-:503:220:250:250:553:501:550:250:250:502:250:250:502:250:250
Sendmail 8.10.2/8.10.2 -447-:220:501:501:250:250:250:550:214:252:502:250:250:502:250:220
Sendmail 8.10.2/8.10.2 -448-:220:220:250:250:250:250:550:214:252:250:250:250:250:250:220
Sendmail 8.10.2/8.10.2 -449-:220:501:250:250:250:501:250:250:252:502:502:502:250:250:220
Sendmail 8.10.2/8.10.2 -450-:503:501:250:250:553:250:250:214:252:502:502:502:502:250:220
Sendmail 8.10.2/8.10.2 -451-:503:501:250:250:250:250:250:250:252:250:502:250:250:250:250
Sendmail 8.10.2/8.10.2 -452-:503:501:501:250:553:501:250:214:252:502:502:502:502:250:220
Sendmail 8.10.2/8.10.2 -453-:503:220:501:250:250:501:250:250:250:502:502:250:250:250:250
Sendmail 8.10.2/8.10.2 -454-:220:220:250:250:250:250:250:214:250:250:250:250:502:250:250
Sendmail 8.10.2/8.10.2 -455-:220:501:501:250:553:501:250:214:250:502:502:250:502:250:250
Sendmail 8.10.2/8.10.2 -456-:220:501:501:250:553:501:550:250:252:250:502:502:250:250:250
Sendmail 8.10.2/8.10.2 -457-:220:220:501:250:250:501:250:250:252:250:250:250:250:250:250
Sendmail 8.10.2/8.10.2 -458-:220:220:250:250:553:250:550:214:252:502:502:502:502:250:250
Sendmail 8.10.2/8.10.2 -459-:220:501:501:250:553:250:550:250:252:250:250:502:502:250:220
Sendmail 8.10.2/8.10.2 -460-:220:501:501:250:250:501:250:250:250:502:250:502:502:250:250
Sendmail 8.10.2/8.10.2 -461-:503:501:250:250:250:250:250:214:252:250:250:250:250:250:220
Sendmail 8.10.2/8.10.2 -462-:503:501:501:250:250:250:250:250:250:250:502:502:250:250:250
Sendmail 8.10.2/8.10.2 -463-:503:220:501:250:553:501:550:214:252:250:250:502:502:250:220
Sendmail 8.10.2/8.10.2 -464-:503:501:250:250:250:250:250:250:252:502:250:250:502:250:220
Sendmail 8.10.2/8.10.2 -465-:503:501:501:250:250:250:250:214:250:250:250:250:250:250:250
Sendmail 8.10.2/8.10.2 -466-:503:220:250:250:553:250:250:214:252:502:502:250:502:250:250
Sendmail 8.10.2/8.10.2 -467-:220:220:501:250:250:250:250:250:250:502:250:250:250:250:250
Sendmail 8.10.2/8.10.2 -468-:220:220:250:250:553:250:250:214:250:250:250:250:250:250:250
Sendmail 8.10.2/8.10.2 -469-:503:220:250:250:250:501:250:250:252:502:502:250:250:250:250
Sendmail 8.10.2/8.10.2 -470-:220:220:250:250:250:501:250:250:252:250:250:250:250:250:220
Sendmail 8.10.2/8.10.2 -471-:503:501:501:250:250:501:250:250:250:250:502:502:250:250:220
Sendmail 8.10.2/8.10.2 -472-:220:220:501:250:553:250:250:214:250:250:502:502:502:250:250
Sendmail 8.10.2/8.10.2 -473-:220:220:501:250:553:250:250:214:252:250:250:250:502:250:250
Sendmail 8.10.2/8.10.2 -474-:220:220:250:250:553:501:250:250:252:502:250:502:250:250:250
Sendmail 8.10.2/8.10.2 -475-:220:501:250:250:553:501:250:250:252:250:250:250:250:250:220
Sendmail 8.10.2/8.10.2 -476-:220:220:250:250:250:501:550:214:252:502:250:502:502:250:220
Sendmail 8.10.2/8.10.2 -477-:220:220:250:250:250:501:550:250:252:502:502:502:502:250:250
Sendmail 8.10.2/8.10.2 -478-:220:501:250:250:553:501:250:250:250:250:250:502:502:250:250
Sendmail 8.10.2/8.10.2 -479-:503:501:501:250:553:501:550:214:252:250:250:250:502:250:220
Sendmail 8.10.2/8.10.2 -480-:503:501:501:250:250:250:250:214:252:502:502:502:250:250:220
Sendmail 8.10.2/8.10.2 -481-:220:220:501:250:553:501:250:214:250:250:250:250:502:250:250
Sendmail 8.10.2/8.10.2 -482-:503:220:250:250:250:250:250:214:250:502:502:250:250:250:220
Sendmail 8.10.2/8.10.2 -483-:220:220:250:250:250:501:250:214:252:502:502:502:502:250:250
Sendmail 8.10.2/8.10.2 -484-:503:501:250:250:250:250:250:214:252:250:502:250:502:250:220
Sendmail 8.10.2/8.10.2 -485-:503:220:501:250:553:501:250:250:252:502:250:250:250:250:250
Sendmail 8.10.2/8.10.2 -486-:503:501:250:250:553:501:250:214:250:502:250:250:250:250:250
Sendmail 8.10.2/8.10.2 -487-:503:220:250:250:250:250:250:214:250:250:250:250:502:250:220
Sendmail 8.10.2/8.10.2 -488-:220:501:250:250:250:501:550:250:250:502:502:250:502:250:250
Sendmail 8.10.2/8.10.2 -489-:503:220:250:250:250:250:250:250:250:250:502:250:502:250:220
Sendmail 8.10.2/8.10.2 -490-:220:220:250:250:553:501:250:250:252:250:502:502:250:250:250
Sendmail 8.10.2/8.10.2 -491-:220:220:250:250:553:501:250:250:250:502:502:502:250:250:250
Sendmail 8.10.2/8.10.2 -492-:220:501:501:250:553:250:250:250:250:250:250:250:250:250:220
Sendmail 8.10.2/8.10.2 -493-:220:501:501:250:250:501:250:250:252:502:502:502:502:250:250
Sendmail 8.10.2/8.10.2 -494-:220:220:250:250:250:501:550:250:252:250:502:250:502:250:220
Sendmail 8.10.2/8.10.2 -495-:503:220:250:250:250:501:250:250:252:250:502:502:250:250:220
Sendmail 8.10.2/8.10.2 -496-:220:501:250:250:553:501:250:250:250:250:250:502:250:250:220
Sendmail 8.10.2/8.10.2 -497-:503:501:501:250:250:501:250:214:250:502:502:502:502:250:220
Sendmail 8.10.2/8.10.2 -498-:503:220:250:250:553:501:550:214:250:250:250:502:502:250:250
Sendmail 8.10.2/8.10.2 -499-:220:501:501:250:250:501:250:214:252:502:502:250:250:250:220
Sendmail 8.10.2/8.10.2 -500-:503:220:250:250:553:250:250:214:250:250:502:250:250:250:220
Sendmail 8.10.2/8.10.2 -501-:220:501:250:250:553:250:250:214:250:250:250:502:250:250:250
Sendmail 8.10.2/8.10.2 -502-:220:501:501:250:250:250:250:214:250:502:502:250:250:250:220
Sendmail 8.10.2/8.10.2 -503-:503:501:501:250:250:501:250:250:250:502:502:502:502:250:220
Sendmail 8.10.2/8.10.2 -504-:503:501:501:250:250:250:250:250:250:250:502:502:502:250:250
Sendmail 8.10.2/8.10.2 -505-:503:220:250:250:553:501:550:250:252:502:502:250:502:250:250
Sendmail 8.10.2/8.10.2 -506-:220:220:250:250:553:501:250:250:250:250:250:502:502:250:250
Sendmail 8.10.2/8.10.2 -507-:503:501:501:250:553:250:250:214:252:250:250:250:502:250:250
Sendmail 8.10.2/8.10.2 -508-:220:220:501:250:553:501:250:250:250:502:250:250:250:250:220
Sendmail 8.10.2/8.10.2 -509-:220:220:501:250:553:501:550:250:250:502:250:250:250:250:220
Sendmail 8.10.2/8.10.2 -510-:503:501:501:250:250:250:250:214:252:502:502:502:502:250:220
Sendmail 8.10.2/8.10.2 -511-:220:501:250:250:553:501:250:250:252:502:502:250:250:250:250
Sendmail 8.10.2/8.10.2 -512-:503:220:501:250:250:501:550:214:252:250:250:502:250:250:250
Sendmail 8.10.2/8.10.2 -513-:503:501:250:250:553:250:250:250:252:250:502:250:250:250:250
Sendmail 8.10.2/8.10.2 -514-:503:501:501:250:553:501:250:214:250:250:502:502:502:250:250
Sendmail 8.10.2/8.10.2 -515-:503:501:250:250:250:501:250:250:252:250:250:502:502:250:220
Sendmail 8.10.2/8.10.2 -516-:220:220:250:250:553:501:250:214:252:502:502:502:250:250:250
Sendmail 8.10.2/8.10.2 -517-:220:501:501:250:250:250:250:250:250:502:502:502:502:250:250
Sendmail 8.10.2/8.10.2 -518-:503:501:501:250:250:250:550:250:252:502:250:250:250:250:220
Sendmail 8.10.2/8.10.2 -519-:503:501:501:250:250:501:250:250:250:502:502:250:250:250:250
Sendmail 8.10.2/8.10.2 -520-:503:501:250:250:250:250:250:250:250:250:502:250:250:250:250
Sendmail 8.10.2/8.10.2 -521-:220:220:501:250:250:501:250:250:250:250:250:250:250:250:220
Sendmail 8.10.2/8.10.2 -522-:220:501:250:250:553:250:250:250:250:250:250:502:250:250:250
Sendmail 8.10.2/8.10.2 -523-:503:501:250:250:553:250:250:214:252:502:250:502:502:250:220
Sendmail 8.10.2/8.10.2 -524-:220:220:501:250:553:501:550:214:252:502:250:502:250:250:250
Sendmail 8.10.2/8.10.2 -525-:503:220:250:250:553:250:250:250:250:250:502:250:250:250:220
Sendmail 8.10.2/8.10.2 -526-:220:220:501:250:250:501:550:214:252:502:250:250:250:250:220
Sendmail 8.10.2/8.10.2 -527-:503:501:501:250:553:250:250:214:250:250:250:502:502:250:250
Sendmail 8.10.2/8.10.2 -528-:503:220:501:250:250:250:250:214:252:502:250:250:250:250:220
Sendmail 8.10.2/8.10.2 -529-:220:501:501:250:250:250:250:250:252:502:250:250:502:250:220
Sendmail 8.10.2/8.10.2 -530-:220:220:250:250:250:250:550:214:250:502:502:250:502:250:250
Sendmail 8.10.2/8.10.2 -531-:503:220:250:250:250:250:250:250:250:250:250:502:502:250:250
Sendmail 8.10.2/8.10.2 -532-:220:220:501:250:553:501:550:214:252:502:502:502:502:250:250
Sendmail 8.10.2/8.10.2 -533-:503:220:250:250:553:250:250:214:252:250:250:250:502:250:220
Sendmail 8.10.2/8.10.2 -534-:503:220:250:250:553:501:250:502:252:250:250:502:502:250:250
Sendmail 8.10.2/8.10.2 -535-:503:501:250:250:553:501:550:250:252:502:502:502:250:250:220
Sendmail 8.10.2/8.10.2 -536-:220:220:250:250:553:501:550:214:250:502:502:502:250:250:220
Sendmail 8.10.2/8.10.2 -537-:220:220:501:250:250:250:550:250:250:502:502:250:502:250:250
Sendmail 8.10.2/8.10.2 -538-:503:501:501:250:553:501:250:250:250:250:250:250:250:250:220
Sendmail 8.10.2/8.10.2 -539-:503:220:501:250:250:501:550:214:252:250:502:250:250:250:220
Sendmail 8.10.2/8.10.2 -540-:503:501:501:250:553:250:550:214:252:502:502:250:502:250:220
Sendmail 8.10.2/8.10.2 -541-:503:220:250:250:250:250:250:214:250:250:502:250:502:250:220
Sendmail 8.10.2/8.10.2 -542-:503:220:501:250:250:250:550:250:252:250:250:502:502:250:250
Sendmail 8.10.2/8.10.2 -543-:503:220:250:250:553:250:550:214:250:502:502:502:250:250:250
Sendmail 8.10.2/8.10.2 -544-:220:501:250:250:553:250:250:214:250:250:250:502:250:250:220
Sendmail 8.10.2/8.10.2 -545-:220:220:501:250:553:250:250:214:252:250:502:502:250:250:250
Sendmail 8.10.2/8.10.2 -546-:220:220:501:250:250:501:250:250:250:250:502:502:502:250:220
Sendmail 8.10.2/8.10.2 -547-:220:220:250:250:250:250:250:250:252:250:502:502:502:250:220
Sendmail 8.10.2/8.10.2 -548-:220:220:250:250:250:250:550:250:250:250:502:502:250:250:220
Sendmail 8.10.2/8.10.2 -549-:503:220:501:250:250:501:250:250:250:502:250:250:502:250:250
Sendmail 8.10.2/8.10.2 -550-:503:501:250:250:250:250:250:250:250:502:502:502:502:250:250
Sendmail 8.10.2/8.10.2 -551-:503:501:501:250:250:250:250:250:250:502:502:502:502:250:220
Sendmail 8.10.2/8.10.2 -552-:503:220:501:250:250:250:250:214:250:250:502:502:502:250:220
Sendmail 8.10.2/8.10.2 -553-:220:220:501:250:250:250:250:250:252:250:250:502:502:250:250
Sendmail 8.10.2/8.10.2 -554-:220:501:250:250:250:250:250:250:250:250:250:250:502:250:220
Sendmail 8.10.2/8.10.2 -555-:503:501:250:250:250:501:250:250:252:502:502:250:250:250:220
Sendmail 8.10.2/8.10.2 -556-:220:501:501:250:553:501:550:214:252:502:250:502:250:250:250
Sendmail 8.10.2/8.10.2 -557-:503:501:250:250:553:250:250:250:250:502:250:502:502:250:220
Sendmail 8.10.2/8.10.2 -558-:220:220:250:250:250:501:250:214:252:502:502:502:250:250:250
Sendmail 8.10.2/8.10.2 -559-:503:220:250:250:250:250:550:214:252:502:250:250:250:250:220
Sendmail 8.10.2/8.10.2 -560-:503:220:250:250:250:250:250:250:250:250:502:502:250:250:220
Sendmail 8.10.2/8.10.2 -561-:503:501:501:250:553:501:550:214:252:502:502:250:250:250:250
Sendmail 8.10.2/8.10.2 -562-:503:220:250:250:553:501:250:250:250:250:502:502:502:250:220
Sendmail 8.10.2/8.10.2 -563-:503:501:250:250:250:250:550:214:250:502:502:250:502:250:220
Sendmail 8.10.2/8.10.2 -564-:503:501:501:250:250:501:250:214:252:250:502:502:502:250:250
Sendmail 8.10.2/8.10.2 -565-:503:501:501:250:553:250:250:214:250:502:250:250:502:250:220
Sendmail 8.10.2/8.10.2 -566-:220:220:501:250:250:501:550:214:252:502:502:502:502:250:250
Sendmail 8.10.2/8.10.2 -567-:220:220:501:250:250:501:550:250:250:502:250:250:502:250:220
Sendmail 8.10.2/8.10.2 -568-:220:501:250:250:250:250:250:250:250:250:250:502:250:250:220
Sendmail 8.10.2/8.10.2 -569-:220:501:250:250:250:501:250:214:252:502:502:250:502:250:220
Sendmail 8.10.2/8.10.2 -570-:220:220:250:250:250:501:250:250:250:502:250:502:250:250:220
Sendmail 8.10.2/8.10.2 -571-:503:220:501:250:553:501:250:214:252:502:250:502:502:250:220
Sendmail 8.10.2/8.10.2 -572-:503:220:250:250:250:501:550:214:252:250:502:502:502:250:250
Sendmail 8.10.2/8.10.2 -573-:220:220:501:250:553:501:250:250:252:502:502:502:250:250:220
Sendmail 8.10.2/8.10.2 -574-:220:501:250:250:553:501:250:214:250:250:502:502:502:250:220
Sendmail 8.10.2/8.10.2 -575-:220:220:250:250:250:501:550:214:252:250:250:250:502:250:250
Sendmail 8.10.2/8.10.2 -576-:220:220:250:250:250:250:250:214:252:502:250:250:250:250:220
Sendmail 8.10.2/8.10.2 -577-:503:220:250:250:553:250:250:250:250:250:250:250:250:250:250
Sendmail 8.10.2/8.10.2 -578-:503:501:501:250:250:501:250:214:250:250:502:502:502:250:250
Sendmail 8.10.2/8.10.2 -579-:503:220:250:250:250:501:250:250:252:250:502:250:250:250:220
Sendmail 8.10.2/8.10.2 -580-:220:501:250:250:250:501:250:250:250:250:502:502:502:250:250
Sendmail 8.10.2/8.10.2 -581-:220:220:250:250:250:501:250:214:252:250:250:250:250:250:250
Sendmail 8.10.2/8.10.2 -582-:220:220:501:250:553:250:250:250:252:250:250:250:250:250:250
Sendmail 8.10.2/8.10.2 -583-:220:220:250:250:553:501:250:214:252:502:502:502:502:250:250
Sendmail 8.10.2/8.10.2 -584-:220:501:501:250:250:501:250:214:252:250:250:250:502:250:220
Sendmail 8.10.2/8.10.2 -585-:220:220:501:250:250:501:550:214:252:502:502:250:502:250:250
Sendmail 8.10.2/8.10.2 -586-:503:501:250:250:250:501:550:214:252:250:250:250:502:250:220
Sendmail 8.10.2/8.10.2 -587-:503:220:250:250:553:250:250:214:252:502:502:502:250:250:250
Sendmail 8.10.2/8.10.2 -588-:220:501:501:250:553:501:550:214:250:250:250:502:502:250:250
Sendmail 8.10.2/8.10.2 -589-:503:220:501:250:553:501:250:214:250:502:502:502:250:250:220
Sendmail 8.10.2/8.10.2 -590-:503:220:250:250:250:501:250:250:252:250:250:502:250:250:220
Sendmail 8.10.2/8.10.2 -591-:220:220:250:250:250:250:550:250:250:502:250:502:502:250:220
Sendmail 8.10.2/8.10.2 -592-:503:220:250:250:553:501:550:250:250:250:502:502:250:250:250
Sendmail 8.10.2/8.10.2 -593-:503:501:250:250:553:501:250:214:252:250:250:502:250:250:250
Sendmail 8.10.2/8.10.2 -594-:503:501:250:250:250:250:250:250:252:502:502:250:502:250:250
Sendmail 8.10.2/8.10.2 -595-:220:220:250:250:250:250:550:250:250:502:250:502:502:250:250
Sendmail 8.10.2/8.10.2 -596-:503:220:250:250:553:501:550:214:250:250:250:250:250:250:220
Sendmail 8.10.2/8.10.2 -597-:220:220:250:250:553:250:550:214:250:250:502:502:502:250:250
Sendmail 8.10.2/8.10.2 -598-:220:501:501:250:250:501:250:250:252:250:502:502:502:250:250
Sendmail 8.10.2/8.10.2 -599-:220:220:250:250:250:250:250:250:250:502:502:502:250:250:250
Sendmail 8.10.2/8.10.2 -600-:503:220:501:250:250:501:550:250:250:250:502:250:502:250:250
Sendmail 8.10.2/8.10.2 -601-:220:501:501:250:250:250:250:214:252:502:250:502:502:250:220
Sendmail 8.10.2/8.10.2 -602-:220:220:250:250:250:250:550:214:252:502:502:502:502:250:220
Sendmail 8.10.2/8.10.2 -603-:503:501:250:250:250:501:250:214:250:250:502:250:250:250:220
Sendmail 8.10.2/8.10.2 -604-:220:501:250:250:553:250:250:214:250:502:502:502:502:250:220
Sendmail 8.10.2/8.10.2 -605-:503:220:501:250:553:250:550:214:250:502:502:502:250:250:250
Sendmail 8.10.2/8.10.2 -606-:220:220:501:250:250:250:250:250:252:250:250:502:250:250:220
Sendmail 8.10.2/8.10.2 -607-:220:501:501:250:553:501:550:250:250:250:250:250:502:250:250
Sendmail 8.10.2/8.10.2 -608-:220:220:501:250:250:501:550:214:250:502:502:250:250:250:250
Sendmail 8.10.2/8.10.2 -609-:503:501:501:250:250:501:250:250:250:502:502:502:250:250:250
Sendmail 8.10.2/8.10.2 -610-:220:501:250:250:553:250:550:250:252:502:502:250:502:250:220
Sendmail 8.10.2/8.10.2 -611-:220:501:501:250:250:501:250:250:250:250:502:502:250:250:220
Sendmail 8.10.2/8.10.2 -612-:503:220:501:250:250:250:250:250:250:502:502:250:502:250:250
Sendmail 8.10.2/8.10.2 -613-:503:220:250:250:250:501:250:214:250:250:250:502:250:250:250
Sendmail 8.10.2/8.10.2 -614-:220:220:501:250:553:501:550:214:250:502:250:250:502:250:250
Sendmail 8.10.2/8.10.2 -615-:220:220:250:250:553:501:250:214:250:250:250:502:250:250:220
Sendmail 8.10.2/8.10.2 -616-:220:220:250:250:553:501:550:250:252:502:250:250:502:250:250
Sendmail 8.10.2/8.10.2 -617-:220:501:250:250:553:501:550:214:252:250:502:250:250:250:250
Sendmail 8.10.2/8.10.2 -618-:220:501:250:250:553:501:250:250:250:502:502:502:502:250:250
Sendmail 8.10.2/8.10.2 -619-:503:220:250:250:250:501:550:214:252:502:250:502:502:250:250
Sendmail 8.10.2/8.10.2 -620-:220:501:250:250:250:501:550:250:252:250:250:250:250:250:220
Sendmail 8.10.2/8.10.2 -621-:220:220:501:250:553:250:550:250:250:502:502:250:502:250:220
Sendmail 8.10.2/8.10.2 -622-:220:220:501:250:553:501:250:250:250:250:502:250:250:250:250
Sendmail 8.10.2/8.10.2 -623-:220:220:250:250:250:250:250:250:252:250:502:250:250:250:250
Sendmail 8.10.2/8.10.2 -624-:503:501:250:250:553:250:550:214:250:250:502:250:250:250:250
Sendmail 8.10.2/8.10.2 -625-:503:501:250:250:250:501:250:250:252:250:250:250:250:250:220
Sendmail 8.10.2/8.10.2 -626-:503:501:501:250:553:250:250:250:252:502:502:250:502:250:220
Sendmail 8.10.2/8.10.2 -627-:503:501:501:250:553:250:250:250:250:250:502:502:502:250:250
Sendmail 8.10.2/8.10.2 -628-:503:220:250:250:250:250:250:250:252:250:250:250:250:250:250
Sendmail 8.10.2/8.10.2 -629-:503:220:501:250:250:250:250:250:252:250:502:502:250:250:250
Sendmail 8.10.2/8.10.2 -630-:220:501:250:250:250:250:550:250:252:502:250:502:250:250:250
Sendmail 8.10.2/8.10.2 -631-:220:501:250:250:250:501:250:250:252:250:502:250:502:250:250
Sendmail 8.10.2/8.10.2/SuSE Linux 8.10.0-0.3 -0-:503:501:501:250:250:501:550:214:252:502:250:502:502:250:250
Sendmail 8.10.2/8.10.2/SuSE Linux 8.10.0-0.3 -1-:503:501:501:250:553:501:550:214:252:502:502:502:502:250:250
Sendmail 8.11.0:250:501:501:250:553:501:550:214:252:502:502:502:502:250:250
Sendmail 8.11.0/8.11.0 -0-:250:501:501:250:553:250:550:250:250:250:502:250:250:250:250
Sendmail 8.11.0/8.11.0 -1-:250:501:501:250:553:250:250:214:250:250:502:502:502:250:250
Sendmail 8.11.0/8.11.0 -2-:452:501:501:452:553:452:503:214:250:250:502:502:502:250:250
Sendmail 8.11.0/8.11.0 -3-:250:220:501:250:553:250:250:214:250:250:250:250:250:250:250
Sendmail 8.11.0/8.11.0 -4-:503:501:501:250:553:501:550:502:252:502:502:502:502:250:250
Sendmail 8.11.0/8.11.0 -5-:220:220:501:250:250:250:250:214:250:250:502:502:250:250:250
Sendmail 8.11.0/8.11.0 -6-:250:501:501:250:553:250:250:214:250:250:502:502:502:250:220
Sendmail 8.11.0/8.11.0 -7-:220:501:501:250:553:250:250:250:250:250:250:502:502:250:250
Sendmail 8.11.0/8.11.0/SuSE Linux 8.11.0-0.4 -0-:503:501:501:250:553:451:550:214:252:502:502:502:502:250:250
Sendmail 8.11.0/8.11.0/SuSE Linux 8.11.0-0.4 -1-:503:501:501:250:553:501:550:214:252:502:502:250:502:250:250
Sendmail 8.11.0/8.11.2:250:501:250:250:553:250:550:214:250:250:502:502:502:250:250
Sendmail 8.11.0/8.9.3:250:501:501:250:553:250:250:502:252:250:502:502:502:250:250
Sendmail 8.11.0/MICROWEB:503:250:501:250:553:501:250:214:250:250:502:502:502:250:250
Sendmail 8.11.1/8.11.1 -0-:250:501:501:250:250:501:250:250:250:502:250:250:250:250:250
Sendmail 8.11.1/8.11.1 -1-:220:220:250:250:250:501:250:250:252:250:250:250:250:250:250
Sendmail 8.11.1/8.11.1 -2-:220:220:501:250:553:250:503:214:250:250:502:502:250:250:250
Sendmail 8.11.1/8.11.1 -3-:250:501:502:250:501:250:550:214:252:502:502:502:502:250:250
Sendmail 8.11.1/8.11.1 -4-:220:501:501:250:250:501:250:214:252:502:502:502:502:250:220
Sendmail 8.11.1/8.11.1 -5-:250:501:501:250:553:501:250:214:252:502:502:502:502:250:250
Sendmail 8.11.1/8.11.1 -6-:220:220:250:250:553:250:553:214:250:250:502:250:502:250:250
Sendmail 8.11.1/8.11.1 -7-:250:501:501:250:553:501:250:214:252:250:250:502:502:250:250
Sendmail 8.11.1/8.11.1 -8-:220:220:250:250:553:250:250:250:252:250:502:502:250:250:250
Sendmail 8.11.1/8.11.1 -9-:220:220:501:250:250:250:550:214:252:502:502:502:502:250:220
Sendmail 8.11.1/8.11.1 -10-:250:501:501:250:553:501:550:214:252:502:502:502:502:250:220
Sendmail 8.11.1/8.11.1 -11-:220:501:501:250:250:250:250:250:250:250:250:250:250:250:250
Sendmail 8.11.1/8.11.1 -12-:250:220:501:250:250:250:250:214:252:502:502:502:502:250:220
Sendmail 8.11.1/8.11.1 -13-:553:220:250:250:553:250:553:214:250:250:502:250:502:250:250
Sendmail 8.11.1/8.11.1 -14-:220:501:250:250:553:501:250:214:252:250:250:250:250:250:220
Sendmail 8.11.1/8.11.1 -15-:250:220:501:250:553:501:250:250:252:502:250:250:502:250:250
Sendmail 8.11.1/8.11.1 -16-:220:501:501:250:553:501:250:214:252:250:502:502:502:250:250
Sendmail 8.11.1/8.11.1 -17-:220:501:501:250:250:250:550:250:250:250:250:502:250:250:220
Sendmail 8.11.1/8.11.1 -18-:250:220:250:250:250:250:550:250:252:502:502:250:502:250:250
Sendmail 8.11.1/8.11.1 -19-:250:501:501:250:250:250:550:250:252:502:502:250:502:250:220
Sendmail 8.11.2 -0-:250:501:501:250:553:250:550:214:252:502:502:502:502:250:250
Sendmail 8.11.2 -1-:503:501:501:250:553:501:250:502:252:502:502:502:502:250:250
Sendmail 8.11.2/8.11.2 -0-:220:220:250:250:250:250:250:214:252:502:502:502:250:250:220
Sendmail 8.11.2/8.11.2 -1-:220:220:250:250:250:250:550:214:250:250:250:502:502:250:220
Sendmail 8.11.2/8.11.2 -2-:250:220:250:250:250:501:550:214:250:250:502:502:502:250:250
Sendmail 8.11.2/8.11.2 -3-:250:220:250:250:250:250:250:214:252:250:502:502:502:250:250
Sendmail 8.11.2/8.11.2 -4-:250:501:250:250:250:501:250:250:250:250:250:502:502:250:250
Sendmail 8.11.2/8.11.2/SuSE Linux 8.11.1-0.5 -0-:503:501:501:250:553:501:250:214:252:502:502:250:502:250:250
Sendmail 8.11.2/8.11.2/SuSE Linux 8.11.1-0.5 -1-:503:501:501:250:553:501:250:214:252:502:250:502:502:250:250
Sendmail 8.11.2/8.11.2/SuSE Linux 8.11.1-0.5 -2-:220:501:501:250:553:501:550:214:252:502:502:502:502:250:250
Sendmail 8.11.2/8.11.2/SuSE Linux 8.11.1-0.5 -3-:503:501:501:250:553:451:503:214:252:502:502:502:502:250:250
Sendmail 8.11.2p1:250:500:501:250:553:553:550:500:500:500:500:500:500:250:500
Sendmail 8.11.2/8.8.7 -0-:220:501:250:250:553:250:250:502:250:250:502:502:502:250:250
Sendmail 8.11.2/8.8.7 -1-:250:220:501:250:553:250:250:502:250:250:502:502:250:250:250
Sendmail 8.11.2/8.9.3 -0-:250:501:250:250:553:250:250:502:250:250:502:502:502:250:250
Sendmail 8.11.2/8.9.3 -1-:250:501:501:250:553:250:250:250:250:250:250:502:250:250:220
Sendmail 8.11.3/8.11.0:220:220:250:250:553:501:250:250:250:250:502:502:250:250:220
Sendmail 8.11.3/8.11.3 -0-:220:220:250:250:250:250:250:502:250:250:502:250:502:250:220
Sendmail 8.11.3/8.11.3 -1-:250:501:501:250:553:501:550:502:252:502:502:502:502:250:250
Sendmail 8.11.3/8.11.3 -2-:220:220:250:250:250:250:452:250:452:452:452:452:250:250:220
Sendmail 8.11.3/8.11.3 -3-:220:220:250:250:250:250:550:250:250:250:502:502:502:250:250
Sendmail 8.11.3/8.11.3 -4-:220:220:250:250:250:250:452:250:452:452:452:452:250:250:250
Sendmail 8.11.3/8.11.3/SuSE Linux 8.11.1-0.5 -0-:503:250:501:250:553:501:550:214:252:502:502:502:502:250:250
Sendmail 8.11.3/8.11.3/SuSE Linux 8.11.1-0.5 -1-:503:501:501:250:553:501:250:214:252:502:502:502:502:250:250
Sendmail 8.11.3/mysql/8.11.3 -0-:250:220:250:250:553:250:250:250:250:250:250:502:250:250:220
Sendmail 8.11.3/mysql/8.11.3 -1-:220:220:250:250:250:250:250:214:252:502:502:250:502:250:250
Sendmail 8.11.3/mysql/8.11.3 -2-:220:220:501:250:250:250:250:214:252:250:502:502:502:250:220
Sendmail 8.11.3/mysql/8.11.3 -3-:220:501:501:250:553:250:250:250:250:502:502:250:502:250:220
Sendmail 8.11.4/8.10.2:220:501:250:250:553:250:550:214:250:502:502:502:250:250:250
Sendmail 8.11.4/8.11.4 -0-:250:501:502:250:501:553:550:214:250:250:502:502:502:250:250
Sendmail 8.11.4/8.11.4 -1-:220:501:501:250:250:250:250:214:250:250:250:502:250:250:220
Sendmail 8.11.4/8.11.4 (2Fast Internet Services):250:220:501:250:250:250:550:214:250:250:250:502:502:250:250
Sendmail 8.11.4/8.9.3:220:501:250:250:553:250:550:250:250:250:250:502:502:250:220
Sendmail 8.11.5:250:501:501:250:553:501:250:214:250:250:502:502:502:250:250
Sendmail 8.11.6 -0-:503:501:501:250:553:250:550:214:252:502:502:502:502:250:250
Sendmail 8.11.6 -1-:250:501:501:250:553:250:250:214:252:502:502:502:502:250:250
Sendmail 8.11.6 -2-:503:501:501:250:553:553:550:214:252:502:502:502:502:250:250
Sendmail 8.11.6 -3-:250:501:501:250:553:250:550:502:250:250:502:502:502:250:250
Sendmail 8.11.6 (EXPN, VRFY):250:501:501:250:553:250:550:214:250:250:502:502:502:250:250
Sendmail 8.11.6+Sun/8.11.6 -0-:220:501:501:250:553:553:250:214:250:250:250:502:502:250:250
Sendmail 8.11.6+Sun/8.11.6 -1-:250:501:501:250:553:553:250:250:250:502:502:502:502:250:250
Sendmail 8.11.6+Sun/8.8.8:250:501:501:250:553:250:553:214:250:250:502:502:502:250:250
Sendmail 8.11.6+Sun/8.9.3:250:501:501:250:553:250:550:214:252:250:502:502:502:250:250
Sendmail 8.11.6,8.12.3,8.12.5:251:501:501:250:553:553:250:214:252:502:502:502:502:250:250
Sendmail 8.11.6/8.11.0 -0-:220:501:250:250:553:250:550:250:250:250:250:502:250:250:220
Sendmail 8.11.6/8.11.0 -1-:220:220:501:250:553:250:550:214:250:250:502:250:250:250:250
Sendmail 8.11.6/8.11.0 -2-:250:220:501:250:553:501:550:214:250:250:502:502:502:250:250
Sendmail 8.11.6/8.11.0 -3-:250:501:502:250:501:501:550:214:252:502:502:502:502:250:250
Sendmail 8.11.6/8.11.0 -4-:220:501:250:250:553:250:250:214:250:250:502:250:250:250:250
Sendmail 8.11.6/8.11.0 -5-:503:501:250:250:250:250:550:214:252:502:502:502:250:250:220
Sendmail 8.11.6/8.11.0 -6-:220:501:250:250:553:250:250:214:250:250:502:502:502:250:220
Sendmail 8.11.6/8.11.0 -7-:220:220:250:250:250:250:550:214:250:250:502:250:502:250:220
Sendmail 8.11.6/8.11.0 -8-:250:501:501:250:553:250:250:214:250:250:502:502:250:250:250
Sendmail 8.11.6/8.11.0 -9-:250:501:501:250:250:250:250:214:250:250:502:502:502:250:250
Sendmail 8.11.6/8.11.0 -10-:250:501:250:250:553:250:550:250:250:250:502:502:250:250:220
Sendmail 8.11.6/8.11.0 -11-:220:220:501:250:250:250:550:214:250:250:250:250:250:250:250
Sendmail 8.11.6/8.11.1:220:220:501:250:553:250:250:250:252:502:502:502:502:250:250
Sendmail 8.11.6/8.11.2 -0-:220:220:250:250:250:250:550:214:250:250:250:250:502:250:250
Sendmail 8.11.6/8.11.2 -1-:250:501:501:250:553:250:550:250:250:502:250:250:250:250:250
Sendmail 8.11.6/8.11.2 -2-:250:501:501:250:250:250:550:214:250:250:502:250:502:250:250
Sendmail 8.11.6/8.11.2 -3-:250:501:501:250:553:250:550:250:250:502:502:250:502:250:250
Sendmail 8.11.6/8.11.2 -4-:220:501:250:250:250:250:550:250:250:250:250:502:250:250:250
Sendmail 8.11.6/8.11.2 -5-:220:501:501:250:553:250:550:214:252:502:250:250:502:250:250
Sendmail 8.11.6/8.11.2 -6-:250:220:250:250:250:250:550:214:250:250:250:502:250:250:250
Sendmail 8.11.6/8.11.2 -7-:220:220:501:250:250:250:550:214:250:250:250:502:250:250:250
Sendmail 8.11.6/8.11.2 -8-:250:220:501:250:553:501:550:214:250:250:250:502:250:250:250
Sendmail 8.11.6/8.11.2 -9-:250:220:501:250:250:250:250:250:252:502:502:502:502:250:250
Sendmail 8.11.6/8.11.2 -10-:250:220:250:250:250:250:250:250:250:502:250:250:250:250:220
Sendmail 8.11.6/8.11.2 -11-:220:220:501:250:250:250:550:250:250:250:502:502:502:250:220
Sendmail 8.11.6/8.11.2 -12-:250:501:501:250:250:250:550:214:250:502:250:502:250:250:250
Sendmail 8.11.6/8.11.2 -13-:220:501:501:250:553:250:550:250:252:502:250:250:250:250:250
Sendmail 8.11.6/8.11.3 -0-:250:501:250:250:553:501:550:250:250:250:502:250:250:250:220
Sendmail 8.11.6/8.11.3 -1-:220:220:250:250:553:250:550:214:250:250:250:250:250:250:250
Sendmail 8.11.6/8.11.6 -0-:250:220:250:250:553:250:250:250:252:502:502:250:502:250:220
Sendmail 8.11.6/8.11.6 -1-:220:501:501:250:250:553:550:214:252:502:502:250:502:250:250
Sendmail 8.11.6/8.11.6 -2-:250:501:501:250:553:553:550:250:252:250:502:250:250:250:250
Sendmail 8.11.6/8.11.6 -3-:220:501:501:250:250:553:550:214:252:502:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -4-:503:501:501:250:553:250:250:214:252:502:250:502:250:250:250
Sendmail 8.11.6/8.11.6 -5-:220:220:501:250:553:553:250:214:250:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -6-:250:501:501:250:250:550:550:214:252:250:250:250:250:250:250
Sendmail 8.11.6/8.11.6 -7-:220:501:501:250:250:250:550:214:250:502:502:250:250:250:250
Sendmail 8.11.6/8.11.6 -8-:250:501:250:250:553:553:550:214:252:502:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -9-:220:501:250:250:250:553:250:214:250:250:502:250:502:250:250
Sendmail 8.11.6/8.11.6 -10-:250:501:250:250:250:250:250:214:250:250:502:250:502:250:220
Sendmail 8.11.6/8.11.6 -11-:503:220:250:250:250:250:550:214:252:502:502:250:250:250:220
Sendmail 8.11.6/8.11.6 -12-:220:220:250:250:553:553:250:250:250:502:250:502:250:250:220
Sendmail 8.11.6/8.11.6 -13-:250:501:250:250:250:250:550:250:252:250:502:250:502:250:220
Sendmail 8.11.6/8.11.6 -14-:250:501:250:250:250:250:250:214:252:502:250:250:250:250:220
Sendmail 8.11.6/8.11.6 -15-:220:220:501:250:553:553:550:214:250:250:502:250:502:250:220
Sendmail 8.11.6/8.11.6 -16-:503:501:501:250:553:553:550:250:252:250:502:250:502:250:220
Sendmail 8.11.6/8.11.6 -17-:250:220:250:250:250:553:250:250:250:502:502:502:250:250:220
Sendmail 8.11.6/8.11.6 -18-:220:220:250:250:250:250:250:250:252:250:250:502:502:250:250
Sendmail 8.11.6/8.11.6 -19-:220:220:501:250:250:553:550:250:252:502:250:502:502:250:220
Sendmail 8.11.6/8.11.6 -20-:220:501:501:250:553:250:250:214:250:502:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -21-:220:501:501:250:553:451:550:214:252:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -22-:250:501:250:250:250:250:250:250:250:502:250:502:250:250:220
Sendmail 8.11.6/8.11.6 -23-:503:501:250:250:250:553:250:250:252:502:250:250:502:250:220
Sendmail 8.11.6/8.11.6 -24-:220:220:501:250:250:250:550:214:252:250:250:250:502:250:250
Sendmail 8.11.6/8.11.6 -25-:250:501:501:250:250:553:550:214:252:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -26-:220:220:501:250:250:250:550:214:252:502:250:250:502:250:220
Sendmail 8.11.6/8.11.6 -27-:250:501:502:250:553:553:550:214:252:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -28-:250:501:250:250:553:250:250:214:252:502:250:502:250:250:250
Sendmail 8.11.6/8.11.6 -29-:550:501:550:550:550:550:550:550:550:550:550:550:550:250:250
Sendmail 8.11.6/8.11.6 -30-:550:220:250:550:550:250:550:550:250:250:250:250:550:250:220
Sendmail 8.11.6/8.11.6 -31-:503:220:501:250:250:553:550:214:252:250:502:250:502:250:220
Sendmail 8.11.6/8.11.6 -32-:220:220:250:250:250:250:550:250:250:502:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -33-:220:220:250:250:553:553:550:214:252:502:250:502:502:250:250
Sendmail 8.11.6/8.11.6 -34-:503:501:501:250:250:250:550:214:252:250:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -35-:220:501:250:250:553:250:550:214:250:502:250:502:250:250:250
Sendmail 8.11.6/8.11.6 -36-:220:220:250:250:250:250:550:214:252:250:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -37-:220:220:501:250:250:553:550:214:250:502:250:502:502:250:250
Sendmail 8.11.6/8.11.6 -38-:503:501:501:250:250:553:250:214:250:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -39-:220:501:250:250:553:553:550:214:250:250:250:250:250:250:220
Sendmail 8.11.6/8.11.6 -40-:220:501:250:250:553:553:550:214:250:250:250:250:250:250:250
Sendmail 8.11.6/8.11.6 -41-:220:501:250:250:553:553:550:214:250:502:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -42-:220:220:250:250:553:250:250:214:250:502:502:250:502:250:250
Sendmail 8.11.6/8.11.6 -43-:250:220:501:250:553:250:550:250:252:502:502:502:250:250:250
Sendmail 8.11.6/8.11.6 -44-:503:501:501:250:250:553:550:250:252:502:502:502:250:250:250
Sendmail 8.11.6/8.11.6 -45-:220:220:501:250:250:250:250:250:252:502:250:250:250:250:220
Sendmail 8.11.6/8.11.6 -46-:220:501:250:250:553:553:550:214:252:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -47-:250:220:250:250:553:553:250:214:250:250:502:502:250:250:250
Sendmail 8.11.6/8.11.6 -48-:250:501:501:250:553:553:550:214:252:502:250:502:502:250:250
Sendmail 8.11.6/8.11.6 -49-:250:501:501:250:553:550:250:214:252:502:250:502:502:250:250
Sendmail 8.11.6/8.11.6 -50-:250:501:250:250:250:250:250:214:252:250:250:250:250:250:220
Sendmail 8.11.6/8.11.6 -51-:503:501:501:250:250:250:550:250:252:502:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -52-:220:501:501:250:250:553:250:214:250:502:250:502:250:250:250
Sendmail 8.11.6/8.11.6 -53-:250:501:250:250:553:553:250:214:252:250:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -54-:220:220:501:250:250:553:250:214:250:502:502:250:250:250:220
Sendmail 8.11.6/8.11.6 -55-:250:220:501:250:250:250:250:250:250:502:502:250:250:250:220
Sendmail 8.11.6/8.11.6 -56-:220:220:501:250:553:553:250:214:252:250:502:250:250:250:220
Sendmail 8.11.6/8.11.6 -57-:250:501:501:250:553:553:550:250:252:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -58-:250:501:501:250:553:250:250:250:252:250:250:502:502:250:250
Sendmail 8.11.6/8.11.6 -59-:503:501:250:250:553:553:550:214:252:502:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -60-:220:501:501:250:553:553:250:214:250:502:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -61-:220:220:250:250:250:250:550:214:252:250:250:502:502:250:250
Sendmail 8.11.6/8.11.6 -62-:220:501:501:250:553:250:550:214:252:250:502:250:502:250:220
Sendmail 8.11.6/8.11.6 -63-:503:501:250:250:250:553:550:214:252:502:502:250:250:250:250
Sendmail 8.11.6/8.11.6 -64-:250:501:501:250:553:250:250:250:252:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -65-:220:220:250:250:553:250:250:214:252:502:502:250:502:250:220
Sendmail 8.11.6/8.11.6 -66-:220:501:250:250:553:250:250:250:252:502:250:502:502:250:250
Sendmail 8.11.6/8.11.6 -67-:220:501:501:250:553:553:550:250:250:502:250:250:502:250:220
Sendmail 8.11.6/8.11.6 -68-:220:220:250:250:250:553:550:214:252:250:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -69-:220:501:501:250:553:553:550:214:252:250:502:250:502:250:250
Sendmail 8.11.6/8.11.6 -70-:220:220:250:250:553:250:250:250:250:502:250:250:502:250:250
Sendmail 8.11.6/8.11.6 -71-:250:220:501:250:553:250:550:250:252:250:502:250:502:250:220
Sendmail 8.11.6/8.11.6 -72-:250:501:501:250:553:250:250:250:252:502:502:250:250:250:250
Sendmail 8.11.6/8.11.6 -73-:220:501:501:250:553:250:250:250:252:502:250:502:502:250:250
Sendmail 8.11.6/8.11.6 -74-:550:501:550:250:250:550:550:550:250:250:550:550:550:250:220
Sendmail 8.11.6/8.11.6 -75-:220:501:250:250:553:553:550:250:250:250:250:502:250:250:250
Sendmail 8.11.6/8.11.6 -76-:503:220:250:250:553:553:250:250:252:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -77-:250:220:250:250:250:250:550:250:252:250:250:502:502:250:220
Sendmail 8.11.6/8.11.6 -78-:220:220:250:250:553:553:250:214:252:250:502:250:250:250:250
Sendmail 8.11.6/8.11.6 -79-:220:220:250:250:553:553:550:214:252:502:250:250:502:250:250
Sendmail 8.11.6/8.11.6 -80-:250:220:501:250:250:553:250:214:252:250:502:250:250:250:220
Sendmail 8.11.6/8.11.6 -81-:220:220:250:250:553:250:250:250:252:502:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -82-:503:501:250:250:250:250:250:214:250:502:250:502:250:250:220
Sendmail 8.11.6/8.11.6 -83-:220:220:250:250:553:250:250:214:250:250:250:502:250:250:250
Sendmail 8.11.6/8.11.6 -84-:250:501:501:250:553:451:550:214:252:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -85-:250:501:501:250:250:553:250:250:252:502:250:502:502:250:220
Sendmail 8.11.6/8.11.6 -86-:220:220:250:250:250:553:550:250:252:502:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -87-:250:220:501:250:250:250:250:250:252:250:250:502:502:250:220
Sendmail 8.11.6/8.11.6 -88-:220:220:501:250:250:250:550:250:252:250:250:250:250:250:220
Sendmail 8.11.6/8.11.6 -89-:220:220:250:250:250:553:250:214:250:250:250:502:250:250:220
Sendmail 8.11.6/8.11.6 -90-:250:501:501:250:553:250:550:214:252:502:250:502:502:250:250
Sendmail 8.11.6/8.11.6 -91-:220:220:250:250:553:553:550:214:252:502:502:250:502:250:250
Sendmail 8.11.6/8.11.6 -92-:220:220:250:250:250:553:550:250:250:250:250:250:250:250:250
Sendmail 8.11.6/8.11.6 -93-:250:501:250:250:250:250:550:214:252:250:250:250:250:250:250
Sendmail 8.11.6/8.11.6 -94-:452:501:452:452:452:452:452:452:452:452:452:452:452:250:250
Sendmail 8.11.6/8.11.6 -95-:220:220:250:250:553:553:250:214:250:502:250:250:250:250:250
Sendmail 8.11.6/8.11.6 -96-:250:501:501:250:250:250:550:214:252:250:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -97-:220:220:501:250:553:553:550:250:250:250:502:502:250:250:220
Sendmail 8.11.6/8.11.6 -98-:250:501:250:250:553:553:250:214:252:250:250:502:502:250:250
Sendmail 8.11.6/8.11.6 -99-:220:501:501:250:553:553:550:250:250:502:250:502:250:250:220
Sendmail 8.11.6/8.11.6 -100-:250:501:501:250:250:250:550:214:252:250:502:250:502:250:250
Sendmail 8.11.6/8.11.6 -101-:250:501:250:250:553:250:250:250:252:250:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -102-:503:220:501:250:553:553:250:250:252:502:250:502:502:250:250
Sendmail 8.11.6/8.11.6 -103-:220:501:250:250:250:250:250:250:252:250:250:502:502:250:250
Sendmail 8.11.6/8.11.6 -104-:250:220:250:250:553:250:550:250:252:502:250:502:502:250:220
Sendmail 8.11.6/8.11.6 -105-:503:220:501:250:250:250:250:214:252:250:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -106-:220:220:501:250:250:553:550:214:252:250:250:250:250:250:250
Sendmail 8.11.6/8.11.6 -107-:250:220:501:250:250:250:250:214:252:502:502:502:250:250:220
Sendmail 8.11.6/8.11.6 -108-:220:501:501:250:250:250:250:250:252:502:502:250:502:250:220
Sendmail 8.11.6/8.11.6 -109-:220:501:250:250:553:250:550:214:252:502:502:502:250:250:250
Sendmail 8.11.6/8.11.6 -110-:220:220:250:250:250:250:550:250:252:502:502:250:250:250:250
Sendmail 8.11.6/8.11.6 -111-:250:220:250:250:250:250:250:214:252:502:250:502:250:250:220
Sendmail 8.11.6/8.11.6 -112-:220:501:250:250:553:553:550:250:252:502:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -113-:503:501:501:250:553:553:250:250:250:250:250:502:250:250:220
Sendmail 8.11.6/8.11.6 -114-:503:501:501:250:250:553:250:214:252:502:502:250:502:250:220
Sendmail 8.11.6/8.11.6 -115-:220:220:250:250:250:250:550:250:252:250:502:502:250:250:250
Sendmail 8.11.6/8.11.6 -116-:503:220:501:250:553:553:550:250:252:250:250:250:250:250:250
Sendmail 8.11.6/8.11.6 -117-:220:220:501:250:250:553:250:250:252:250:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -118-:503:501:501:250:250:250:550:214:252:250:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -119-:503:220:250:250:553:553:250:214:252:250:250:250:250:250:220
Sendmail 8.11.6/8.11.6 -120-:220:220:501:250:553:250:250:250:252:502:250:502:502:250:250
Sendmail 8.11.6/8.11.6 -121-:220:220:250:250:250:250:550:250:252:502:502:250:250:250:220
Sendmail 8.11.6/8.11.6 -122-:250:220:501:250:250:553:550:214:250:250:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -123-:220:220:501:250:553:553:250:214:252:250:250:502:502:250:250
Sendmail 8.11.6/8.11.6 -124-:250:501:250:250:553:250:550:214:252:250:250:502:502:250:250
Sendmail 8.11.6/8.11.6 -125-:220:220:250:250:250:553:250:250:250:250:250:502:502:250:220
Sendmail 8.11.6/8.11.6 -126-:503:501:501:250:553:553:550:250:250:502:250:250:250:250:250
Sendmail 8.11.6/8.11.6 -127-:220:220:501:250:250:553:550:250:252:250:250:250:502:250:220
Sendmail 8.11.6/8.11.6 -128-:220:220:501:250:553:553:550:250:250:250:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -129-:250:501:250:250:553:250:250:250:252:502:250:502:250:250:250
Sendmail 8.11.6/8.11.6 -130-:250:501:501:250:250:250:550:250:252:250:250:502:502:250:250
Sendmail 8.11.6/8.11.6 -131-:220:501:501:250:250:250:550:250:250:250:250:250:502:250:250
Sendmail 8.11.6/8.11.6 -132-:250:501:501:250:553:250:550:250:250:250:250:250:250:250:250
Sendmail 8.11.6/8.11.6 -133-:220:220:250:250:553:250:550:214:250:502:502:502:250:250:250
Sendmail 8.11.6/8.11.6 -134-:220:501:501:250:553:553:550:250:252:502:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -135-:220:220:501:250:553:250:550:214:252:502:502:250:502:250:250
Sendmail 8.11.6/8.11.6 -136-:250:501:501:250:250:553:550:214:252:250:502:502:250:250:250
Sendmail 8.11.6/8.11.6 -137-:250:501:501:250:250:250:250:214:250:250:250:250:502:250:250
Sendmail 8.11.6/8.11.6 -138-:220:501:250:250:250:250:250:250:250:502:250:250:502:250:250
Sendmail 8.11.6/8.11.6 -139-:220:220:501:250:250:553:250:250:252:250:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -140-:220:220:501:250:250:553:250:250:252:502:250:502:502:250:220
Sendmail 8.11.6/8.11.6 -141-:503:501:250:250:553:250:550:214:252:502:502:502:250:250:250
Sendmail 8.11.6/8.11.6 -142-:250:501:501:250:250:250:250:214:252:502:502:250:502:250:250
Sendmail 8.11.6/8.11.6 -143-:250:220:501:250:553:250:550:214:250:502:502:250:250:250:250
Sendmail 8.11.6/8.11.6 -144-:250:501:250:250:553:553:250:214:252:502:250:502:502:250:250
Sendmail 8.11.6/8.11.6 -145-:250:501:501:250:553:250:550:214:252:250:502:502:250:250:250
Sendmail 8.11.6/8.11.6 -146-:250:220:250:250:250:250:250:250:250:250:502:502:250:250:220
Sendmail 8.11.6/8.11.6 -147-:250:220:501:250:553:553:550:214:252:502:502:502:250:250:250
Sendmail 8.11.6/8.11.6 -148-:220:220:250:250:553:250:550:214:250:502:250:250:250:250:250
Sendmail 8.11.6/8.11.6 -149-:250:501:501:250:553:250:250:214:252:250:250:250:250:250:250
Sendmail 8.11.6/8.11.6 -150-:220:220:501:250:250:553:250:250:252:502:250:250:502:250:250
Sendmail 8.11.6/8.11.6 -151-:250:501:250:250:553:553:550:214:252:502:250:502:502:250:250
Sendmail 8.11.6/8.11.6 -152-:220:501:501:250:250:250:550:250:252:502:250:250:502:250:250
Sendmail 8.11.6/8.11.6 -153-:503:220:501:250:250:250:550:214:252:502:250:250:250:250:250
Sendmail 8.11.6/8.11.6 -154-:220:220:250:250:553:250:250:214:250:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -155-:220:501:501:250:553:553:550:250:250:502:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -156-:250:220:250:250:553:250:550:214:250:502:502:250:502:250:250
Sendmail 8.11.6/8.11.6 -157-:250:220:250:250:250:250:250:214:250:250:250:502:502:250:220
Sendmail 8.11.6/8.11.6 -158-:250:220:250:250:553:250:550:214:252:502:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -159-:220:501:250:250:553:250:550:250:252:250:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -160-:550:501:550:550:550:550:550:250:250:550:550:550:550:250:220
Sendmail 8.11.6/8.11.6 -161-:250:220:501:250:250:250:250:250:252:250:502:250:250:250:220
Sendmail 8.11.6/8.11.6 -162-:220:501:501:250:250:553:250:214:252:502:250:250:250:250:250
Sendmail 8.11.6/8.11.6 -163-:220:501:250:250:553:553:250:214:250:250:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -164-:250:220:250:250:553:250:250:214:252:502:250:250:250:250:250
Sendmail 8.11.6/8.11.6 -165-:250:220:250:250:553:553:550:250:250:250:250:250:502:250:250
Sendmail 8.11.6/8.11.6 -166-:250:501:250:250:553:250:550:214:250:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -167-:250:501:250:250:553:250:250:250:252:250:502:250:502:250:220
Sendmail 8.11.6/8.11.6 -168-:250:220:250:250:553:553:250:214:250:502:502:250:502:250:220
Sendmail 8.11.6/8.11.6 -169-:220:220:250:250:250:250:250:214:252:250:250:502:250:250:250
Sendmail 8.11.6/8.11.6 -170-:503:220:501:250:553:553:250:250:250:250:250:502:250:250:250
Sendmail 8.11.6/8.11.6 -171-:250:501:501:250:250:250:550:214:252:250:250:502:502:250:250
Sendmail 8.11.6/8.11.6 -172-:250:501:501:250:553:250:250:250:252:250:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -173-:220:220:501:250:553:553:250:214:252:502:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -174-:220:220:250:250:250:250:550:250:252:502:250:502:502:250:250
Sendmail 8.11.6/8.11.6 -175-:503:220:250:250:553:250:250:214:250:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -176-:250:501:250:250:553:553:250:214:250:250:250:502:502:250:250
Sendmail 8.11.6/8.11.6 -177-:503:220:250:250:250:250:250:250:252:502:502:250:250:250:250
Sendmail 8.11.6/8.11.6 -178-:250:220:250:250:250:553:550:214:252:502:250:250:250:250:220
Sendmail 8.11.6/8.11.6 -179-:220:501:501:250:553:553:550:250:252:502:502:250:502:250:250
Sendmail 8.11.6/8.11.6 -180-:250:220:501:250:553:250:550:214:250:250:250:250:502:250:250
Sendmail 8.11.6/8.11.6 -181-:250:220:250:250:250:553:550:250:250:250:250:250:250:250:220
Sendmail 8.11.6/8.11.6 -182-:250:220:501:250:250:250:550:250:252:502:502:502:250:250:250
Sendmail 8.11.6/8.11.6 -183-:250:220:501:250:250:250:550:214:250:250:250:250:250:250:250
Sendmail 8.11.6/8.11.6 -184-:220:220:501:250:553:553:550:214:250:502:502:250:250:250:220
Sendmail 8.11.6/8.11.6 -185-:220:501:250:250:250:553:250:214:252:502:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -186-:503:220:501:250:250:553:250:250:250:502:250:502:250:250:250
Sendmail 8.11.6/8.11.6 -187-:220:220:501:250:250:250:250:214:252:502:250:250:502:250:250
Sendmail 8.11.6/8.11.6 -188-:220:220:250:250:553:250:550:214:252:250:250:250:250:250:220
Sendmail 8.11.6/8.11.6 -189-:250:501:501:250:553:451:550:250:252:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -190-:220:220:250:250:553:550:250:214:250:250:250:250:250:250:250
Sendmail 8.11.6/8.11.6 -191-:220:220:250:250:553:553:550:214:252:502:250:502:502:250:220
Sendmail 8.11.6/8.11.6 -192-:220:501:501:250:250:553:250:214:252:502:250:502:502:250:250
Sendmail 8.11.6/8.11.6 -193-:220:220:250:250:553:553:550:250:250:502:250:502:250:250:250
Sendmail 8.11.6/8.11.6 -194-:250:501:250:250:250:250:550:250:250:502:250:502:250:250:250
Sendmail 8.11.6/8.11.6 -195-:503:220:250:250:553:553:550:250:252:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -196-:250:220:250:250:553:250:250:214:252:250:250:250:250:250:250
Sendmail 8.11.6/8.11.6 -197-:250:501:250:250:250:250:550:250:250:250:502:502:250:250:250
Sendmail 8.11.6/8.11.6 -198-:503:220:501:250:553:553:550:214:252:502:250:502:502:250:220
Sendmail 8.11.6/8.11.6 -199-:250:501:501:250:250:250:250:214:250:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -200-:250:220:501:250:553:553:550:214:252:250:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -201-:503:220:250:250:553:250:550:250:252:502:250:502:502:250:250
Sendmail 8.11.6/8.11.6 -202-:250:501:501:250:250:250:250:250:252:502:502:502:250:250:220
Sendmail 8.11.6/8.11.6 -203-:220:220:250:250:553:250:550:250:252:250:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -204-:220:220:250:250:553:250:250:250:250:502:502:250:250:250:250
Sendmail 8.11.6/8.11.6 -205-:220:501:501:250:250:250:250:214:252:502:250:250:502:250:250
Sendmail 8.11.6/8.11.6 -206-:250:501:250:250:250:250:250:214:250:502:502:502:250:250:250
Sendmail 8.11.6/8.11.6 -207-:250:501:501:250:250:250:250:214:252:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -208-:250:501:501:250:250:553:550:214:252:502:250:502:250:250:250
Sendmail 8.11.6/8.11.6 -209-:220:501:250:250:553:553:250:250:250:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -210-:220:501:501:250:250:250:550:214:250:502:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -211-:220:220:501:250:250:250:250:250:250:250:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -212-:220:220:501:250:250:553:250:250:252:250:250:250:502:250:250
Sendmail 8.11.6/8.11.6 -213-:250:501:501:250:553:250:554:214:252:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -214-:220:501:250:250:553:553:550:214:250:250:250:502:502:250:250
Sendmail 8.11.6/8.11.6 -215-:250:220:250:250:250:250:250:214:252:250:250:250:250:250:250
Sendmail 8.11.6/8.11.6 -216-:250:501:501:250:250:250:250:250:250:502:502:502:250:250:250
Sendmail 8.11.6/8.11.6 -217-:250:220:501:250:250:553:250:250:252:502:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -218-:250:501:250:250:553:553:550:214:250:502:502:250:502:250:250
Sendmail 8.11.6/8.11.6 -219-:503:501:501:250:250:250:550:250:252:250:250:502:502:250:250
Sendmail 8.11.6/8.11.6 -220-:220:501:250:250:250:553:550:214:250:502:502:250:250:250:250
Sendmail 8.11.6/8.11.6 -221-:220:501:501:250:553:553:550:214:250:502:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -222-:503:220:501:250:553:553:550:214:250:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -223-:220:501:501:250:250:553:550:214:250:502:502:502:250:250:250
Sendmail 8.11.6/8.11.6 -224-:220:220:250:250:553:250:250:214:252:502:250:250:502:250:250
Sendmail 8.11.6/8.11.6 -225-:220:501:501:250:553:553:250:250:252:502:502:502:250:250:220
Sendmail 8.11.6/8.11.6 -226-:250:501:250:250:553:250:550:250:250:250:250:250:250:250:220
Sendmail 8.11.6/8.11.6 -227-:250:501:501:250:250:250:550:250:252:250:250:250:250:250:250
Sendmail 8.11.6/8.11.6 -228-:503:220:250:250:553:553:550:250:252:502:250:250:250:250:250
Sendmail 8.11.6/8.11.6 -229-:250:220:250:250:250:553:550:250:252:502:250:250:250:250:250
Sendmail 8.11.6/8.11.6 -230-:503:501:250:250:250:553:250:214:252:502:502:250:250:250:220
Sendmail 8.11.6/8.11.6 -231-:220:220:501:250:553:553:550:250:252:502:250:502:502:250:250
Sendmail 8.11.6/8.11.6 -232-:250:501:501:250:553:250:250:214:252:250:250:502:502:250:220
Sendmail 8.11.6/8.11.6 -233-:250:501:250:250:250:250:550:214:252:502:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -234-:250:501:250:250:553:553:250:214:252:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -235-:220:501:501:250:553:553:250:250:252:502:502:250:250:250:250
Sendmail 8.11.6/8.11.6 -236-:250:501:501:250:250:250:250:214:250:502:250:502:250:250:250
Sendmail 8.11.6/8.11.6 -237-:503:220:501:250:250:553:250:250:252:250:502:502:250:250:220
Sendmail 8.11.6/8.11.6 -238-:503:220:250:250:553:553:250:250:250:250:250:250:502:250:220
Sendmail 8.11.6/8.11.6 -239-:250:501:250:250:250:250:250:214:252:502:502:250:502:250:220
Sendmail 8.11.6/8.11.6 -240-:220:220:501:250:553:250:550:250:252:250:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -241-:220:501:501:250:250:553:250:250:250:502:502:250:250:250:250
Sendmail 8.11.6/8.11.6 -242-:250:501:501:250:553:250:550:214:252:502:502:502:250:250:220
Sendmail 8.11.6/8.11.6 -243-:250:220:250:250:553:250:550:214:250:250:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -244-:250:220:250:250:553:250:550:250:250:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -245-:250:220:250:250:250:250:550:214:252:250:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -246-:250:501:250:250:553:250:250:250:252:502:250:250:502:250:250
Sendmail 8.11.6/8.11.6 -247-:250:501:501:250:553:250:550:214:252:250:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -248-:250:501:501:250:553:250:550:214:252:502:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -249-:220:220:501:250:250:250:250:502:250:250:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -250-:250:501:501:250:250:250:550:214:252:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -251-:250:220:501:250:250:553:250:214:252:502:250:502:502:250:250
Sendmail 8.11.6/8.11.6 -252-:250:220:250:250:553:553:550:250:250:250:250:250:250:250:250
Sendmail 8.11.6/8.11.6 -253-:220:501:501:250:250:553:550:250:252:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -254-:250:501:501:250:553:553:250:214:250:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -255-:220:220:501:250:250:250:250:214:252:250:502:250:502:250:250
Sendmail 8.11.6/8.11.6 -256-:220:220:250:250:553:250:250:250:250:502:250:502:502:250:220
Sendmail 8.11.6/8.11.6 -257-:220:501:250:250:250:250:550:214:250:250:250:250:250:250:220
Sendmail 8.11.6/8.11.6 -258-:220:220:250:250:250:250:250:250:252:502:250:250:250:250:250
Sendmail 8.11.6/8.11.6 -259-:250:501:501:250:553:250:250:250:250:502:250:502:250:250:220
Sendmail 8.11.6/8.11.6 -260-:503:220:501:250:553:553:550:250:250:250:250:502:502:250:220
Sendmail 8.11.6/8.11.6 -261-:503:220:250:250:250:250:250:250:252:502:502:502:250:250:220
Sendmail 8.11.6/8.11.6 -262-:503:220:250:250:553:250:250:214:252:250:250:250:250:250:250
Sendmail 8.11.6/8.11.6 -263-:220:220:250:250:553:250:550:250:252:502:502:502:250:250:250
Sendmail 8.11.6/8.11.6 -264-:250:501:501:250:553:250:550:214:250:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -265-:220:220:250:250:250:250:250:214:250:502:250:250:502:250:250
Sendmail 8.11.6/8.11.6 -266-:220:220:250:250:553:250:250:250:252:502:502:250:502:250:250
Sendmail 8.11.6/8.11.6 -267-:250:501:501:250:250:553:250:250:250:502:250:502:250:250:220
Sendmail 8.11.6/8.11.6 -268-:220:501:501:250:250:250:550:214:252:250:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -269-:503:501:501:250:250:553:550:214:250:250:502:250:250:250:250
Sendmail 8.11.6/8.11.6 -270-:250:220:250:250:250:250:250:250:250:502:502:250:250:250:250
Sendmail 8.11.6/8.11.6 -271-:220:220:501:250:250:250:550:214:252:250:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -272-:220:220:501:250:250:250:550:250:250:250:250:502:502:250:250
Sendmail 8.11.6/8.11.6 -273-:220:220:501:250:553:250:250:250:250:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -274-:220:501:501:250:250:250:250:250:252:250:502:250:502:250:250
Sendmail 8.11.6/8.11.6 -275-:250:501:501:250:250:250:550:250:252:502:250:502:502:250:220
Sendmail 8.11.6/8.11.6 -276-:503:501:250:250:553:250:250:250:250:250:502:250:250:250:220
Sendmail 8.11.6/8.11.6 -277-:250:220:501:250:553:250:250:214:250:502:250:250:502:250:250
Sendmail 8.11.6/8.11.6 -278-:220:501:250:250:553:553:550:214:252:502:250:502:250:250:220
Sendmail 8.11.6/8.11.6 -279-:503:501:501:250:250:250:250:250:252:502:250:502:502:250:250
Sendmail 8.11.6/8.11.6 -280-:220:501:250:250:553:250:250:250:252:502:250:250:502:250:250
Sendmail 8.11.6/8.11.6 -281-:220:501:501:250:553:553:550:214:252:502:250:502:502:250:250
Sendmail 8.11.6/8.11.6 -282-:503:220:250:250:250:250:250:250:252:250:250:502:502:250:250
Sendmail 8.11.6/8.11.6 -283-:503:501:501:250:250:250:250:250:250:250:250:502:250:250:220
Sendmail 8.11.6/8.11.6 -284-:220:220:250:250:553:250:550:214:250:502:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -285-:220:220:250:250:250:550:250:214:252:502:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -286-:250:501:250:250:250:250:550:250:252:250:250:250:250:250:250
Sendmail 8.11.6/8.11.6 -287-:220:220:501:250:250:250:250:214:252:250:250:502:250:250:220
Sendmail 8.11.6/8.11.6 -288-:250:220:250:250:553:250:250:250:252:502:250:250:502:250:220
Sendmail 8.11.6/8.11.6 -289-:250:220:501:250:553:250:250:214:250:502:502:250:250:250:250
Sendmail 8.11.6/8.11.6 -290-:503:501:250:250:250:553:250:214:252:502:250:502:250:250:220
Sendmail 8.11.6/8.11.6 -291-:250:220:250:250:553:250:550:214:252:502:250:250:250:250:220
Sendmail 8.11.6/8.11.6 -292-:250:220:501:250:553:250:550:250:252:502:502:250:502:250:220
Sendmail 8.11.6/8.11.6 -293-:503:220:250:250:250:553:550:250:252:250:502:502:250:250:250
Sendmail 8.11.6/8.11.6 -294-:220:220:250:250:553:553:550:214:250:250:502:502:250:250:250
Sendmail 8.11.6/8.11.6 -295-:220:501:250:250:250:250:550:214:250:250:502:250:502:250:220
Sendmail 8.11.6/8.11.6 -296-:220:501:250:250:553:250:550:250:250:250:250:250:502:250:220
Sendmail 8.11.6/8.11.6 -297-:250:220:501:250:553:250:550:214:252:502:502:250:250:250:220
Sendmail 8.11.6/8.11.6 -298-:220:501:501:250:553:553:250:214:252:250:250:502:250:250:220
Sendmail 8.11.6/8.11.6 -299-:503:501:501:250:553:553:550:214:252:502:502:250:250:250:220
Sendmail 8.11.6/8.11.6 -300-:503:220:250:250:250:553:550:250:252:502:502:250:502:250:220
Sendmail 8.11.6/8.11.6 -301-:250:501:501:250:553:250:550:214:252:250:502:250:502:250:220
Sendmail 8.11.6/8.11.6 -302-:220:501:501:250:553:553:550:250:250:250:502:502:250:250:220
Sendmail 8.11.6/8.11.6 -303-:220:220:501:250:553:250:550:250:250:502:250:502:502:250:220
Sendmail 8.11.6/8.11.6 -304-:250:501:501:250:553:250:250:250:250:250:250:250:502:250:220
Sendmail 8.11.6/8.11.6 -305-:250:501:501:250:553:250:250:214:252:502:250:502:250:250:250
Sendmail 8.11.6/8.11.6 -306-:220:220:250:250:553:553:250:214:250:502:250:502:502:250:220
Sendmail 8.11.6/8.11.6 -307-:220:501:501:250:250:553:550:214:252:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -308-:250:501:501:250:250:553:550:214:252:502:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -309-:503:501:501:250:553:553:550:250:252:502:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -310-:220:501:250:250:250:250:550:214:250:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -311-:220:501:250:250:553:250:250:214:252:502:502:502:250:250:250
Sendmail 8.11.6/8.11.6 -312-:220:501:501:250:553:250:250:250:250:502:250:502:502:250:220
Sendmail 8.11.6/8.11.6 -313-:220:501:250:250:553:250:550:214:250:250:502:250:502:250:250
Sendmail 8.11.6/8.11.6 -314-:250:501:501:250:250:250:250:214:250:502:250:502:502:250:220
Sendmail 8.11.6/8.11.6 -315-:503:501:501:250:553:250:550:214:252:502:250:502:502:250:250
Sendmail 8.11.6/8.11.6 -316-:250:220:250:250:250:250:550:250:252:250:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -317-:220:220:250:250:250:553:250:250:252:502:250:250:502:250:220
Sendmail 8.11.6/8.11.6 -318-:250:501:501:250:553:553:250:250:250:250:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -319-:220:220:250:250:553:553:550:250:250:250:502:250:502:250:250
Sendmail 8.11.6/8.11.6 -320-:220:501:501:250:553:250:250:214:250:502:502:502:250:250:250
Sendmail 8.11.6/8.11.6 -321-:250:501:501:250:553:250:550:214:252:502:250:250:250:250:250
Sendmail 8.11.6/8.11.6 -322-:220:501:501:250:250:553:550:250:252:502:250:502:250:250:220
Sendmail 8.11.6/8.11.6 -323-:220:220:250:250:553:250:550:214:250:250:250:502:250:250:250
Sendmail 8.11.6/8.11.6 -324-:220:501:501:250:553:553:550:250:252:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -325-:503:220:501:250:553:250:550:214:250:502:502:250:502:250:250
Sendmail 8.11.6/8.11.6 -326-:250:220:250:250:250:250:250:214:252:502:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -327-:220:501:250:250:553:250:550:214:252:502:250:502:250:250:220
Sendmail 8.11.6/8.11.6 -328-:250:501:501:250:553:553:550:214:252:502:502:502:250:250:250
Sendmail 8.11.6/8.11.6 -329-:220:501:250:250:250:250:550:214:250:502:502:502:250:250:250
Sendmail 8.11.6/8.11.6 -330-:220:220:501:250:250:553:550:250:250:250:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -331-:250:220:250:250:250:250:550:250:250:250:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -332-:250:220:250:250:250:250:550:214:250:502:502:250:250:250:250
Sendmail 8.11.6/8.11.6 -333-:250:220:250:250:553:553:550:214:250:250:502:502:250:250:250
Sendmail 8.11.6/8.11.6 -334-:220:501:501:250:553:553:250:250:250:502:502:250:502:250:250
Sendmail 8.11.6/8.11.6 -335-:220:220:501:250:553:553:250:214:252:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -336-:503:220:250:250:250:553:250:214:252:250:250:502:502:250:250
Sendmail 8.11.6/8.11.6 -337-:503:501:250:250:553:553:250:250:252:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -338-:250:501:501:250:250:250:550:214:252:502:250:502:502:250:250
Sendmail 8.11.6/8.11.6 -339-:220:220:501:250:553:553:250:250:250:250:250:250:502:250:250
Sendmail 8.11.6/8.11.6 -340-:250:501:501:250:553:250:550:214:250:250:502:250:502:250:250
Sendmail 8.11.6/8.11.6 -341-:503:501:501:250:250:553:550:214:252:502:502:502:250:250:250
Sendmail 8.11.6/8.11.6 -342-:220:501:501:250:250:250:250:250:252:250:250:250:250:250:250
Sendmail 8.11.6/8.11.6 -343-:220:220:501:250:250:553:250:250:252:250:250:502:502:250:220
Sendmail 8.11.6/8.11.6 -344-:220:501:501:250:553:250:250:250:250:250:502:250:250:250:220
Sendmail 8.11.6/8.11.6 -345-:250:501:250:250:553:553:550:214:252:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -346-:220:220:250:250:553:250:250:214:252:250:250:502:502:250:250
Sendmail 8.11.6/8.11.6 -347-:503:501:250:250:250:553:250:214:252:502:250:502:502:250:250
Sendmail 8.11.6/8.11.6 -348-:220:220:250:250:250:553:550:214:250:250:502:250:502:250:250
Sendmail 8.11.6/8.11.6 -349-:503:220:501:250:553:250:250:250:250:250:250:502:250:250:220
Sendmail 8.11.6/8.11.6 -350-:220:220:501:250:553:250:250:250:252:250:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -351-:220:501:501:250:553:553:250:214:250:250:502:250:502:250:220
Sendmail 8.11.6/8.11.6 -352-:250:501:501:250:553:553:550:214:250:502:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -353-:220:220:250:250:553:250:250:250:250:250:502:502:250:250:250
Sendmail 8.11.6/8.11.6 -354-:250:220:501:250:553:250:550:214:252:502:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -355-:250:220:250:250:553:250:250:250:250:502:250:250:250:250:250
Sendmail 8.11.6/8.11.6 -356-:220:501:501:250:250:553:550:250:250:250:250:502:250:250:250
Sendmail 8.11.6/8.11.6 -357-:220:220:250:250:553:250:550:250:250:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -358-:250:501:250:250:553:250:250:214:252:502:502:250:250:250:220
Sendmail 8.11.6/8.11.6 -359-:220:501:501:250:250:553:550:250:250:250:250:250:250:250:250
Sendmail 8.11.6/8.11.6 -360-:250:220:250:250:250:250:550:214:250:502:250:502:502:250:220
Sendmail 8.11.6/8.11.6 -361-:250:501:250:250:553:250:250:214:252:250:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -362-:250:220:501:250:553:553:250:250:250:502:250:250:250:250:220
Sendmail 8.11.6/8.11.6 -363-:220:501:501:250:250:250:550:214:250:502:250:250:250:250:250
Sendmail 8.11.6/8.11.6 -364-:250:501:250:250:250:553:550:250:252:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -365-:250:501:501:250:553:250:550:214:250:250:250:250:250:250:220
Sendmail 8.11.6/8.11.6 -366-:220:501:501:250:250:250:250:250:250:502:250:502:250:250:250
Sendmail 8.11.6/8.11.6 -367-:503:220:501:250:553:553:550:250:252:502:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -368-:250:220:250:250:553:250:250:214:250:502:250:502:502:250:220
Sendmail 8.11.6/8.11.6 -369-:250:220:250:250:553:250:250:214:252:502:250:250:250:250:220
Sendmail 8.11.6/8.11.6 -370-:220:220:501:250:250:553:550:250:250:250:250:502:502:250:220
Sendmail 8.11.6/8.11.6 -371-:250:501:250:250:250:250:250:250:250:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -372-:250:501:250:250:250:250:250:214:252:250:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -373-:250:220:250:250:553:250:550:250:252:502:502:250:250:250:220
Sendmail 8.11.6/8.11.6 -374-:503:220:250:250:553:553:550:214:252:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -375-:220:220:501:250:553:553:550:214:252:502:502:250:502:250:220
Sendmail 8.11.6/8.11.6 -376-:220:220:250:250:553:250:250:250:250:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -377-:220:220:501:250:553:250:550:214:252:250:502:250:502:250:250
Sendmail 8.11.6/8.11.6 -378-:220:220:501:250:553:250:250:214:250:502:250:250:250:250:250
Sendmail 8.11.6/8.11.6 -379-:250:501:501:250:250:553:250:214:252:502:250:250:250:250:250
Sendmail 8.11.6/8.11.6 -380-:220:220:501:250:553:553:550:214:252:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -381-:220:501:501:250:553:250:250:214:250:250:250:502:502:250:220
Sendmail 8.11.6/8.11.6 -382-:250:501:501:250:250:250:550:214:250:502:502:250:250:250:250
Sendmail 8.11.6/8.11.6 -383-:220:501:501:250:553:553:250:250:252:502:502:502:250:250:250
Sendmail 8.11.6/8.11.6 -384-:220:220:250:250:250:250:250:250:250:502:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -385-:220:501:501:250:250:250:550:250:250:502:250:502:250:250:250
Sendmail 8.11.6/8.11.6 -386-:220:220:501:250:250:250:250:214:250:502:250:502:250:250:220
Sendmail 8.11.6/8.11.6 -387-:250:220:501:250:553:250:550:214:252:502:502:502:250:250:250
Sendmail 8.11.6/8.11.6 -388-:250:220:501:250:553:250:250:250:250:502:250:502:250:250:250
Sendmail 8.11.6/8.11.6 -389-:250:220:250:250:250:250:250:250:252:250:250:250:250:250:220
Sendmail 8.11.6/8.11.6 -390-:503:220:501:250:553:250:550:214:252:250:250:502:502:250:250
Sendmail 8.11.6/8.11.6 -391-:503:501:250:250:553:250:250:250:250:502:502:250:502:250:250
Sendmail 8.11.6/8.11.6 -392-:250:501:250:250:553:250:250:214:252:250:250:502:502:250:220
Sendmail 8.11.6/8.11.6 -393-:503:220:501:250:553:250:550:250:250:502:250:502:502:250:220
Sendmail 8.11.6/8.11.6 -394-:220:501:501:250:553:250:250:250:252:250:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -395-:503:501:250:250:250:250:550:214:252:250:250:502:502:250:220
Sendmail 8.11.6/8.11.6 -396-:220:501:501:250:250:553:250:250:252:502:502:250:250:250:220
Sendmail 8.11.6/8.11.6 -397-:250:501:250:250:250:250:550:214:252:502:250:502:250:250:220
Sendmail 8.11.6/8.11.6 -398-:220:220:250:250:553:553:550:214:252:250:502:250:250:250:250
Sendmail 8.11.6/8.11.6 -399-:220:220:250:250:250:250:550:214:252:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -400-:503:220:501:250:250:553:250:214:252:502:250:502:250:250:250
Sendmail 8.11.6/8.11.6 -401-:220:220:501:250:250:250:550:214:252:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -402-:250:501:501:250:553:250:550:250:252:502:502:250:502:250:250
Sendmail 8.11.6/8.11.6 -403-:250:501:250:250:250:250:250:250:252:250:502:250:502:250:220
Sendmail 8.11.6/8.11.6 -404-:503:501:501:250:553:553:550:250:250:250:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -405-:220:220:250:250:553:553:550:214:250:502:250:502:502:250:250
Sendmail 8.11.6/8.11.6 -406-:220:501:250:250:250:250:250:214:250:250:502:502:250:250:250
Sendmail 8.11.6/8.11.6 -407-:503:220:250:250:250:250:250:250:250:502:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -408-:503:220:250:250:250:250:550:214:252:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -409-:250:501:501:250:553:553:550:214:252:502:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -410-:503:501:501:250:553:553:250:250:252:502:250:502:502:250:220
Sendmail 8.11.6/8.11.6 -411-:220:220:501:250:553:553:550:214:250:250:502:502:250:250:220
Sendmail 8.11.6/8.11.6 -412-:503:220:250:250:553:250:250:250:252:250:250:250:502:250:250
Sendmail 8.11.6/8.11.6 -413-:220:220:501:250:250:250:250:250:250:250:250:502:502:250:220
Sendmail 8.11.6/8.11.6 -414-:220:501:250:250:553:553:550:214:252:250:502:250:502:250:220
Sendmail 8.11.6/8.11.6 -415-:220:501:250:250:250:250:550:250:252:250:250:250:250:250:220
Sendmail 8.11.6/8.11.6 -416-:220:501:501:250:553:553:250:214:252:250:502:250:502:250:220
Sendmail 8.11.6/8.11.6 -417-:250:501:250:250:553:553:250:214:250:250:502:250:502:250:250
Sendmail 8.11.6/8.11.6 -418-:250:501:501:250:553:250:250:214:252:250:502:250:502:250:220
Sendmail 8.11.6/8.11.6 -419-:250:501:501:250:553:250:550:250:250:502:502:250:502:250:220
Sendmail 8.11.6/8.11.6 -420-:503:501:501:250:553:553:550:214:250:250:250:502:502:250:250
Sendmail 8.11.6/8.11.6 -421-:503:220:250:250:250:553:250:214:252:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -422-:250:501:501:250:553:250:550:214:252:502:502:250:502:250:220
Sendmail 8.11.6/8.11.6 -423-:503:220:501:250:553:250:250:250:252:250:250:502:250:250:220
Sendmail 8.11.6/8.11.6 -424-:250:220:501:250:553:250:250:214:250:502:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -425-:220:220:501:250:553:250:250:214:252:502:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -426-:220:501:501:250:553:250:550:250:252:502:502:250:502:250:220
Sendmail 8.11.6/8.11.6 -427-:503:501:250:250:250:250:250:250:252:502:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -428-:250:220:501:250:553:250:550:214:252:250:502:250:250:250:220
Sendmail 8.11.6/8.11.6 -429-:250:501:501:250:250:250:250:250:250:502:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -430-:503:220:501:250:553:553:550:214:252:502:502:250:250:250:250
Sendmail 8.11.6/8.11.6 -431-:250:220:501:250:553:250:550:214:252:250:250:502:502:250:250
Sendmail 8.11.6/8.11.6 -432-:220:501:501:250:250:250:550:214:250:250:250:250:502:250:250
Sendmail 8.11.6/8.11.6 -433-:250:220:250:250:250:250:250:250:250:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -434-:250:501:501:250:553:250:550:250:252:502:250:502:250:250:220
Sendmail 8.11.6/8.11.6 -435-:250:501:501:250:250:553:250:214:252:502:250:250:250:250:220
Sendmail 8.11.6/8.11.6 -436-:220:220:250:250:250:250:250:250:250:502:250:502:502:250:250
Sendmail 8.11.6/8.11.6 -437-:250:220:501:250:553:553:550:250:252:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -438-:220:501:250:250:250:553:250:250:252:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -439-:250:501:501:250:250:250:550:214:250:250:502:250:250:250:220
Sendmail 8.11.6/8.11.6 -440-:503:501:250:250:553:553:250:214:252:250:502:250:250:250:250
Sendmail 8.11.6/8.11.6 -441-:250:220:501:250:553:250:550:214:252:502:250:250:502:250:250
Sendmail 8.11.6/8.11.6 -442-:503:501:501:250:250:553:550:214:252:502:502:250:250:250:220
Sendmail 8.11.6/8.11.6 -443-:250:220:501:250:553:250:550:214:252:250:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -444-:250:220:250:250:250:250:250:250:250:502:502:250:502:250:250
Sendmail 8.11.6/8.11.6 -445-:220:501:250:250:553:553:550:214:252:502:502:250:250:250:220
Sendmail 8.11.6/8.11.6 -446-:503:501:501:250:553:250:550:214:250:502:502:502:250:250:220
Sendmail 8.11.6/8.11.6 -447-:220:220:501:250:553:250:250:214:252:502:250:502:250:250:250
Sendmail 8.11.6/8.11.6 -448-:250:501:501:250:553:250:250:250:250:502:250:502:502:250:250
Sendmail 8.11.6/8.11.6 -449-:220:220:250:250:250:250:550:214:250:250:250:502:502:250:250
Sendmail 8.11.6/8.11.6 -450-:503:501:501:250:553:553:250:250:252:250:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -451-:220:501:250:250:250:250:250:214:250:502:502:502:250:250:220
Sendmail 8.11.6/8.11.6 -452-:220:220:501:250:553:250:250:250:250:250:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -453-:250:501:501:250:553:553:250:214:252:250:250:502:502:250:220
Sendmail 8.11.6/8.11.6 -454-:250:501:501:250:553:250:550:250:250:250:250:250:502:250:220
Sendmail 8.11.6/8.11.6 -455-:220:220:250:250:250:250:250:250:252:250:250:250:502:250:250
Sendmail 8.11.6/8.11.6 -456-:250:501:501:250:250:553:550:214:250:250:502:250:502:250:250
Sendmail 8.11.6/8.11.6 -457-:220:220:250:250:553:250:250:250:252:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -458-:220:501:501:250:250:250:550:250:252:250:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -459-:220:501:501:250:250:250:250:250:250:502:250:250:502:250:250
Sendmail 8.11.6/8.11.6 -460-:250:501:250:250:250:250:250:214:252:502:502:250:250:250:220
Sendmail 8.11.6/8.11.6 -461-:250:501:501:250:250:250:550:250:252:502:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -462-:220:501:250:250:553:250:550:214:252:250:250:250:502:250:220
Sendmail 8.11.6/8.11.6 -463-:250:501:501:250:553:553:250:214:252:250:250:502:502:250:250
Sendmail 8.11.6/8.11.6 -464-:220:220:250:250:553:250:250:214:252:502:502:250:250:250:250
Sendmail 8.11.6/8.11.6 -465-:220:220:250:250:250:250:550:214:252:502:502:250:502:250:220
Sendmail 8.11.6/8.11.6 -466-:250:220:250:250:250:553:550:214:252:502:250:250:502:250:250
Sendmail 8.11.6/8.11.6 -467-:250:501:250:250:250:250:550:250:250:502:250:502:502:250:250
Sendmail 8.11.6/8.11.6 -468-:220:220:250:250:553:250:250:214:252:250:502:502:250:250:250
Sendmail 8.11.6/8.11.6 -469-:220:220:250:250:250:250:550:214:252:502:502:250:250:250:250
Sendmail 8.11.6/8.11.6 -470-:220:501:250:250:250:250:550:250:250:250:502:502:250:250:250
Sendmail 8.11.6/8.11.6 -471-:503:220:501:250:553:553:550:214:252:250:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -472-:220:501:250:250:250:553:250:214:250:502:250:502:250:250:220
Sendmail 8.11.6/8.11.6 -473-:250:501:501:250:250:553:250:214:252:502:250:502:250:250:250
Sendmail 8.11.6/8.11.6 -474-:503:501:501:250:553:553:550:214:252:502:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -475-:250:220:501:250:553:553:250:250:250:250:250:502:502:250:250
Sendmail 8.11.6/8.11.6 -476-:250:501:501:250:250:250:550:214:250:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -477-:250:220:250:250:553:553:550:214:252:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -478-:220:220:250:250:553:553:550:214:250:502:502:502:250:250:250
Sendmail 8.11.6/8.11.6 -479-:250:501:250:250:553:250:250:214:252:502:250:502:250:250:220
Sendmail 8.11.6/8.11.6 -480-:503:501:501:250:250:553:250:214:252:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -481-:220:501:250:250:250:250:250:250:252:250:250:502:502:250:220
Sendmail 8.11.6/8.11.6 -482-:250:501:501:250:250:553:250:214:250:250:250:250:502:250:250
Sendmail 8.11.6/8.11.6 -483-:220:501:501:250:250:553:550:214:252:250:250:502:502:250:250
Sendmail 8.11.6/8.11.6 -484-:220:501:250:250:553:250:250:250:252:502:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -485-:220:220:250:250:250:553:550:214:252:250:250:250:502:250:220
Sendmail 8.11.6/8.11.6 -486-:250:220:250:250:250:250:550:214:252:250:250:250:250:250:220
Sendmail 8.11.6/8.11.6 -487-:220:501:501:250:553:250:550:250:250:250:250:250:502:250:220
Sendmail 8.11.6/8.11.6 -488-:503:220:250:250:553:250:250:250:250:502:502:250:250:250:220
Sendmail 8.11.6/8.11.6 -489-:220:501:250:250:250:250:550:214:250:502:250:250:250:250:250
Sendmail 8.11.6/8.11.6 -490-:220:220:250:250:250:250:550:214:250:502:250:502:502:250:250
Sendmail 8.11.6/8.11.6 -491-:250:501:501:250:250:250:550:250:252:502:502:250:250:250:220
Sendmail 8.11.6/8.11.6 -492-:220:501:501:250:250:553:550:214:252:502:250:250:250:250:250
Sendmail 8.11.6/8.11.6 -493-:220:220:501:250:553:553:250:214:250:502:502:250:250:250:250
Sendmail 8.11.6/8.11.6 -494-:220:501:250:250:553:250:550:214:252:250:502:502:250:250:220
Sendmail 8.11.6/8.11.6 -495-:250:501:501:553:553:250:550:214:252:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -496-:220:501:250:250:250:250:250:214:252:502:250:502:502:250:220
Sendmail 8.11.6/8.11.6 -497-:250:501:501:250:553:250:250:214:252:250:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -498-:250:501:250:250:250:250:550:250:250:502:502:250:502:250:250
Sendmail 8.11.6/8.11.6 -499-:250:501:250:250:553:250:550:250:252:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -500-:220:220:250:250:250:553:550:214:252:502:250:502:250:250:250
Sendmail 8.11.6/8.11.6 -501-:220:220:250:250:250:250:550:214:250:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -502-:220:501:250:250:553:553:550:214:250:502:250:502:250:250:220
Sendmail 8.11.6/8.11.6 -503-:250:220:250:250:553:553:550:250:250:250:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -504-:220:220:501:250:553:553:250:214:252:502:250:250:502:250:250
Sendmail 8.11.6/8.11.6 -505-:220:220:250:250:250:553:250:250:252:250:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -506-:250:501:501:250:553:250:550:250:252:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -507-:250:220:250:250:250:250:250:214:250:502:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -508-:503:501:501:250:250:553:550:214:252:250:250:502:502:250:250
Sendmail 8.11.6/8.11.6 -509-:220:501:250:250:250:250:550:214:252:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -510-:503:220:501:250:250:250:250:250:252:502:250:250:250:250:250
Sendmail 8.11.6/8.11.6 -511-:220:220:501:250:553:250:250:250:252:250:250:250:502:250:220
Sendmail 8.11.6/8.11.6 -512-:220:501:250:250:250:250:250:214:250:502:250:250:250:250:220
Sendmail 8.11.6/8.11.6 -513-:220:501:501:250:553:553:250:214:252:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -514-:250:501:250:250:553:250:250:214:250:502:502:250:250:250:220
Sendmail 8.11.6/8.11.6 -515-:503:501:250:250:553:553:550:214:250:502:502:250:502:250:220
Sendmail 8.11.6/8.11.6 -516-:250:501:501:250:553:250:250:250:252:250:250:250:502:250:250
Sendmail 8.11.6/8.11.6 -517-:220:501:250:250:250:250:250:250:252:502:502:502:250:250:220
Sendmail 8.11.6/8.11.6 -518-:220:501:550:250:550:250:550:250:250:250:250:250:550:250:220
Sendmail 8.11.6/8.11.6 -519-:250:220:250:250:250:250:250:250:252:250:250:250:250:250:250
Sendmail 8.11.6/8.11.6 -520-:220:220:501:250:250:553:250:214:252:502:250:250:250:250:250
Sendmail 8.11.6/8.11.6 -521-:250:220:501:250:553:250:550:214:250:502:502:502:250:250:250
Sendmail 8.11.6/8.11.6 -522-:220:220:250:250:553:250:550:250:252:502:502:250:502:250:250
Sendmail 8.11.6/8.11.6 -523-:250:220:250:250:250:250:550:250:250:502:250:502:250:250:220
Sendmail 8.11.6/8.11.6 -524-:220:220:501:250:250:250:550:250:252:250:250:502:250:250:220
Sendmail 8.11.6/8.11.6 -525-:503:501:501:250:250:553:250:214:252:502:502:502:250:250:220
Sendmail 8.11.6/8.11.6 -526-:220:501:501:250:553:553:250:250:252:250:250:502:250:250:250
Sendmail 8.11.6/8.11.6 -527-:250:501:501:250:553:250:550:214:252:250:250:250:502:250:250
Sendmail 8.11.6/8.11.6 -528-:503:220:250:250:553:250:250:250:250:502:250:250:502:250:250
Sendmail 8.11.6/8.11.6 -529-:220:220:250:250:250:250:250:250:252:502:250:250:502:250:250
Sendmail 8.11.6/8.11.6 -530-:250:220:501:250:553:553:550:250:250:502:250:502:502:250:220
Sendmail 8.11.6/8.11.6 -531-:220:501:501:250:553:250:550:250:252:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -532-:250:220:250:250:250:250:550:214:252:502:250:502:250:250:250
Sendmail 8.11.6/8.11.6 -533-:220:220:250:250:250:553:250:250:252:502:250:502:250:250:220
Sendmail 8.11.6/8.11.6 -534-:250:501:501:250:553:250:550:214:250:250:250:502:502:250:250
Sendmail 8.11.6/8.11.6 -535-:250:220:501:250:553:250:250:250:252:250:250:502:502:250:220
Sendmail 8.11.6/8.11.6 -536-:220:501:501:250:250:250:550:250:252:250:502:502:250:250:250
Sendmail 8.11.6/8.11.6 -537-:220:220:250:250:553:250:550:214:252:502:250:502:502:250:250
Sendmail 8.11.6/8.11.6 -538-:503:220:501:250:553:553:550:250:250:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -539-:220:501:501:250:553:250:550:250:252:250:502:250:502:250:220
Sendmail 8.11.6/8.11.6 -540-:220:220:250:250:553:553:250:214:252:502:250:502:250:250:220
Sendmail 8.11.6/8.11.6 -541-:503:220:250:250:250:553:550:214:252:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -542-:503:501:501:250:553:553:550:214:252:502:250:502:250:250:250
Sendmail 8.11.6/8.11.6 -543-:220:501:501:250:553:250:250:214:252:502:502:250:250:250:250
Sendmail 8.11.6/8.11.6 -544-:503:501:501:250:553:553:250:214:250:250:502:250:250:250:250
Sendmail 8.11.6/8.11.6 -545-:250:501:250:250:250:250:550:214:252:250:250:502:502:250:220
Sendmail 8.11.6/8.11.6 -546-:220:220:501:250:250:250:550:250:252:502:502:250:250:250:250
Sendmail 8.11.6/8.11.6 -547-:250:220:250:250:553:250:250:250:250:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -548-:220:501:501:250:553:250:250:214:250:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -549-:250:501:250:250:553:550:550:214:252:250:250:250:250:250:220
Sendmail 8.11.6/8.11.6 -550-:250:501:501:250:553:553:250:250:252:250:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -551-:220:501:250:250:250:250:550:214:252:502:250:250:502:250:250
Sendmail 8.11.6/8.11.6 -552-:250:501:501:250:553:553:250:214:250:250:502:250:502:250:250
Sendmail 8.11.6/8.11.6 -553-:220:220:250:250:553:250:250:250:250:502:250:250:502:250:220
Sendmail 8.11.6/8.11.6 -554-:250:220:250:250:553:553:550:214:250:250:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -555-:220:220:250:250:553:553:550:250:250:250:250:250:502:250:220
Sendmail 8.11.6/8.11.6 -556-:250:501:501:250:250:250:250:250:252:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -557-:250:220:501:250:250:250:250:214:252:502:502:250:250:250:250
Sendmail 8.11.6/8.11.6 -558-:250:220:250:250:250:250:550:214:252:502:502:250:502:250:250
Sendmail 8.11.6/8.11.6 -559-:250:220:501:250:553:553:550:214:250:250:250:502:502:250:250
Sendmail 8.11.6/8.11.6 -560-:503:501:250:250:553:250:250:214:252:502:502:250:502:250:220
Sendmail 8.11.6/8.11.6 -561-:220:501:501:250:553:553:550:214:250:502:502:250:502:250:250
Sendmail 8.11.6/8.11.6 -562-:503:501:501:250:250:250:550:250:250:250:250:502:502:250:250
Sendmail 8.11.6/8.11.6 -563-:250:220:250:250:553:250:550:214:252:502:502:250:250:250:250
Sendmail 8.11.6/8.11.6 -564-:250:501:250:250:250:250:250:250:250:502:250:250:250:250:250
Sendmail 8.11.6/8.11.6 -565-:220:220:501:250:250:250:550:250:252:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6 -566-:250:501:250:250:553:553:250:214:252:250:502:502:502:250:220
Sendmail 8.11.6/8.11.6 -567-:503:220:501:250:250:250:250:250:250:250:250:250:250:250:250
Sendmail 8.11.6/8.11.6 -568-:250:501:501:250:250:250:550:250:252:502:250:502:250:250:220
Sendmail 8.11.6/8.11.6 -569-:250:501:501:250:553:553:550:214:250:250:250:250:250:250:220
Sendmail 8.11.6/8.11.6 -570-:220:501:501:250:553:250:550:214:252:250:250:250:502:250:220
Sendmail 8.11.6/8.11.6 -571-:250:501:501:250:553:250:550:214:250:502:502:250:250:250:250
Sendmail 8.11.6/8.11.6 -572-:220:220:501:250:553:553:550:214:250:502:250:250:502:250:250
Sendmail 8.11.6/8.11.6 -573-:250:220:250:250:553:250:250:214:250:502:502:250:502:250:250
Sendmail 8.11.6/8.11.6 -574-:503:220:501:250:553:553:550:214:252:250:250:502:502:250:220
Sendmail 8.11.6/8.11.6 -575-:503:220:501:250:250:250:550:214:252:502:502:502:250:250:220
Sendmail 8.11.6/8.11.6 -576-:220:220:501:250:553:553:550:214:252:250:250:250:250:250:250
Sendmail 8.11.6/8.11.6 -577-:220:220:501:250:250:553:550:214:252:502:250:502:250:250:250
Sendmail 8.11.6/8.11.6 -578-:220:220:250:250:553:250:250:214:252:502:250:250:250:250:250
Sendmail 8.11.6/8.11.6 (Netbuy.nl):250:501:501:250:553:501:250:214:250:250:250:502:502:250:250
Sendmail 8.11.6/8.11.6/SuSE Linux 0.5 -0-:503:501:501:250:553:553:550:250:250:250:250:250:250:250:220
Sendmail 8.11.6/8.11.6/SuSE Linux 0.5 -1-:503:220:501:250:553:553:550:214:252:502:250:502:502:250:250
Sendmail 8.11.6/8.11.6/SuSE Linux 0.5 -2-:503:220:501:250:553:553:550:214:252:250:502:502:250:250:220
Sendmail 8.11.6/8.11.6/SuSE Linux 0.5 -3-:503:501:250:250:250:553:550:250:252:250:502:502:502:250:250
Sendmail 8.11.6/8.11.6/SuSE Linux 0.5 -4-:503:501:501:250:553:250:550:214:250:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6/SuSE Linux 0.5 -5-:503:501:501:250:553:553:250:214:250:502:250:502:250:250:250
Sendmail 8.11.6/8.11.6/SuSE Linux 0.5 -6-:220:501:250:250:553:250:250:250:252:502:250:502:250:250:220
Sendmail 8.11.6/8.11.6/SuSE Linux 0.5 -7-:220:501:250:250:250:553:550:214:250:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6/SuSE Linux 0.5 -8-:503:501:501:220:553:553:550:214:252:502:502:502:502:250:250
Sendmail 8.11.6/8.11.6/SuSE Linux 0.5 -9-:503:501:501:250:553:553:503:214:252:502:502:502:502:250:250
Sendmail 8.11.6/8.9.3 -0-:220:220:250:250:250:250:250:250:250:250:502:502:502:250:220
Sendmail 8.11.6/8.9.3 -1-:220:220:250:250:250:250:250:502:250:250:250:250:502:250:220
Sendmail 8.11.6/8.9.3 -2-:220:220:250:250:553:250:550:502:250:250:502:502:502:250:250
Sendmail 8.11.6/8.9.3 -3-:503:501:501:250:553:501:550:502:250:502:502:502:502:250:250
Sendmail 8.11.6/8.9.3 -4-:220:220:250:250:553:250:550:502:250:250:502:502:250:250:250
Sendmail 8.11.6/8.9.3 -5-:250:501:501:250:553:501:550:502:250:250:502:502:502:250:250
Sendmail 8.11.6/8.9.3 -6-:220:220:250:250:250:250:550:250:250:250:250:502:502:250:220
Sendmail 8.11.6/8.9.3 -7-:250:501:501:250:553:250:250:502:250:250:502:502:502:250:250
Sendmail 8.11.6/8.9.3 -8-:220:220:250:250:553:250:250:502:252:502:502:250:250:250:250
Sendmail 8.11.6/8.9.3 -9-:220:501:250:250:250:250:550:502:250:250:250:502:250:250:250
Sendmail 8.11.6/8.9.3 -10-:220:220:250:250:553:250:550:250:250:250:250:502:502:250:220
Sendmail 8.11.6/8.9.3 -11-:250:220:501:250:250:250:250:502:250:250:502:502:502:250:250
Sendmail 8.11.6/GrafiX Internet B.V. -0-:220:220:501:250:553:250:250:214:252:250:502:502:250:250:220
Sendmail 8.11.6/GrafiX Internet B.V. -1-:220:220:501:250:250:250:550:214:250:502:502:250:502:250:220
Sendmail 8.11.6/GrafiX Internet B.V. -2-:250:501:250:250:250:250:250:250:252:502:502:250:502:250:250
Sendmail 8.11.6/GrafiX Internet B.V. -3-:250:501:501:250:553:250:250:214:252:502:250:250:502:250:250
Sendmail 8.11.6/GrafiX Internet B.V. -4-:250:501:501:250:553:250:550:214:252:502:250:502:250:250:250
Sendmail 8.11.6/GrafiX Internet B.V. -5-:250:501:501:250:553:250:550:250:252:502:250:502:502:250:250
Sendmail 8.11.6/GrafiX Internet B.V. -6-:250:501:501:250:250:250:250:214:252:502:250:502:502:250:220
Sendmail 8.11.6/GrafiX Internet B.V. -7-:250:501:501:250:553:250:550:214:252:250:250:502:250:250:220
Sendmail 8.11.6/GrafiX Internet B.V. -8-:250:220:501:250:250:250:550:214:252:502:250:250:250:250:220
Sendmail 8.11.6/GrafiX Internet B.V. -9-:250:220:250:250:250:250:250:214:252:502:250:250:502:250:220
Sendmail 8.11.6/GrafiX Internet B.V. -10-:220:220:250:250:553:250:550:250:250:250:250:250:250:250:220
Sendmail 8.11.6/GrafiX Internet B.V. -11-:250:220:501:250:250:250:250:214:252:250:502:502:250:250:220
Sendmail 8.11.6/GrafiX Internet B.V. -12-:250:501:501:250:553:250:250:214:252:502:250:502:502:250:250
Sendmail 8.11.6/GrafiX Internet B.V. -13-:250:501:501:250:553:250:550:250:252:502:502:502:250:250:250
Sendmail 8.11.6/GrafiX Internet B.V. -14-:250:501:501:250:553:250:550:250:250:502:250:250:502:250:250
Sendmail 8.11.6/GrafiX Internet B.V. -15-:220:501:501:250:250:250:250:214:252:502:502:502:250:250:250
Sendmail 8.11.6/GrafiX Internet B.V. -16-:250:501:501:250:553:250:550:214:252:502:250:250:502:250:250
Sendmail 8.11.6/WindoNet Internetdiensten:220:501:250:250:250:250:250:214:252:502:502:502:502:250:220
Sendmail 8.11.6/verio:220:501:501:250:553:553:550:502:250:250:502:502:502:250:250
Sendmail 8.11.6p2/8.11.1:220:501:250:250:553:250:250:250:250:502:250:250:502:250:220
Sendmail 8.11.6p2/8.11.3:250:501:501:250:553:501:550:214:250:250:502:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -0-:250:501:501:250:553:553:250:250:252:502:250:250:502:250:250
Sendmail 8.11.6p2/8.11.6 -1-:503:220:501:250:553:250:550:214:252:250:502:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -2-:550:501:501:250:553:553:503:214:252:502:502:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -3-:220:501:501:250:250:553:250:250:250:250:502:502:250:250:250
Sendmail 8.11.6p2/8.11.6 -4-:250:501:501:250:553:250:250:214:252:502:250:250:250:250:250
Sendmail 8.11.6p2/8.11.6 -5-:220:501:250:250:553:250:550:214:250:502:502:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -6-:503:501:250:250:250:553:250:250:250:502:250:502:250:250:250
Sendmail 8.11.6p2/8.11.6 -7-:250:220:501:250:250:250:250:214:250:250:502:502:250:250:250
Sendmail 8.11.6p2/8.11.6 -8-:220:220:501:250:250:250:550:250:252:502:502:250:502:250:220
Sendmail 8.11.6p2/8.11.6 -9-:503:220:501:250:553:553:250:250:250:250:250:250:250:250:250
Sendmail 8.11.6p2/8.11.6 -10-:250:501:501:250:553:250:250:214:250:502:250:250:250:250:250
Sendmail 8.11.6p2/8.11.6 -11-:220:220:250:250:553:250:550:250:250:250:502:502:250:250:250
Sendmail 8.11.6p2/8.11.6 -12-:220:501:501:250:553:250:550:250:252:502:250:250:502:250:220
Sendmail 8.11.6p2/8.11.6 -13-:503:501:250:250:553:250:250:214:250:250:502:502:502:250:220
Sendmail 8.11.6p2/8.11.6 -14-:220:220:250:250:250:553:550:250:252:502:250:250:250:250:220
Sendmail 8.11.6p2/8.11.6 -15-:220:220:250:250:250:553:250:250:252:250:250:250:250:250:250
Sendmail 8.11.6p2/8.11.6 -16-:220:220:501:250:250:250:250:250:250:502:502:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -17-:220:220:250:250:250:553:550:214:252:502:502:502:250:250:220
Sendmail 8.11.6p2/8.11.6 -18-:250:220:250:250:250:553:250:250:252:250:502:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -19-:250:220:250:250:250:553:250:250:250:250:502:502:502:250:220
Sendmail 8.11.6p2/8.11.6 -20-:220:220:250:250:250:553:550:214:252:502:250:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -21-:220:220:250:250:250:553:550:250:250:502:502:250:250:250:220
Sendmail 8.11.6p2/8.11.6 -22-:220:501:501:250:553:553:250:214:252:250:250:250:250:250:220
Sendmail 8.11.6p2/8.11.6 -23-:220:501:250:250:250:250:250:250:250:502:250:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -24-:503:501:501:250:553:250:250:214:250:502:250:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -25-:220:501:501:250:553:553:250:250:252:502:250:502:502:250:220
Sendmail 8.11.6p2/8.11.6 -26-:250:501:250:250:553:553:250:214:250:250:250:250:250:250:220
Sendmail 8.11.6p2/8.11.6 -27-:220:501:250:250:553:553:550:214:250:502:502:250:502:250:250
Sendmail 8.11.6p2/8.11.6 -28-:220:220:501:250:250:250:550:214:252:502:502:250:250:250:220
Sendmail 8.11.6p2/8.11.6 -29-:250:501:250:250:553:553:250:214:250:502:502:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -30-:220:220:501:250:553:250:250:250:252:502:502:502:250:250:250
Sendmail 8.11.6p2/8.11.6 -31-:503:501:501:250:250:250:550:214:252:250:250:250:502:250:220
Sendmail 8.11.6p2/8.11.6 -32-:220:501:250:250:553:250:550:250:250:250:250:250:250:250:250
Sendmail 8.11.6p2/8.11.6 -33-:250:220:501:250:553:553:550:214:252:502:250:250:250:250:220
Sendmail 8.11.6p2/8.11.6 -34-:250:501:501:250:553:553:550:214:252:250:250:250:250:250:250
Sendmail 8.11.6p2/8.11.6 -35-:503:501:501:250:553:553:550:250:252:502:502:502:250:250:250
Sendmail 8.11.6p2/8.11.6 -36-:220:501:501:250:553:250:550:214:250:250:502:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -37-:503:501:250:250:553:250:550:214:252:502:250:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -38-:220:220:250:250:250:250:250:250:252:502:502:502:502:250:220
Sendmail 8.11.6p2/8.11.6 -39-:250:501:501:250:250:553:250:214:250:502:502:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -40-:220:501:250:250:553:553:550:214:252:502:502:502:250:250:220
Sendmail 8.11.6p2/8.11.6 -41-:220:501:250:250:553:553:250:214:252:502:502:250:502:250:250
Sendmail 8.11.6p2/8.11.6 -42-:220:501:250:250:553:250:550:250:252:502:502:250:502:250:250
Sendmail 8.11.6p2/8.11.6 -43-:220:501:250:250:250:553:250:214:250:250:250:250:502:250:250
Sendmail 8.11.6p2/8.11.6 -44-:220:220:501:250:553:250:550:214:252:250:502:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -45-:503:220:250:250:250:250:250:214:252:502:250:250:502:250:250
Sendmail 8.11.6p2/8.11.6 -46-:503:501:501:250:553:250:250:214:252:250:250:250:502:250:220
Sendmail 8.11.6p2/8.11.6 -47-:220:220:250:250:553:250:250:214:252:502:502:502:502:250:220
Sendmail 8.11.6p2/8.11.6 -48-:250:501:501:250:250:250:250:250:252:502:502:250:502:250:220
Sendmail 8.11.6p2/8.11.6 -49-:250:501:250:250:250:553:250:250:252:502:502:502:250:250:250
Sendmail 8.11.6p2/8.11.6 -50-:220:220:250:250:553:250:550:214:250:502:502:250:502:250:250
Sendmail 8.11.6p2/8.11.6 -51-:503:501:501:250:553:553:250:214:252:250:250:250:250:250:250
Sendmail 8.11.6p2/8.11.6 -52-:220:220:250:250:250:553:250:214:252:502:502:250:502:250:250
Sendmail 8.11.6p2/8.11.6 -53-:250:501:501:250:553:250:250:214:250:502:250:250:502:250:250
Sendmail 8.11.6p2/8.11.6 -54-:220:501:501:250:250:250:550:214:252:502:502:250:502:250:250
Sendmail 8.11.6p2/8.11.6 -55-:250:501:501:250:553:553:550:250:252:502:502:250:502:250:250
Sendmail 8.11.6p2/8.11.6 -56-:220:501:501:250:553:250:550:250:250:502:502:250:502:250:250
Sendmail 8.11.6p2/8.11.6 -57-:220:220:501:250:553:250:250:250:250:250:502:250:250:250:220
Sendmail 8.11.6p2/8.11.6 -58-:503:220:501:250:553:250:250:214:252:502:502:250:502:250:250
Sendmail 8.11.6p2/8.11.6 -59-:220:220:501:250:553:553:550:250:252:250:250:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -60-:503:220:250:250:553:250:550:214:252:502:250:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -61-:503:501:250:250:553:553:550:214:252:250:502:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -62-:250:501:501:250:250:553:550:250:252:502:250:250:250:250:220
Sendmail 8.11.6p2/8.11.6 -63-:220:501:501:250:553:553:250:214:250:502:250:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -64-:220:220:250:250:250:250:550:214:250:250:502:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -65-:250:501:250:250:553:553:550:250:252:250:250:250:250:250:220
Sendmail 8.11.6p2/8.11.6 -66-:220:501:501:250:553:553:550:214:252:502:502:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -67-:220:220:501:250:553:250:550:214:250:502:502:502:250:250:220
Sendmail 8.11.6p2/8.11.6 -68-:250:220:501:250:553:250:250:214:252:250:502:250:250:250:250
Sendmail 8.11.6p2/8.11.6 -69-:250:220:501:250:250:553:250:250:250:250:502:502:502:250:220
Sendmail 8.11.6p2/8.11.6 -70-:220:501:501:250:553:250:550:250:250:502:502:502:250:250:250
Sendmail 8.11.6p2/8.11.6 -71-:503:220:250:250:553:250:550:250:252:502:250:502:250:250:250
Sendmail 8.11.6p2/8.11.6 -72-:220:501:501:250:250:553:250:214:252:502:502:250:502:250:250
Sendmail 8.11.6p2/8.11.6 -73-:503:220:250:250:250:553:250:250:250:250:502:250:502:250:220
Sendmail 8.11.6p2/8.11.6 -74-:220:220:501:250:553:250:250:250:252:502:502:250:502:250:250
Sendmail 8.11.6p2/8.11.6 -75-:503:501:501:250:553:250:550:214:252:502:502:502:250:250:250
Sendmail 8.11.6p2/8.11.6 -76-:503:501:250:250:553:250:550:214:252:250:250:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -77-:503:220:250:250:250:250:250:250:250:250:502:250:250:250:220
Sendmail 8.11.6p2/8.11.6 -78-:220:220:501:250:553:250:250:250:250:502:250:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -79-:220:501:501:250:553:250:550:214:250:502:502:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -80-:220:501:501:250:553:553:250:214:252:250:250:502:502:250:220
Sendmail 8.11.6p2/8.11.6 -81-:250:220:250:250:553:250:250:250:250:250:502:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -82-:250:501:250:250:553:553:550:250:250:502:250:502:250:250:250
Sendmail 8.11.6p2/8.11.6 -83-:220:220:250:250:250:250:550:214:252:250:502:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -84-:503:220:250:250:553:250:250:214:252:502:502:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -85-:220:501:501:250:250:553:250:250:252:502:502:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -86-:250:220:250:250:553:553:250:214:250:502:250:502:502:250:220
Sendmail 8.11.6p2/8.11.6 -87-:250:501:250:250:553:250:250:214:250:502:502:250:502:250:250
Sendmail 8.11.6p2/8.11.6 -88-:503:501:501:250:553:250:550:214:250:502:502:250:250:250:250
Sendmail 8.11.6p2/8.11.6 -89-:503:220:250:250:250:250:550:214:250:502:250:502:250:250:220
Sendmail 8.11.6p2/8.11.6 -90-:503:501:250:250:250:553:250:214:250:502:502:502:502:250:220
Sendmail 8.11.6p2/8.11.6 -91-:220:501:501:250:553:250:250:214:252:250:502:250:502:250:220
Sendmail 8.11.6p2/8.11.6 -92-:503:501:250:250:553:553:250:214:252:250:502:502:502:250:220
Sendmail 8.11.6p2/8.11.6 -93-:250:220:250:250:553:553:550:250:252:250:502:502:250:250:250
Sendmail 8.11.6p2/8.11.6 -94-:503:220:250:250:250:250:550:214:252:502:502:502:250:250:220
Sendmail 8.11.6p2/8.11.6 -95-:220:501:250:250:250:250:250:250:252:250:250:250:250:250:250
Sendmail 8.11.6p2/8.11.6 -96-:503:501:250:250:250:250:550:214:252:502:502:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -97-:503:501:250:250:553:553:550:214:252:502:502:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -98-:503:501:501:250:553:250:250:214:252:250:502:502:250:250:250
Sendmail 8.11.6p2/8.11.6 -99-:220:501:250:250:250:553:250:214:252:250:502:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -100-:220:501:501:250:250:553:550:214:252:250:502:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -101-:220:220:501:250:553:553:250:214:252:502:502:250:250:250:250
Sendmail 8.11.6p2/8.11.6 -102-:220:220:501:250:250:553:250:214:252:250:502:250:502:250:220
Sendmail 8.11.6p2/8.11.6 -103-:503:220:250:250:250:250:250:250:250:250:502:502:250:250:250
Sendmail 8.11.6p2/8.11.6 -104-:503:220:250:250:553:250:550:214:250:502:502:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -105-:503:220:501:250:553:250:250:214:252:502:250:250:250:250:250
Sendmail 8.11.6p2/8.11.6 -106-:220:501:501:250:250:250:550:214:252:502:502:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -107-:220:220:501:250:250:250:250:250:252:250:502:250:250:250:250
Sendmail 8.11.6p2/8.11.6 -108-:250:501:501:250:553:553:250:214:250:502:250:250:250:250:250
Sendmail 8.11.6p2/8.11.6 -109-:250:501:250:250:250:553:550:214:252:502:250:250:250:250:250
Sendmail 8.11.6p2/8.11.6 -110-:250:501:501:250:553:553:250:214:252:502:502:502:502:250:220
Sendmail 8.11.6p2/8.11.6 -111-:220:220:501:250:553:553:550:250:252:250:502:250:502:250:250
Sendmail 8.11.6p2/8.11.6 -112-:220:501:501:250:553:250:550:214:252:250:502:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -113-:503:220:501:250:553:250:550:250:250:250:250:250:502:250:220
Sendmail 8.11.6p2/8.11.6 -114-:250:220:250:250:250:553:250:214:250:502:250:250:250:250:250
Sendmail 8.11.6p2/8.11.6 -115-:250:501:501:250:250:250:250:250:252:502:502:250:250:250:250
Sendmail 8.11.6p2/8.11.6 -116-:220:501:501:250:553:250:550:250:250:502:502:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -117-:220:501:250:250:250:250:550:250:252:502:502:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -118-:220:501:501:250:250:553:250:250:252:502:250:250:250:250:250
Sendmail 8.11.6p2/8.11.6 -119-:250:220:501:250:553:553:250:250:252:502:502:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -120-:503:220:501:250:553:553:250:214:250:502:502:250:502:250:250
Sendmail 8.11.6p2/8.11.6 -121-:220:220:250:250:250:553:550:214:250:502:250:250:250:250:250
Sendmail 8.11.6p2/8.11.6 -122-:503:501:250:250:553:250:550:214:252:502:250:250:250:250:220
Sendmail 8.11.6p2/8.11.6 -123-:250:501:250:250:553:250:250:214:252:250:502:250:250:250:250
Sendmail 8.11.6p2/8.11.6 -124-:220:501:501:250:553:250:550:250:252:250:502:502:250:250:250
Sendmail 8.11.6p2/8.11.6 -125-:220:501:250:250:553:553:250:250:250:502:502:250:502:250:220
Sendmail 8.11.6p2/8.11.6 -126-:503:220:501:250:553:553:550:214:252:502:502:250:250:250:220
Sendmail 8.11.6p2/8.11.6 -127-:503:501:501:250:250:553:250:214:252:502:502:250:250:250:250
Sendmail 8.11.6p2/8.11.6 -128-:503:220:501:250:553:250:550:214:252:502:502:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -129-:503:501:250:250:553:553:250:250:250:250:250:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -130-:503:501:250:250:553:250:550:214:252:502:502:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -131-:503:220:501:250:553:250:250:214:252:502:502:250:250:250:250
Sendmail 8.11.6p2/8.11.6 -132-:220:501:501:250:553:250:550:214:252:250:250:250:502:250:250
Sendmail 8.11.6p2/8.11.6 -133-:503:501:501:250:553:250:550:214:252:250:250:250:502:250:250
Sendmail 8.11.6p2/8.11.6 -134-:503:501:501:250:553:250:550:214:250:250:502:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -135-:250:220:250:250:250:553:250:250:252:502:502:502:250:250:250
Sendmail 8.11.6p2/8.11.6 -136-:220:220:501:250:250:250:250:250:252:250:250:250:250:250:220
Sendmail 8.11.6p2/8.11.6 -137-:503:501:250:250:553:553:250:214:252:502:502:250:250:250:220
Sendmail 8.11.6p2/8.11.6 -138-:503:220:250:250:250:250:550:214:252:250:502:502:250:250:220
Sendmail 8.11.6p2/8.11.6 -139-:220:501:501:250:250:553:250:250:252:502:502:502:502:250:220
Sendmail 8.11.6p2/8.11.6 -140-:220:220:250:250:553:553:250:214:252:250:502:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -141-:220:220:250:250:250:553:250:214:252:502:502:502:502:250:220
Sendmail 8.11.6p2/8.11.6 -142-:503:220:250:250:250:250:250:250:250:502:250:502:250:250:220
Sendmail 8.11.6p2/8.11.6 -143-:220:220:250:250:553:553:250:214:252:502:502:502:250:250:250
Sendmail 8.11.6p2/8.11.6 -144-:503:220:501:250:553:250:550:214:252:502:502:250:502:250:250
Sendmail 8.11.6p2/8.11.6 -145-:503:501:501:250:553:250:550:250:250:250:502:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -146-:220:220:501:250:553:553:250:214:252:502:250:502:502:250:220
Sendmail 8.11.6p2/8.11.6 -147-:503:220:501:250:553:250:250:250:250:502:502:250:502:250:250
Sendmail 8.11.6p2/8.11.6 -148-:250:501:501:250:250:553:250:250:250:250:250:502:250:250:220
Sendmail 8.11.6p2/8.11.6 -149-:250:501:501:250:250:553:550:214:252:502:502:250:502:250:250
Sendmail 8.11.6p2/8.11.6 -150-:220:501:501:250:553:553:250:214:252:502:502:250:502:250:250
Sendmail 8.11.6p2/8.11.6 -151-:220:220:501:250:250:250:250:214:252:502:502:502:250:250:250
Sendmail 8.11.6p2/8.11.6 -152-:250:501:250:250:553:553:250:214:250:502:502:502:502:250:220
Sendmail 8.11.6p2/8.11.6 -153-:220:220:501:250:553:250:250:250:252:250:502:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -154-:250:501:501:250:250:553:250:214:250:250:502:502:250:250:220
Sendmail 8.11.6p2/8.11.6 -155-:220:501:501:250:553:250:250:250:252:250:502:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -156-:220:501:250:250:250:250:550:214:252:250:502:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -157-:250:220:250:250:553:250:250:250:252:250:502:502:250:250:220
Sendmail 8.11.6p2/8.11.6 -158-:503:501:501:250:250:553:550:250:252:502:502:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -159-:220:220:501:250:553:553:250:214:250:250:502:250:502:250:220
Sendmail 8.11.6p2/8.11.6 -160-:220:501:501:250:553:250:550:214:250:250:250:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -161-:503:220:250:250:553:553:250:214:250:502:502:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -162-:220:501:250:250:250:250:250:214:252:502:250:250:250:250:250
Sendmail 8.11.6p2/8.11.6 -163-:250:501:501:250:250:250:250:214:252:502:502:502:250:250:220
Sendmail 8.11.6p2/8.11.6 -164-:220:220:250:250:553:553:250:214:250:250:502:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -165-:220:501:501:250:553:553:250:214:252:250:502:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -166-:220:220:501:250:250:250:550:250:252:250:502:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -167-:503:501:250:250:250:250:550:214:252:250:502:502:502:250:220
Sendmail 8.11.6p2/8.11.6 -168-:503:501:501:250:553:553:250:214:252:250:502:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -169-:503:220:250:250:250:553:250:214:252:250:250:502:250:250:250
Sendmail 8.11.6p2/8.11.6 -170-:503:501:501:250:553:250:550:214:252:250:250:502:502:250:220
Sendmail 8.11.6p2/8.11.6 -171-:250:220:250:250:250:553:250:250:250:502:502:250:250:250:220
Sendmail 8.11.6p2/8.11.6 -172-:220:220:250:250:553:250:250:214:252:250:250:250:502:250:250
Sendmail 8.11.6p2/8.11.6 -173-:220:501:501:250:553:553:250:214:252:502:250:250:502:250:250
Sendmail 8.11.6p2/8.11.6 -174-:220:501:250:250:250:553:250:250:250:250:502:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -175-:503:501:250:250:553:250:550:214:250:250:502:250:502:250:250
Sendmail 8.11.6p2/8.11.6 -176-:220:220:250:250:553:553:250:250:250:502:502:502:250:250:250
Sendmail 8.11.6p2/8.11.6 -177-:220:501:501:250:553:250:550:214:250:502:502:250:250:250:220
Sendmail 8.11.6p2/8.11.6 -178-:503:220:501:250:553:250:550:214:252:502:502:502:250:250:220
Sendmail 8.11.6p2/8.11.6 -179-:220:220:250:250:250:553:250:214:252:250:250:250:502:250:250
Sendmail 8.11.6p2/8.11.6 -180-:220:220:501:250:553:250:250:214:252:250:250:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -181-:220:501:501:250:553:250:250:250:250:250:502:502:250:250:250
Sendmail 8.11.6p2/8.11.6 -182-:250:501:501:250:250:553:250:214:252:250:502:502:502:250:250
Sendmail 8.11.6p2/8.11.6 -183-:220:501:501:250:250:250:550:214:250:502:502:502:502:250:250
Sendmail 8.11.7/8.11.4/VUT Brno:550:501:501:250:553:553:503:214:250:250:502:502:502:250:250
Sendmail 8.11.7/8.11.7 -0-:220:501:501:250:250:250:250:214:252:250:502:250:250:250:220
Sendmail 8.11.7/8.11.7 -1-:220:501:501:250:553:250:550:250:252:502:502:502:250:250:250
Sendmail 8.11.7/8.11.7 -2-:250:220:250:250:250:250:250:214:250:502:502:502:502:250:250
Sendmail 8.11.7/8.11.7 -3-:250:220:250:250:553:250:250:250:250:502:502:502:250:250:220
Sendmail 8.11.7/8.11.7 -4-:250:220:501:250:250:250:250:250:250:250:250:250:250:250:250
Sendmail 8.11.7/8.11.7 -5-:250:501:250:250:553:250:550:214:252:250:250:250:502:250:250
Sendmail 8.11.7/8.11.7 -6-:250:501:501:250:250:250:250:214:250:502:502:502:250:250:250
Sendmail 8.11.7/8.11.7 -7-:250:220:501:250:553:250:550:250:252:250:502:502:502:250:220
Sendmail 8.11.7/8.11.7 -8-:220:501:250:250:250:250:550:250:250:502:502:502:502:250:250
Sendmail 8.11.7/8.11.7 -9-:250:220:250:250:553:250:250:214:250:502:502:502:250:250:250
Sendmail 8.11.7/8.11.7 -10-:250:501:501:250:553:250:250:250:250:250:502:250:502:250:250
Sendmail 8.11.7/8.11.7 -11-:220:220:501:250:250:250:550:250:250:502:250:250:250:250:220
Sendmail 8.11.7/8.11.7 -12-:250:220:250:250:553:250:250:214:250:502:250:250:502:250:220
Sendmail 8.11.7/8.11.7 -13-:250:220:250:250:250:250:250:250:250:502:502:502:250:250:220
Sendmail 8.11.7/8.11.7 -14-:250:501:250:250:553:250:550:250:252:502:502:502:502:250:220
Sendmail 8.11.7/8.11.7 -15-:220:220:501:250:553:250:550:214:252:502:502:250:250:250:250
Sendmail 8.11.7/8.11.7 -16-:250:220:250:250:250:250:550:250:252:502:502:502:502:250:220
Sendmail 8.11.7/8.11.7 -17-:250:501:501:250:250:250:550:214:250:502:502:250:502:250:220
Sendmail 8.11.7/8.11.7 -18-:220:501:250:250:553:250:550:250:250:250:502:502:502:250:250
Sendmail 8.11.7/8.11.7 -19-:250:220:250:250:250:250:550:214:250:250:502:502:250:250:250
Sendmail 8.11.7/8.11.7 -20-:250:220:250:250:250:250:550:214:252:250:502:502:250:250:250
Sendmail 8.11.7/8.11.7 -21-:220:501:250:250:553:250:550:250:250:502:502:502:250:250:220
Sendmail 8.11.7/8.11.7 -22-:220:220:250:250:553:250:550:214:252:250:250:502:502:250:250
Sendmail 8.11.7/8.11.7 -23-:250:220:250:250:553:250:550:214:252:502:502:502:250:250:220
Sendmail 8.11.7/8.11.7 -24-:250:220:501:250:250:250:550:250:250:502:502:250:502:250:250
Sendmail 8.11.7/8.11.7 -25-:250:220:250:250:250:250:250:214:250:502:502:502:250:250:250
Sendmail 8.11.7/8.11.7 -26-:250:501:501:250:553:250:550:250:250:502:502:250:250:250:220
Sendmail 8.11.7/8.11.7 -27-:250:220:250:250:553:250:250:250:250:250:250:502:502:250:250
Sendmail 8.11.7/8.11.7 -28-:250:501:250:250:553:250:250:250:252:250:250:502:502:250:250
Sendmail 8.11.7/8.11.7 -29-:220:220:501:250:553:250:250:214:252:250:250:250:250:250:250
Sendmail 8.11.7/8.11.7 -30-:250:220:501:250:250:250:250:214:252:250:250:250:502:250:250
Sendmail 8.11.7/8.11.7 -31-:250:220:501:250:250:250:250:250:250:502:502:502:502:250:250
Sendmail 8.11.7/8.11.7 -32-:250:501:250:250:250:250:250:250:252:502:250:250:502:250:220
Sendmail 8.11.7/8.11.7 -33-:250:501:501:250:553:250:250:250:252:250:502:250:250:250:250
Sendmail 8.12.1/8.12.1 -0-:503:220:250:250:553:553:250:214:250:250:250:250:250:250:220
Sendmail 8.12.1/8.12.1 -1-:220:220:250:250:553:553:250:214:252:502:250:250:502:250:220
Sendmail 8.12.1/8.12.1 -2-:503:220:501:250:553:553:250:214:252:250:502:502:502:250:250
Sendmail 8.12.1/8.12.1 -3-:220:220:250:250:250:250:250:214:250:250:502:250:250:250:250
Sendmail 8.12.1/8.12.1 -4-:220:501:250:250:553:250:550:250:250:250:502:502:502:250:220
Sendmail 8.12.1/8.12.1 -5-:220:220:250:250:250:250:250:250:252:502:502:250:502:250:250
Sendmail 8.12.1/8.12.1 -6-:220:220:250:250:553:553:250:214:252:502:250:502:250:250:250
Sendmail 8.12.1/8.12.1 -7-:220:501:501:250:250:250:250:250:250:250:502:502:502:250:220
Sendmail 8.12.1/8.12.1/25-10-2001:220:220:501:250:250:553:550:250:250:250:250:250:502:250:220
Sendmail 8.12.1/SilverpointIS:220:501:250:250:250:250:550:214:250:250:502:250:502:250:250
Sendmail 8.12.2 -0-:250:501:501:250:553:553:550:214:250:250:502:502:502:250:250
Sendmail 8.12.2 -1-:250:501:501:250:553:250:550:214:250:250:502:502:502:250:250
Sendmail 8.12.2-8.12.5:250:501:501:250:553:553:550:214:252:502:502:502:502:250:250
Sendmail 8.12.2/8.12.2/SuSE Linux 0.6:503:220:501:250:553:553:250:214:252:502:502:502:502:250:250
Sendmail 8.12.2/8.12.2/SideWinder Firewall:503:501:501:250:553:250:250:502:252:502:502:502:502:250:250
Secure Computing SideWinder G2, 6.0.3:503:501:501:250:553:553:250:502:252:502:502:502:502:250:250
Sendmail 8.12.3/8.11.3/SuSE Linux 8.11.1-0.5:503:501:501:250:553:250:250:214:252:502:502:502:502:250:250
Sendmail 8.12.3/8.12.3 -0-:250:501:501:250:553:553:550:214:250:502:502:502:502:250:250
Sendmail 8.12.3/8.12.3 -1-:250:501:250:250:553:553:250:214:250:250:250:250:250:250:250
Sendmail 8.12.3/8.12.3 -2-:220:501:501:250:553:250:550:214:250:250:250:250:250:250:220
Sendmail 8.12.3/8.12.3 -3-:250:220:250:250:250:250:250:250:250:250:250:502:502:250:250
Sendmail 8.12.3/8.12.3 -4-:250:220:250:250:250:553:550:214:250:250:250:250:250:250:220
Sendmail 8.12.3/8.12.3 -5-:220:220:250:250:250:553:550:250:250:250:250:502:502:250:220
Sendmail 8.12.3/8.12.3 -6-:250:501:501:250:553:553:550:214:250:250:250:502:250:250:250
Sendmail 8.12.3/8.12.3 -7-:220:501:250:250:250:553:550:250:250:250:250:250:502:250:250
Sendmail 8.12.3/8.12.3 -8-:250:501:501:250:553:553:250:250:250:250:250:502:250:250:250
Sendmail 8.12.3/8.12.3 -9-:220:501:501:250:553:250:550:250:250:250:502:502:502:250:220
Sendmail 8.12.3/8.12.3 -10-:220:501:250:250:250:250:250:214:250:250:250:502:502:250:250
Sendmail 8.12.3/8.12.3 -11-:250:501:501:250:553:553:550:214:250:250:502:502:250:250:250
Sendmail 8.12.3/8.12.3 -12-:250:220:250:250:250:553:250:214:250:250:250:250:502:250:220
Sendmail 8.12.3/8.12.3 -13-:220:501:250:250:553:250:250:214:250:250:502:250:502:250:250
Sendmail 8.12.3/8.12.3 -14-:220:501:250:250:553:553:550:214:250:250:502:250:250:250:220
Sendmail 8.12.3/8.12.3 -15-:220:220:250:250:250:250:550:214:250:250:250:250:502:250:220
Sendmail 8.12.3/8.12.3 -16-:220:220:501:250:553:553:250:214:250:250:502:250:502:250:250
Sendmail 8.12.3/8.12.3 -17-:220:501:501:250:250:250:250:214:250:250:250:502:502:250:220
Sendmail 8.12.3/8.12.3 -18-:220:220:250:250:250:553:550:214:250:250:250:250:250:250:250
Sendmail 8.12.3/8.12.3 -19-:250:501:501:250:250:250:250:250:250:250:250:502:502:250:220
Sendmail 8.12.3/8.12.3 -20-:250:220:501:250:250:553:550:250:250:250:502:502:502:250:250
Sendmail 8.12.3/8.12.3 -21-:250:501:501:250:250:553:550:214:250:250:502:502:250:250:250
Sendmail 8.12.3/8.12.3 -22-:250:220:501:250:553:250:250:214:250:250:502:250:502:250:250
Sendmail 8.12.3/8.12.3 -23-:220:501:250:250:553:250:250:250:250:250:250:502:502:250:250
Sendmail 8.12.3/8.12.3 -24-:250:220:501:250:250:250:250:214:250:250:250:250:502:250:250
Sendmail 8.12.3/8.12.3 -25-:220:501:501:250:250:250:250:250:250:250:502:502:250:250:250
Sendmail 8.12.3/8.12.3 -26-:250:220:501:250:250:250:550:250:250:250:250:250:250:250:250
Sendmail 8.12.3/8.12.3 -27-:250:220:250:250:553:553:250:250:250:250:502:502:250:250:220
Sendmail 8.12.3/8.12.3 -28-:220:220:250:250:250:250:550:502:250:250:502:250:502:250:250
Sendmail 8.12.3/8.12.3 -29-:220:220:250:250:553:553:250:250:250:250:502:502:250:250:250
Sendmail 8.12.3/8.12.3 -30-:220:501:501:250:553:553:250:502:250:250:502:502:502:250:250
Sendmail 8.12.3/8.12.3 -31-:220:220:250:250:553:553:550:250:250:250:250:250:502:250:250
Sendmail 8.12.3/8.12.3 -32-:220:220:501:250:553:553:550:214:250:250:250:250:250:250:250
Sendmail 8.12.3/8.12.3 -33-:220:501:501:250:553:553:550:502:250:250:502:502:250:250:220
Sendmail 8.12.3/8.12.3 -34-:220:501:501:250:553:553:550:502:250:250:502:250:502:250:250
Sendmail 8.12.3/8.12.3 -35-:220:220:250:250:553:553:250:502:250:250:502:502:502:250:220
Sendmail 8.12.3/8.12.3 -36-:220:220:250:250:250:553:250:502:250:250:502:502:250:250:250
Sendmail 8.12.3/8.12.3 -37-:220:220:250:250:250:250:250:502:250:250:250:502:502:250:220
Sendmail 8.12.3/8.12.3 -38-:250:501:501:250:553:553:550:502:250:250:250:250:502:250:220
Sendmail 8.12.3/8.12.3 -39-:220:501:250:250:250:553:550:250:250:250:502:502:502:250:250
Sendmail 8.12.3/8.12.3 -40-:220:220:250:250:250:553:550:502:250:250:502:250:502:250:250
Sendmail 8.12.3/8.12.3 -41-:250:220:250:250:553:250:550:250:250:250:250:502:502:250:250
Sendmail 8.12.3/8.12.3 -42-:220:220:501:250:553:553:550:250:250:250:250:502:502:250:250
Sendmail 8.12.3/8.12.3 -43-:220:220:250:250:553:553:550:502:250:250:502:250:250:250:220
Sendmail 8.12.3/8.12.3 -44-:220:220:250:250:250:250:250:502:250:250:250:250:502:250:250
Sendmail 8.12.3/8.12.3 -45-:250:220:250:250:250:553:550:250:250:250:502:502:250:250:220
Sendmail 8.12.3/8.12.3 -46-:220:220:501:250:250:553:250:214:250:250:250:250:250:250:250
Sendmail 8.12.3/8.12.3 -47-:250:220:250:250:250:553:550:214:250:250:250:250:502:250:220
Sendmail 8.12.3/8.12.3 -48-:220:501:250:250:553:553:550:250:250:250:502:502:502:250:220
Sendmail 8.12.3/8.12.3 -49-:250:220:250:250:553:250:250:214:250:250:250:502:250:250:250
Sendmail 8.12.3/8.12.3/SuSE Linux 0.6:503:501:501:250:553:553:550:214:252:250:502:502:502:250:250
Sendmail 8.12.3 -0-:503:501:501:250:553:250:550:214:252:502:502:502:502:250:250
Sendmail 8.12.3 -1-:451:501:501:250:553:451:503:214:252:502:502:502:502:250:250
Sendmail 8.12.3 -2-:250:220:250:250:250:250:550:214:250:250:250:250:502:250:220
Sendmail 8.12.3 -3-:250:501:250:250:250:250:550:214:250:250:502:250:250:250:250
Sendmail 8.12.3 -4-:220:501:250:250:250:553:550:250:250:250:502:502:502:250:220
Sendmail 8.12.3 -5-:220:220:250:250:553:250:550:214:250:250:250:502:250:250:220
Sendmail 8.12.3 -6-:250:220:501:250:553:553:550:214:250:250:250:250:250:250:250
Sendmail 8.12.3 -7-:250:220:501:250:553:250:250:250:250:250:502:502:250:250:250
Sendmail 8.12.3 -8-:220:220:250:250:553:553:550:214:250:250:502:250:502:250:250
Sendmail 8.12.3 -9-:250:501:501:250:553:250:550:214:250:250:250:502:502:250:220
Sendmail 8.12.3 -10-:220:220:501:250:250:553:550:214:250:250:250:250:502:250:250
Sendmail 8.12.3 -11-:250:501:250:250:553:553:550:214:250:250:250:502:502:250:250
Sendmail 8.12.3 -12-:220:220:250:250:553:553:550:214:250:250:502:250:250:250:220
Sendmail 8.12.3 -13-:220:220:501:250:250:250:250:214:250:250:250:250:250:250:220
Sendmail 8.12.4/8.12.4:220:501:250:250:553:250:250:214:250:250:250:250:250:250:250
Sendmail 8.12.5/8.11.4 -0-:220:220:501:250:250:250:250:214:250:250:250:250:502:250:250
Sendmail 8.12.5/8.11.4 -1-:250:220:250:250:250:553:550:250:250:502:502:502:502:250:250
Sendmail 8.12.5/8.11.4 -2-:220:220:250:250:553:553:550:214:250:502:502:250:502:250:250
Sendmail 8.12.5/8.11.4 -3-:220:220:250:250:250:553:550:214:250:502:250:502:250:250:250
Sendmail 8.12.5/8.11.6 -0-:220:220:250:250:553:250:550:250:250:502:502:250:502:250:220
Sendmail 8.12.5/8.11.6 -1-:250:220:250:250:250:250:550:502:252:502:502:502:502:250:250
Sendmail 8.12.5/8.11.6 -2-:220:501:501:250:250:250:550:502:252:250:502:502:250:250:250
Sendmail 8.12.5/8.11.6 -3-:220:220:250:250:250:250:550:502:250:502:502:502:502:250:220
Sendmail 8.12.5/8.11.6 -4-:220:220:250:250:553:250:550:502:252:502:502:502:250:250:250
Sendmail 8.12.5/8.11.6 -5-:220:220:501:250:553:250:550:502:252:502:250:502:502:250:220
Sendmail 8.12.5/8.11.6 -6-:220:220:250:250:250:250:550:502:252:250:502:502:502:250:250
Sendmail 8.12.5/8.12.5 -0-:250:501:250:250:553:250:550:214:252:502:502:502:502:250:250
Sendmail 8.12.5/8.12.5 -1-:250:501:501:250:553:553:250:214:250:250:502:502:502:250:250
Sendmail 8.12.5/8.12.5 -2-:220:501:501:250:250:553:550:214:250:250:502:250:502:250:250
Sendmail 8.12.5/8.12.5 -3-:250:501:501:250:553:553:550:214:252:502:250:250:502:250:250
Sendmail 8.12.5/8.12.5 -4-:220:501:501:250:250:553:550:214:250:250:502:502:502:250:250
Sendmail 8.12.5/8.12.5 -5-:220:501:250:250:553:553:250:250:250:250:502:250:250:250:220
Sendmail 8.12.5/8.12.5 -6-:220:501:250:250:250:553:250:214:250:250:502:502:502:250:220
Sendmail 8.12.5/8.12.5 -7-:503:501:501:250:250:553:550:214:250:502:502:502:502:250:250
Sendmail 8.12.5/jtpda-5.4:503:501:501:250:553:451:550:502:250:502:502:502:502:250:250
Sendmail 8.12.6:250:501:501:250:553:553:550:502:250:250:502:502:502:250:250
Sendmail 8.12.6/8.11.1 -0-:250:220:501:250:250:250:550:214:252:502:502:502:502:250:250
Sendmail 8.12.6/8.11.1 -1-:220:220:250:250:250:250:550:250:250:250:502:250:502:250:220
Sendmail 8.12.6/8.11.1 -2-:250:220:250:250:553:250:250:250:250:502:502:250:502:250:220
Sendmail 8.12.6/8.11.6:220:501:250:250:553:553:550:214:252:502:250:250:502:250:250
Sendmail 8.12.6/8.11.6/SuSE Linux 0.5:503:501:501:250:553:553:250:214:252:502:502:502:502:250:250
Sendmail 8.12.6/8.12.2:220:220:250:250:250:553:250:250:250:250:250:250:502:250:220
Sendmail 8.12.6/8.12.6 -0-:220:220:250:250:250:553:550:250:252:250:502:502:502:250:250
Sendmail 8.12.6/8.12.6 -1-:220:501:250:250:250:553:550:214:252:502:502:250:250:250:250
Sendmail 8.12.6/8.12.6 -2-:250:501:501:250:553:553:550:214:252:250:502:502:502:250:250
Sendmail 8.12.6/8.12.6 -3-:250:501:250:250:553:553:550:214:252:250:502:502:502:250:250
Sendmail 8.12.6/8.12.6 -4-:220:501:501:250:553:250:250:214:250:250:250:250:502:250:250
Sendmail 8.12.6/8.12.6 -5-:220:220:250:250:250:553:550:214:252:502:502:502:502:250:250
Sendmail 8.12.6/8.12.6 -6-:220:501:501:250:553:250:550:250:252:250:502:502:502:250:250
Sendmail 8.12.6/8.12.6 -7-:220:501:501:250:553:250:550:214:250:502:250:250:250:250:220
Sendmail 8.12.6/8.12.6 -8-:220:220:250:250:553:250:250:214:250:502:502:250:502:250:220
Sendmail 8.12.6/8.12.6 -9-:250:220:501:250:553:250:550:250:250:250:250:250:250:250:220
Sendmail 8.12.6/8.12.6 -10-:250:501:501:250:250:553:250:250:252:250:250:502:502:250:250
Sendmail 8.12.6/8.12.6 -11-:503:501:250:250:250:250:550:214:250:502:502:502:502:250:250
Sendmail 8.12.6/8.12.6 -12-:220:220:250:250:250:553:250:250:250:502:502:502:250:250:250
Sendmail 8.12.6/8.12.6 -13-:250:501:250:250:250:553:250:250:250:250:250:250:250:250:220
Sendmail 8.12.6/8.12.6/SuSE Linux 0.6:503:501:501:250:220:553:550:214:252:502:502:502:502:250:250
Sendmail 8.12.6p2/8.12.5:250:501:250:250:553:250:250:214:250:502:502:250:502:250:220
Sendmail 8.12.6p2/8.12.6 -0-:220:220:250:250:250:250:250:214:252:250:250:250:502:250:250
Sendmail 8.12.6p2/8.12.6 -1-:220:220:250:250:250:250:550:214:250:250:502:502:250:250:250
Sendmail 8.12.6p2/8.12.6 -2-:220:501:501:250:250:250:250:250:252:250:250:502:502:250:220
Sendmail 8.12.6p2/8.12.6 -3-:220:501:250:250:250:250:250:250:250:502:502:250:250:250:220
Sendmail 8.12.6p2/8.12.6 -4-:220:501:250:250:250:250:250:214:252:250:502:502:502:250:250
Sendmail 8.12.6p2/8.12.6 -5-:220:220:250:250:250:250:550:214:252:502:250:502:502:250:250
Sendmail 8.12.6p2/8.12.6 -6-:250:220:250:250:250:250:550:214:250:502:250:502:502:250:250
Sendmail 8.12.6p2/8.12.6 -7-:220:220:250:250:553:250:550:250:252:502:502:502:250:250:220
Sendmail 8.12.6p2/8.12.6 -8-:250:501:250:250:553:250:550:250:250:250:502:250:250:250:220
Sendmail 8.12.6p2/8.12.6 -9-:250:220:250:250:553:250:550:214:252:502:502:250:502:250:250
Sendmail 8.12.6p2/8.12.6 -10-:220:501:501:250:250:250:550:250:252:250:250:502:250:250:220
Sendmail 8.12.6p2/8.12.6 -11-:250:501:501:250:250:250:550:214:252:250:502:502:502:250:250
Sendmail 8.12.6p2/8.12.6 -12-:250:501:501:250:553:250:550:214:252:502:502:250:250:250:250
Sendmail 8.12.6p2/8.12.6 -13-:220:220:501:250:553:250:550:214:252:502:502:502:250:250:250
Sendmail 8.12.6p2/8.12.6 -14-:220:220:501:250:553:250:550:250:252:250:250:502:502:250:250
Sendmail 8.12.6p2/8.12.6 -15-:250:501:501:250:553:250:250:214:252:502:502:502:250:250:220
Sendmail 8.12.6p2/8.12.6 -16-:220:501:250:250:250:250:550:250:250:250:250:502:502:250:250
Sendmail 8.12.6p2/8.12.6 -17-:220:220:501:250:553:250:550:214:252:250:250:250:502:250:220
Sendmail 8.12.6p2/8.12.6 -18-:250:501:501:250:553:250:250:214:250:502:502:502:502:250:250
Sendmail 8.12.6p2/8.12.6 -19-:250:220:250:250:250:250:250:250:250:250:250:502:250:250:220
Sendmail 8.12.6p2/8.12.6 -20-:250:220:501:250:553:250:550:214:252:502:502:250:250:250:250
Sendmail 8.12.6p2/8.12.6 -21-:220:220:250:250:250:250:250:250:250:502:250:250:250:250:250
Sendmail 8.12.6p2/8.12.6 -22-:220:220:250:250:250:250:250:214:250:250:502:250:502:250:220
Sendmail 8.12.6p2/8.12.6 -23-:220:220:250:250:553:250:550:214:250:502:250:250:502:250:220
Sendmail 8.12.6p2/8.12.6 -24-:220:501:501:250:553:250:550:250:252:502:502:250:250:250:220
Sendmail 8.12.6p2/8.12.6 -25-:220:220:250:250:250:250:250:214:252:250:502:250:250:250:250
Sendmail 8.12.6p2/8.12.6 -26-:250:220:250:250:250:250:250:214:252:502:250:250:250:250:220
Sendmail 8.12.6p2/8.12.6 -27-:250:220:501:250:250:250:550:250:250:250:502:502:250:250:250
Sendmail 8.12.6p2/8.12.6 -28-:220:501:501:250:553:250:250:214:252:250:250:250:250:250:250
Sendmail 8.12.6p2/8.12.6 -29-:220:501:250:250:553:250:550:214:252:502:250:502:502:250:250
Sendmail 8.12.6p2/8.12.6 -30-:220:220:501:250:553:250:550:214:252:502:502:502:502:250:250
Sendmail 8.12.6p2/8.12.6 -31-:220:220:250:250:553:250:550:214:250:502:250:502:502:250:250
Sendmail 8.12.6p2/8.12.6 -32-:250:220:501:250:553:250:550:214:252:502:250:250:250:250:250
Sendmail 8.12.6p2/8.12.6 -33-:250:220:501:250:553:250:250:250:252:250:502:502:502:250:220
Sendmail 8.12.6p2/8.12.6 -34-:220:220:501:250:553:553:550:250:250:250:502:250:250:250:250
Sendmail 8.12.6p2/8.12.6 -35-:220:220:501:250:553:250:250:214:250:250:250:502:502:250:250
Sendmail 8.12.6p2/8.12.6 -36-:250:501:501:250:553:250:550:250:252:250:250:250:250:250:220
Sendmail 8.12.6p2/8.12.6 -37-:220:220:250:250:553:250:550:214:250:502:250:502:502:250:220
Sendmail 8.12.6p2/8.12.6 -38-:220:501:250:250:553:250:550:250:250:250:250:502:502:250:250
Sendmail 8.12.6p2/8.12.6 -39-:220:501:501:250:553:250:550:214:250:502:502:502:502:250:220
Sendmail 8.12.6p2/8.12.6 -40-:220:501:501:250:250:250:550:214:250:250:250:250:502:250:220
Sendmail 8.12.6p2/8.12.6 -41-:250:501:250:250:553:250:550:214:252:502:502:502:502:250:220
Sendmail 8.12.6p2/8.12.6 -42-:250:501:250:250:553:250:550:214:252:502:502:250:250:250:250
Sendmail 8.12.6p2/8.12.6 -43-:250:501:250:250:250:250:550:250:252:250:502:502:502:250:250
Sendmail 8.12.6p2/8.12.6 -44-:220:220:501:250:553:250:550:214:250:502:250:250:502:250:220
Sendmail 8.12.6p2/8.12.6 -45-:220:501:501:250:250:250:550:214:252:250:250:502:250:250:250
Sendmail 8.12.6p2/8.12.6 -46-:220:501:501:250:553:250:250:250:250:502:502:502:250:250:250
Sendmail 8.12.6p2/8.12.6 -47-:220:501:501:250:553:250:550:250:252:502:250:250:250:250:220
Sendmail 8.12.6p2/8.12.6 -48-:220:501:501:250:250:250:250:214:252:250:250:502:250:250:250
Sendmail 8.12.6p2/8.12.6 -49-:220:220:250:250:553:250:550:214:250:502:502:502:502:250:250
Sendmail 8.12.6p2/8.12.6 -50-:220:220:501:250:250:250:250:250:250:502:250:502:502:250:250
Sendmail 8.12.6p2/8.12.6 -51-:220:501:501:250:553:250:550:214:252:250:502:250:502:250:250
Sendmail 8.12.6p2/8.12.6 -52-:250:501:250:250:553:250:250:214:252:502:502:250:502:250:250
Sendmail 8.12.6p2/8.12.6 -53-:250:220:250:250:553:250:550:250:252:502:502:250:502:250:250
Sendmail 8.12.6p2/8.12.6 -54-:220:220:501:250:553:250:550:214:252:502:502:250:250:250:220
Sendmail 8.12.6p2/8.12.6 -55-:220:501:250:250:250:250:250:250:250:250:250:250:250:250:220
Sendmail 8.12.6p2/8.12.6 -56-:250:220:250:250:553:250:550:250:252:502:502:502:250:250:220
Sendmail 8.12.6p2/8.12.6 -57-:220:220:501:250:250:250:250:250:250:502:250:250:502:250:220
Sendmail 8.12.6p2/8.12.6 -58-:250:220:250:250:250:250:250:250:252:250:502:502:502:250:250
Sendmail 8.12.6p2/8.12.6 -59-:250:220:501:250:553:250:550:214:252:250:502:502:502:250:250
Sendmail 8.12.6p2/8.12.6 -60-:220:501:250:250:553:250:550:214:252:250:502:502:502:250:250
Sendmail 8.12.6p2/8.12.6 -61-:220:220:501:250:553:250:550:214:252:502:502:502:502:250:220
Sendmail 8.12.6p2/8.12.6 -62-:250:501:501:250:250:250:550:250:252:502:502:502:502:250:250
Sendmail 8.12.6p2/8.12.6 -63-:220:220:250:250:553:250:550:214:250:250:250:250:502:250:250
Sendmail 8.12.6p2/8.12.6 -64-:250:501:501:250:250:250:550:214:250:502:502:250:502:250:250
Sendmail 8.12.6p2/8.12.6 -65-:250:501:250:250:553:250:250:250:250:502:250:502:502:250:250
Sendmail 8.12.6p2/8.12.6 -66-:250:501:501:250:553:250:550:214:250:502:502:250:502:250:250
Sendmail 8.12.6p2/8.12.6 -67-:220:501:501:250:250:250:550:214:252:502:250:502:502:250:220
Sendmail 8.12.6p2/8.12.6 -68-:220:220:501:250:250:250:550:214:250:250:502:502:502:250:220
Sendmail 8.12.6p2/8.12.6 -69-:250:501:250:250:553:250:550:214:252:502:250:250:250:250:250
Sendmail 8.12.6p2/8.12.6 -70-:220:501:250:250:553:250:250:250:250:250:502:502:250:250:220
Sendmail 8.12.6p2/8.12.6 -71-:250:220:501:250:553:250:550:250:252:250:250:250:250:250:220
Sendmail 8.12.6p2/8.12.6 -72-:250:220:250:250:553:250:250:250:252:502:502:502:502:250:250
Sendmail 8.12.6p2/8.12.6 -73-:220:220:501:250:250:250:250:250:252:502:250:502:502:250:250
Sendmail 8.12.6p2/8.12.6 -74-:250:501:501:250:553:250:550:214:250:502:250:502:502:250:250
Sendmail 8.12.6p2/8.12.6 -75-:250:501:501:250:250:250:550:214:252:250:250:502:250:250:250
Sendmail 8.12.6p2/8.12.6 -76-:220:501:501:250:250:250:250:250:252:502:250:250:250:250:250
Sendmail 8.12.6p2/8.12.6 -77-:220:501:501:250:553:250:550:214:252:250:502:250:250:250:250
Sendmail 8.12.6p2/8.12.6 -78-:250:220:250:250:553:250:550:250:252:502:502:502:502:250:250
Sendmail 8.12.6p2/8.12.6 -79-:250:501:250:250:250:250:550:214:252:250:502:502:250:250:250
Sendmail 8.12.6p2/8.12.6 -80-:250:501:501:250:553:250:250:214:252:250:502:250:502:250:250
Sendmail 8.12.6p2/8.12.6 -81-:220:220:501:250:553:250:550:214:252:502:250:502:502:250:250
Sendmail 8.12.6p2/8.12.6 -82-:220:220:250:250:553:250:550:250:252:502:502:502:502:250:250
Sendmail 8.12.6p2/8.12.6 -83-:220:220:250:250:250:250:550:250:252:250:250:250:250:250:220
Sendmail 8.12.6p2/8.12.6 -84-:220:220:501:250:250:250:550:214:252:250:502:502:250:250:220
Sendmail 8.12.6p2/8.12.6 -85-:250:501:501:250:250:250:550:250:252:250:250:250:502:250:220
Sendmail 8.12.6p2/8.12.6 -86-:220:220:250:250:250:250:550:214:252:502:502:250:502:250:250
Sendmail 8.12.6p2/8.12.6 -87-:250:501:250:250:553:250:550:214:250:502:250:250:250:250:220
Sendmail 8.12.6p2/8.12.6 -88-:220:220:501:250:250:250:250:214:252:502:502:502:502:250:250
Sendmail 8.12.6p2/8.12.6 -89-:220:220:501:250:250:250:250:250:250:250:502:250:250:250:220
Sendmail 8.12.6p2/8.12.6 -90-:220:501:250:250:250:250:550:214:250:502:502:250:502:250:250
Sendmail 8.12.6p2/8.12.6 -91-:250:501:501:250:553:250:250:250:252:502:502:250:502:250:220
Sendmail 8.12.6p2/8.12.6 -92-:220:501:501:250:553:250:550:250:250:502:502:502:250:250:220
Sendmail 8.12.6p2/8.12.6 -93-:250:501:250:250:553:250:550:250:250:502:502:250:502:250:220
Sendmail 8.12.6p2/8.12.6 -94-:220:220:501:250:553:250:250:250:250:250:250:502:502:250:220
Sendmail 8.12.6p2/8.12.6 -95-:220:501:250:250:250:250:250:250:252:502:502:250:502:250:250
Sendmail 8.12.6p2/8.12.6 -96-:220:220:501:250:250:250:250:214:252:502:250:502:502:250:220
Sendmail 8.12.6p2/8.12.6 -97-:250:220:250:250:553:250:250:250:252:502:250:502:502:250:250
Sendmail 8.12.6p2/8.12.6 -98-:250:220:250:250:250:250:550:214:252:250:502:502:502:250:250
Sendmail 8.12.6p2/8.12.6 -99-:250:220:501:250:250:250:550:250:250:250:502:502:502:250:250
Sendmail 8.12.6p2/8.12.6 -100-:220:220:501:250:553:250:550:214:250:502:250:250:502:250:250
Sendmail 8.12.6p2/8.12.6 -101-:220:220:250:250:553:250:550:214:252:502:502:250:250:250:220
Sendmail 8.12.6p2/8.12.6 -102-:250:220:250:250:553:250:550:214:250:502:502:502:250:250:250
Sendmail 8.12.6p2/8.12.6 -103-:220:501:250:250:250:250:250:214:250:502:250:502:502:250:220
Sendmail 8.12.6p2/8.12.6 -104-:250:220:501:250:553:250:250:250:250:250:250:250:502:250:220
Sendmail 8.12.6p2/8.12.6 -105-:250:501:501:250:553:250:550:250:252:250:502:250:250:250:250
Sendmail 8.12.6p2/8.12.6 -106-:250:220:501:250:553:250:250:250:252:502:502:502:502:250:250
Sendmail 8.12.6p2/8.12.6 -107-:250:220:250:250:553:250:550:250:250:502:250:502:502:250:250
Sendmail 8.12.6p2/8.12.6 -108-:220:501:501:250:250:250:250:250:250:502:502:502:250:250:220
Sendmail 8.12.6p2/8.12.6 -109-:220:501:250:250:250:250:250:214:252:250:250:502:502:250:250
Sendmail 8.12.6p2/8.12.6 -110-:220:501:250:250:250:250:550:250:252:502:250:250:502:250:250
Sendmail 8.12.6p2/8.12.6 -111-:250:220:250:250:553:250:250:250:250:250:250:250:250:250:250
Sendmail 8.12.6p2/8.12.6 -112-:250:220:250:250:553:250:550:214:252:250:250:250:250:250:220
Sendmail 8.12.6p2/8.12.6 -113-:250:220:501:250:553:250:550:250:252:502:250:502:502:250:220
Sendmail 8.12.6p2/8.12.6 -114-:220:220:501:250:250:250:550:250:252:502:250:250:502:250:220
Sendmail 8.12.6p2/8.12.6 -115-:220:501:250:250:553:250:550:214:252:502:502:502:502:250:250
Sendmail 8.12.6p2/8.12.6 -116-:250:220:501:250:553:250:250:250:252:502:250:502:502:250:250
Sendmail 8.12.6p2/8.12.6 -117-:250:220:501:250:553:250:550:214:252:502:250:250:502:250:220
Sendmail 8.12.6p2/8.12.6 -118-:250:501:250:250:553:250:250:214:250:502:250:502:250:250:220
Sendmail 8.12.6p2/8.12.6 -119-:220:220:250:250:250:250:550:250:252:250:502:250:502:250:220
Sendmail 8.12.6p2/8.12.6 -120-:250:220:501:250:553:250:550:250:250:502:502:502:502:250:220
Sendmail 8.12.6p2/8.12.6 -121-:220:220:501:250:553:250:550:214:252:502:250:502:250:250:250
Sendmail 8.12.6p2/8.12.6 -122-:220:501:501:250:553:250:550:214:250:502:502:250:250:250:250
Sendmail 8.12.6p2/8.12.6 -123-:220:220:501:250:553:250:550:214:250:250:250:502:250:250:250
Sendmail 8.12.6p2/8.12.6 -124-:250:501:250:250:553:250:550:250:250:250:502:502:502:250:250
Sendmail 8.12.6p2/8.12.6 -125-:250:220:501:250:553:250:550:214:252:250:250:250:250:250:220
Sendmail 8.12.6p2/8.12.6 -126-:220:220:250:250:553:250:550:250:252:250:250:250:502:250:250
Sendmail 8.12.6p2/8.12.6 -127-:220:220:250:250:553:250:550:250:250:502:250:502:250:250:220
Sendmail 8.12.6p2/8.12.6 -128-:250:220:501:250:250:250:250:250:250:250:250:250:250:250:220
Sendmail 8.12.6p2/8.12.6 -129-:250:501:501:250:250:250:250:214:252:250:250:502:250:250:250
Sendmail 8.12.6p2/8.12.6 -130-:220:501:250:250:553:250:550:214:252:502:502:250:250:250:220
Sendmail 8.12.6p2/8.12.6 -131-:250:501:501:250:553:250:550:214:250:250:502:502:502:250:220
Sendmail 8.12.6p2/8.12.8 -0-:250:220:501:250:250:250:250:214:252:502:250:250:502:250:250
Sendmail 8.12.6p2/8.12.8 -1-:250:501:501:250:553:250:550:214:252:502:502:250:502:250:250
Sendmail 8.12.7/8.11.6av -0-:220:501:250:250:250:250:250:250:252:502:502:502:502:250:220
Sendmail 8.12.7/8.11.6av -1-:220:220:250:250:553:553:250:214:250:502:502:502:502:250:220
Sendmail 8.12.8/8.10.2:220:220:501:250:553:501:250:214:252:502:502:502:502:250:250
Sendmail 8.12.8/8.11.4:220:501:250:250:250:553:250:214:250:250:502:502:502:250:250
Sendmail 8.12.8/8.11.4 (2Fast Internet Services) -0-:250:501:250:250:250:250:250:502:252:250:502:502:502:250:250
Sendmail 8.12.8/8.11.4 (2Fast Internet Services) -1-:220:501:501:250:553:250:250:502:252:250:502:502:502:250:250
Sendmail 8.12.8/8.11.4 (2Fast Internet Services) -2-:220:501:501:250:250:250:250:502:252:250:502:502:502:250:250
Sendmail 8.12.8/8.11.4 (2Fast Internet Services) -3-:220:501:501:250:250:250:250:250:252:250:502:502:502:250:250
Sendmail 8.12.8/8.11.4 (2Fast Internet Services) -4-:250:501:250:250:553:250:250:250:252:250:502:502:250:250:250
Sendmail 8.12.8/8.11.4 (2Fast Internet Services) -5-:250:220:501:250:553:250:250:250:252:250:250:502:502:250:250
Sendmail 8.12.8/8.11.4 (2Fast Internet Services) -6-:250:220:250:250:553:250:250:502:250:250:250:502:502:250:250
Sendmail 8.12.8/8.11.6 -0-:503:501:501:250:553:553:550:214:252:502:502:250:502:250:250
Sendmail 8.12.8/8.11.6 -1-:503:501:501:250:250:553:550:214:252:502:250:502:250:250:250
Sendmail 8.12.8/8.11.6 -2-:503:220:501:250:553:553:550:214:252:502:502:502:250:250:250
Sendmail 8.12.8/8.11.6 -3-:220:501:501:250:553:553:550:214:252:502:250:502:502:250:220
Sendmail 8.12.8/8.11.6 -4-:503:220:250:250:553:553:250:214:252:502:502:502:502:250:250
Sendmail 8.12.8/8.11.6 -5-:503:501:501:250:553:250:550:250:252:502:502:502:250:250:220
Sendmail 8.12.8/8.11.6 -6-:503:501:501:250:250:553:550:214:252:502:502:502:502:250:250
Sendmail 8.12.8/8.11.6 -7-:503:501:501:250:553:553:550:214:250:502:502:502:250:250:250
Sendmail 8.12.8/8.11.6 -8-:503:220:250:250:553:553:250:214:252:502:502:250:502:250:250
Sendmail 8.12.8/8.11.6 -9-:503:501:501:250:553:553:250:250:252:250:250:502:502:250:250
Sendmail 8.12.8/8.11.6 -10-:220:220:501:250:250:250:250:214:250:502:250:502:502:250:250
Sendmail 8.12.8/8.11.6 -11-:503:501:250:250:553:553:250:214:250:502:502:502:502:250:250
Sendmail 8.12.8/8.11.6 -12-:503:220:250:250:553:250:550:214:252:250:502:250:250:250:250
Sendmail 8.12.8/8.11.6 -13-:503:501:250:250:553:250:250:250:252:502:502:250:502:250:250
Sendmail 8.12.8/8.11.6 -14-:503:501:501:250:553:553:550:250:252:502:502:502:502:250:250
Sendmail 8.12.8/8.11.6 -15-:503:501:501:250:553:553:550:250:250:502:502:250:502:250:250
Sendmail 8.12.8/8.11.6 -16-:503:501:250:250:553:250:250:214:250:502:502:502:502:250:250
Sendmail 8.12.8/8.11.6 -17-:503:501:501:250:553:553:250:214:252:502:250:502:502:250:220
Sendmail 8.12.8/8.11.6 -18-:503:220:501:250:553:553:550:214:252:502:250:502:250:250:220
Sendmail 8.12.8/8.11.6 -19-:503:501:501:250:553:553:250:214:250:502:502:502:250:250:250
Sendmail 8.12.8/8.11.6 -20-:220:501:501:250:250:553:250:214:252:502:502:502:502:250:250
Sendmail 8.12.8/8.11.6 -21-:503:501:501:250:553:250:250:250:250:502:250:502:502:250:250
Sendmail 8.12.8/8.11.6 -22-:503:501:501:250:553:250:250:250:252:502:502:502:502:250:250
Sendmail 8.12.8/8.11.6 -23-:220:501:501:250:553:553:250:214:250:502:250:250:250:250:250
Sendmail 8.12.8/8.11.6 -24-:503:501:501:250:553:250:550:214:252:502:250:502:502:250:220
Sendmail 8.12.8/8.11.6 -25-:220:501:250:250:250:553:250:214:250:502:250:502:250:250:250
Sendmail 8.12.8/8.11.6 -26-:503:501:501:250:553:553:550:214:252:502:502:250:502:250:220
Sendmail 8.12.8/8.11.6 -27-:503:501:501:250:250:553:550:214:252:502:250:250:502:250:250
Sendmail 8.12.8/8.11.6 -28-:503:501:501:250:553:250:250:250:252:502:502:250:502:250:250
Sendmail 8.12.8/8.11.6 -29-:220:220:501:250:250:553:550:214:252:502:250:502:502:250:250
Sendmail 8.12.8/8.11.6 -30-:503:501:501:250:250:553:250:214:252:250:502:502:502:250:250
Sendmail 8.12.8/8.11.6 -31-:503:501:250:250:250:553:550:250:252:502:502:502:502:250:250
Sendmail 8.12.8/8.11.6 -32-:220:501:501:250:553:553:550:214:250:502:250:250:502:250:250
Sendmail 8.12.8/8.11.6 -33-:503:501:501:250:553:553:550:250:250:502:502:502:502:250:250
Sendmail 8.12.8/8.11.6 -34-:503:501:501:250:553:250:550:250:252:502:250:250:502:250:250
Sendmail 8.12.8/8.11.6 -35-:220:501:250:250:553:553:250:214:250:502:502:250:250:250:250
Sendmail 8.12.8/8.11.6 -36-:220:220:250:250:553:553:550:214:252:502:502:502:250:250:250
Sendmail 8.12.8/8.11.6 -37-:503:501:501:250:553:553:250:214:252:502:502:502:502:250:220
Sendmail 8.12.8/8.11.6 -38-:503:501:501:250:553:250:250:214:252:250:502:502:502:250:220
Sendmail 8.12.8/8.11.6 -39-:220:501:501:250:553:553:550:250:252:502:502:502:250:250:250
Sendmail 8.12.8/8.11.6 -40-:503:501:501:250:553:553:250:214:252:502:250:502:502:250:250
Sendmail 8.12.8/8.11.6 -41-:220:220:250:250:250:250:250:214:252:502:250:502:502:250:250
Sendmail 8.12.8/8.11.6 -42-:220:501:250:250:250:553:250:250:252:502:502:250:502:250:250
Sendmail 8.12.8/8.11.6 -43-:220:501:250:250:553:553:250:214:252:502:502:502:502:250:250
Sendmail 8.12.8/8.11.6 -44-:503:220:250:250:553:553:550:214:250:502:502:250:502:250:250
Sendmail 8.12.8/8.11.6 -45-:503:501:501:250:553:553:250:214:252:502:502:502:250:250:220
Sendmail 8.12.8/8.11.6 -46-:220:220:501:250:553:553:250:250:250:250:502:502:502:250:220
Sendmail 8.12.8/8.11.6 -47-:503:501:501:250:250:553:550:214:252:250:502:502:502:250:220
Sendmail 8.12.8/8.11.6 -48-:503:220:501:250:553:250:550:250:252:502:502:502:502:250:250
Sendmail 8.12.8/8.11.6 -49-:503:220:501:250:250:553:550:214:252:502:502:502:502:250:250
Sendmail 8.12.8/8.11.6 -50-:503:501:501:250:553:553:250:250:252:502:502:502:502:250:250
Sendmail 8.12.8/8.11.6 -51-:220:501:250:250:250:553:550:214:252:502:502:250:502:250:220
Sendmail 8.12.8/8.11.6 -52-:503:501:501:250:553:553:550:214:250:502:502:502:250:250:220
Sendmail 8.12.8/8.11.6 -53-:503:501:501:250:553:553:250:214:252:502:502:250:502:250:250
Sendmail 8.12.8/8.11.6 -54-:503:501:501:250:250:553:550:214:252:502:250:502:502:250:250
Sendmail 8.12.8/8.11.6 -55-:503:220:250:250:553:553:250:250:250:250:502:502:502:250:220
Sendmail 8.12.8/8.11.6 -56-:503:501:250:250:553:553:250:214:252:502:502:502:502:250:250
Sendmail 8.12.8/8.11.6 -57-:503:501:501:250:553:553:550:250:252:502:502:250:502:250:250
Sendmail 8.12.8/8.11.6 -58-:220:220:250:250:553:553:250:250:250:250:250:250:502:250:250
Sendmail 8.12.8/8.11.6 -59-:503:501:501:250:553:553:550:214:252:502:250:502:502:250:250
Sendmail 8.12.8/8.11.6 -60-:220:220:501:250:250:250:250:250:252:502:502:502:502:250:250
Sendmail 8.12.8/8.11.6 -61-:503:501:501:250:553:553:550:214:252:250:502:250:502:250:250
Sendmail 8.12.8/8.11.6 -62-:503:501:501:250:553:553:550:250:252:502:250:502:502:250:250
Sendmail 8.12.8/8.11.6 -63-:503:501:501:250:553:553:550:214:250:502:502:250:502:250:250
Sendmail 8.12.8/8.11.6 -64-:503:220:501:250:553:553:250:250:250:502:502:502:502:250:250
Sendmail 8.12.8/8.11.6 -65-:503:501:501:250:553:553:250:214:252:502:502:502:250:250:250
Sendmail 8.12.8/8.11.6 -66-:503:501:501:250:553:553:550:214:252:502:502:502:250:250:250
Sendmail 8.12.8/8.11.6 -67-:220:220:501:250:553:553:550:214:252:502:250:502:502:250:250
Sendmail 8.12.8/8.11.6 -68-:503:501:501:250:553:250:550:214:252:250:250:502:502:250:250
Sendmail 8.12.8/8.11.6 -69-:503:220:501:250:553:250:250:214:252:502:502:502:250:250:250
Sendmail 8.12.8/8.11.6 -70-:503:220:501:250:553:553:550:250:250:250:502:502:502:250:250
Sendmail 8.12.8/8.11.6 -71-:220:501:501:250:250:553:250:214:252:502:502:250:502:250:220
Sendmail 8.12.8/8.11.6 -72-:503:220:501:250:553:250:550:250:252:250:502:502:502:250:250
Sendmail 8.12.8/8.11.6 -73-:503:501:501:250:553:553:550:214:250:250:502:502:502:250:250
Sendmail 8.12.8/8.11.6 -74-:220:220:501:250:250:250:250:250:250:502:502:502:250:250:250
Sendmail 8.12.8/8.11.6 -75-:503:501:250:250:553:553:550:250:252:502:502:502:502:250:250
Sendmail 8.12.8/8.11.6 -76-:503:220:501:250:553:553:550:214:252:502:502:502:502:250:220
Sendmail 8.12.8/8.11.6 -77-:503:501:250:250:553:553:550:214:252:502:502:502:250:250:220
Sendmail 8.12.8/8.11.6 -78-:503:220:501:250:250:553:550:214:252:250:502:502:502:250:250
Sendmail 8.12.8/8.11.6 -79-:250:220:501:250:250:501:550:250:250:250:250:502:250:250:250
Sendmail 8.12.8/8.11.6 -80-:220:501:501:250:250:501:250:214:250:250:250:250:250:250:220
Sendmail 8.12.8/8.11.6 -81-:250:501:501:250:553:501:250:250:250:250:502:502:502:250:220
Sendmail 8.12.8/8.11.6 -82-:220:501:501:250:553:501:250:250:250:250:502:502:250:250:250
Sendmail 8.12.8/8.11.6 -83-:220:501:501:250:250:501:550:250:250:250:502:502:502:250:250
Sendmail 8.12.8/8.11.6 -84-:250:220:501:250:250:250:550:214:250:250:502:502:502:250:250
Sendmail 8.12.8/8.11.6 -85-:250:501:501:250:553:501:250:250:250:250:250:502:250:250:250
Sendmail 8.12.8/8.11.6 -86-:220:220:250:250:250:501:550:214:250:250:502:250:502:250:250
Sendmail 8.12.8/8.12.2:250:501:501:250:553:553:250:214:252:250:502:502:502:250:250
Sendmail 8.12.8/8.12.4 -0-:220:220:250:250:553:250:550:250:250:250:250:502:502:250:250
Sendmail 8.12.8/8.12.4 -1-:250:220:250:250:250:250:550:214:250:250:250:250:250:250:220
Sendmail 8.12.8/8.12.4 -2-:220:501:501:250:553:250:250:250:250:250:250:250:502:250:250
Sendmail 8.12.8/8.12.4 -3-:250:220:501:250:250:553:550:214:250:250:502:502:250:250:250
Sendmail 8.12.8/8.12.5:550:501:501:250:553:250:503:214:252:502:502:502:502:250:250
Sendmail 8.12.8/8.12.8 -0-:571:501:501:250:553:553:503:214:252:502:502:502:502:250:250
Sendmail 8.12.8/8.12.8 -1-:220:220:250:250:553:553:250:250:252:250:502:502:250:250:250
Sendmail 8.12.8/8.12.8 -2-:503:501:501:250:553:250:250:250:252:250:502:250:250:250:220
Sendmail 8.12.8/8.12.8 -3-:250:220:501:250:553:250:550:214:252:250:502:502:250:250:250
Sendmail 8.12.8/8.12.8 -4-:250:501:501:250:250:250:550:502:250:250:502:502:502:250:220
Sendmail 8.12.8/8.12.8 -5-:220:220:250:250:553:250:250:250:252:250:502:502:502:250:250
Sendmail 8.12.8/8.12.8 -6-:503:501:250:250:250:250:250:250:250:502:250:502:250:250:220
Sendmail 8.12.8/8.12.8 -7-:220:501:250:250:553:250:250:250:252:250:250:502:502:250:220
Sendmail 8.12.8/8.12.8 -8-:503:501:250:250:553:250:550:214:252:502:250:502:250:250:250
Sendmail 8.12.8/8.12.8 -9-:250:220:250:250:250:553:250:250:250:250:250:502:250:250:250
Sendmail 8.12.8/8.12.8 -10-:250:501:501:250:553:553:250:214:250:502:502:502:502:250:220
Sendmail 8.12.8/8.12.8 -11-:220:220:250:250:250:250:250:214:252:502:502:502:502:250:220
Sendmail 8.12.8/8.12.8 -12-:220:220:501:250:250:250:250:250:250:502:502:250:502:250:250
Sendmail 8.12.8/8.12.8 -13-:250:501:501:250:250:553:250:214:250:250:502:502:502:250:250
Sendmail 8.12.8/8.12.8 -14-:220:220:501:250:553:553:550:214:250:502:250:502:250:250:250
Sendmail 8.12.8/8.12.8 -15-:250:501:501:250:553:553:550:250:250:250:502:502:502:250:250
Sendmail 8.12.8/8.12.8 -16-:250:501:501:250:553:250:550:214:250:502:502:502:250:250:220
Sendmail 8.12.8/8.12.8 -17-:220:501:250:250:553:553:550:214:250:250:502:502:502:250:250
Sendmail 8.12.8/8.12.8 -18-:503:220:250:250:553:250:250:214:252:502:250:502:502:250:250
Sendmail 8.12.8/8.12.8 -19-:220:220:501:250:250:553:550:214:252:250:502:250:250:250:250
Sendmail 8.12.8/8.12.8 -20-:220:220:250:250:553:250:250:214:250:502:502:502:250:250:250
Sendmail 8.12.8/8.12.8 -21-:220:220:501:250:250:250:250:214:250:250:250:502:502:250:220
Sendmail 8.12.8/8.12.8 -22-:250:220:250:250:553:250:550:214:250:250:250:502:502:250:250
Sendmail 8.12.8/8.12.8 -23-:250:501:501:250:553:553:250:214:252:502:502:502:502:250:250
Sendmail 8.12.8/8.12.8 -24-:220:501:501:250:553:250:550:250:250:250:502:250:502:250:250
Sendmail 8.12.8/8.12.8 -25-:250:501:501:250:553:250:250:250:252:502:502:250:502:250:250
Sendmail 8.12.8/8.12.8 -26-:220:220:250:250:553:250:250:250:250:250:502:502:502:250:250
Sendmail 8.12.8/8.12.8 -27-:250:501:501:250:250:553:250:214:252:250:250:502:502:250:220
Sendmail 8.12.8/8.12.8 -28-:220:501:501:250:553:250:550:250:250:250:502:502:502:250:250
Sendmail 8.12.8/8.12.8 -29-:220:220:250:250:553:250:250:214:252:502:502:502:502:250:250
Sendmail 8.12.8/8.12.8 -30-:250:220:501:250:553:250:550:214:252:502:250:502:502:250:250
Sendmail 8.12.8/8.12.8 -31-:220:220:501:250:553:553:550:214:252:502:502:502:502:250:220
Sendmail 8.12.8/8.12.8 -32-:220:220:501:250:553:250:250:250:250:502:502:250:250:250:250
Sendmail 8.12.8/8.12.8 -33-:220:501:501:250:553:250:550:250:250:250:502:250:250:250:220
Sendmail 8.12.8/8.12.8 -34-:503:501:501:250:553:250:250:214:252:502:502:502:250:250:250
Sendmail 8.12.8/8.12.8 -35-:220:501:501:250:553:250:550:214:250:502:250:250:250:250:250
Sendmail 8.12.8/8.12.8 -36-:220:220:250:250:250:250:550:214:250:250:502:250:502:250:250
Sendmail 8.12.8/8.12.8 -37-:250:501:501:250:553:250:553:214:252:502:502:502:502:250:250
Sendmail 8.12.8/8.12.8/[TERRA]-2003030501:503:220:501:250:553:250:250:214:252:502:502:502:502:250:250
Sendmail 8.12.8/INCA InterNet Services:250:501:501:250:553:501:250:214:250:502:502:502:502:250:250
Sendmail 8.12.8p1/8.12.8 -0-:220:501:501:250:553:553:550:250:250:250:250:250:250:250:220
Sendmail 8.12.8p1/8.12.8 -1-:250:220:501:250:250:250:550:214:250:250:502:250:250:250:250
Sendmail 8.12.8p1/8.12.8 -2-:250:501:501:250:553:250:550:250:250:250:250:502:250:250:250
Sendmail 8.12.8p1/8.12.8 -3-:220:220:250:250:553:250:550:250:250:250:250:250:250:250:250
Sendmail 8.12.8p1/8.12.8 -4-:220:501:501:250:250:250:550:214:250:250:502:250:502:250:250
Sendmail 8.12.8p1/8.12.8 -5-:220:501:501:250:250:250:550:250:250:250:250:502:502:250:250
Sendmail 8.12.8p1/8.12.8 -6-:250:220:501:250:553:250:550:214:250:250:250:502:250:250:250
Sendmail 8.12.8p1/8.12.8 -7-:220:501:250:250:553:250:550:214:250:250:502:502:502:250:250
Sendmail 8.12.8p1/8.12.8 -8-:250:220:501:250:553:250:550:214:250:250:502:502:502:250:250
Sendmail 8.12.8p1/8.12.8 -9-:220:220:501:250:553:250:550:214:250:250:502:502:250:250:250
Sendmail 8.12.8p1/8.12.8 -10-:220:220:250:250:250:553:250:214:250:250:502:502:502:250:250
Sendmail 8.12.8p1/8.12.8 -11-:220:501:501:250:553:250:550:250:250:250:250:502:250:250:250
Sendmail 8.12.8p1/8.12.8 -12-:220:220:501:250:553:250:250:250:250:250:502:502:250:250:250
Sendmail 8.12.8p1/8.12.8 -13-:220:220:250:250:553:250:550:250:250:250:250:250:502:250:250
Sendmail 8.12.8p1/8.12.8 -14-:220:501:250:250:553:250:550:250:250:250:502:250:250:250:250
Sendmail 8.12.8p1/8.12.8 -15-:250:501:250:250:250:250:550:214:250:250:250:250:250:250:220
Sendmail 8.12.8p1/8.12.8 -16-:220:501:250:250:553:250:550:250:250:250:502:250:502:250:250
Sendmail 8.12.8p1/8.12.8 -17-:250:220:250:250:553:250:550:214:250:250:250:250:502:250:220
Sendmail 8.12.8p1/8.12.8 -18-:220:220:501:250:250:250:250:250:250:250:250:502:250:250:250
Sendmail 8.12.8p1/8.12.8 -19-:220:220:250:250:553:250:550:250:250:250:502:250:250:250:220
Sendmail 8.12.8p1/8.12.8 -20-:250:220:501:250:553:250:550:214:250:250:250:502:502:250:220
Sendmail 8.12.8p1/8.12.8 -21-:220:501:250:250:553:250:550:250:250:250:502:502:250:250:220
Sendmail 8.12.8p1/8.12.8 -22-:220:220:250:250:250:250:550:250:250:250:502:502:502:250:220
Sendmail 8.12.8p1/8.12.8 -23-:220:501:501:250:553:250:550:250:250:250:250:250:250:250:250
Sendmail 8.12.8p1/8.12.8 -24-:250:501:250:250:553:250:250:250:250:250:502:502:502:250:250
Sendmail 8.12.8p1/8.12.8 -25-:250:501:501:250:250:250:550:214:250:250:502:502:250:250:250
Sendmail 8.12.9-SW/8.12.9-SW:220:220:250:250:553:553:550:214:250:250:502:502:502:250:250
Sendmail 8.12.9/8.11.0 -0-:250:220:250:250:553:250:550:214:250:250:502:502:502:250:220
Sendmail 8.12.9/8.11.0 -1-:220:220:501:250:250:250:250:214:250:250:502:502:502:250:220
Sendmail 8.12.9/8.11.0 -2-:220:501:250:250:553:501:550:250:250:250:502:502:250:250:250
Sendmail 8.12.9/8.11.0 -3-:220:501:501:250:553:250:250:214:250:250:502:502:502:250:250
Sendmail 8.12.9/8.11.0 -4-:250:220:250:250:553:250:550:250:250:250:502:250:502:250:250
Sendmail 8.12.9/8.11.0 -5-:220:220:501:250:250:250:250:250:250:250:502:250:250:250:250
Sendmail 8.12.9/8.11.0 -6-:250:220:501:250:553:501:250:250:250:250:502:502:502:250:220
Sendmail 8.12.9/8.11.0 -7-:250:501:501:250:553:501:550:214:250:250:502:502:502:250:220
Sendmail 8.12.9/8.11.0 -8-:220:501:501:250:553:250:250:214:250:250:250:250:502:250:220
Sendmail 8.12.9/8.11.0 -9-:220:501:250:250:553:501:550:250:250:250:250:250:502:250:250
Sendmail 8.12.9/8.11.0 -10-:220:501:250:250:553:250:250:250:250:250:250:250:250:250:250
Sendmail 8.12.9/8.12.5 -0-:250:501:250:250:250:553:550:250:250:250:502:502:502:250:220
Sendmail 8.12.9/8.12.5 -1-:250:501:502:250:501:553:250:214:250:250:502:502:502:250:250
Sendmail 8.12.9/8.12.6 -0-:250:501:501:250:553:553:550:214:553:553:502:502:502:250:250
Sendmail 8.12.9/8.12.6 -1-:220:220:501:250:553:553:550:214:250:250:502:250:502:250:250
Sendmail 8.12.9/8.12.6 -2-:250:501:501:250:553:250:550:214:250:250:502:502:250:250:250
Sendmail 8.12.9/8.12.6 -3-:250:501:501:250:553:553:250:502:250:250:502:502:502:250:250
Sendmail 8.12.9/8.12.6 -4-:220:501:250:250:250:250:250:250:252:502:502:502:250:250:250
Sendmail 8.12.9/8.11.6 -5-:250:220:501:250:250:250:250:250:250:250:502:250:250:250:250
Sendmail 8.12.9/8.12.8 -0-:250:220:501:250:250:553:250:214:250:250:250:502:502:250:220
Sendmail 8.12.9/8.12.8 -1-:250:220:501:250:250:250:250:214:250:250:502:250:250:250:250
Sendmail 8.12.9/8.12.8 -2-:220:501:501:250:250:250:550:214:250:250:250:502:502:250:250
Sendmail 8.12.9/8.12.8 -3-:250:220:250:250:250:250:250:214:250:250:250:250:250:250:250
Sendmail 8.12.9/8.12.8 -4-:250:501:501:250:250:250:550:250:250:250:250:250:250:250:250
Sendmail 8.12.9/8.12.8 -5-:250:501:501:250:553:553:250:214:250:250:502:502:502:250:220
Sendmail 8.12.9/8.12.8 -6-:250:501:501:250:553:250:550:214:250:250:502:250:250:250:220
Sendmail 8.12.9/8.12.8 -7-:250:220:501:250:250:250:250:214:250:250:502:250:250:250:220
Sendmail 8.12.9/8.12.8 -8-:250:501:501:250:553:250:550:250:250:250:502:502:502:250:250
Sendmail 8.12.9/8.12.8 -9-:250:501:501:250:553:553:250:214:250:250:502:250:250:250:250
Sendmail 8.12.9/8.12.9 -0-:220:220:250:250:250:250:250:214:250:250:502:502:250:250:250
Sendmail 8.12.9/8.12.9 -1-:250:501:501:250:250:553:250:250:250:250:502:250:250:250:250
Sendmail 8.12.9/8.12.9 -2-:250:220:501:250:553:250:250:250:250:250:250:250:502:250:250
Sendmail 8.12.9/8.12.9 -3-:250:220:250:250:250:553:250:214:250:250:502:250:502:250:220
Sendmail 8.12.9/8.12.9 -4-:250:220:501:250:553:250:250:250:250:250:502:502:502:250:250
Sendmail 8.12.9/8.12.9 -5-:220:220:501:250:553:250:250:214:250:250:502:502:250:250:250
Sendmail 8.12.9/8.12.9 -6-:220:220:501:250:250:553:250:250:250:250:250:250:250:250:250
Sendmail 8.12.9/8.12.9 -7-:220:220:501:250:250:553:250:214:250:250:502:502:250:250:220
Sendmail 8.12.9/8.12.9 -8-:220:501:250:250:553:553:250:250:250:250:250:502:502:250:250
Sendmail 8.12.9/8.12.9 -9-:250:501:250:250:250:250:250:250:250:250:502:502:502:250:250
Sendmail 8.12.9/8.12.9 -10-:250:501:250:250:250:553:550:214:250:250:502:502:502:250:250
Sendmail 8.12.9/8.12.9 -11-:220:501:501:250:553:250:250:250:250:250:502:502:502:250:250
Sendmail 8.12.9/8.12.9 -12-:250:220:501:250:553:553:250:214:250:250:502:502:250:250:250
Sendmail 8.12.9/8.12.9 -13-:220:501:250:250:250:250:250:214:250:250:502:250:250:250:220
Sendmail 8.12.9/8.12.9 -14-:220:220:250:250:553:250:250:214:250:250:502:502:502:250:220
Sendmail 8.12.9/8.12.9 -15-:250:501:250:250:553:553:250:214:250:250:502:502:250:250:250
Sendmail 8.12.9/8.12.9 -16-:220:501:501:250:250:553:250:250:250:250:502:250:250:250:220
Sendmail 8.12.9/8.12.9 -17-:220:501:250:250:250:250:250:250:250:250:250:502:250:250:250
Sendmail 8.12.9/8.12.9 -18-:250:501:250:250:553:553:250:214:250:250:502:502:502:250:250
Sendmail 8.12.9/8.12.9 -19-:250:501:250:250:553:250:250:214:250:250:250:250:502:250:250
Sendmail 8.12.9/8.12.9 -20-:250:501:250:250:250:553:250:250:250:250:502:502:502:250:250
Sendmail 8.12.9/8.12.9 -21-:220:220:250:250:553:553:250:214:250:250:250:250:250:250:250
Sendmail 8.12.9/8.12.9 -22-:250:220:250:250:250:553:250:214:250:250:250:250:502:250:250
Sendmail 8.12.9/8.12.9 -23-:250:220:501:250:553:553:250:214:250:250:502:250:250:250:220
Sendmail 8.12.9/8.12.9 -24-:220:220:501:250:553:553:250:214:250:250:250:502:502:250:220
Sendmail 8.12.9/8.12.9 -25-:220:220:501:250:250:553:250:214:250:250:502:502:502:250:220
Sendmail 8.12.9/8.12.9 -26-:250:220:250:250:553:553:250:250:250:250:250:502:250:250:250
Sendmail 8.12.9/8.12.9 -27-:250:220:250:250:250:553:250:250:250:250:250:250:502:250:250
Sendmail 8.12.9/8.12.9 -28-:250:220:501:250:250:553:250:250:250:250:502:502:250:250:250
Sendmail 8.12.9/8.12.9 -29-:250:501:250:250:553:250:250:250:250:250:502:502:502:250:220
Sendmail 8.12.9/8.12.9 -30-:220:501:501:250:250:553:250:250:250:250:502:250:250:250:250
Sendmail 8.12.9/8.12.9 -31-:250:220:501:250:553:250:250:250:250:250:502:250:250:250:220
Sendmail 8.12.9/8.12.9 -32-:220:220:501:250:250:553:250:214:250:250:502:250:502:250:250
Sendmail 8.12.9/8.12.9 -33-:250:501:250:250:553:250:250:214:250:250:502:502:502:250:220
Sendmail 8.12.9/8.12.9 -34-:250:220:501:250:553:250:550:250:250:250:502:502:502:250:250
Sendmail 8.12.9/8.12.9 -35-:250:501:501:250:553:250:250:250:250:250:250:250:250:250:250
Sendmail 8.12.9/8.12.9 -36-:250:501:501:250:553:553:550:214:250:250:250:502:502:250:250
Sendmail 8.12.9/8.12.9 -37-:250:220:250:250:250:250:250:214:250:250:250:502:502:250:250
Sendmail 8.12.9/8.12.9 -38-:250:501:501:250:250:250:250:250:250:250:250:250:502:250:220
Sendmail 8.12.9/8.12.9 -39-:250:220:250:250:250:250:250:250:250:250:502:250:250:250:250
Sendmail 8.12.9/8.12.9 -40-:250:501:501:250:553:250:250:250:250:250:250:502:502:250:250
Sendmail 8.12.9/8.12.9 -41-:250:501:250:250:553:250:250:214:250:250:250:502:502:250:250
Sendmail 8.12.9/8.12.9 -42-:220:501:250:250:250:553:250:214:250:250:502:250:250:250:220
Sendmail 8.12.9/8.12.9 -43-:220:501:250:250:553:553:250:250:250:250:502:250:250:250:250
Sendmail 8.12.9/8.12.9 -44-:220:220:250:250:250:250:250:214:250:250:250:502:502:250:250
Sendmail 8.12.9/8.12.9 -45-:250:501:250:250:250:250:250:214:250:250:502:502:502:250:220
Sendmail 8.12.9/8.12.9 -46-:503:501:501:250:553:250:553:214:252:502:502:502:502:250:250
Sendmail 8.12.9/8.12.9 -47-:220:501:250:250:553:553:250:214:250:250:250:502:502:250:250
Sendmail 8.12.9/8.12.9 -48-:220:220:250:250:553:250:250:250:250:250:250:502:502:250:220
Sendmail 8.12.9/8.12.9 -49-:250:501:250:250:250:250:250:250:250:250:502:502:250:250:220
Sendmail 8.12.9/8.12.9 -50-:220:501:501:250:250:250:250:214:250:250:502:502:502:250:220
Sendmail 8.12.9/8.12.9 -51-:250:220:501:250:553:553:550:214:250:502:502:502:502:250:250
Sendmail 8.12.9/8.12.9 -52-:220:501:501:250:250:250:250:214:250:250:502:502:250:250:250
Sendmail 8.12.9/8.12.9 -53-:250:501:501:250:553:553:250:250:250:250:502:250:250:250:250
Sendmail 8.12.9/8.12.9 -54-:250:220:250:250:250:553:250:250:250:250:250:250:250:250:250
Sendmail 8.12.9/8.12.9 -55-:250:220:250:250:250:250:250:250:250:250:502:502:502:250:250
Sendmail 8.12.9/8.12.9 -56-:220:220:250:250:553:553:250:250:250:250:250:250:250:250:220
Sendmail 8.12.9/8.12.9 -57-:220:220:250:250:250:553:250:250:250:250:250:502:250:250:250
Sendmail 8.12.9/8.12.9 -58-:250:501:501:250:250:250:250:214:250:250:502:250:502:250:250
Sendmail 8.12.9/8.12.9 -59-:220:501:250:250:553:250:250:214:250:250:250:250:250:250:220
Sendmail 8.12.9/8.12.9 -60-:220:220:250:250:553:250:250:214:250:250:502:502:250:250:250
Sendmail 8.12.9/8.12.9 -61-:220:220:250:250:250:553:250:250:250:250:502:250:250:250:250
Sendmail 8.12.9/8.12.9 -62-:503:501:501:250:553:553:250:214:250:250:502:502:502:250:250
Sendmail 8.12.9/8.12.9 -63-:250:501:501:250:553:553:250:250:250:250:250:502:502:250:220
Sendmail 8.12.9/8.12.9 -64-:220:220:501:250:553:553:250:250:250:250:502:502:502:250:250
Sendmail 8.12.9/8.12.9 -65-:220:220:501:250:250:553:250:214:250:250:502:502:502:250:250
Sendmail 8.12.9/8.12.9 -66-:220:220:501:250:553:553:250:250:250:250:250:502:502:250:250
Sendmail 8.12.9/8.12.9 -67-:250:220:250:250:250:553:250:214:250:250:502:502:502:250:250
Sendmail 8.12.9/8.12.9 -68-:250:501:250:250:553:250:250:250:250:250:502:250:250:250:250
Sendmail 8.12.9/8.12.9 -69-:250:501:501:250:553:553:550:214:250:502:502:502:250:250:250
Sendmail 8.12.9/8.12.9 -70-:250:220:501:250:250:553:250:250:250:250:502:502:502:250:250
Sendmail 8.12.9/8.12.9 -71-:220:220:250:250:250:553:250:214:250:250:250:502:502:250:250
Sendmail 8.12.9/8.12.9 -72-:220:220:501:250:553:250:250:214:250:250:250:250:250:250:250
Sendmail 8.12.9/8.12.9 -73-:220:220:250:250:553:250:250:250:250:250:250:250:502:250:250
Sendmail 8.12.9/8.12.9 -74-:220:220:250:250:250:553:250:214:250:250:250:250:250:250:220
Sendmail 8.12.9/8.12.9 -75-:250:250:501:250:553:553:550:214:252:502:502:502:502:250:250
Sendmail 8.12.9/8.12.9 -76-:250:220:501:250:553:553:250:214:250:250:250:250:502:250:250
Sendmail 8.12.9/8.12.9 -77-:250:501:501:250:553:553:250:214:250:250:250:250:502:250:250
Sendmail 8.12.9/8.12.9 -78-:220:220:250:250:250:553:250:250:250:250:502:250:502:250:250
Sendmail 8.12.9/8.12.9 -79-:250:501:501:250:553:250:550:250:250:250:502:250:502:250:220
Sendmail 8.12.9/8.12.9 -80-:250:501:250:250:553:553:250:250:250:250:250:502:502:250:220
Sendmail 8.12.9/8.12.9 -81-:220:501:501:250:250:553:250:250:250:250:502:250:502:250:220
Sendmail 8.12.9/8.12.9 -82-:220:220:250:250:553:553:250:214:250:250:502:250:502:250:220
Sendmail 8.12.9/8.12.9 -83-:250:220:250:250:553:553:250:250:250:250:502:250:502:250:250
Sendmail 8.12.9/8.12.9 -84-:220:220:250:250:250:553:250:250:250:250:502:250:502:250:220
Sendmail 8.12.9/8.12.9 -85-:250:501:250:250:553:553:250:250:250:250:502:502:502:250:220
Sendmail 8.12.9/8.12.9 -86-:250:220:501:250:553:553:250:214:250:250:502:502:502:250:250
Sendmail 8.12.9/8.12.9 -87-:250:501:501:250:250:553:250:250:250:250:250:502:250:250:250
Sendmail 8.12.9/8.12.9 -88-:220:501:501:250:553:250:250:250:250:250:250:502:502:250:220
Sendmail 8.12.9/8.12.9 -89-:250:220:501:250:553:553:250:214:250:250:250:250:502:250:220
Sendmail 8.12.9/8.12.9 -90-:220:220:250:250:250:553:250:214:250:250:502:250:502:250:220
Sendmail 8.12.9/8.12.9 -91-:250:220:250:250:250:553:250:214:250:250:250:502:502:250:220
Sendmail 8.12.9/8.12.9 -92-:220:501:501:250:250:250:250:214:250:250:502:502:502:250:250
Sendmail 8.12.9/8.12.9 -93-:250:220:501:250:553:553:250:214:252:502:502:502:502:250:250
Sendmail 8.12.9/8.12.9 -94-:250:220:501:250:250:553:250:250:250:250:250:250:502:250:220
Sendmail 8.12.9/8.12.9 -95-:250:501:250:250:553:553:250:250:250:250:502:502:250:250:220
Sendmail 8.12.9/8.12.9 -96-:250:501:250:250:250:250:250:214:250:250:502:502:250:250:250
Sendmail 8.12.9/8.12.9 -97-:220:220:250:250:250:553:250:214:250:250:250:502:502:250:220
Sendmail 8.12.9/8.12.9 -98-:220:220:501:250:553:553:250:250:250:250:250:502:250:250:250
Sendmail 8.12.9/8.12.9 -99-:250:501:501:250:553:501:550:214:252:250:502:502:502:250:250
Sendmail 8.12.9/8.12.9 -100-:220:220:250:250:250:250:250:250:250:250:502:250:502:250:250
Sendmail 8.12.9/8.12.9 -101-:220:220:501:250:250:250:250:250:250:250:502:502:250:250:250
Sendmail 8.12.9/8.12.9 -102-:250:220:250:250:250:250:250:250:250:250:250:502:250:250:250
Sendmail 8.12.9/8.12.9 -103-:250:220:501:250:553:553:250:250:250:250:250:502:250:250:250
Sendmail 8.12.9/8.12.9 -104-:220:220:501:250:250:250:250:214:250:250:502:250:250:250:250
Sendmail 8.12.9/8.12.9 -105-:250:220:501:250:553:250:250:250:250:250:502:502:250:250:220
Sendmail 8.12.9/8.12.9 -106-:220:220:501:250:250:250:550:250:250:250:502:250:502:250:250
Sendmail 8.12.9/8.12.9 -107-:220:501:501:250:250:553:250:250:250:250:502:502:502:250:250
Sendmail 8.12.9/8.12.9 -108-:250:501:501:250:553:250:250:214:250:250:502:250:250:250:220
Sendmail 8.12.9/8.12.9 -109-:250:220:501:250:250:553:250:214:250:250:250:250:250:250:250
Sendmail 8.12.9/8.12.9 -110-:220:501:501:250:250:250:250:214:250:250:502:502:250:250:220
Sendmail 8.12.9/8.12.9 -111-:220:501:250:250:553:250:250:250:250:250:502:250:502:250:220
Sendmail 8.12.9/8.12.9 -112-:250:220:250:250:250:250:250:214:250:250:502:502:502:250:250
Sendmail 8.12.9/8.12.9 -113-:220:501:501:250:250:250:250:214:250:250:502:250:502:250:250
Sendmail 8.12.9/8.12.9 -114-:250:220:501:250:250:553:250:250:250:250:250:502:250:250:250
Sendmail 8.12.9/8.12.9 -115-:220:501:250:250:553:250:250:214:250:250:502:250:502:250:220
Sendmail 8.12.9/8.12.9 -116-:250:501:250:250:250:553:250:214:250:250:250:502:502:250:250
Sendmail 8.12.9/8.12.9 -117-:220:220:250:250:553:553:250:214:250:250:250:502:250:250:250
Sendmail 8.12.9/8.12.9 -118-:250:501:250:250:553:250:250:250:250:250:250:250:502:250:250
Sendmail 8.12.9/8.12.9 -119-:220:220:250:250:250:553:250:250:250:250:250:502:502:250:250
Sendmail 8.12.9/8.12.9 -120-:220:220:501:250:553:553:250:250:250:250:502:250:250:250:220
Sendmail 8.12.9/8.12.9 -121-:250:220:501:250:553:553:250:214:250:250:502:502:502:250:220
Sendmail 8.12.9/8.12.9 -122-:220:501:501:250:250:553:250:214:250:250:250:502:250:250:250
Sendmail 8.12.9/8.12.9 -123-:250:501:501:250:553:553:550:502:250:502:502:502:502:250:250
Sendmail 8.12.9/8.12.9 -124-:220:501:250:250:553:250:550:250:252:502:502:502:502:250:250
Sendmail 8.12.9/8.12.9 -125-:220:501:250:250:250:553:250:214:250:250:250:502:250:250:220
Sendmail 8.12.9/8.12.9 -126-:250:220:501:250:250:250:250:214:250:250:250:250:250:250:220
Sendmail 8.12.9/8.12.9 -127-:250:501:250:250:250:553:250:250:250:250:502:250:250:250:220
Sendmail 8.12.9/8.12.9 -128-:250:501:501:250:553:250:550:214:250:502:502:502:250:250:250
Sendmail 8.12.9/8.12.9 -129-:250:501:501:250:250:553:250:250:250:250:502:502:502:250:220
Sendmail 8.12.9/8.12.9 -130-:220:501:501:250:250:250:250:214:250:250:250:250:250:250:250
Sendmail 8.12.9/8.12.9 -131-:220:220:250:250:553:250:250:214:250:250:502:502:502:250:250
Sendmail 8.12.9/8.12.9 -132-:250:220:501:250:553:250:250:214:250:250:502:502:250:250:250
Sendmail 8.12.9/8.12.9 -133-:220:501:501:250:250:553:250:214:250:250:502:502:250:250:220
Sendmail 8.12.9/8.12.9 -134-:220:501:250:250:250:250:250:250:250:250:502:250:502:250:250
Sendmail 8.12.9/8.12.9 -135-:220:501:501:250:553:553:250:214:250:250:502:502:250:250:250
Sendmail 8.12.9/8.12.9 -136-:220:220:250:250:553:250:250:250:250:250:502:250:250:250:250
Sendmail 8.12.9/8.12.9 -137-:250:501:250:250:553:553:250:250:250:250:502:502:502:250:250
Sendmail 8.12.9/8.12.9 -138-:250:220:501:250:553:553:250:214:250:250:250:502:502:250:220
Sendmail 8.12.9/8.12.9 -139-:250:501:501:250:250:250:250:250:250:250:250:250:502:250:250
Sendmail 8.12.9/8.12.9 -140-:250:501:501:250:250:250:250:250:250:250:502:502:502:250:250
Sendmail 8.12.9/8.12.9 -141-:250:501:501:250:553:250:250:214:250:250:502:250:250:250:250
Sendmail 8.12.9/8.12.9 -142-:220:220:501:250:250:250:250:214:250:250:502:502:502:250:250
Sendmail 8.12.9/8.12.9 -143-:250:220:250:250:553:553:250:214:250:250:502:502:502:250:250
Sendmail 8.12.9/8.12.9 -144-:250:220:250:250:250:553:250:250:250:250:250:250:250:250:220
Sendmail 8.12.9/8.12.9 -145-:250:220:501:250:250:250:250:214:250:250:250:502:502:250:250
Sendmail 8.12.9/8.12.9 -146-:220:220:501:250:250:250:250:250:250:250:250:502:502:250:250
Sendmail 8.12.9/8.12.9 -147-:250:501:501:250:553:250:250:214:250:250:502:250:502:250:250
Sendmail 8.12.9/8.12.9 -148-:220:501:250:250:553:250:250:250:250:250:502:502:502:250:250
Sendmail 8.12.9/8.12.9 -149-:250:501:501:250:553:553:250:214:250:250:502:250:502:250:220
Sendmail 8.12.9/8.12.9 -150-:220:501:501:250:250:250:250:250:250:250:502:250:502:250:250
Sendmail 8.12.9/8.12.9 -151-:250:501:250:250:250:250:250:250:250:250:502:502:250:250:250
Sendmail 8.12.9/8.12.9 -152-:250:501:501:250:553:553:550:502:252:502:502:502:502:250:250
Sendmail 8.12.9/8.9.1:250:250:501:250:553:250:550:214:250:250:502:502:502:250:250
Sendmail 8.12.9 -0-:220:220:250:250:553:250:250:250:252:250:250:250:502:250:250
Sendmail 8.12.9 -1-:250:501:501:250:553:250:250:250:252:250:250:250:250:250:220
Sendmail 8.12.9 -2-:250:501:501:250:553:250:250:250:250:250:250:250:250:250:220
Sendmail 8.12.9 -3-:250:220:250:250:553:553:550:214:250:250:502:250:250:250:220
Sendmail 8.12.9 -4-:220:220:250:250:250:553:550:214:250:250:250:250:502:250:220
Sendmail 8.12.9 -5-:250:501:501:250:250:553:550:214:250:250:250:250:502:250:250
Sendmail 8.12.9 -6-:250:220:501:250:250:250:550:214:250:250:502:250:250:250:220
Sendmail 8.12.9 -7-:250:220:250:250:250:553:550:214:250:250:502:250:250:250:220
Sendmail 8.12.9 -8-:220:220:250:250:553:250:250:214:250:250:250:250:502:250:250
Sendmail 8.12.9 -9-:220:501:501:250:250:250:550:250:250:250:250:250:250:250:220
Sendmail 8.12.9 -10-:250:501:250:250:553:553:250:250:250:250:250:250:502:250:220
Sendmail 8.12.9 -11-:220:220:250:250:553:250:550:214:250:250:502:250:250:250:220
Sendmail 8.12.9 -12-:220:501:250:250:553:553:550:214:250:250:502:502:502:250:220
Sendmail 8.12.9 -13-:220:501:501:250:553:553:550:214:250:250:502:502:502:250:250
Sendmail 8.12.9 -14-:220:220:501:250:250:250:550:214:250:250:502:502:250:250:250
Sendmail 8.12.9 -15-:250:501:250:250:553:553:550:214:250:250:502:502:502:250:250
Sendmail 8.12.9 -16-:220:501:250:250:250:553:550:214:250:250:502:502:502:250:220
Sendmail 8.12.9 -17-:250:220:501:250:553:553:250:250:250:250:502:502:502:250:250
Sendmail 8.12.9 -18-:250:220:250:250:250:250:250:250:250:250:502:250:250:250:220
Sendmail 8.12.9 -19-:250:220:501:250:553:250:250:214:250:250:502:502:502:250:250
Sendmail 8.12.9/SMI-SVR4:550:501:501:250:553:553:503:502:252:502:502:502:502:250:250
Sendmail 8.12.11/8.12.11:503:501:501:250:553:250:550:502:250:502:502:502:502:250:250
Sendmail 8.8.5/8.8.5:250:501:501:250:553:250:250:214:250:250:500:500:500:250:250
Sendmail 8.8.6p2003-03-31/8.8.2:250:501:501:250:553:451:550:214:250:250:500:500:500:250:250
Sendmail 8.8.8 -0-:503:501:501:250:553:250:550:214:252:502:500:500:500:250:250
Sendmail 8.8.8 -1-:250:501:501:250:553:250:550:502:250:250:500:500:500:250:250
Sendmail 8.8.8/8.8.7 -0-:250:501:501:250:553:501:550:502:550:550:500:500:500:250:250
Sendmail 8.8.8/8.8.7 -1-:503:501:501:250:553:501:550:502:550:502:500:500:500:250:250
Sendmail 8.8.8p1/8.8.5:250:501:501:250:553:250:550:214:250:502:500:500:500:250:250
Sendmail 8.9.1/8.9.1 -0-:250:501:250:250:553:501:550:214:250:250:500:500:250:250:250
Sendmail 8.9.1/8.9.1 -1-:250:220:501:250:553:501:550:214:250:250:250:500:500:250:250
Sendmail 8.9.1/8.9.1 -2-:250:501:501:250:250:501:550:250:250:250:500:500:500:250:250
Sendmail 8.9.1/8.9.1 -3-:250:501:250:250:553:250:550:250:250:250:250:500:500:250:250
Sendmail 8.9.1/8.9.1 -4-:220:501:501:250:553:501:250:214:250:250:250:500:250:250:250
Sendmail 8.9.1/8.9.1 -5-:220:220:250:250:250:250:250:250:250:250:500:500:250:250:220
Sendmail 8.9.1/8.9.1 -6-:250:220:250:250:553:501:550:214:250:250:500:500:500:250:250
Sendmail 8.9.1/8.9.1 -7-:250:501:501:250:250:250:550:214:250:250:500:500:500:250:250
Sendmail 8.9.1/8.9.1 -8-:250:501:501:250:250:501:550:214:250:250:500:500:500:250:250
Sendmail 8.9.1/8.9.1 -9-:250:501:501:250:553:250:250:214:250:250:250:500:500:250:250
Sendmail 8.9.1/8.9.1 -10-:250:501:501:250:250:501:250:214:250:250:500:250:250:250:250
Sendmail 8.9.1/8.9.1 -11-:250:501:501:250:553:250:250:214:250:250:220:250:500:250:250
Sendmail 8.9.1/8.9.1 -12-:220:220:501:250:553:501:250:214:250:250:250:250:500:250:250
Sendmail 8.9.1/8.9.1 -13-:250:501:501:250:250:501:550:214:250:250:250:500:500:250:250
Sendmail 8.9.1/8.9.1 -14-:250:501:501:250:553:501:250:214:250:250:500:500:500:250:220
Sendmail 8.9.1/8.9.1 -15-:250:501:501:250:553:250:250:214:250:250:500:500:250:250:250
Sendmail 8.9.1/8.9.1 -16-:220:220:250:250:553:250:250:250:250:250:500:250:500:250:220
Sendmail 8.9.1/8.9.1 -17-:250:501:501:250:553:250:550:214:250:250:500:250:250:250:250
Sendmail 8.9.1/8.9.1 -18-:220:501:501:250:553:501:550:250:250:250:500:250:250:250:220
Sendmail 8.9.1/8.9.1 -19-:250:501:250:250:553:501:550:250:250:250:500:500:250:250:250
Sendmail 8.9.1/8.9.1 -20-:250:501:501:250:553:501:250:250:250:250:500:500:250:250:250
Sendmail 8.9.1/8.9.1 -21-:250:220:250:250:553:501:250:250:250:250:250:250:500:250:220
Sendmail 8.9.1/8.9.1 -22-:250:220:501:250:250:501:550:214:250:250:250:500:500:250:250
Sendmail 8.9.1/8.9.1 -23-:220:220:501:250:250:501:550:250:250:250:500:250:250:250:220
Sendmail 8.9.1/8.9.1 -24-:250:501:501:250:553:250:250:214:250:250:500:250:500:250:220
Sendmail 8.9.1/8.9.1 -25-:250:220:250:250:553:501:550:250:250:250:250:250:500:250:250
Sendmail 8.9.1/8.9.1 -26-:250:501:250:250:553:501:550:250:250:250:500:500:250:250:220
Sendmail 8.9.1/8.9.1 -27-:250:220:501:250:250:250:250:250:250:250:220:250:500:250:220
Sendmail 8.9.1/8.9.1 -28-:250:501:501:250:553:501:250:250:250:250:250:250:250:250:250
Sendmail 8.9.1/8.9.1 -29-:250:501:501:250:553:501:550:214:250:250:250:250:250:250:250
Sendmail 8.9.1/8.9.1 -30-:250:501:501:250:553:250:250:250:250:250:500:250:250:250:220
Sendmail 8.9.1/8.9.1 -31-:220:501:250:250:553:501:550:214:250:250:500:250:500:250:250
Sendmail 8.9.1/8.9.1 -32-:250:501:501:250:553:501:250:250:250:250:250:500:500:250:250
Sendmail 8.9.1/8.9.1 -33-:220:220:501:250:250:501:250:214:250:250:500:250:500:250:250
Sendmail 8.9.1/8.9.1 -34-:220:220:501:250:553:501:550:214:250:250:500:500:250:250:220
Sendmail 8.9.1/8.9.1 -35-:250:501:501:250:250:250:250:214:250:250:500:500:500:250:250
Sendmail 8.9.1/8.9.1 -36-:220:501:501:250:250:501:250:214:250:250:500:500:500:250:250
Sendmail 8.9.1/8.9.1 -37-:250:501:501:250:250:501:550:250:250:250:500:250:250:250:250
Sendmail 8.9.1/8.9.1 -38-:250:220:501:250:553:501:250:214:250:250:250:500:500:250:250
Sendmail 8.9.1/8.9.1 -39-:250:220:501:250:553:250:550:214:250:250:500:500:500:250:250
Sendmail 8.9.1/8.9.1 -40-:220:501:501:250:553:501:550:250:250:250:500:250:250:250:250
Sendmail 8.9.1/8.9.1 -41-:250:501:501:250:553:501:550:250:250:250:500:500:500:250:220
Sendmail 8.9.1/8.9.1 -42-:220:501:501:250:553:501:550:214:250:250:500:250:250:250:250
Sendmail 8.9.1/8.9.1 -43-:250:501:501:250:553:501:550:214:250:250:250:500:500:250:250
Sendmail 8.9.1/8.9.1 -44-:250:501:501:250:250:250:250:250:250:250:500:500:500:250:250
Sendmail 8.9.1/8.9.1 -45-:250:501:501:250:553:501:550:250:250:250:250:500:500:250:250
Sendmail 8.9.1/8.9.1 -46-:220:501:501:250:250:501:550:250:250:250:500:500:500:250:250
Sendmail 8.9.1/8.9.1 -47-:250:501:501:250:553:250:250:250:250:250:500:500:500:250:250
Sendmail 8.9.1/8.9.1 -48-:220:501:501:250:553:501:550:214:250:250:500:250:500:250:250
Sendmail 8.9.1/8.9.1 -49-:250:220:501:250:250:250:550:214:250:250:250:250:500:250:250
Sendmail 8.9.1/8.9.1 -50-:250:501:501:250:250:250:550:214:250:250:500:500:250:250:250
Sendmail 8.9.1/8.9.1 -51-:250:501:250:250:553:501:250:250:250:250:250:500:500:250:250
Sendmail 8.9.1/8.9.1 -52-:220:220:250:250:250:501:250:250:250:250:250:500:250:250:250
Sendmail 8.9.1/8.9.1 -53-:250:501:501:250:553:250:250:214:250:250:500:250:250:250:250
Sendmail 8.9.1/8.9.1 -54-:250:501:501:250:553:501:250:250:250:250:500:500:500:250:250
Sendmail 8.9.1/8.9.1 -55-:250:501:501:250:553:250:250:214:250:250:250:250:500:250:250
Sendmail 8.9.1/8.9.1 -56-:250:501:501:250:250:501:550:250:250:250:250:250:250:250:220
Sendmail 8.9.1/8.9.1 -57-:250:501:501:250:553:501:550:214:250:250:500:250:250:250:250
Sendmail 8.9.1/8.9.1 -58-:220:220:501:250:553:501:550:214:250:250:250:500:500:250:220
Sendmail 8.9.1/8.9.1 -59-:250:220:501:250:250:250:550:250:250:250:500:500:500:250:250
Sendmail 8.9.1/8.9.1 -60-:250:501:501:250:250:501:550:250:250:250:500:500:500:250:220
Sendmail 8.9.1/8.9.1 -61-:220:501:501:250:553:250:550:214:250:250:500:250:500:250:250
Sendmail 8.9.1/8.9.1 -62-:250:501:501:250:553:501:250:214:250:250:250:500:250:250:250
Sendmail 8.9.1/8.9.1 -63-:220:501:501:250:553:250:550:214:250:250:500:500:250:250:250
Sendmail 8.9.1/8.9.1 -64-:250:501:501:250:250:250:550:214:250:250:250:500:500:250:250
Sendmail 8.9.1/8.9.1 -65-:250:501:501:250:553:501:550:214:250:250:250:500:250:250:250
Sendmail 8.9.1/8.9.1 -66-:250:501:501:250:220:250:550:214:250:250:500:500:500:250:220
Sendmail 8.9.1/8.9.1 -67-:250:501:501:250:553:501:550:250:250:250:500:250:250:250:250
Sendmail 8.9.1/8.9.1 -68-:250:501:501:250:553:501:550:214:250:250:250:250:500:250:250
Sendmail 8.9.1/8.9.1 -69-:250:501:501:250:553:250:550:214:250:250:500:250:500:250:220
Sendmail 8.9.1/8.9.1 -70-:250:501:501:250:553:250:550:250:250:250:500:250:250:250:250
Sendmail 8.9.1/8.9.1 -71-:250:220:250:250:553:250:550:214:250:250:500:500:500:250:220
Sendmail 8.9.1/8.9.1 -72-:220:501:501:250:250:501:550:214:250:250:500:500:250:250:250
Sendmail 8.9.1/8.9.1 -73-:250:220:501:250:250:250:550:214:250:250:500:500:500:250:250
Sendmail 8.9.1/8.9.1 -74-:220:501:501:250:553:501:550:214:250:250:500:500:250:250:220
Sendmail 8.9.1/8.9.1 -75-:220:220:501:250:553:501:550:214:250:250:250:250:250:250:250
Sendmail 8.9.1/8.9.1 -76-:250:501:501:250:553:250:550:214:250:250:250:250:250:250:250
Sendmail 8.9.1/8.9.1 -77-:250:501:501:250:553:501:250:214:250:250:250:250:500:250:250
Sendmail 8.9.1/8.9.1 -78-:250:220:250:250:553:501:550:250:250:250:250:500:500:250:220
Sendmail 8.9.1/8.9.1 -79-:250:501:501:250:553:250:250:250:250:250:250:250:500:250:250
Sendmail 8.9.1/8.9.1 -80-:220:501:250:250:553:501:550:214:250:250:250:250:250:250:250
Sendmail 8.9.1/8.9.1 -81-:250:220:501:250:553:501:550:214:250:250:500:250:500:250:220
Sendmail 8.9.1/8.9.1 -82-:250:220:501:250:553:501:550:214:250:250:250:250:250:250:250
Sendmail 8.9.1/8.9.1 -83-:250:501:501:250:553:501:550:250:250:250:250:500:500:250:220
Sendmail 8.9.1/8.9.1 -84-:250:501:250:250:553:501:550:214:250:250:500:500:500:250:220
Sendmail 8.9.1/8.9.1 -85-:250:501:250:250:553:501:550:214:250:250:250:500:500:250:250
Sendmail 8.9.1/8.9.1 -86-:220:501:501:250:250:250:550:214:250:250:500:250:250:250:250
Sendmail 8.9.1/8.9.1 -87-:250:501:250:250:553:501:550:250:250:250:500:250:250:250:250
Sendmail 8.9.1/8.9.1 -88-:220:501:501:250:250:501:550:214:250:250:500:500:500:250:250
Sendmail 8.9.1/8.9.1 -89-:250:501:250:250:553:250:550:214:250:250:500:250:250:250:220
Sendmail 8.9.1/8.9.1 -90-:220:501:501:250:553:501:550:214:250:250:500:500:500:250:250
Sendmail 8.9.1/8.9.1 -91-:250:501:501:250:250:250:550:214:220:250:500:500:500:250:250
Sendmail 8.9.1/8.9.1 -92-:220:501:501:250:553:501:550:214:250:250:250:500:500:250:250
Sendmail 8.9.1/8.9.1 -93-:250:220:501:250:250:501:550:250:250:250:500:500:500:250:250
Sendmail 8.9.1/8.9.1 -94-:220:501:501:250:553:501:550:214:250:250:500:250:500:250:220
Sendmail 8.9.1/8.9.1 -95-:250:220:250:250:553:501:550:250:250:250:500:250:250:250:220
Sendmail 8.9.1/8.9.1 -96-:220:501:501:250:250:250:250:214:250:220:250:500:500:250:250
Sendmail 8.9.1/8.9.1 -97-:250:220:501:250:553:501:250:214:250:250:500:500:500:250:250
Sendmail 8.9.1/8.9.1 -98-:250:220:501:250:553:501:550:214:250:250:500:500:500:250:220
Sendmail 8.9.1/8.9.1 -99-:250:220:250:250:553:501:550:214:250:250:250:250:250:250:250
Sendmail 8.9.1/8.9.1 -100-:250:501:250:250:553:250:550:214:250:250:500:500:500:250:250
Sendmail 8.9.1/8.9.1 -101-:250:501:501:250:250:501:250:214:250:250:250:250:250:250:250
Sendmail 8.9.1b+Sun/8.8.8:250:501:501:250:553:453:450:214:250:250:500:500:500:250:250
Sendmail 8.9.3 -0-:503:501:501:250:553:501:550:214:252:502:500:500:500:250:250
Sendmail 8.9.3 -1-:250:501:501:250:553:250:550:214:250:250:500:500:500:250:250
Sendmail 8.9.3 -2-:250:501:501:250:553:501:550:214:250:250:500:500:500:250:250
Sendmail 8.9.3 -3-:503:501:501:250:553:501:550:502:252:502:500:500:500:250:250
Sendmail 8.9.3+Sun/8.9.1:250:501:501:250:553:250:250:214:252:250:500:500:500:250:250
Sendmail 8.9.3+Sun/8.9.3 -0-:250:501:501:250:553:250:550:214:250:250:500:500:250:250:250
Sendmail 8.9.3+Sun/8.9.3 -1-:250:501:501:250:553:501:550:214:252:502:500:500:500:250:250
Sendmail 8.9.3/8.9.3 -0-:250:501:501:250:250:250:550:214:252:502:500:500:500:250:250
Sendmail 8.9.3/8.9.3 -1-:550:501:501:250:553:501:503:214:250:250:500:500:500:250:250
Sendmail 8.9.3/8.9.3 -2-:250:501:501:250:553:501:250:502:250:250:500:500:500:250:250
Sendmail 8.9.3/8.9.3 -3-:250:501:501:250:553:501:553:214:553:553:500:500:500:250:250
Sendmail 8.9.3/8.9.3 -4-:250:501:250:250:553:250:250:214:252:502:500:500:500:250:250
Sendmail 8.9.3/8.9.3 -5-:250:501:501:250:553:501:554:214:250:250:500:500:500:250:250
Sendmail 8.9.3/8.9.3 -6-:250:501:501:250:553:501:550:502:250:250:500:500:500:250:250
Sendmail 8.9.3/8.9.3 -7-:503:501:501:250:553:501:250:502:252:502:500:500:500:250:250
Sendmail 8.9.3/8.9.3 -8-:250:501:501:250:553:250:250:250:252:502:500:500:500:250:250
Sendmail 8.9.3/8.9.3 -9-:250:501:501:250:553:250:250:214:252:502:500:500:500:250:220
Sendmail 8.9.3/8.9.3 -10-:503:501:501:250:553:250:550:502:252:502:500:500:500:250:250
Sendmail 8.9.3/8.9.3 -11-:503:501:501:250:553:250:550:214:252:502:500:250:500:250:250
Sendmail 8.9.3/8.9.3 -12-:503:220:501:250:553:250:550:214:252:502:500:500:500:250:250
Sendmail 8.9.3/8.9.3 -13-:503:501:501:250:250:250:550:214:252:502:500:500:500:250:250
Sendmail 8.9.3/8.9.3 -14-:503:501:501:250:553:501:250:214:252:502:500:500:500:250:250
Sendmail 8.9.3p2/8.9.3 -0-:250:501:501:250:553:501:550:502:252:502:500:500:500:250:250
Sendmail 8.9.3p2/8.9.3 -1-:250:501:501:250:553:501:553:214:250:550:500:500:500:250:250
Sendmail AIX4.3/8.9.3/8.9.3 -0-:250:501:501:250:553:501:250:214:250:250:500:500:250:250:250
Sendmail AIX4.3/8.9.3/8.9.3 -1-:250:501:501:250:553:550:550:214:250:250:500:500:500:250:250
Sendmail Build 1 8.9.3p2/8.8.3:503:501:501:250:553:553:550:214:252:502:500:500:500:250:250
Sendmail Switch-2.2.0:503:501:501:250:553:250:550:214:252:502:502:502:502:250:250
Sendmail Switch-2.2.3:503:501:501:250:553:553:550:214:252:502:502:502:502:250:250
Sendmail Switch-2.2.6/:250:501:501:250:553:501:250:214:252:250:502:502:502:250:250
Sendmail Switch-3.0.4/Switch-3.0.0:250:501:501:250:553:250:250:214:250:502:502:502:502:250:250
Sendmail UNIFORM 8.9.3/8.9.3 :250:501:501:250:553:501:250:214:252:250:500:500:500:250:250
Sendmail for NT Build 101 8.9.3/NT-8.9.3 -0-:250:501:250:250:553:501:550:214:250:250:500:500:500:250:250
Sendmail for NT Build 101 8.9.3/NT-8.9.3 -1-:250:501:501:250:553:501:550:250:250:250:500:500:500:250:250
Sendmail for NT Build 101 8.9.3/NT-8.9.3 -2-:250:220:501:250:553:501:550:214:250:250:500:500:500:250:250
Sendmail for NT Build 101 8.9.3/NT-8.9.3 -3-:250:501:501:250:553:501:550:214:250:250:500:500:250:250:250
Sendmail for NT Build 103 8.9.3/NT-8.9.3 -0-:250:501:501:250:553:501:250:214:250:250:250:500:500:250:250
Sendmail for NT Build 103 8.9.3/NT-8.9.3 -1-:250:501:501:250:553:501:250:214:252:502:500:500:500:250:250
Sendmail for NT Build 103 8.9.3p2/NT-8.9.3 -0-:250:501:501:250:553:501:550:214:250:250:500:250:500:250:250
Sendmail for NT Build 103 8.9.3p2/NT-8.9.3 -1-:503:501:501:250:553:501:550:214:252:250:500:500:500:250:250
Sendmail for NT Build 103 8.9.3p2/NT-8.9.3 -2-:503:501:501:250:553:250:250:214:250:250:500:500:500:250:250
Sendmail for NT Build 103 8.9.3p2/NT-8.9.3 -3-:250:220:501:250:553:501:550:214:250:550:500:500:500:250:250
Sendmail for NT Build 103 8.9.3p2/NT-8.9.3 -4-:250:501:501:250:553:501:550:214:250:550:500:500:500:250:250
Sendmail for NT Build 103 8.9.3p2/NT-8.9.3 -5-:250:501:501:250:553:250:550:214:250:550:500:500:500:250:250
Sendmail for NT Build 98 8.9.3/NT-8.9.3:451:501:501:250:553:451:503:214:252:502:500:500:500:250:250
StrongMail 2.04:504:501:501:250:501:501:505:502:502:502:502:502:502:502:250
PostMaster 3.15.2  (build 264):504:504:500:250:250:250:250:500:550:550:500:500:500:250:250
Smail 3.2.0:220:220:250:250:250:250:250:250:250:250:250:250:250:250:220
Sugarsoft Mail Server 2.50:0:250:501:250:501:250:501:214:550:500:500:500:500:250:500
TIS/FWTK smap proxy -0-:250:250:501:250:250:250:250:214:250:250:500:500:500:220:500
TIS/FWTK smap proxy -1-:250:250:501:550:250:250:571:214:250:250:500:500:500:220:500
TIS/FWTK smap proxy -2-:250:250:501:506:250:250:250:214:250:250:500:500:500:220:500
TIS/FWTK smap proxy -3-:250:250:501:250:250:553:550:214:250:250:500:500:500:220:500
TIS/FWTK smap proxy -4-:250:250:501:250:250:250:550:214:250:250:500:500:500:220:250
TIS/FWTK smap proxy -5-:250:250:501:250:250:516:513:214:250:250:500:500:500:220:500
TIS/FWTK smap proxy -6-:250:250:501:250:250:250:571:214:250:250:500:500:500:220:500
TIS/FWTK smap proxy -7-:250:250:501:250:250:250:250:214:250:250:500:500:500:220:250
USA.NET-SMTA vC8.MAIN.1.11G:503:501:500:250:553:250:553:214:500:500:500:500:500:250:250
VNWD:503:501:501:250:553:501:550:214:250:502:500:500:500:250:250
VPOP3 SMTP Server:250:250:500:250:501:250:250:214:500:500:500:500:500:250:250
VaMailArmor-2.0.1.7:220:250:250:250:250:250:552:502:252:502:502:502:502:250:250
VisNetic.MailServer.v5.0.2.0 -0-:250:501:501:250:501:501:250:214:502:551:500:250:250:250:250
VisNetic.MailServer.v5.0.2.0 -1-:250:501:501:250:501:250:550:214:502:502:500:250:250:250:502
VisNetic.MailServer.v5.8.6.6:250:501:501:250:501:501:550:214:502:502:500:250:250:250:502
Weasel 1.5:503:250:553:250:250:250:250:500:250:550:500:500:500:250:250
Weasel 1.68:503:250:553:250:250:250:550:500:553:550:500:500:500:250:250
WinProxy:250:250:250:250:250:250:550:214:500:500:500:500:500:250:250
WinProxy 1.5.1:250:250:250:250:250:250:550:214:500:500:500:500:500:250:500
XMail 1.10:503:501:500:250:451:250:451:250:501:500:500:500:500:250:250
XMail 1.11 (Linux/Ix86):503:501:500:501:451:250:451:250:501:500:500:500:500:250:250
XMail 1.11 (Win32/Ix86) -0-:503:501:500:250:451:505:451:250:501:500:500:500:500:250:250
XMail 1.11 (Win32/Ix86) -1-:503:501:500:501:451:505:451:250:501:500:500:500:500:250:250
XMail 1.12 (Win32/Ix86) -0-:503:501:500:250:451:250:451:250:252:500:500:500:500:250:250
XMail 1.12 (Win32/Ix86) -1-:503:501:500:250:451:505:451:250:252:500:500:500:500:250:250
XMail 1.14 (Win32/Ix86) -0-:503:501:500:501:451:505:451:250:252:500:500:500:500:250:250
XMail 1.14 (Win32/Ix86) -1-:220:220:500:250:451:250:451:250:252:500:500:500:500:250:250
XMail 1.7 (Win32/Ix86):503:501:500:250:451:250:451:500:501:500:500:500:500:250:250
XWall 3.23,3.24:503:501:502:250:250:250:501:211:553:502:502:250:250:250:250
eSafe Gateway Appliance:503:501:500:250:250:250:550:502:502:502:502:502:502:250:500
iMate Mail Server 5.0.0:503:501:250:250:250:250:501:214:500:500:500:500:500:250:250
iMail.nlm 3.11:250:250:250:250:501:451:250:214:500:500:502:502:502:250:250
iPlanet Messaging Server 5.1:250:251:501:250:250:250:250:214:252:250:502:250:250:250:250
iPlanet Messaging Server 5.2 -0-:250:251:501:250:250:250:250:214:251:250:502:250:250:250:250
iPlanet Messaging Server 5.2 -1-:250:251:501:250:250:250:250:214:252:550:502:250:250:250:250
inFusion Mail Server Enterprise v2.1:503:250:503:250:250:250:550:214:507:507:507:507:507:250:250
inFusion Mail Server Enterprise v2.3.1:503:0:503:250:250:250:550:214:507:507:507:507:507:250:250
magic-smtpd 0.7.0 beta:555:250:555:250:250:250:555:214:252:502:502:502:502:250:250
Kerio MailServer 5.1.6 -1-:250:250:500:250:250:553:550:214:250:500:500:500:500:250:220
Kerio MailServer 5.1.6 -2-:250:250:500:250:250:250:550:214:252:500:250:500:500:250:250
Kerio MailServer 5.5.0:250:250:500:250:250:250:550:214:252:500:500:500:500:250:220
Kerio MailServer 5.5.1 -0-:250:250:500:250:250:553:550:214:250:500:500:500:500:250:250
Kerio MailServer 5.5.1 -1-:250:250:500:250:250:250:550:214:252:500:500:250:500:250:250
Kerio MailServer 5.5.1 -2-:250:250:500:250:250:250:550:250:252:500:250:500:500:250:220
Kerio MailServer 5.5.1 -3-:250:250:250:250:250:250:550:214:252:500:500:500:500:250:250
Kerio MailServer 5.5.1 -4-:250:220:500:250:250:250:550:214:252:500:500:500:500:250:250
Kerio MailServer 5.6.0 -0-:220:250:250:250:250:250:550:214:252:500:500:500:500:250:250
Kerio MailServer 5.6.0 -1-:220:220:500:250:250:250:550:214:250:500:500:500:500:250:250
Kerio MailServer 5.6.0 -2-:250:250:500:250:250:553:550:214:252:500:500:250:500:250:250
Kerio MailServer 5.6.1 -0-:250:250:500:250:250:250:550:214:252:500:500:500:500:250:250
Kerio MailServer 5.6.1 -1-:553:250:500:250:553:553:503:214:252:500:500:500:500:250:250
Kerio MailServer 5.6.1 -2-:250:220:250:250:250:250:550:214:252:500:500:500:500:250:250
Kerio MailServer 5.6.1 -3-:250:250:500:250:250:250:550:214:252:250:500:500:500:250:250
Kerio MailServer 5.6.1 -4-:250:250:500:250:250:553:550:214:252:500:500:500:500:250:250
ERCUR SMTP-Server v3.10.07:250:250:501:250:250:550:250:214:550:550:502:250:250:250:502
MERCUR SMTP-Server v3.20.01:250:250:501:250:250:250:550:214:550:550:502:250:250:250:250
MERCUR SMTP-Server v3.30.02:250:250:501:250:250:250:550:214:550:550:502:250:250:250:502
MERCUR SMTP-Server v3.30.07:550:250:501:550:550:550:501:214:550:550:502:550:550:250:502
MERCUR SMTP-Server v3.30.09 -0-:250:250:501:250:250:250:250:214:550:550:502:250:250:250:250
MERCUR SMTP-Server v3.30.09 -1-:250:250:501:250:250:550:550:214:550:550:502:250:250:250:502
MERCUR SMTP-Server v3.30.09 -2-:250:250:500:250:250:550:550:214:550:550:502:250:250:250:502
MERCUR SMTP-Server v3.30.09 -3-:250:250:501:250:250:250:250:214:550:550:502:250:250:250:502
MERCUR SMTP-Server v4:250:250:501:250:250:250:501:214:550:550:502:250:250:250:250
MERCUR SMTP-Server v4.01.00:250:250:501:250:250:550:250:214:550:550:502:250:250:250:250
MERCUR SMTP-Server v4.01.09:250:250:501:250:250:550:550:214:550:550:502:250:250:250:250
MERCUR SMTP-Server v4.02.01:250:250:501:250:250:550:501:214:550:550:502:250:250:250:250
Lotus Domino Build V60_M14_07282002 Release Candidate:250:501:501:250:501:250:554:214:252:252:502:250:250:250:250
Lotus Domino Release 4.6.7a:503:501:501:250:250:250:250:214:502:502:500:500:500:250:250
Lotus Domino Release 5.0.10 -0-:220:501:501:250:501:250:250:214:252:252:502:250:250:250:250
Lotus Domino Release 5.0.10 -1-:250:501:501:250:250:250:250:214:252:252:502:250:250:250:250
Lotus Domino Release 5.0.10 -2-:250:501:501:250:501:250:250:502:250:252:502:250:250:250:250
Lotus Domino Release 5.0.10 -3-:250:501:500:250:501:250:250:214:252:252:502:250:250:250:250
Lotus Domino Release 5.0.10 -4-:250:501:250:250:501:250:250:214:252:252:502:250:250:250:250
Lotus Domino Release 5.0.11 -0-:250:501:501:250:501:250:554:214:252:550:502:250:250:250:250
Lotus Domino Release 5.0.11 -1-:250:501:501:250:501:250:250:502:550:550:502:250:250:250:250
Lotus Domino Release 5.0.11 -2-:250:501:501:250:501:250:250:214:250:252:502:250:250:250:250
Lotus Domino Release 5.0.11 -3-:250:501:501:250:501:250:250:214:550:550:502:250:250:250:250
Lotus Domino Release 5.0.12:250:501:501:250:501:250:250:502:550:252:502:250:250:250:250
Lotus Domino Release 5.0.5 -0-:250:501:501:250:501:554:554:502:550:550:502:250:250:250:250
Lotus Domino Release 5.0.5 -1-:250:501:501:250:501:250:554:502:550:550:502:250:250:250:250
Lotus Domino Release 5.0.5 -2-:250:501:501:250:501:250:554:214:250:252:502:250:250:250:250
Lotus Domino Release 5.0.5 -3-:554:501:501:554:501:554:503:214:252:252:502:554:554:250:250
Lotus Domino Release 5.0.5 -4-:250:501:501:250:501:250:554:214:550:550:502:250:250:250:250
Lotus Domino Release 5.0.6a -0-:250:501:501:250:501:250:554:214:252:252:502:250:250:250:250
Lotus Domino Release 5.0.6a -1-:250:501:501:250:501:250:554:502:550:252:502:250:250:250:250
Lotus Domino Release 5.0.6a -2-:250:501:501:250:501:250:554:502:252:252:502:250:250:250:250
Lotus Domino Release 5.0.6a -3-:250:501:500:250:501:250:554:214:252:252:502:250:250:250:250
Lotus Domino Release 5.0.6a -4-:250:501:501:250:501:250:554:214:252:252:250:250:250:250:250
Lotus Domino Release 5.0.6a -5-:250:501:501:250:501:250:554:250:252:252:502:250:250:250:250
Lotus Domino Release 5.0.7:250:501:501:250:501:250:554:214:550:252:502:250:250:250:250
Lotus Domino Release 5.0.8 -0-:250:501:501:250:501:554:250:502:252:252:502:250:250:250:250
Lotus Domino Release 5.0.8 -1-:250:220:501:250:501:250:250:214:252:252:502:250:250:250:250
Lotus Domino Release 5.0.8,5.0.10:250:501:501:250:501:250:250:214:252:252:502:250:250:250:250
Lotus Domino Release 5.0.9 -0-:250:501:501:250:501:554:250:502:550:252:502:250:250:250:250
Lotus Domino Release 5.0.9 -1-:250:501:501:250:501:250:250:250:252:252:502:250:250:250:250
Lotus Domino Release 5.0.9 -2-:250:501:501:250:501:554:250:214:550:550:502:250:250:250:250
Lotus Domino Release 5.0.9a:250:501:501:250:501:250:250:214:252:550:502:250:250:250:250
Lotus Domino Release 5.07a:554:501:501:250:501:250:503:214:252:252:502:554:554:250:250
Lotus Domino Release 6.0 -0-:220:220:501:250:501:250:250:214:252:252:502:250:250:250:250
Lotus Domino Release 6.0 -1-:250:501:501:250:501:554:550:214:252:252:502:250:250:250:250
Lotus Domino Release 6.0.1 -0-:250:501:501:250:501:554:250:214:252:250:502:250:250:250:250
Lotus Domino Release 6.0.1 -1-:250:501:501:250:501:554:250:214:550:252:502:250:250:250:250
Lotus Domino Release 6.0.1CF1 -0-:250:501:501:250:501:250:550:214:252:252:502:250:250:250:250
Lotus Domino Release 6.0.1CF1 -1-:250:501:501:250:501:554:250:214:252:252:502:250:250:250:250
Lotus Domino Release 6.0.1CF1 -2-:250:501:501:250:501:554:550:214:252:550:502:250:250:250:250
Lotus Domino Release 6.0.1CF1 -3-:501:501:501:250:501:554:501:214:252:252:502:250:250:250:250
Lotus Domino Release 6.0.3:250:501:501:250:501:250:250:502:252:252:502:250:250:250:250
Lotus SMTP MTA Service -0-:503:501:501:250:250:250:501:214:550:502:500:500:500:250:250
Lotus SMTP MTA Service -1-:503:501:500:250:250:250:250:214:502:502:500:500:500:250:250
Lotus SMTP MTA Service -2-:503:501:250:250:250:250:250:214:502:502:500:500:500:250:250
Lotus SMTP MTA Service -3-:503:501:501:250:250:250:501:214:502:502:500:500:500:250:250
Lotus SMTP MTA Service -4-:503:501:503:503:503:503:503:503:503:503:500:500:500:503:501
Lotus SMTP MTA Service -5-:503:501:501:250:250:250:250:214:500:500:500:500:500:250:250
Lotus SMTP MTA Service -6-:503:501:501:250:501:250:503:214:502:502:500:500:500:250:250
WinRoute Pro 4.1 -0-:250:250:250:250:250:250:250:214:250:500:500:500:500:250:250
WinRoute Pro 4.1 -1-:220:250:250:250:250:250:550:214:500:500:500:500:500:250:250
WinRoute Pro 4.2.0:250:250:250:250:250:250:550:250:500:500:500:500:500:250:250
WinRoute Pro 4.2.1 -0-:250:250:250:250:250:250:550:250:500:500:250:500:500:250:220
WinRoute Pro 4.2.1 -1-:250:250:250:250:250:250:250:214:500:500:500:500:500:250:250
WinRoute Pro 4.2.2:250:250:502:250:501:250:550:214:500:500:502:502:502:250:250
WinRoute Pro 4.2.4:220:250:250:250:250:250:250:214:500:500:500:500:500:250:250
WinRoute Pro 4.2.5 -0-:250:250:250:250:250:250:550:214:500:500:500:500:500:250:220
WinRoute Pro 4.2.5 -1-:250:250:250:250:250:250:550:214:500:250:500:500:500:250:250
MailMarshal (v4,2,5,0) -0-:220:501:250:250:501:250:501:214:252:502:500:500:500:250:250
MailMarshal (v4,2,5,0) -1-:503:501:501:452:501:452:503:214:252:502:500:500:500:250:250
MailMarshal (v5,0,3,74):503:501:501:250:501:250:250:214:252:502:500:500:250:250:250
MailMarshal (v5,0,3,76) -0-:503:501:501:250:501:250:501:214:252:502:500:500:250:250:250
MailMarshal (v5,0,3,76) -1-:503:501:501:250:501:250:501:214:252:502:500:500:500:250:250
MailMarshal (v5,0,3,85):503:501:501:250:250:250:250:214:252:502:500:500:500:250:250
MailMarshal (v5,0,3,91) -0-:503:501:501:250:501:250:501:214:252:502:500:250:500:250:250
MailMarshal (v5,0,3,91) -1-:503:501:501:250:501:250:501:214:252:502:250:500:500:250:250
MailMarshal (v5,0,3,91) -2-:503:220:501:250:501:250:501:214:252:502:500:500:500:250:250
MailMarshal (v5,0,3,91) -3-:503:501:250:250:501:250:501:214:252:502:500:500:500:250:250
MailMarshal (v5,0,3,91) -4-:503:501:500:250:501:250:501:214:252:502:500:500:500:250:250
Mercury 1.44 -0-:501:250:250:250:250:250:550:214:251:502:502:250:250:250:250
Mercury 1.44 -1-:501:250:250:250:250:250:550:214:550:502:502:250:250:250:250
Mercury 1.48 -0-:501:220:250:250:250:250:553:214:550:502:502:250:250:250:250
Mercury 1.48 -1-:501:250:250:250:550:550:503:214:550:502:502:550:550:250:250
Mercury 1.48 -2-:501:250:250:250:250:250:553:214:251:502:502:250:250:250:250
Mercury 1.48 -3-:501:250:250:250:250:250:553:214:550:502:502:250:250:250:250
Mercury/32 v3.30 -0-:501:250:250:250:250:250:553:214:550:220:502:250:250:250:250
Mercury/32 v3.30 -1-:501:250:250:250:250:250:553:214:550:220:502:250:250:250:250
Mercury/32 v3.32 -0-:501:250:250:250:250:250:250:214:251:502:502:250:250:250:250
Mercury/32 v3.32 -1-:501:250:502:250:501:250:553:214:550:502:502:502:502:250:250
Mercury/32 v3.32 -2-:501:250:250:250:250:250:250:214:251:502:502:250:250:250:250
Mercury/32 v3.32 -3-:501:250:502:250:501:250:553:214:550:502:502:502:502:250:250
MailMax 2.040 -0-:503:501:501:250:250:250:553:214:250:502:502:502:502:250:250
MailMax 2.040 -1-:503:501:501:250:250:250:250:214:502:502:250:250:502:250:250
MailMax 2.040 -2-:220:501:501:250:250:250:553:214:502:502:502:502:502:250:250
MailMax 2.040 -3-:503:501:501:250:250:250:553:214:250:502:250:502:502:250:250
MailMax 2.040 -4-:503:501:250:250:250:250:553:214:502:250:502:502:502:250:250
MailMax 2.040 -5-:503:220:501:250:250:250:553:250:502:502:502:502:250:250:250
MailMax 2.040 -6-:503:501:501:250:250:250:553:214:554:502:502:502:502:250:250
MailMax 2.040 -7-:503:501:501:250:250:250:250:214:502:502:502:502:502:250:250
MailMax 2.040 -8-:503:501:501:250:250:250:250:214:554:502:502:502:502:250:250
MailMax 2.040 -9-:220:501:501:250:250:250:553:214:502:502:250:250:502:250:250
MailMax 2.040 -10-:503:501:501:250:250:250:553:214:502:502:502:502:250:250:250
MailMax 2.040 -11-:503:501:501:250:250:250:553:214:250:250:502:502:502:250:250
MailMax 3.029:503:501:501:250:250:250:553:214:502:502:502:502:502:250:250
MailMax 3.065:503:501:501:250:250:250:550:214:250:502:502:502:502:250:250
MailMax 5 -0-:250:501:501:250:501:250:250:214:502:502:502:502:502:250:250
MailMax 5 -1-:250:501:501:250:501:250:550:214:502:502:502:502:502:250:250
pleMailServer 10.1.0.0 -0-:250:501:500:553:553:250:250:214:550:550:500:500:500:250:250
AppleMailServer 10.1.0.0 -1-:250:501:500:553:553:250:553:214:550:550:500:500:500:250:250
AppleMailServer 10.1.4.0 -0-:250:501:500:250:553:250:553:214:250:550:500:500:500:250:250
AppleMailServer 10.1.4.0 -1-:250:501:500:250:553:250:553:214:550:550:500:500:500:250:250
AppleMailServer 10.1.4.0 -2-:250:501:500:250:553:250:250:214:250:550:500:500:500:250:250
AppleMailServer 10.2.0.0:250:501:500:250:553:250:250:214:550:550:500:500:500:250:250
AppleMailServer 10.2.2.0:250:501:500:250:553:250:250:214:503:503:500:500:500:250:250
AppleMailServer 10.2.3.0:250:501:500:250:553:250:553:214:503:503:500:500:500:250:250
InterChange v3.20:250:250:500:250:250:250:250:211:550:500:500:500:500:250:250
InterChange v3.50:250:250:500:250:250:250:550:211:550:500:500:500:500:250:250
InterChange v3.62 -0-:250:250:500:250:250:250:550:211:252:500:500:500:500:250:250
InterChange v3.62 -1-:250:250:500:250:250:250:250:211:252:500:500:500:500:250:250
IMail 8.05:503:250:501:250:250:250:550:211:250:550:502:250:250:250:250
SMTPXD version 1:503:250:250:250:553:250:251:214:252:502:500:500:500:200:500
SMTPXD version 141:503:250:250:250:553:250:250:214:252:502:500:500:500:200:500
SMTPXD version 145:503:250:250:250:553:250:550:214:252:502:500:500:500:200:500
SMTPXD version 57 -0-:503:250:250:250:553:553:550:214:252:502:500:500:500:200:500
SMTPXD version 57 -1-:503:250:550:250:250:250:250:214:252:502:500:500:500:200:500
SMTPXD version 63:503:250:250:250:554:250:250:214:252:502:500:500:500:200:500
SMTPXD version 68:503:250:553:250:553:501:550:214:252:502:500:500:500:200:500
QuickMail Pro Server 1.7 -0-:250:250:501:250:501:250:550:214:250:250:504:250:250:250:250
QuickMail Pro Server 1.7 -1-:550:550:501:250:501:250:501:214:250:250:504:250:250:250:250
QuickMail Pro Server for Mac 2.0.1:503:250:501:250:250:250:553:550:252:550:550:550:550:250:250
QuickMail Pro Server for Mac 3.0:503:250:501:250:250:250:250:550:252:550:550:550:550:250:250
QuickMail Pro Server for MacOS 1.1.1r1:503:250:501:250:501:250:250:550:252:550:550:550:550:250:250
SLmail 4.1.3395:250:250:500:250:501:250:250:214:250:250:500:250:250:250:500
SLmail 5.1.0.4420:250:250:500:250:501:250:250:214:250:250:500:250:250:250:250
Sun Internet Mail Server sims.3.5.2000.03.23.18.03.p10:250:251:501:250:250:250:550:214:251:250:502:250:250:200:250
Sun Internet Mail Server sims.4.0.2001.07.26.11.50.p9:250:251:501:250:250:250:550:214:251:250:502:250:250:250:250
Mailtraq 1.1.4.1149:503:501:250:250:250:250:550:501:503:501:501:501:501:250:250
Mailtraq 1.1.5.1167:503:501:250:250:250:250:250:501:503:501:501:501:501:250:250
Mailtraq 2.0.0.1255:500:501:250:250:250:250:250:501:503:501:501:501:501:250:250
Mailtraq 2.0.0.1264:220:501:250:250:250:250:250:501:503:501:501:501:501:250:250
Mailtraq 2.1.0.1310:500:501:250:250:250:554:550:501:503:501:501:501:501:250:250
Mailtraq 2.2.0.1348:500:501:250:250:250:554:250:501:503:501:501:501:501:250:250
Mailtraq 2.2.0.1362:500:501:250:250:250:250:550:501:503:501:501:501:501:250:250
Minesweeper 100:503:501:501:250:501:250:450:502:502:502:502:502:502:250:250
Stalker Internet Mail Server V.1.6:250:250:500:250:501:250:250:214:252:500:500:500:500:250:250
Stalker Internet Mail Server V.1.7 -0-:250:250:500:250:501:572:250:214:252:500:500:500:500:250:250
Stalker Internet Mail Server V.1.7 -1-:250:250:500:250:501:250:550:214:252:500:500:500:500:250:250
Stalker Internet Mail Server V.1.8b8:250:250:500:250:501:572:550:214:252:500:500:500:500:250:250
eXtremail V1.2 release 2:503:501:501:250:451:250:451:250:500:500:500:500:500:250:250
eXtremail V1.5 release 5 -0-:503:501:501:250:451:250:250:250:500:500:500:500:500:250:250
eXtremail V1.5 release 5 -1-:503:501:501:250:451:250:451:250:250:500:500:500:500:250:250
LSMTP for Windows NT v1.1b:503:250:504:250:501:250:501:214:252:502:502:502:502:250:250
Dimac Mail Server 1.1.0.0a:503:250:250:250:250:250:551:250:551:500:500:500:500:250:250
VopMail Version 4.3.183.0 -0-:503:250:250:250:250:550:250:500:250:500:500:500:500:250:250
VopMail Version 4.3.183.0 -1-:503:250:250:250:250:550:250:500:250:500:500:500:500:250:220
VopMail Version 4.6.189.0:503:250:250:250:250:250:250:500:551:500:500:500:500:250:250
VopMail Version 5.1.202.0 -0-:503:250:550:550:250:250:550:500:551:500:500:500:500:250:250
VopMail Version 5.1.202.0 -1-:503:250:501:250:250:250:501:500:551:500:500:500:500:250:250
VopMail Version 5.3.232.0 -0-:503:250:250:250:250:250:550:500:252:250:500:500:500:250:250
VopMail Version 5.3.232.0 -1-:503:250:250:250:250:250:550:250:252:500:500:500:500:250:250
VopMail Version 5.3.232.0 -2-:220:250:250:250:250:250:550:500:252:500:500:500:500:250:250
VopMail Version 5.3.232.0 -3-:503:250:250:250:250:250:550:500:252:500:500:500:250:250:250
VopMail Version 5.3.232.0 -4-:503:220:250:250:250:250:550:500:252:500:500:500:500:250:250
SMTP/cmap -0-:250:250:501:250:250:250:250:500:500:500:500:500:500:250:500
SMTP/cmap -1-:250:501:501:250:501:250:550:500:500:500:500:500:500:250:500
SMTP/cmap -2-:250:501:501:250:553:501:250:500:500:250:250:250:250:250:220
SMTP/cmap -3-:250:501:501:250:553:553:550:500:500:500:500:500:500:250:500
SMTP/cmap -4-:250:250:501:250:501:250:501:500:500:500:500:500:500:250:500
SMTP/cmap -5-:250:250:501:250:553:250:250:500:500:500:500:500:500:250:500
SMTP/cmap -6-:250:250:501:250:553:250:250:250:250:250:250:250:250:250:250
Symantec Enterprise Firewall 7.04 (Windows):503:250:501:250:501:250:553:214:252:252:500:500:500:250:250
Symantec Velociraptor 1.5:503:250:501:250:553:501:553:214:252:252:500:500:500:250:250
NetGain Mimetic Gateway version 3.3.0.0:250:501:501:250:250:250:500:502:502:502:502:250:502:250:502
ModusMail Version 1.4.232.0:503:250:501:250:250:550:501:500:252:500:500:500:500:250:250
mtmail 0.96:503:250:501:250:250:250:250:214:502:502:502:502:502:200:500
PowerMTA v1.6:250:250:501:250:501:250:250:214:502:502:502:502:502:250:250
BorderWare 6.5:503:250:501:250:501:250:501:241:252:502:502:250:250:250:250
MailEnable Management MailEnable Version 1.07:250:250:501:250:501:250:501:211:503:503:503:503:503:250:250
MailEnable 1.63:250:250:501:250:501:250:501:211:503:503:503:502:502:250:250
IBM AS/400 SMTP V05R01M00:503:501:501:250:501:250:501:214:252:502:502:502:502:250:500
IBM AS/400 SMTP V05R01M00:503:501:214:250:501:250:501:214:252:214:502:214:502:250:500
Dmail v3.0k6:503:251:501:250:501:250:501:214:250:502:502:250:250:250:250
a SMTP proxy refusing to server our requests:503:503:503:503:503:503:503:503:503:503:503:503:503:503:503
Watchguard Firebox III, version WFS70 with hotfix 030926:250:250:501:250:553:553:250:214:252:252:500:500:500:250:250
SmarterMail 1.61:503:250:501:250:250:250:501:502:550:550:500:500:500:250:250
Courier 0.38.0:502:502:250:250:250:250:250:250:250:250:250:250:250:250:250
Trend Micro ESMTP:250:250:501:250:250:250:501:214:252:502:500:500:500:250:250
';


tests = "
MAIL FROM: $VALID_SOURCE
HELO
HELO $MY_DOMAIN->MAIL FROM test
HELO $MY_DOMAIN->MAIL FROM: <>
HELO $MY_DOMAIN->MAIL FROM: <$VALID_SOURCE
HELO $MY_DOMAIN->MAIL FROM: <$INVALID_SOURCE>
HELO $MY_DOMAIN->MAIL FROM: <$VALID_SOURCE>->RCPT TO: test
HELO $MY_DOMAIN->HELP
HELO $MY_DOMAIN->VRFY root
HELO $MY_DOMAIN->EXPN root
HELO $MY_DOMAIN->TURN
HELO $MY_DOMAIN->SOML FROM: <$VALID_SOURCE>
HELO $MY_DOMAIN->SAML FROM: <$VALID_SOURCE>
HELO $MY_DOMAIN->NOOP
EHLO $MY_DOMAIN
#HELO $MY_DOMAIN->ETRN test
#HELO $MY_DOMAIN->MAIL FROM: <$VALID_SOURCE>->RCPT TO: <$TARGET_DOMAIN:$VALID_SOURCE>
";

port = get_kb_item("Services/smtp");
if (! port) port = 25;
if (! get_port_state(port)) exit(0);


soc = open_sock_tcp(port);
if(!soc)exit(0);
r = recv_line(socket:soc, length:4096);
if(!r)exit(0);
close(soc);


function set_smtp_server_type(srv)
{
  set_kb_item(name:string("smtp/", port, "/real_banner"), value:s);
  
  
  if (match(string: srv, pattern: "Sendmail *", icase: 1))
   set_kb_item(name: "SMTP/sendmail", value: TRUE);
  else if (match(string: srv, pattern: "Postfix*", icase: 1))
   set_kb_item(name: "SMTP/postfix", value: TRUE);
  else if (match(string: srv, pattern: "Qmail*", icase: 1))
   set_kb_item(name: "SMTP/qmail", value: TRUE);
  else if (match(string: srv, pattern: "CheckPoint FireWall-1 *", icase: 1))
   set_kb_item(name: "SMTP/firewall-1", value: TRUE);
  else if (match(string: srv, pattern: "Exim*", icase: 1))
   set_kb_item(name: "SMTP/exim", value: TRUE);
  else if (match(string: srv, pattern: "Lotus Domino*", icase: 1))
   set_kb_item(name: "SMTP/domino", value: TRUE);
  else if (match(string: srv, pattern: "InterMail*", icase: 1))
   set_kb_item(name: "SMTP/intermail", value: TRUE);
  else if (match(string: srv, pattern: "XMail*", icase: 1))
   set_kb_item(name: "SMTP/xmail", value: TRUE);
  #
  # I'm not sure all this is right
  #
  else if (match(string: srv, pattern: "Post.Office*", icase: 1))
   set_kb_item(name: "SMTP/postoffice", value: TRUE);
  else if(match(string: srv, pattern: "Microsoft ESMTP MAIL*", icase: 1))
   set_kb_item(name: "SMTP/microsoft_esmtp_5", value: TRUE);
  else if(match(string: srv, pattern: "Microsoft Exchange*", icase: 1))
   set_kb_item(name: "SMTP/microsoft_esmtp_5", value: TRUE);
  else if (match(string: srv, pattern: "InterScan VirusWall*", icase: 1))
   set_kb_item(name: "SMTP/interscan", value: TRUE);
  else if (match(string: srv, pattern: "NTMail v5*", icase: 1))
   set_kb_item(name: "SMTP/microsoft_esmtp_5", value: TRUE);
  else
  # The other servers are not identified by smtpserver_detect and I'm lazy
  {
    k = ereg_replace(string: srv, pattern: "^([A-Za-z]+).*", replace: "\1");
    if (! k) return;
    k = tolower(k);
    k = strcat("SMTP/", k);
    #display("Setting ", k, " in KB");
    set_kb_item(name: k, value: TRUE);
  }
}

tests = str_replace(string: tests, find: "$MY_DOMAIN", replace: "hotmail.com");
tests = str_replace(string: tests, find: "$VALID_SOURCE", 
                    replace: string("nessus", rand(), "@hotmail.com"));
tests = str_replace(string: tests, find: "$INVALID_SOURCE", 
                    replace: string("nessus", rand(), "@invalid", rand(), ".org"));
tests = str_replace(string: tests, find: "$TARGET_DOMAIN", replace: get_host_name());

codes = ""; i = 0;
broken_test = 0;
foreach t (split(tests))
{
  t = chomp(t);
  if (strlen(t) > 0 && ! match(string: t, pattern: "#*")) 
  {
    i ++;
    soc = open_sock_tcp(port);
    if (! soc)
    {
      sleep(1);
      soc = open_sock_tcp(port);
    }
    if (! soc)
    {
      codes = string(codes, ":0");
      debug_print('Connection refused for test ', i, '\n');
      broken_test ++;
    }
    else
    {
      r = smtp_recv_banner(socket: soc); 
      foreach c (split(t, sep: "->"))
      {
        c = ereg_replace(string: c, pattern: "->$", replace: "");
        debug_print(level: 2, 'CMD = ', c, '\n');
        send(socket: soc, data: string(c, "\r\n"));
        r = recv_line(socket: soc, length: 1024, timeout: 30);
	debug_print(level: 2, 'R   = ', r, '\n');
      }
      close(soc);
      r2 = eregmatch(string: r, pattern: "^([0-9]+)");
      if (isnull(r2))
      {
         debug_print('No answer for test ', i, '\n'); 
         codes = string(codes, ":0");
         broken_test ++;
      }
      else
        codes = string(codes, ":", r2[1]);
    }
  }
}

debug_print('codes=', codes, '\n');

results = split(codes+'\n', sep: ":");	# keep: 0

s = egrep(string: fingerprints, pattern : codes);
if (s)
{
  s = ereg_replace(string: s, pattern: "([^:]+):.*", replace: "\1");
  s = ereg_replace(string: s, pattern: " *-[0-9]-$", replace: "");
  set_smtp_server_type(srv: s);
  if (display_report)
  {
   report = string("This server could be fingerprinted as being ", s);
   if (result[5] == "250" || result[5] == "250:")
    report = string(report, "(with source email address checking like RBL, ...)");
   security_note(port: port, data: report);
  }
  exit(0);
}

if (! display_report) exit(0);

debug_print ('results=', results, '\n');

foreach sig (split(fingerprints)) {	# keep: 0
  if (! match(string: sig, pattern: "#*")) {
    v = split(sig, sep: ":");	# keep: 0
    if (max_index(v) > 15)
    {
      srv = v[0];
      diff = 0;
      # display(v, "\n");
      for (i = max_index(v) - 1; i > 0; i --)
        if (v[i] != results[i]) diff ++;
      differences[srv] = diff;
     }
  }
}

m = 999999;
foreach d (differences) { if (d < m) m = d; }
hyp = ""; prev = "";
foreach i (keys(differences))
  if (differences[i] == m)
  {
    i = ereg_replace(string: i, pattern: " *(-[0-9]-)?:?$", replace: "");
    if (i != prev)
      hyp = string(hyp, i, "\n");
    prev = i;
    # set_smtp_server_type(srv: i);
  }

report = "smtpscan was not able to reliably identify this server.";
if (m < 12)	# Not too many differences
{
 report = strcat(report, ' It might be:\n', hyp);
if (results[5] == "250") 
 report = string(report, "(with source email address checking like RBL, ...)\n");

report = string(report, "The fingerprint differs from these known signatures on ", m, " point(s)\n");
}
if (! broken_test)
  report = string(report, "\nIf you known precisely what it is, please send this fingerprint\nto smtp-signatures@nessus.org :\n", codes);
security_note(port: port,
              data: report);

