#
# This script is (C) Tenable Network Security
#




if(description)
{
 script_id(11740);
 script_bugtraq_id(7910, 7911, 7913);
 script_version ("$Revision: 1.8 $");

 name["english"] = "Infinity CGI Exploit Scanner";

 script_name(english:name["english"]);
 
 desc["english"] = "
The remote is running Infinity Exploit Scanner, a web-based CGI vulnerability
scanner implemented in perl and stored under the name 'nph-exploitscanget.cgi'.

There is a flaw in this CGI which lets an attacker execute arbitrary
commands on this host.

In addition to this, there is a flaw in this CGI which may allow an attacker
to use this CGI to scan third-party hosts by bypassing the policy set by
the administrator of this CGI. This CGI is also vulnerable to 
cross-site scripting issues.

Solution : Upgrade to the latest version
Risk factor : High";




 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the presence of nph-exploitscanget.cgi";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 
 
 script_copyright(english:"This script is Copyright (C) 2003 Tenable Network Security",
		francais:"Ce script est Copyright (C) 2003 Tenable Network Security");
 family["english"] = "CGI abuses : XSS";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#


include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);



function check(loc, port)
{
 req = http_get(item:string(loc, "/nph-exploitscanget.cgi?host=`id`&port=", port, "&errchk=0&idsbypass=0"),
 		port:port);			
 r = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
 if( r == NULL )exit(0);
 if(egrep(pattern:".*uid=[0-9].*gid=[0-9]", string:r))
 {
 	security_hole(port);
	exit(0);
 }
}



foreach dir (cgi_dirs())
{
 check(loc:dir, port:port);
}
