#
# (C) Tenable Network Security
#
# 

if (description) {
  script_id(18248);
  script_version("$Revision: 1.3 $");

  script_cve_id("CAN-2005-1561", "CAN-2005-1562");
  script_bugtraq_id(13601);

  name["english"] = "MaxWebPortal <= 1.35 Multiple Vulnerabilities";
  script_name(english:name["english"]);
 
  desc["english"] = "
According to its banner, the remote host is running a version of
MaxWebPortal that is prone to multiple cross-site scripting and SQL
injection vulnerabilities.  Exploitation of these flaws may result in
password theft and/or site defacement. 

See also : http://www.hackerscenter.com/archive/view.asp?id=2542
Solution : Upgrade to MaxWebPortal 1.36 or later.
Risk factor : High";
  script_description(english:desc["english"]);
 
  summary["english"] = "Checks for multiple vulnerabilities in MaxWebPortal <= 1.35";
  script_summary(english:summary["english"]);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2005 Tenable Network Security");

  script_dependencie("http_version.nasl");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_asp(port:port)) exit(0);


# Check various directories for MaxWebPortal.
foreach dir (cgi_dirs()) {
  # Pull up the site info page.
  req = http_get(item:string(dir, "/site_info.asp"), port:port);
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # Test the version number.
  #
  # nb: a more complete version number can be found in "site_info.asp".
  if (
    "This page is generated by MaxWebPortal" >< res && 
    egrep(string:res, pattern:'acronym title="Version: 1\\.([0-2]|3[0-5])', icase:TRUE)
  ) {
    security_hole(port);
    exit(0);
  }
}
